/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.git.wiz;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.net.URL;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import oracle.ide.controls.JMultiLineLabel;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;
import oracle.ide.util.IdeUtil;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.dialogs.progress.IndeterminateProgressMonitor;
import oracle.javatools.ui.HyperlinkButton;
import oracle.javatools.util.Pair;
import oracle.jdevimpl.vcs.git.GITClientAdaptor;
import oracle.jdevimpl.vcs.git.GITConnectionManager;
import oracle.jdevimpl.vcs.git.GITTraversalException;
import oracle.jdevimpl.vcs.git.GITUtil;
import oracle.jdevimpl.vcs.git.res.Resource;
import oracle.jdevimpl.vcs.git.wiz.GITCommonPanel;
import oracle.jdevimpl.vcs.git.wiz.GITRemoteBranchTagThread;
import org.netbeans.libs.git.GitClient;
import org.netbeans.libs.git.GitException;
import org.netbeans.libs.git.GitRemoteConfig;

class GITPushRepositoryPanel
extends GITCommonPanel {
    private static final String F1_HELP_ID = "f1_git_push_wizard_2_html";
    private JMultiLineLabel _hintText = new JMultiLineLabel();
    private JLabel _lblRepository = new JLabel();
    private JComboBox _cmnRepository = new JComboBox();
    private final HyperlinkButton _btnProxy = new HyperlinkButton();
    private URL _localRootUrl;

    public GITPushRepositoryPanel() {
        this.setHelpID(F1_HELP_ID);
        ResourceUtils.resButton((AbstractButton)this._btnProxy, (String)Resource.get("WZ_PROXY_BUTTON"));
        this.jbInit();
        this.addListeners();
    }

    private void jbInit() {
        Insets ins = new Insets(5, 5, 5, 5);
        Insets ins0 = new Insets(0, 0, 0, 5);
        this.setLayout(new GridBagLayout());
        this._btnProxy.setEnabled(false);
        this._hintText.setText(Resource.get("WZ_PUSH_REMOTE_HINT"));
        ResourceUtils.resLabel((JLabel)this._lblRepository, (Component)this._cmnRepository, (String)Resource.get("WZ_PUSH_REPOSITORY_URL"));
        this.add((Component)this._hintText, new GridBagConstraints(0, 0, 2, 1, 1.0, 0.0, 17, 2, ins, 0, 0));
        this.add(this._lblRepository, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, ins, 0, 0));
        this.add(this._cmnRepository, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 17, 2, ins, 0, 0));
        this.add((Component)this._btnProxy, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 13, 0, ins0, 0, 0));
        this.add(this._authPanel, new GridBagConstraints(0, 3, 2, 4, 1.0, 0.0, 17, 2, ins, 0, 0));
        this.add(new JPanel(), new GridBagConstraints(0, 7, 2, 1, 1.0, 1.0, 17, 1, ins, 0, 0));
        this._cmnRepository.setEditable(true);
    }

    public void onEntry(TraversableContext dataContext) {
        if (dataContext.getDirection() == 1) {
            Map mpConfig = (Map)dataContext.get("git.push-remote-config");
            Iterator it = mpConfig.keySet().iterator();
            while (it.hasNext()) {
                GitRemoteConfig config = (GitRemoteConfig)mpConfig.get(it.next());
                List uris = config.getPushUris();
                Iterator iterator = uris.iterator();
                while (iterator.hasNext()) {
                    String url = (String)iterator.next();
                    this.addNonDuplicateItem(this._cmnRepository, url);
                }
            }
            Collection<Pair<String, String>> infoLst = GITConnectionManager.getInstance().getConnectionInfoList();
            for (Pair pair : infoLst) {
                this.addNonDuplicateItem(this._cmnRepository, (String)pair.getSecond());
            }
            String defRepo = this.getDefaultPushGITRepo(mpConfig);
            if (defRepo != null) {
                this._cmnRepository.setSelectedItem(defRepo);
            }
            this.setDefaultAuthentication(defRepo);
            this._localRootUrl = (URL)dataContext.get("git.local-url");
        }
    }

    public void onExit(TraversableContext dataContext) throws TraversalException {
        if (dataContext.getDirection() == 1) {
            String remoteUrl = (String)this._cmnRepository.getSelectedItem();
            if (remoteUrl == null || remoteUrl.isEmpty()) {
                throw new TraversalException(Resource.get("WZ_PUSH_REPOS_EMPTY"), Resource.get("WZ_PUSH_REPOS_VALID"));
            }
            GitClient client = null;
            boolean restore = false;
            try {
                client = GITClientAdaptor.getClient(this._localRootUrl);
                GITClientAdaptor.setAuthentication(client, this._authPanel.getUser().trim(), this._authPanel.getPassword(), this._authPanel.getKeyFile(), this._authPanel.getPassPhrase());
                restore = GITUtil.authenticator(remoteUrl);
                final IndeterminateProgressMonitor progress = new IndeterminateProgressMonitor((Component)IdeUtil.getMainWindow(), Resource.get("WZ_REMOTE_BRANCH_PROGRESS"));
                progress.getPanel().setMessage(Resource.format("WZ_REMOTE_BRANCH_FROM", remoteUrl));
                final GITRemoteBranchTagThread rbThread = new GITRemoteBranchTagThread(client, remoteUrl, progress);
                rbThread.start();
                progress.addCancellationListener(new ChangeListener(){

                    @Override
                    public void stateChanged(ChangeEvent e) {
                        rbThread.interrupt();
                        progress.close();
                    }
                });
                progress.start();
                if (rbThread.getError() != null) {
                    throw rbThread.getError();
                }
                if (progress.isCanceled()) {
                    throw new TraversalException(Resource.get("WZ_OPERATION_CANCELED"), Resource.get("WZ_REMOTE_BRANCH_PROGRESS"));
                }
                dataContext.put("git.remote-branches", rbThread.getBranches());
                dataContext.put("git.tags", rbThread.getTags());
            }
            catch (GitException e) {
                throw new GITTraversalException(Resource.format("WZ_PUSH_REPOS_NO_CONNECT", remoteUrl), Resource.get("WZ_PUSH_REPOS_VALID"), (Exception)((Object)e));
            }
            finally {
                GITUtil.authenricatorRestore(restore);
                if (client != null) {
                    GITClientAdaptor.clearAuthentication(client);
                    client.release();
                }
            }
            dataContext.put("git.push-remote-uri", (Object)remoteUrl.trim());
            dataContext.put("git.username", (Object)this._authPanel.getUser().trim());
            dataContext.put("git.password", (Object)this._authPanel.getPassword());
            dataContext.put("git.keyfile", (Object)this._authPanel.getKeyFile());
            dataContext.put("git.passphrase", (Object)this._authPanel.getPassPhrase());
        }
    }

    private void addListeners() {
        this._cmnRepository.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    GITPushRepositoryPanel.this._authPanel.populateAuthentication((String)e.getItem());
                }
            }
        });
        this._cmnRepository.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JComboBox src = (JComboBox)e.getSource();
                GITPushRepositoryPanel.this.enableProxy((String)src.getSelectedItem());
            }
        });
        this._cmnRepository.getEditor().getEditorComponent().addKeyListener(new KeyListener(){

            @Override
            public void keyTyped(KeyEvent e) {
            }

            @Override
            public void keyPressed(KeyEvent e) {
            }

            @Override
            public void keyReleased(KeyEvent e) {
                String txt = (String)GITPushRepositoryPanel.this._cmnRepository.getEditor().getItem();
                GITPushRepositoryPanel.this.enableProxy(txt);
            }
        });
        this._btnProxy.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GITPushRepositoryPanel.this.proxyPrompt();
            }
        });
    }

    private void enableProxy(String txt) {
        if (txt.startsWith("http")) {
            this._btnProxy.setEnabled(true);
        } else {
            this._btnProxy.setEnabled(false);
        }
    }

    protected String getDefaultPushGITRepo(Map<String, GitRemoteConfig> remote) {
        if (remote != null) {
            for (String key : remote.keySet()) {
                List uris = remote.get(key).getPushUris();
                if (uris == null || uris.size() <= 0) continue;
                return (String)uris.get(0);
            }
        }
        return null;
    }
}

