/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.git.wiz;

import java.awt.Color;
import java.awt.Component;
import java.net.URL;
import java.util.ArrayList;
import java.util.Map;
import java.util.logging.Level;
import javax.swing.JDialog;
import javax.swing.SwingUtilities;
import oracle.bali.ewt.wizard.WizardDialog;
import oracle.ide.Context;
import oracle.ide.dialogs.WizardLauncher;
import oracle.ide.model.Node;
import oracle.ide.panels.CommitListener;
import oracle.ide.util.Namespace;
import oracle.ide.wizard.FSM;
import oracle.ide.wizard.FSMBuilder;
import oracle.ide.wizard.FSMWizard;
import oracle.ide.wizard.Step;
import oracle.ide.wizard.WelcomePanel;
import oracle.jdeveloper.vcs.spi.VCSCancellable;
import oracle.jdevimpl.vcs.git.GITCancellable;
import oracle.jdevimpl.vcs.git.GITClientAdaptor;
import oracle.jdevimpl.vcs.git.GITCommandProgressMonitor;
import oracle.jdevimpl.vcs.git.GITProcessException;
import oracle.jdevimpl.vcs.git.GITProfile;
import oracle.jdevimpl.vcs.git.GITRefSpec;
import oracle.jdevimpl.vcs.git.GITUtil;
import oracle.jdevimpl.vcs.git.nav.GITRemoteFetchNode;
import oracle.jdevimpl.vcs.git.nav.GITRepositoryNavigator;
import oracle.jdevimpl.vcs.git.res.Resource;
import oracle.jdevimpl.vcs.git.wiz.GITFetchBranchPanel;
import oracle.jdevimpl.vcs.git.wiz.GITFetchSummaryPanel;
import oracle.jdevimpl.vcs.git.wiz.GITRemoteWizard;
import oracle.jdevimpl.vcs.git.wiz.GITRepositoryPanel;
import org.netbeans.libs.git.GitClient;
import org.netbeans.libs.git.GitException;
import org.netbeans.libs.git.progress.ProgressMonitor;

public class GITFetchWizard
extends GITRemoteWizard {
    private Namespace ns;
    private WizardDialog wd;

    public boolean runWizard(Component parent, Context context) throws Exception {
        FSMBuilder fsmBuilder = new FSMBuilder();
        Step welcomeStep = WelcomePanel.newStep((String)Resource.get("WZ_FETCH_NAME"), (String)Resource.get("WZ_FETCH_HEADER"), (String)Resource.get("WZ_FETCH_TEXT"), (String)"GitFetchSkipNextTime", (String)"f1_git_fetch_wizard_1_html");
        fsmBuilder.newStartState(welcomeStep, (Object)"git.repository");
        Step step = new Step(Resource.get("WZ_FETCH_REPOSITORY"), GITRepositoryPanel.class);
        fsmBuilder.newState((Object)"git.repository", step, (Object)"git.branch");
        step = new Step(Resource.get("WZ_FETCH_BRANCH"), GITFetchBranchPanel.class);
        fsmBuilder.newState((Object)"git.branch", step, (Object)"git.summary");
        step = new Step(Resource.get("WZ_FETCH_SUMMARY"), GITFetchSummaryPanel.class);
        fsmBuilder.newFinalState((Object)"git.summary", step);
        try {
            FSM stateMachine = fsmBuilder.getFSM();
            this.ns = this.populate(context);
            if (this.ns == null) {
                return false;
            }
            Node node = context.getNode();
            if (node != null && node instanceof GITRemoteFetchNode) {
                String uri = ((GITRemoteFetchNode)node).getURI();
                this.ns.put("git.default-remote", (Object)uri);
            }
            FSMWizard wiz = new FSMWizard(stateMachine, this.ns);
            wiz.setWelcomePageAdded(true);
            wiz.setFinishPageAdded(true);
            wiz.setWizardTitle(Resource.get("WZ_FETCH_TITLE"));
            wiz.setRoadmapVisible(true);
            wiz.setHeaderGradientBackground(new Color[]{new Color(-1), new Color(-3219482)});
            this.wd = this.createWizardDialog(wiz, parent, context);
            if (WizardLauncher.runDialog((JDialog)this.wd)) {
                return true;
            }
        }
        catch (Exception e) {
            GITProfile.getQualifiedLogger(GITFetchWizard.class.getName()).log(Level.WARNING, "Failed to create fetch wizard", e);
            throw new GITProcessException(Resource.get("PROCESS_EXCEPTION_FETCH_ERROR"), e);
        }
        return false;
    }

    @Override
    protected CommitListener getCommitListener(WizardDialog wd, Context context) {
        return new GITRemoteWizard.GITRemoteCommitListener(this, Resource.get("WIZARD_FETCH_GIT"), wd, context);
    }

    @Override
    protected boolean runOperation(final GITCancellable cancel) throws GITProcessException {
        String remoteUrl = (String)this.ns.get("git.remote-uri");
        Map branches = (Map)this.ns.get("git.use-branches");
        URL localUrl = (URL)this.ns.get("git.local-url");
        String username = (String)this.ns.get("git.username");
        char[] passed = (char[])this.ns.get("git.password");
        String keyFile = (String)this.ns.get("git.keyfile");
        char[] passPhrase = (char[])this.ns.get("git.passphrase");
        String remoteName = (String)this.ns.get("git.remote-name");
        boolean restore = false;
        GitClient client = null;
        GITCommandProgressMonitor monitor = new GITCommandProgressMonitor(Resource.get("FETCH_OPERATION"));
        try {
            VCSCancellable cancellable = new VCSCancellable(){

                public boolean isCancelled() {
                    return cancel.hasCancelled();
                }
            };
            client = GITClientAdaptor.getClient(localUrl);
            monitor.setLog(true);
            monitor.setCancellable(cancellable);
            ArrayList<String> fetchSpec = new ArrayList<String>();
            for (String branch : branches.keySet()) {
                fetchSpec.add(GITRefSpec.getFetchSpec(branch.trim(), ((String)branches.get(branch)).trim()));
            }
            restore = GITUtil.authenticator(remoteUrl);
            GITClientAdaptor.setAuthentication(client, username, passed, keyFile, passPhrase);
            client.fetch(remoteUrl, fetchSpec, (ProgressMonitor)monitor);
            if (cancellable.isCancelled()) {
                boolean bl = false;
                return bl;
            }
        }
        catch (GitException.AuthorizationException e) {
            throw new GITProcessException(Resource.get("WZ_FETCH_FAILED"), e.getMessage());
        }
        catch (GitException e) {
            throw new GITProcessException(Resource.get("WZ_FETCH_FAILED"), e.getMessage());
        }
        finally {
            this.connection(remoteUrl, remoteName, username, passed, passPhrase);
            GITClientAdaptor.clearAuthentication(client);
            GITUtil.authenricatorRestore(restore);
            monitor.logCompleted();
            if (client != null) {
                client.release();
            }
        }
        this.updateNavigator(localUrl);
        return true;
    }

    private void updateNavigator(final URL url) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                GITRepositoryNavigator.getInstance().updateNavigator(url, true);
            }
        });
    }
}

