/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.git.wiz;

import java.awt.Color;
import java.awt.Component;
import java.awt.EventQueue;
import java.io.File;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.logging.Level;
import javax.swing.JDialog;
import javax.swing.SwingUtilities;
import oracle.bali.ewt.wizard.WizardDialog;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.controls.WaitCursor;
import oracle.ide.dialogs.WizardLauncher;
import oracle.ide.gallery.GalleryManager;
import oracle.ide.gallery.ObjectGallery;
import oracle.ide.net.URLFactory;
import oracle.ide.util.IdeUtil;
import oracle.ide.util.Namespace;
import oracle.ide.wizard.FSM;
import oracle.ide.wizard.FSMBuilder;
import oracle.ide.wizard.FSMWizard;
import oracle.ide.wizard.Step;
import oracle.ide.wizard.WelcomePanel;
import oracle.javatools.dialogs.progress.IndeterminateProgressMonitor;
import oracle.jdeveloper.vcs.spi.VCSCancellable;
import oracle.jdeveloper.vcs.util.VCSProcessUtils;
import oracle.jdeveloper.vcs.util.VCSWindowUtils;
import oracle.jdevimpl.vcs.generic.util.NewFilesHandler;
import oracle.jdevimpl.vcs.generic.util.VCSDirectoryWatcher;
import oracle.jdevimpl.vcs.git.GITClientAdaptor;
import oracle.jdevimpl.vcs.git.GITCommandProgressMonitor;
import oracle.jdevimpl.vcs.git.GITProcessException;
import oracle.jdevimpl.vcs.git.GITProfile;
import oracle.jdevimpl.vcs.git.GITRefSpec;
import oracle.jdevimpl.vcs.git.GITUtil;
import oracle.jdevimpl.vcs.git.res.Resource;
import oracle.jdevimpl.vcs.git.wiz.GITCloneBranchPanel;
import oracle.jdevimpl.vcs.git.wiz.GITCloneDestinationPanel;
import oracle.jdevimpl.vcs.git.wiz.GITCloneRepositoryPanel;
import oracle.jdevimpl.vcs.git.wiz.GITCloneSummaryPanel;
import oracle.jdevimpl.vcs.git.wiz.GITFetchWizard;
import oracle.jdevimpl.vcs.git.wiz.GITWizard;
import org.netbeans.libs.git.GitClient;
import org.netbeans.libs.git.GitException;
import org.netbeans.libs.git.GitRemoteConfig;
import org.netbeans.libs.git.GitRepository;
import org.netbeans.libs.git.progress.ProgressMonitor;

public class GITCloneWizard
extends GITWizard {
    private static final String F1_HELP_ID = "f1_git_clone_wizard_1_html";
    private static final String REPOS = "git.clone-repository";
    private static final String BRANCH = "git.clone-branch";
    private static final String DESTINATION = "git.clone-destination";
    private static final String SUMMARY = "git.clone-summary";
    static final String DESTINATION_DIR = "git.clone-destination-dir";
    static final String CLONE_NAME = "git.clone-clone-name";
    static final String CHECKOUT_BRANCH = "git.clone-checkout-branch";
    private Namespace _ns;
    private WizardDialog _wd;

    public boolean runWizard(Component parent, Context context) throws Exception {
        this._ns = new Namespace();
        return this.runWizardImpl(parent, context, this._ns);
    }

    public URL runWizard(Component parent, String repos, String user, char[] passwd) throws Exception {
        this._ns = this.populate(repos, user, passwd);
        if (this.runWizardImpl(parent, Context.newIdeContext(), this._ns)) {
            String destination = this.getDestination((String)this._ns.get(DESTINATION_DIR), (String)this._ns.get(CLONE_NAME));
            return URLFactory.newDirURL((String)destination);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean commitWizard(Context context) {
        WaitCursor wc = new WaitCursor((Component)Ide.getMainWindow());
        wc.show();
        try {
            if (this.runOperation(context)) {
                boolean bl = true;
                return bl;
            }
        }
        catch (Exception e) {
            GITProfile.getQualifiedLogger(GITCloneWizard.class.getName()).log(Level.WARNING, "Failed to clone", e);
            this.getExceptionHandler().handleException(e, (Component)VCSWindowUtils.getCurrentWindow());
        }
        finally {
            wc.hide();
        }
        return false;
    }

    private boolean runWizardImpl(Component parent, Context context, Namespace ns) throws GITProcessException {
        FSMBuilder fsmBuilder = new FSMBuilder();
        Step welcomeStep = WelcomePanel.newStep((String)Resource.get("WZ_CLONE_NAME"), (String)Resource.get("WZ_CLONE_HEADER"), (String)(ns.contains("git.remote-uri") ? Resource.get("WZ_CLONE_TEXT_POPULATED") : Resource.get("WZ_CLONE_TEXT")), (String)"GitCloneSkipNextTime", (String)F1_HELP_ID);
        fsmBuilder.newStartState(welcomeStep, (Object)REPOS);
        Step step = new Step(Resource.get("WZ_CLONE_REPOSITORY"), GITCloneRepositoryPanel.class);
        fsmBuilder.newState((Object)REPOS, step, (Object)BRANCH);
        step = new Step(Resource.get("WZ_CLONE_BRANCH"), GITCloneBranchPanel.class);
        fsmBuilder.newState((Object)BRANCH, step, (Object)DESTINATION);
        step = new Step(Resource.get("WZ_CLONE_DESTINATION_HEADER"), GITCloneDestinationPanel.class);
        fsmBuilder.newState((Object)DESTINATION, step, (Object)SUMMARY);
        step = new Step(Resource.get("WZ_CLONE_SUMMARY"), GITCloneSummaryPanel.class);
        fsmBuilder.newFinalState((Object)SUMMARY, step);
        try {
            FSM stateMachine = fsmBuilder.getFSM();
            FSMWizard wiz = new FSMWizard(stateMachine, ns);
            wiz.setWelcomePageAdded(true);
            wiz.setFinishPageAdded(true);
            wiz.setWizardTitle(Resource.get("WZ_CLONE_TITLE"));
            wiz.setRoadmapVisible(true);
            wiz.setHeaderGradientBackground(new Color[]{new Color(-1), new Color(-3219482)});
            this._wd = this.createWizardDialog(wiz, parent, context);
            if (WizardLauncher.runDialog((JDialog)this._wd)) {
                return true;
            }
        }
        catch (Exception e) {
            GITProfile.getQualifiedLogger(GITFetchWizard.class.getName()).log(Level.WARNING, "Failed to create clone wizard", e);
            throw new GITProcessException(Resource.get("PROCESS_EXCEPTION_CLONE_ERROR"), e);
        }
        return false;
    }

    private boolean runOperation(Context context) throws GITProcessException {
        String dest = (String)this._ns.get(DESTINATION_DIR);
        String cloneName = (String)this._ns.get(CLONE_NAME);
        Collection remoteBranch = (Collection)this._ns.get("git.use-branches");
        String remote = (String)this._ns.get("git.remote-name");
        String remoteUrl = (String)this._ns.get("git.remote-uri");
        String checkoutBranch = (String)this._ns.get(CHECKOUT_BRANCH);
        String username = (String)this._ns.get("git.username");
        char[] passed = (char[])this._ns.get("git.password");
        String keyFile = (String)this._ns.get("git.keyfile");
        char[] passPhrase = (char[])this._ns.get("git.passphrase");
        GITCommandProgressMonitor monitor = new GITCommandProgressMonitor(Resource.get("CLONE_OPERATION"));
        final IndeterminateProgressMonitor progress = new IndeterminateProgressMonitor((Component)IdeUtil.getMainWindow(), Resource.get("WZ_CLONE_PROGRESS"), (Object)Resource.format("WZ_CLONE_MESSAGE", remoteUrl), null);
        ArrayList<String> refSpec = new ArrayList<String>();
        GitClient client = null;
        boolean restore = false;
        try {
            String destination = this.getDestination(dest, cloneName);
            URL destUrl = URLFactory.newDirURL((String)destination);
            VCSCancellable cancellable = new VCSCancellable(){

                public boolean isCancelled() {
                    return progress.isCanceled();
                }
            };
            progress.start();
            VCSDirectoryWatcher watcher = new VCSDirectoryWatcher(destUrl);
            client = GitRepository.getInstance((File)new File(destination)).createClient();
            monitor.setLog(true);
            monitor.setCancellable(cancellable);
            client.init((ProgressMonitor)monitor);
            if (progress.isCancelled()) {
                boolean bl = false;
                return bl;
            }
            if (!remoteBranch.isEmpty()) {
                for (String branch : remoteBranch) {
                    refSpec.add(GITRefSpec.getFetchSpec(branch, remote + '/' + branch));
                }
                restore = GITUtil.authenticator(remoteUrl);
                GITClientAdaptor.setAuthentication(client, username, passed, keyFile, passPhrase);
                client.fetch(remoteUrl, refSpec, (ProgressMonitor)monitor);
                if (progress.isCancelled()) {
                    boolean bl = false;
                    return bl;
                }
            }
            ArrayList<String> remoteUrls = new ArrayList<String>();
            remoteUrls.add(remoteUrl);
            client.setRemote(new GitRemoteConfig(remote, remoteUrls, remoteUrls, refSpec, refSpec), (ProgressMonitor)monitor);
            if (progress.isCancelled()) {
                boolean bl = false;
                return bl;
            }
            if (checkoutBranch != null) {
                client.createBranch(checkoutBranch, remote + "/" + checkoutBranch, (ProgressMonitor)monitor);
                if (progress.isCancelled()) {
                    boolean bl = false;
                    return bl;
                }
                watcher.beginWatch();
                client.checkoutRevision(checkoutBranch, true, (ProgressMonitor)monitor);
                client.reset(checkoutBranch, GitClient.ResetType.HARD, (ProgressMonitor)monitor);
                watcher.endWatch();
                this.openNewFiles(watcher, context, checkoutBranch);
            } else {
                this.createApplication(context, destUrl);
            }
        }
        catch (GitException e) {
            GITProfile.getQualifiedLogger(GITCloneWizard.class.getName()).log(Level.SEVERE, e.getMessage());
            throw new GITProcessException(Resource.get("WZ_CLONE_FAILED"), e.getMessage());
        }
        finally {
            this.connection(remoteUrl, remote, username, passed, passPhrase);
            progress.finish();
            GITUtil.authenricatorRestore(restore);
            monitor.logCompleted();
            if (client != null) {
                client.release();
            }
        }
        return true;
    }

    private String getDestination(String dest, String cloneName) {
        StringBuilder sb = new StringBuilder(dest);
        if (dest.lastIndexOf(File.separatorChar) != dest.length() - 1) {
            sb.append(File.separatorChar);
        }
        sb.append(cloneName);
        String destination = sb.toString();
        return destination;
    }

    private void openNewFiles(VCSDirectoryWatcher watcher, final Context context, final String name) {
        final WaitCursor wc = new WaitCursor((Component)Ide.getMainWindow());
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                wc.show();
            }
        });
        final NewFilesHandler nfh = new NewFilesHandler(watcher, "oracle.jdeveloper.git");
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                block4: {
                    try {
                        if (!VCSProcessUtils.productHandleNewFiles()) break block4;
                        nfh.handleNewFiles(context, name);
                    }
                    catch (Exception ex) {
                        try {
                            GITCloneWizard.this.getExceptionHandler().handleException(ex);
                        }
                        catch (Throwable throwable) {
                            EventQueue.invokeLater(new Runnable(){

                                @Override
                                public void run() {
                                    wc.hide();
                                }
                            });
                            throw throwable;
                        }
                        EventQueue.invokeLater(new /* invalid duplicate definition of identical inner class */);
                    }
                }
                EventQueue.invokeLater(new /* invalid duplicate definition of identical inner class */);
            }
        });
    }

    private Namespace populate(String repos, String user, char[] passwd) throws URISyntaxException {
        Namespace ns = new Namespace();
        if (repos != null) {
            ns.put("git.remote-uri", (Object)repos);
        }
        if (user != null) {
            ns.put("git.username", (Object)user);
        }
        if (passwd != null && passwd.length > 0) {
            ns.put("git.password", (Object)passwd);
        }
        return ns;
    }

    private void createApplication(final Context context, URL destUrl) {
        final ObjectGallery gallery = GalleryManager.getGalleryManager().getGallery();
        if (gallery != null) {
            context.setWorkspace(null);
            context.setProject(null);
            Ide.getWorkspaces().setWorkDirectory(destUrl);
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    gallery.runDialog(context, "Applications", null);
                }
            });
        }
    }
}

