/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.git.wiz;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JLayer;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.plaf.LayerUI;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableModel;
import oracle.ide.Ide;
import oracle.ide.controls.JMultiLineLabel;
import oracle.ide.panels.DefaultTraversablePanel;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;
import oracle.ide.util.ResourceUtils;
import oracle.ide.wizard.WizardCallbacks;
import oracle.javatools.ui.table.EmptyTableTextLayer;
import oracle.javatools.ui.table.GenericTable;
import oracle.javatools.ui.table.GenericTableAutoSizeModel;
import oracle.javatools.ui.table.GenericTableModel;
import oracle.javatools.ui.table.GenericTablePersistentSettings;
import oracle.jdeveloper.vcs.vop.DisplayProperty;
import oracle.jdevimpl.vcs.git.GITDisplayProperty;
import oracle.jdevimpl.vcs.git.res.Resource;

public class GITCloneBranchPanel
extends DefaultTraversablePanel {
    private static final String BRANCH_KEY = "git-clone-branch-table";
    private static final String F1_HELP_ID = "f1_git_clone_wizard_3_html";
    private JMultiLineLabel _hintText = new JMultiLineLabel();
    private GenericTable _tableBranches = new GenericTable();
    private JButton _btnSelect = new JButton();
    private JButton _btnDeselect = new JButton();
    private EmptyTableTextLayer _emptyBranchTable;

    public GITCloneBranchPanel() {
        this.init();
        this.addListeners();
        this.setHelpID(F1_HELP_ID);
    }

    private void init() {
        Insets ins = new Insets(5, 5, 5, 5);
        this._tableBranches.setModel((TableModel)new RemoteBranchTableModel(this.getDisplayProperties()));
        this._hintText.setText(Resource.get("WZ_CLONE_BRANCH_HINT"));
        EmptyTableTextLayer emptyBranchTable = new EmptyTableTextLayer((JTable)this._tableBranches, Resource.get("CLONE_EMPTY_NO_BRANCH"));
        JScrollPane scrollpane = new JScrollPane((Component)this._tableBranches);
        JLayer<JScrollPane> layer = new JLayer<JScrollPane>(scrollpane, (LayerUI<JScrollPane>)emptyBranchTable);
        ResourceUtils.resButton((AbstractButton)this._btnSelect, (String)Resource.get("BRANCH_SELECT_ALL"));
        ResourceUtils.resButton((AbstractButton)this._btnDeselect, (String)Resource.get("BRANCH_DESELECT_ALL"));
        this._tableBranches.setAutoResizeMode(3);
        this.autoSizeCoumnstoFit((RemoteBranchTableModel)this._tableBranches.getModel());
        this.setLayout(new GridBagLayout());
        this.add((Component)this._hintText, new GridBagConstraints(0, 0, 3, 1, 1.0, 0.0, 17, 2, ins, 0, 0));
        this.add(layer, new GridBagConstraints(0, 1, 3, 1, 1.0, 1.0, 17, 1, ins, 0, 0));
        this.add(new JPanel(), new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 17, 2, ins, 0, 0));
        this.add(this._btnSelect, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 17, 0, ins, 0, 0));
        this.add(this._btnDeselect, new GridBagConstraints(2, 2, 1, 1, 0.0, 0.0, 17, 0, ins, 0, 0));
    }

    private void autoSizeCoumnstoFit(RemoteBranchTableModel model) {
        Object[] prototypeValues = new Object[model.getColumnCount()];
        for (int i = 0; i < prototypeValues.length; ++i) {
            prototypeValues[i] = model.getProperty(i).getPrototypeValue();
        }
        this._tableBranches.autoSizeColumnsToFit(prototypeValues);
    }

    private DisplayProperty[] getDisplayProperties() {
        DisplayProperty[] props = new DisplayProperty[]{new GITDisplayProperty(Resource.get("WZ_CLONE_BRANCH_COLUMN1"), null, 0, Boolean.FALSE, null, Boolean.class, 80, true), new GITDisplayProperty(Resource.get("WZ_CLONE_BRANCH_COLUMN2"), null, 2, " a very long branch name that may be used in a clone operation ", null, String.class, 200, false)};
        return props;
    }

    public void onEntry(TraversableContext dataContext) {
        if (dataContext.getDirection() == 1) {
            Map branches = (Map)dataContext.get("git.remote-branches");
            ((RemoteBranchTableModel)this._tableBranches.getModel()).addData(branches.keySet(), "master");
            this._tableBranches.setSortColumn(1, true);
        }
        WizardCallbacks callbacks = dataContext.getWizardCallbacks();
        callbacks.wizardEnableButtons(Boolean.valueOf(true), Boolean.valueOf(true), Boolean.valueOf(false));
        dataContext.setWizardCallbacks(callbacks);
        Map settings = (Map)Ide.getDTCache().getData(BRANCH_KEY);
        if (settings != null) {
            this._tableBranches.setPersistentSettings(new GenericTablePersistentSettings(settings));
        }
    }

    public void onExit(TraversableContext dataContext) throws TraversalException {
        if (dataContext.getDirection() == 1) {
            Collection branches = ((RemoteBranchTableModel)this._tableBranches.getModel()).getIncludeBranches();
            int nbranches = ((RemoteBranchTableModel)this._tableBranches.getModel()).getRowCount();
            if (branches.isEmpty() && nbranches > 0) {
                throw new TraversalException(Resource.get("WZ_NO_BRANCH"), Resource.get("WZ_NO_BRANCH_TITLE"));
            }
            dataContext.put("git.use-branches", (Object)branches);
            GenericTablePersistentSettings settings = this._tableBranches.getPersistentSettings();
            Ide.getDTCache().putData(BRANCH_KEY, settings.toMap());
        }
    }

    private void addListeners() {
        this._btnSelect.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GITCloneBranchPanel.this.selectAllBranches(true);
            }
        });
        this._btnDeselect.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GITCloneBranchPanel.this.selectAllBranches(false);
            }
        });
    }

    private void selectAllBranches(boolean enable) {
        TableModel model = this._tableBranches.getModel();
        for (int r = 0; r < model.getRowCount(); ++r) {
            model.setValueAt(enable, r, 0);
        }
    }

    private static class RemoteBranchTableModel
    extends DefaultTableModel
    implements GenericTableModel,
    GenericTableAutoSizeModel {
        private String[] _fromBranch;
        private Boolean[] _include;
        private DisplayProperty[] _properties;

        RemoteBranchTableModel(DisplayProperty[] properties) {
            this._properties = properties;
        }

        @Override
        public int getColumnCount() {
            return this._properties.length;
        }

        @Override
        public String getColumnName(int col) {
            return this._properties[col].getName();
        }

        public Class getColumnClass(int col) {
            return this._properties[col].getType();
        }

        @Override
        public void setValueAt(Object value, int row, int col) {
            if (col == 0) {
                this._include[row] = (Boolean)value;
            }
            this.fireTableCellUpdated(row, col);
        }

        @Override
        public boolean isCellEditable(int row, int column) {
            return this._properties[column].isEditable();
        }

        @Override
        public Object getValueAt(int row, int col) {
            if (col == 0 && row < this._include.length) {
                return this._include[row];
            }
            if (col == 1 && row < this._fromBranch.length) {
                return this._fromBranch[row];
            }
            return new Object();
        }

        @Override
        public int getRowCount() {
            if (this._fromBranch == null || this._fromBranch.length == 0) {
                return 0;
            }
            return this._fromBranch.length;
        }

        DisplayProperty getProperty(int column) {
            return this._properties[column];
        }

        private void addData(Set<String> branches, String defBranch) {
            this._fromBranch = branches.toArray(new String[0]);
            this._include = new Boolean[branches.size()];
            for (int b = 0; b < this._include.length; ++b) {
                this._include[b] = (Boolean)this._properties[0].getPrototypeValue();
                if (!this._fromBranch[b].equals(defBranch)) continue;
                this._include[b] = Boolean.TRUE;
            }
        }

        private Collection<String> getIncludeBranches() {
            ArrayList<String> branches = new ArrayList<String>();
            for (int b = 0; b < this._include.length; ++b) {
                if (!this._include[b].booleanValue()) continue;
                branches.add(this._fromBranch[b]);
            }
            return branches;
        }

        public int getColumnAlignment(int column) {
            return this._properties[column].getAlignment();
        }

        public boolean canHide(int column) {
            return false;
        }

        public int getColumnAutoSizeMaximum(int column) {
            return this._properties[column].getMaximumDefaultSize();
        }
    }
}

