/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.git.cmd;

import java.awt.Component;
import java.io.File;
import java.net.URL;
import java.util.Collection;
import java.util.Map;
import oracle.javatools.dialogs.progress.DeterminateProgressMonitor;
import oracle.jdeveloper.vcs.generic.CommandState;
import oracle.jdeveloper.vcs.generic.VCSProfile;
import oracle.jdeveloper.vcs.spi.VCSCommandStyle;
import oracle.jdeveloper.vcs.spi.VCSDirectoryInvokable;
import oracle.jdevimpl.vcs.git.GITClientAdaptor;
import oracle.jdevimpl.vcs.git.GITCommandProgressMonitor;
import oracle.jdevimpl.vcs.git.GITProcessException;
import oracle.jdevimpl.vcs.git.GITUtil;
import oracle.jdevimpl.vcs.git.cmd.GITAbstractOperation;
import oracle.jdevimpl.vcs.git.res.Resource;
import org.netbeans.libs.git.GitClient;
import org.netbeans.libs.git.GitException;
import org.netbeans.libs.git.progress.ProgressMonitor;

public class GITOperationRevert
extends GITAbstractOperation {
    public GITOperationRevert() {
        super("oracle.jdeveloper.git.revert", VCSCommandStyle.MULTI);
    }

    protected GITOperationRevert(String id) {
        super(id, VCSCommandStyle.MULTI);
    }

    @Override
    protected DeterminateProgressMonitor createProgressMonitor(Component parent) {
        return new DeterminateProgressMonitor(parent, this.getProgressTitle(), (Object)this.getProgressMessage(), "", 0, -1);
    }

    @Override
    protected VCSDirectoryInvokable createDirectoryInvokable(VCSProfile profile, CommandState commandState, Map options) {
        return new GITAbstractOperation.DirectoryInvokable(commandState.getInvokableState()){

            protected boolean doInvocation(URL parent, URL[] children) throws Exception {
                GITCommandProgressMonitor monitor = new GITCommandProgressMonitor(Resource.get("REVERT_OPERATION"));
                GitClient client = null;
                monitor.setLog(true);
                try {
                    client = GITClientAdaptor.getClient(parent);
                    Collection<File> files = GITUtil.convertURLToFile(children);
                    client.checkout(files.toArray(new File[0]), "HEAD", true, (ProgressMonitor)monitor);
                    if (monitor.getError() != null) {
                        throw new GITProcessException(Resource.get("PROCESS_EXCEPTION_REVERT_ERROR"), monitor.getError());
                    }
                }
                catch (GitException ge) {
                    throw new GITProcessException(Resource.get("PROCESS_EXCEPTION_REVERT_ERROR"), (Exception)((Object)ge));
                }
                finally {
                    monitor.logCompleted();
                    if (client != null) {
                        client.release();
                    }
                }
                return true;
            }
        };
    }

    @Override
    protected void postInvoke(VCSProfile profile, CommandState commandState) throws Exception {
        super.postInvoke(profile, commandState);
        this.fireSomeFilesCreated(commandState.getInvokableState().getProcessedURLs().toArray(new URL[0]));
    }

    protected String getProgressTitle() {
        return Resource.get("OPERATION_UNDO_PROGRESS_TITLE");
    }

    protected String getProgressMessage() {
        return Resource.get("OPERATION_UNDO_PROGRESS_MESSAGE");
    }
}

