/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.git.cmd;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.net.URL;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JTextArea;
import javax.swing.border.EmptyBorder;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.ide.model.Locatable;
import oracle.ide.net.URLFactory;
import oracle.ide.util.IdeUtil;
import oracle.ide.util.ResourceUtils;
import oracle.jdeveloper.vcs.generic.CommandState;
import oracle.jdeveloper.vcs.generic.VCSProfile;
import oracle.jdevimpl.vcs.git.GITClientAdaptor;
import oracle.jdevimpl.vcs.git.GITCommandProgressMonitor;
import oracle.jdevimpl.vcs.git.GITProcessException;
import oracle.jdevimpl.vcs.git.GITProfile;
import oracle.jdevimpl.vcs.git.GITUtil;
import oracle.jdevimpl.vcs.git.cmd.GITOperationMerge;
import oracle.jdevimpl.vcs.git.res.Resource;
import org.netbeans.libs.git.GitClient;
import org.netbeans.libs.git.GitException;
import org.netbeans.libs.git.GitRebaseResult;
import org.netbeans.libs.git.GitRepositoryState;
import org.netbeans.libs.git.GitRevisionInfo;
import org.netbeans.libs.git.SearchCriteria;
import org.netbeans.libs.git.progress.ProgressMonitor;

public class GITOperationRebase
extends GITOperationMerge {
    public static final String COMMAND_ID = "oracle.jdeveloper.git.rebase";
    private String _activeBranch;

    public GITOperationRebase() {
        super(COMMAND_ID);
    }

    @Override
    protected Map<String, Object> getBranchRevisionOptions(URL root, String branch, boolean useTracking) throws GitException, GITProcessException {
        Map<String, Object> options = super.getBranchRevisionOptions(root, branch, true);
        this._activeBranch = (String)options.get("Git-active-branch");
        return options;
    }

    @Override
    protected boolean invokeCommand(VCSProfile profile, CommandState commandState) throws Exception {
        List<Locatable> nodes = Arrays.asList(commandState.getLocatables());
        if (this.isRebasing(nodes)) {
            JEWTDialog dialog = this.rebaseNotCompleteDialog(nodes);
            dialog.runDialog();
            dialog.dispose();
            return true;
        }
        return super.invokeCommand(profile, commandState);
    }

    private JEWTDialog rebaseNotCompleteDialog(Collection nodes) {
        Locatable[] loc = nodes.toArray(new Locatable[0]);
        URL root = GITUtil.getRootContaining(loc[0].getURL());
        RebaseDialog rebase = new RebaseDialog(root);
        return rebase.createDialog();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isRebasing(Collection nodes) {
        Locatable[] loc = nodes.toArray(new Locatable[0]);
        URL root = GITUtil.getRootContaining(loc[0].getURL());
        GITCommandProgressMonitor monitor = new GITCommandProgressMonitor("RepositoryState");
        GitClient client = null;
        try {
            client = GITClientAdaptor.getClient(root);
            GitRepositoryState state = client.getRepositoryState((ProgressMonitor)monitor);
            if (state.equals((Object)GitRepositoryState.REBASING)) {
                boolean bl = true;
                return bl;
            }
        }
        catch (GitException gitException) {
        }
        finally {
            if (client != null) {
                client.release();
            }
        }
        return false;
    }

    @Override
    protected boolean invokeCommandImpl(VCSProfile profile, CommandState commandState, Component parentUi, Map options) throws Exception {
        String revision = (String)options.get("Git-use-revision");
        URL root = (URL)options.get("Git-local-root");
        Collection<URL> processed = this.rebase(GitClient.RebaseOperationType.BEGIN, root, revision);
        this.setProcessedUrls(commandState, processed.toArray(new URL[0]));
        return true;
    }

    protected String getDialogHint() {
        if (this._activeBranch != null) {
            return Resource.format("OPERATION_REBASE_DIALOG_HINT", this._activeBranch);
        }
        return super.getDialogHint();
    }

    @Override
    protected String getErrorTitle() {
        return Resource.get("REBASE_FAILED_TITLE");
    }

    private Collection<URL> rebase(GitClient.RebaseOperationType type, URL root, String revision) throws GITProcessException {
        GITCommandProgressMonitor monitor = new GITCommandProgressMonitor(Resource.get("REBASE_OPERATION"));
        GitClient client = null;
        Collection<URL> processed = Collections.emptyList();
        monitor.setLog(false);
        try {
            client = GITClientAdaptor.getClient(root);
            GitRevisionInfo preRev = this.getRevisionInfo(client, revision, monitor);
            monitor.setLog(true);
            GitRebaseResult result = client.rebase(type, revision, (ProgressMonitor)monitor);
            monitor.setLog(false);
            this.setConflicts(result.getConflicts());
            this.setFailures(result.getFailures());
            if (preRev != null) {
                processed = this.getProcessed(client, preRev.getRevision(), revision);
            }
        }
        catch (GitException e) {
            throw new GITProcessException(Resource.get("PROCESS_EXCEPTION_REBASE_ERROR"), e.getMessage());
        }
        finally {
            monitor.logCompleted();
            if (client != null) {
                client.release();
            }
        }
        return processed;
    }

    private GitRevisionInfo getRevisionInfo(GitClient client, String revision, GITCommandProgressMonitor monitor) {
        if (this._activeBranch != null) {
            try {
                return client.getCommonAncestor(new String[]{this._activeBranch, revision}, (ProgressMonitor)monitor);
            }
            catch (GitException.MissingObjectException e) {
                GITProfile.getQualifiedLogger(GITOperationRebase.class.getName()).log(Level.WARNING, e.getMessage());
            }
            catch (GitException e) {
                GITProfile.getQualifiedLogger(GITOperationRebase.class.getName()).log(Level.WARNING, e.getMessage());
            }
        }
        return null;
    }

    private Collection<URL> getProcessed(GitClient client, String startRev, String endRev) {
        GITCommandProgressMonitor monitor = new GITCommandProgressMonitor("log");
        HashSet<URL> urls = new HashSet<URL>();
        try {
            GitRevisionInfo[] infos;
            SearchCriteria search = new SearchCriteria();
            search.setRevisionFrom(startRev);
            search.setRevisionTo(endRev);
            for (GitRevisionInfo info : infos = client.log(search, (ProgressMonitor)monitor)) {
                Map map = info.getModifiedFiles();
                Iterator it = map.keySet().iterator();
                while (it.hasNext()) {
                    urls.add(URLFactory.newFileURL((File)((File)it.next())));
                }
            }
        }
        catch (GitException.MissingObjectException e) {
            GITProfile.getQualifiedLogger(GITOperationRebase.class.getName()).log(Level.WARNING, e.getMessage());
        }
        catch (GitException e) {
            GITProfile.getQualifiedLogger(GITOperationRebase.class.getName()).log(Level.WARNING, e.getMessage());
        }
        return urls;
    }

    private class RebaseDialog
    implements ActionListener {
        private JEWTDialog _dialog;
        private JButton _btContinue = new JButton();
        private JButton _btSkip = new JButton();
        private JButton _btAbort = new JButton();
        private URL _root;

        RebaseDialog(URL root) {
            this._root = root;
        }

        public JEWTDialog createDialog() {
            JTextArea label = new JTextArea();
            this._dialog = new JEWTDialog(IdeUtil.getMainWindow(), Resource.get("REBASE_DLG_TITLE"));
            this._btContinue.addActionListener(this);
            this._btSkip.addActionListener(this);
            this._btAbort.addActionListener(this);
            ResourceUtils.resButton((AbstractButton)this._btContinue, (String)Resource.get("REBASE_DLG_COMPLETE"));
            ResourceUtils.resButton((AbstractButton)this._btSkip, (String)Resource.get("REBASE_DLG_ABORT"));
            ResourceUtils.resButton((AbstractButton)this._btAbort, (String)Resource.get("REBASE_DLG_SKIP"));
            label.setText(Resource.get("REBASE_DLG_MSG"));
            label.setRows(2);
            label.setLineWrap(true);
            label.setWrapStyleWord(true);
            label.setEditable(false);
            label.setBorder(new EmptyBorder(0, 0, 0, 0));
            this._dialog.setContent((Component)label);
            this._dialog.setButtonMask(2);
            this._dialog.addCustomButton((Component)this._btContinue);
            this._dialog.addCustomButton((Component)this._btSkip);
            this._dialog.addCustomButton((Component)this._btAbort);
            return this._dialog;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            try {
                Collection processed;
                if (e.getSource() == this._btContinue) {
                    processed = GITOperationRebase.this.rebase(GitClient.RebaseOperationType.CONTINUE, this._root, null);
                    this._dialog.closeDialog(true);
                }
                if (e.getSource() == this._btSkip) {
                    processed = GITOperationRebase.this.rebase(GitClient.RebaseOperationType.SKIP, this._root, null);
                    this._dialog.closeDialog(true);
                }
                if (e.getSource() == this._btAbort) {
                    processed = GITOperationRebase.this.rebase(GitClient.RebaseOperationType.ABORT, this._root, null);
                    this._dialog.closeDialog(true);
                }
            }
            catch (GITProcessException f) {
                GITProfile.getQualifiedLogger(GITOperationRebase.class.getName()).log(Level.WARNING, f.getMessage());
                GITOperationRebase.this.getExceptionHandler().handleException((Exception)((Object)f));
            }
        }
    }
}

