/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.git.cmd;

import java.awt.Component;
import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.ide.Ide;
import oracle.ide.model.Element;
import oracle.ide.model.Locatable;
import oracle.javatools.dialogs.MessageDialog;
import oracle.javatools.dialogs.progress.IndeterminateProgressMonitor;
import oracle.jdeveloper.vcs.generic.CommandState;
import oracle.jdeveloper.vcs.generic.VCSProfile;
import oracle.jdeveloper.vcs.spi.VCSCommandStyle;
import oracle.jdeveloper.vcs.spi.VCSHashURL;
import oracle.jdeveloper.vcs.spi.VCSOptionsCustomizer;
import oracle.jdeveloper.vcs.util.VCSComponents;
import oracle.jdeveloper.vcs.util.VCSWindowUtils;
import oracle.jdevimpl.vcs.git.GITClientAdaptor;
import oracle.jdevimpl.vcs.git.GITCommandProgressMonitor;
import oracle.jdevimpl.vcs.git.GITProcessException;
import oracle.jdevimpl.vcs.git.GITStatusResolver;
import oracle.jdevimpl.vcs.git.GITUtil;
import oracle.jdevimpl.vcs.git.cmd.GITExtendedNodeAbstractOperation;
import oracle.jdevimpl.vcs.git.cmd.GITStatusFilter;
import oracle.jdevimpl.vcs.git.res.Resource;
import org.netbeans.libs.git.GitClient;
import org.netbeans.libs.git.GitException;
import org.netbeans.libs.git.GitStatus;
import org.netbeans.libs.git.progress.ProgressMonitor;

public class GITOperationAdd
extends GITExtendedNodeAbstractOperation {
    protected static GITStatusFilter _filter = new GitStatusUnadded();

    public GITOperationAdd() {
        super("oracle.jdeveloper.git.add", VCSCommandStyle.MULTI);
    }

    protected GITOperationAdd(String id) {
        super(id, VCSCommandStyle.MULTI);
    }

    protected boolean locatablesValid(VCSProfile profile) {
        Element elm = this.getContext().getElement();
        if (elm != null && elm.mayHaveChildren()) {
            return true;
        }
        return super.locatablesValid(profile);
    }

    protected Locatable[] getOperands(VCSProfile profile) throws Exception {
        Locatable[] fileLocs;
        Collection<Locatable> flds = this.findFolders(profile);
        if (flds.isEmpty()) {
            return super.getOperands(profile);
        }
        ArrayList<Locatable> locs = new ArrayList<Locatable>();
        this.getFilteredCollectionWithProgress(locs, flds, _filter, Resource.get("ADD_PROGRESS_TITLE"), Resource.get("ADD_PROGRESS"));
        for (Locatable loc : fileLocs = super.getOperands(profile)) {
            locs.add(loc);
        }
        return locs.toArray(new Locatable[0]);
    }

    @Override
    protected JEWTDialog createOperationDialogImpl(Collection nodes, VCSOptionsCustomizer customizer, CommandState commandState) {
        this.setGITVersionOperationPanel(VCSComponents.createSelectFileListerComponent((Collection)nodes));
        JEWTDialog dialog = VCSComponents.createOperationDialog((Component)VCSWindowUtils.getCurrentWindow(), (String)this.getDialogTitle(), null, (Component)this.getGITVersionOperationPanel(), (Component)(customizer != null ? customizer.getComponent() : null), (String)this.getHelpTopicId(), (Component)(customizer != null ? customizer.getInitialFocusComponent() : null));
        return dialog;
    }

    protected int doitImpl(VCSProfile profile) throws Exception {
        int stat;
        Collection<Locatable> flds = this.findFolders(profile);
        if (!flds.isEmpty() && (stat = this.saveNodesIfDirty(flds.toArray(new Locatable[0]))) != 0) {
            return stat;
        }
        Locatable[] locatables = this.getOperands(profile);
        int stat2 = this.saveNodesIfDirty(locatables);
        if (stat2 != 0) {
            return stat2;
        }
        return this.doitImplInvoke(profile, locatables);
    }

    protected CommandState getCommandState(VCSProfile profile, Locatable[] locatables) throws Exception {
        CommandState state = super.getCommandState(profile, locatables);
        if (state == null) {
            MessageDialog.information((Component)Ide.getMainWindow(), (Object)Resource.get("INFO_NO_ADDALL"), (String)Resource.get("INFO_NO_ADDALL_TITLE"), null);
        }
        return state;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean invokeCommandImpl(VCSProfile profile, CommandState commandState, Component parentUi, Map options) throws Exception {
        IndeterminateProgressMonitor progress = new IndeterminateProgressMonitor(parentUi, Resource.get("OPERATION_ADD_PROGRESS_TITLE"));
        progress.setMillisToPopup(0);
        progress.setCloseOnFinish(true);
        progress.setCancellable(false);
        progress.start();
        try {
            boolean bl = this.invokeAdd(profile, commandState, options, progress);
            return bl;
        }
        finally {
            if (!progress.isCancelled()) {
                progress.finish();
            }
        }
    }

    @Override
    protected boolean invokeCommandSilentlyImpl(VCSProfile profile, CommandState commandState, Map options) throws Exception {
        return this.invokeAdd(profile, commandState, options, null);
    }

    private boolean invokeAdd(VCSProfile profile, CommandState commandState, Map options, IndeterminateProgressMonitor progress) throws Exception {
        GitClient client = null;
        Locatable[] locs = this.getGITVersionOperationPanel() == null ? commandState.getLocatables() : this.getGITVersionOperationPanel().getSelectedLocatables();
        Map<VCSHashURL, Collection<URL>> wtUrls = this.sortByWorkTree(locs);
        GITCommandProgressMonitor monitor = new GITCommandProgressMonitor(Resource.get("ADD_OPERATION"));
        monitor.setLog(true);
        Iterator<VCSHashURL> it = wtUrls.keySet().iterator();
        while (it.hasNext()) {
            try {
                VCSHashURL root = it.next();
                client = GITClientAdaptor.getClient(root.getURL());
                Collection<File> files = GITUtil.convertURLToFile(wtUrls.get(root).toArray(new URL[0]));
                this.updateProgress(progress, Resource.get("COMMIT_PROGRESS_ADD"));
                client.add(files.toArray(new File[0]), (ProgressMonitor)monitor);
                if (monitor.getError() != null) {
                    throw new GITProcessException(Resource.get("PROCESS_EXCEPTION_ADD_ERROR"), monitor.getError());
                }
                Collection<URL> processed = this.getProcessedUrlsNotifier(commandState);
                processed.addAll(wtUrls.get(root));
                commandState.setProperty("git.structure-changed", processed);
            }
            catch (GitException ex) {
                throw new GITProcessException(Resource.get("PROCESS_EXCEPTION_ADD_ERROR"), ex.getMessage());
            }
            finally {
                monitor.logCompleted();
                if (client == null) continue;
                client.release();
            }
        }
        return monitor.hasFinished();
    }

    @Override
    protected void postInvoke(VCSProfile profile, CommandState commandState) throws Exception {
        super.postInvoke(profile, commandState);
    }

    static class GitStatusUnadded
    implements GITStatusFilter {
        GitStatusUnadded() {
        }

        @Override
        public boolean accept(GitStatus status) {
            return this.unAdded(status);
        }

        private boolean unAdded(GitStatus stat) {
            if (GITStatusResolver.isAddedModified(stat)) {
                return true;
            }
            if (GITStatusResolver.isPendingModified(stat)) {
                return true;
            }
            if (stat.getStatusHeadIndex().equals((Object)GitStatus.Status.STATUS_NORMAL)) {
                if (stat.getStatusHeadWC().equals((Object)GitStatus.Status.STATUS_ADDED) && stat.getStatusIndexWC().equals((Object)GitStatus.Status.STATUS_ADDED)) {
                    return true;
                }
                if (stat.getStatusHeadWC().equals((Object)GitStatus.Status.STATUS_MODIFIED) && stat.getStatusIndexWC().equals((Object)GitStatus.Status.STATUS_MODIFIED)) {
                    return true;
                }
            }
            return false;
        }
    }
}

