/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.git.changelist;

import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import oracle.ide.Ide;
import oracle.ide.model.Workspace;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFilter;
import oracle.ideri.util.Product;
import oracle.jdeveloper.vcs.changelist.ChangeList;
import oracle.jdeveloper.vcs.changelist.ChangeListEvent;
import oracle.jdeveloper.vcs.changelist.ChangeListEventQueue;
import oracle.jdeveloper.vcs.spi.VCSHashURL;
import oracle.jdevimpl.vcs.git.GITClientAdaptor;
import oracle.jdevimpl.vcs.git.GITCommandProgressMonitor;
import oracle.jdevimpl.vcs.git.GITProfile;
import oracle.jdevimpl.vcs.git.GITUtil;
import org.netbeans.libs.git.GitClient;
import org.netbeans.libs.git.GitException;
import org.netbeans.libs.git.GitStatus;
import org.netbeans.libs.git.progress.ProgressMonitor;

public abstract class GITAbstractEventQueue
extends ChangeListEventQueue {
    private URLFilter _filter = new URLFilter(){

        public boolean accept(URL url) {
            return true;
        }
    };

    public GITAbstractEventQueue(ChangeList changeList) {
        super(changeList);
    }

    protected abstract boolean filter(GitStatus var1);

    protected boolean useVCSStatusURLS() {
        return Ide.getActiveWorkspace() != null;
    }

    protected Collection<? extends VCSHashURL> getVCSStatusURLS(ChangeListEvent cle) {
        Set<VCSHashURL> gitRoots = null;
        ArrayList<VCSHashURL> urls = new ArrayList<VCSHashURL>();
        GITCommandProgressMonitor monitor = new GITCommandProgressMonitor("status");
        gitRoots = !Product.isJDeveloper() ? this.getRoots() : this.getClientRoots(cle);
        try {
            for (VCSHashURL gitRoot : gitRoots) {
                GitClient client = GITClientAdaptor.getClient(gitRoot.getURL());
                this.getUrls(urls, monitor, gitRoot, client);
            }
            return urls;
        }
        catch (GitException e) {
            GITProfile.getQualifiedLogger(GITAbstractEventQueue.class.getName()).log(Level.SEVERE, e.getMessage());
            return Collections.emptyList();
        }
    }

    protected URLFilter getURLFilter() {
        return this._filter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void getUrls(Collection<VCSHashURL> urls, GITCommandProgressMonitor monitor, VCSHashURL gitRoot, GitClient client) throws GitException {
        try {
            File[] roots = new File[]{new File(gitRoot.getURL().getPath())};
            Map files = client.getStatus(roots, "HEAD", (ProgressMonitor)monitor);
            for (File file : files.keySet()) {
                if (!this.filter((GitStatus)files.get(file))) continue;
                URL fURL = URLFactory.newFileURL((File)file);
                if (!this.getURLFilter().accept(fURL)) continue;
                urls.add(new VCSHashURL(fURL));
            }
        }
        finally {
            client.release();
        }
    }

    private Set<VCSHashURL> getClientRoots(ChangeListEvent cle) {
        HashSet<VCSHashURL> roots = new HashSet<VCSHashURL>();
        Workspace[] wks = cle.getWorkspaces();
        if (wks == null) {
            wks = new Workspace[]{Ide.getActiveWorkspace()};
        }
        for (Workspace wk : wks) {
            VCSHashURL hUrl;
            URL root = GITUtil.getRootContaining(wk.getURL());
            if (root == null || roots.contains(hUrl = new VCSHashURL(root))) continue;
            roots.add(hUrl);
        }
        return roots;
    }

    private Set<VCSHashURL> getRoots() {
        URL[] roots = GITUtil.getReposRoots();
        LinkedHashSet<VCSHashURL> urls = new LinkedHashSet<VCSHashURL>();
        for (URL root : roots) {
            urls.add(new VCSHashURL(root));
        }
        return urls;
    }
}

