/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.git;

import java.awt.Component;
import java.io.File;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import javax.swing.SwingUtilities;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.config.Preferences;
import oracle.ide.file.ContentSetRoot;
import oracle.ide.log.LogManager;
import oracle.ide.model.Element;
import oracle.ide.model.Locatable;
import oracle.ide.model.Node;
import oracle.ide.model.NodeFactory;
import oracle.ide.model.Project;
import oracle.ide.model.Workspace;
import oracle.ide.navigator.NavigatorWindow;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.ide.net.URLFilter;
import oracle.ide.view.View;
import oracle.ide.webbrowser.AuthenticatorManager;
import oracle.ideri.util.Product;
import oracle.javatools.data.PropertyStorage;
import oracle.javatools.dialogs.MessageDialog;
import oracle.jdeveloper.vcs.generic.VCSProfile;
import oracle.jdeveloper.vcs.generic.VCSProfileRegistry;
import oracle.jdeveloper.vcs.nav.ConnectionProvider;
import oracle.jdeveloper.vcs.spi.VCSPreferences;
import oracle.jdeveloper.vcs.spi.VCSSingleWorkingCopyLocator;
import oracle.jdeveloper.vcs.spi.VCSStatus;
import oracle.jdeveloper.vcs.spi.VCSWorkingCopyNonProjectBased;
import oracle.jdevimpl.vcs.git.GITClientAdaptor;
import oracle.jdevimpl.vcs.git.GITCommandProgressMonitor;
import oracle.jdevimpl.vcs.git.GITConfig;
import oracle.jdevimpl.vcs.git.GITConnectionInfo;
import oracle.jdevimpl.vcs.git.GITNavURLFileSystemHelper;
import oracle.jdevimpl.vcs.git.GITProfile;
import oracle.jdevimpl.vcs.git.GITUser;
import oracle.jdevimpl.vcs.git.nav.GITRemote;
import oracle.jdevimpl.vcs.git.nav.GITRepositoryNavigator;
import oracle.jdevimpl.vcs.git.res.Resource;
import org.netbeans.libs.git.GitBranch;
import org.netbeans.libs.git.GitClient;
import org.netbeans.libs.git.GitException;
import org.netbeans.libs.git.GitMergeResult;
import org.netbeans.libs.git.GitRevisionInfo;
import org.netbeans.libs.git.GitTag;
import org.netbeans.libs.git.SearchCriteria;
import org.netbeans.libs.git.progress.ProgressMonitor;

public class GITUtil {
    private static final String WORKING_TREE_TYPE = "git-not-use-project";

    private GITUtil() {
    }

    public static URL getGitClientRoot(Workspace wks) {
        URL gitURL = GITUtil.getRootContaining(wks.getURL());
        if (gitURL == null) {
            URL url = wks.getActiveProjectURL();
            if (url == null) {
                return null;
            }
            gitURL = GITUtil.getRootContaining(url);
            if (gitURL != null) {
                return gitURL;
            }
            Project prj = wks.getActiveProject();
            if (prj.isOpen()) {
                Collection roots = ContentSetRoot.getContentSetRoots((Project)prj);
                for (ContentSetRoot root : roots) {
                    gitURL = GITUtil.getRootContaining(root.getURL());
                    if (gitURL == null) continue;
                    return gitURL;
                }
            }
        } else {
            return gitURL;
        }
        return null;
    }

    public static boolean insideWorkingCopy(URL url) {
        if (url == null) {
            return false;
        }
        if (!Product.isJDeveloper() || System.getProperty(WORKING_TREE_TYPE) != null) {
            return GITUtil.getWorkingTreeNonProjectLocator().getRootContaining(url) != null;
        }
        return GITUtil.getWorkingTreeLocator().getRootContaining(url) != null;
    }

    public static URL getRootContaining(URL url) {
        URL root = null;
        root = !Product.isJDeveloper() || System.getProperty(WORKING_TREE_TYPE) != null ? GITUtil.getWorkingTreeNonProjectLocator().getRootContaining(GITNavURLFileSystemHelper.fromNavigatorURL(url)) : GITUtil.getWorkingTreeLocator().getRootContaining(url);
        if (root == null) {
            return null;
        }
        final URL froot = root;
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                GITRepositoryNavigator.getInstance().createRepositoryConnection(new GITConnectionInfo(){

                    @Override
                    public URL getRootURL() {
                        return froot;
                    }
                });
            }
        });
        return root;
    }

    public static URL[] getReposRoots() {
        if (!Product.isJDeveloper() || System.getProperty(WORKING_TREE_TYPE) != null) {
            return GITUtil.getWorkingTreeNonProjectLocator().getRoots();
        }
        return GITUtil.getWorkingTreeLocator().getRoots();
    }

    public static Locatable[] convertURLToLocatable(Collection<URL> urls) {
        ArrayList<Node> locs = new ArrayList<Node>();
        for (URL url : urls) {
            try {
                Node node = NodeFactory.findOrCreate((URL)url);
                locs.add(node);
            }
            catch (Exception exception) {}
        }
        return locs.toArray(new Locatable[0]);
    }

    public static Collection<URL> convertFileToUrl(File[] files) {
        ArrayList<URL> urls = new ArrayList<URL>();
        for (File file : files) {
            urls.add(URLFactory.newFileURL((File)file));
        }
        return urls;
    }

    public static Collection<File> convertURLToFile(URL[] urls) {
        ArrayList<File> files = new ArrayList<File>();
        for (URL url : urls) {
            files.add(new File(url.getPath()));
        }
        return files;
    }

    public static Collection<File> convertURLToFile(URL[] urls, URLFilter filter) {
        ArrayList<File> files = new ArrayList<File>();
        for (URL url : urls) {
            if (!filter.accept(url)) continue;
            files.add(new File(url.getPath()));
        }
        return files;
    }

    public static Collection<File> convertLocatableToFile(Locatable[] locs) {
        ArrayList<File> files = new ArrayList<File>();
        for (Locatable loc : locs) {
            files.add(new File(loc.getURL().getPath()));
        }
        return files;
    }

    public static Collection<URL> convertLocatableToURL(Locatable[] locs) {
        ArrayList<URL> urls = new ArrayList<URL>();
        for (Locatable loc : locs) {
            urls.add(loc.getURL());
        }
        return urls;
    }

    public static boolean isRepositoryNavigatorView(View view) {
        return ConnectionProvider.isVersioningConnectionView((View)view);
    }

    public static GITRemote[] getGitRemoteNodes(Context context) {
        ArrayList<GITRemote> nodes = null;
        Element[] elms = context.getSelection();
        if (elms != null) {
            for (Element elm : elms) {
                if (!(elm instanceof GITRemote)) continue;
                if (nodes == null) {
                    nodes = new ArrayList<GITRemote>();
                }
                nodes.add((GITRemote)elm);
            }
        }
        return nodes == null ? new GITRemote[]{} : nodes.toArray(new GITRemote[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isLatest(URL root, String branchName, String revision) {
        GitClient client = null;
        try {
            client = GITClientAdaptor.getClient(root);
            GITCommandProgressMonitor monitor = new GITCommandProgressMonitor("log");
            GitRevisionInfo[] info = client.log(GITUtil.getSearchCriteria(root, branchName), (ProgressMonitor)monitor);
            if (info.length == 1 && info[0].getRevision().equals(revision)) {
                boolean bl = true;
                return bl;
            }
        }
        catch (GitException e) {
            GITProfile.getQualifiedLogger(GITUtil.class.getName()).log(Level.WARNING, e.getMessage());
        }
        catch (URISyntaxException e) {
            GITProfile.getQualifiedLogger(GITUtil.class.getName()).log(Level.WARNING, e.getMessage());
        }
        finally {
            if (client != null) {
                client.release();
            }
        }
        return false;
    }

    public static GitBranch getActiveBranch(Map<String, GitBranch> gitBranch) {
        for (String branch : gitBranch.keySet()) {
            GitBranch gBranch = gitBranch.get(branch);
            if (!gBranch.isActive()) continue;
            return gBranch;
        }
        return null;
    }

    public static void logMergeConflicts(GitMergeResult result) {
        Collection conflicts = result.getConflicts();
        GITUtil.logFiles(conflicts, Resource.get("MERGE_FAIL_OP_CONFLICT"));
    }

    public static void logMergeFailures(GitMergeResult result) {
        Collection failures = result.getFailures();
        GITUtil.logFiles(failures, Resource.get("MERGE_FAIL_OP_FAILURE"));
    }

    public static void logFiles(Collection<File> files, String information) {
        if (files.isEmpty()) {
            return;
        }
        GITUtil.log(information);
        Iterator<File> it = files.iterator();
        while (it.hasNext()) {
            GITUtil.log(it.next().getPath());
        }
    }

    public static void reportMergeFailures(Collection<File> failures) {
        GITUtil.reportFiles(failures, Resource.get("MERGE_FAILED_TITLE"), Resource.get("MERGE_FAIL_OP_UI_FAILURE"));
    }

    public static void reportMergeConflicts(Collection<File> conflicts) {
        GITUtil.reportFiles(conflicts, Resource.get("MERGE_CONFLICT_TITLE"), Resource.get("MERGE_CONFLICT_OP_UI_FAILURE"));
    }

    public static Collection<File> getModifiedFiles(GitClient client, String fromRevision, String toRevision, GITCommandProgressMonitor monitor) throws GitException.MissingObjectException, GitException {
        HashSet<File> modifiedFiles = new HashSet<File>();
        SearchCriteria sc = new SearchCriteria();
        sc.setRevisionFrom(fromRevision);
        sc.setRevisionTo(toRevision);
        GitRevisionInfo[] info = client.log(sc, (ProgressMonitor)monitor);
        for (int i = 0; i < info.length; ++i) {
            Map files = info[i].getModifiedFiles();
            Iterator itf = files.keySet().iterator();
            while (itf.hasNext()) {
                modifiedFiles.add((File)itf.next());
            }
        }
        return modifiedFiles;
    }

    public static void reportFiles(Collection<File> failures, Collection<File> conflicts, String title) {
        StringBuilder sb1 = new StringBuilder();
        StringBuilder sb2 = new StringBuilder();
        for (File file : failures) {
            sb1.append(file.getPath());
            sb1.append('\n');
        }
        for (File file : conflicts) {
            sb2.append(file.getPath());
            sb2.append('\n');
        }
        MessageDialog.information((Component)Ide.getMainWindow(), (Object)Resource.format("REVERT_COMMIT_ERROR_FAILURE_COMBINED", sb1.toString(), sb2.toString()), (String)title, null);
    }

    public static void reportFiles(Collection<File> files, String title, String msg) {
        if (files == null || files.isEmpty()) {
            return;
        }
        StringBuilder sb = new StringBuilder();
        sb.append(msg);
        sb.append('\n');
        Iterator<File> it = files.iterator();
        while (it.hasNext()) {
            sb.append(it.next().getPath());
            sb.append('\n');
        }
        MessageDialog.information((Component)Ide.getMainWindow(), (Object)sb.toString(), (String)title, null);
    }

    private static SearchCriteria getSearchCriteria(URL url, String branch) throws URISyntaxException {
        SearchCriteria search = new SearchCriteria();
        File[] files = new File[]{new File(url.toURI())};
        search.setFiles(files);
        search.setLimit(1);
        search.setRevisionTo(branch);
        return search;
    }

    private static void log(String message) {
        if (VCSPreferences.getInstance((PropertyStorage)Preferences.getPreferences(), (String)"oracle.jdeveloper.git").getAutoLogMessages()) {
            LogManager.getLogManager().getMsgPage().log((Object)message);
        }
    }

    public static String getRemoteBranchName(String name, String branch) {
        StringBuilder sb = new StringBuilder(name);
        sb.append("/");
        sb.append(branch);
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<String, GitBranch> getBranches(URL root, boolean remote) {
        GitClient client = null;
        try {
            GITCommandProgressMonitor monitor = new GITCommandProgressMonitor("branches");
            client = GITClientAdaptor.getClient(root);
            Map map = client.getBranches(remote, (ProgressMonitor)monitor);
            return map;
        }
        catch (GitException e) {
            GITProfile.getQualifiedLogger(GITUtil.class.getName()).log(Level.WARNING, e.getMessage());
            Map<String, GitBranch> map = Collections.emptyMap();
            return map;
        }
        finally {
            if (client != null) {
                client.release();
            }
        }
    }

    public static Map<String, GitBranch> getBranches(URL root) {
        return GITUtil.getBranches(root, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<String, GitTag> getTags(URL root) {
        GITCommandProgressMonitor monitor = new GITCommandProgressMonitor("getTags");
        GitClient client = null;
        try {
            Map tags;
            client = GITClientAdaptor.getClient(root);
            Map map = tags = client.getTags((ProgressMonitor)monitor, true);
            return map;
        }
        catch (GitException ge) {
            GITProfile.getQualifiedLogger(GITUtil.class.getName()).log(Level.WARNING, ge.getMessage());
            Map<String, GitTag> map = Collections.emptyMap();
            return map;
        }
        finally {
            if (client != null) {
                client.release();
            }
        }
    }

    public static boolean isConflict(URL url) {
        VCSProfile profile = VCSProfileRegistry.getInstance().getProfile("oracle.jdeveloper.git");
        try {
            VCSStatus status = (VCSStatus)profile.getStatusCacheBridge().get(url);
            return status.equals(profile.getStatusInstance("CONFLICT"));
        }
        catch (Exception e) {
            GITProfile.getQualifiedLogger(GITUtil.class.getName()).log(Level.WARNING, "Failed to get status of " + URLFileSystem.getPlatformPathName((URL)url));
            return false;
        }
    }

    public static boolean authenticator(String urlStr) {
        if (urlStr.startsWith("http://") || urlStr.startsWith("https://")) {
            AuthenticatorManager.getInstance().pushAuthenticator(null);
            return true;
        }
        return false;
    }

    public static void authenricatorRestore(boolean restore) {
        if (restore) {
            AuthenticatorManager.getInstance().popAuthenticator();
        }
    }

    private static VCSSingleWorkingCopyLocator getWorkingTreeLocator() {
        return VCSSingleWorkingCopyLocator.getLocatorInstance((String)"oracle.jdeveloper.git", (String)".git/");
    }

    private static VCSWorkingCopyNonProjectBased getWorkingTreeNonProjectLocator() {
        return VCSWorkingCopyNonProjectBased.getInstance((String)"oracle.jdeveloper.git", (String)".git/");
    }

    public static URL getClientRoot() {
        URL tRoot = null;
        if (!Product.isJDeveloper()) {
            NavigatorWindow window = Ide.getLastActiveNavigator();
            if (window != null) {
                Context context = window.getContext();
                Node node = context.getNode();
                if (node != null && node.getURL() != null) {
                    tRoot = GITUtil.getRootContaining(node.getURL());
                } else {
                    Element elm = context.getElement();
                    if (elm != null && elm instanceof Locatable && ((Locatable)elm).getURL() != null) {
                        tRoot = GITUtil.getRootContaining(((Locatable)elm).getURL());
                    }
                }
            }
        } else {
            URL gitUrl;
            Workspace wks = Ide.getActiveWorkspace();
            if (wks == null) {
                return null;
            }
            tRoot = gitUrl = GITUtil.getGitClientRoot(wks);
        }
        return tRoot;
    }

    public static String getSuffixAsType(URL url) {
        String type = URLFileSystem.getSuffix((URL)url);
        if (type.length() > 1) {
            type = type.substring(1);
        }
        return type;
    }

    public static String shortCommitId(String commit) {
        return commit.substring(0, 7);
    }

    public static List<GITUser> getUserList(URL root) {
        GITConfig config = new GITConfig();
        return config.getUsers(root);
    }
}

