/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.timesten.utils;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.SwingUtilities;
import oracle.dbtools.raptor.backgroundTask.IRaptorTaskListener;
import oracle.dbtools.raptor.backgroundTask.IRaptorTaskRunMode;
import oracle.dbtools.raptor.backgroundTask.RaptorTask;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskAdapter;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskEvent;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskManager;
import oracle.dbtools.raptor.backgroundTask.TaskException;
import oracle.dbtools.raptor.timesten.DataSheet;
import oracle.dbtools.raptor.timesten.Messages;
import oracle.dbtools.raptor.timesten.TimesTenUtil;
import oracle.dbtools.raptor.timesten.commands.TTInstanceInformation;
import oracle.dbtools.raptor.timesten.editors.TTSchemaSQLTab;

public class TTSchema {
    private static Logger theLogger = Logger.getLogger(TTSchema.class.getPackage().getName());
    private static final String[] SYSTEM_SCHEMA = new String[]{"SYS", "TTREP"};
    private static final Pattern PASSWORD_PROMPT_REGEX = Pattern.compile("(^Enter\\s+password\\s+for\\s+[^:]*:\\s*)(.*)");
    private static final DataSheet theDataSheet = DataSheet.getInstance();

    public static String getDDL(TTSchemaSQLTab.ResultCallBack resultCallBack, String string, String string2, String string3, boolean bl, boolean bl2, String string4) {
        Object object;
        String[] stringArray = null;
        String string5 = null;
        string5 = System.getProperty("os.name").toLowerCase().startsWith("windows") ? "ttSchema" : (bl ? "ttSchemaCS" : "ttSchema");
        String string6 = null;
        if (string.toUpperCase().indexOf("TTC_SERVER_DSN") != -1) {
            object = TTInstanceInformation.getInstance();
            string6 = "\"" + string + ";" + ((TTInstanceInformation)object).getClientDriver() + "\"";
        } else {
            string6 = "\"DSN=" + string + "\"";
        }
        object = string2 == null ? "\"" + string3 + "\"" : "\"" + string2 + "\"" + "." + "\"" + string3 + "\"";
        stringArray = TTSchema.getArgs(string5, string6, string2, (String)object);
        TTSchemaTask tTSchemaTask = new TTSchemaTask(resultCallBack, string5, stringArray, bl2, string4);
        RaptorTaskManager.getInstance().addTask((RaptorTask)tTSchemaTask);
        if (resultCallBack == null) {
            try {
                return (String)tTSchemaTask.getResult();
            }
            catch (Exception exception) {
                theLogger.log(Level.SEVERE, "Background execution failed", exception);
            }
        }
        return "";
    }

    public static String[] run(String[] stringArray) {
        return TTSchema.run(stringArray, false, null);
    }

    /*
     * WARNING - void declaration
     */
    public static String[] run(String[] stringArray, boolean bl, String string) {
        StringBuilder stringBuilder = new StringBuilder();
        String[] stringArray2 = new String[]{null, null};
        String string2 = null;
        String string3 = null;
        try {
            String string4;
            Object object;
            StringBuffer stringBuffer = new StringBuffer(128);
            for (String string5 : stringArray) {
                void object22;
                if (!System.getProperty("os.name").toLowerCase().startsWith("windows")) {
                    String string6 = string5.replace("$", "\\$");
                }
                stringBuffer.append((String)object22);
                stringBuffer.append(" ");
            }
            Object object3 = null;
            theLogger.log(Level.INFO, "Executing " + stringBuffer.toString());
            if (System.getProperty("os.name").toLowerCase().startsWith("windows")) {
                try {
                    object = TTSchema.generateWindowsBatFile(stringBuffer.toString());
                    theLogger.log(Level.INFO, "Executing bat file" + ((File)object).getCanonicalPath());
                    String[] stringArray3 = new String[]{((File)object).getCanonicalPath()};
                    object3 = Runtime.getRuntime().exec(stringArray3);
                }
                catch (IOException iOException) {
                    stringArray2[0] = Messages.getString("TTSchema.GeneratingBatchFileFailed") + iOException.toString();
                    stringArray2[1] = stringArray2[0];
                    return stringArray2;
                }
            }
            try {
                object = TTSchema.generateUnixShellScript(stringBuffer.toString());
                theLogger.log(Level.INFO, "Executing shell script" + ((File)object).getCanonicalPath());
                object3 = Runtime.getRuntime().exec("/bin/sh " + ((File)object).getCanonicalPath());
            }
            catch (IOException iOException) {
                stringArray2[0] = Messages.getString("TTSchema.GeneratingShellScriptFailed") + iOException.toString();
                stringArray2[1] = stringArray2[0];
                return stringArray2;
            }
            object = new BufferedReader(new InputStreamReader(((Process)object3).getInputStream()));
            if (bl) {
                BufferedWriter bufferedWriter = new BufferedWriter(new OutputStreamWriter(((Process)object3).getOutputStream()));
                if (string != null) {
                    bufferedWriter.write(string);
                }
                bufferedWriter.newLine();
                bufferedWriter.flush();
            }
            boolean bl2 = false;
            while ((string4 = ((BufferedReader)object).readLine()) != null) {
                Matcher matcher;
                if (!bl2 && (matcher = PASSWORD_PROMPT_REGEX.matcher(string4)).matches()) {
                    bl2 = true;
                    string4 = matcher.group(2);
                    if (string4.length() == 0) continue;
                }
                stringBuilder.append(string4);
                stringBuilder.append("\n");
            }
            ((BufferedReader)object).close();
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(((Process)object3).getErrorStream()));
            StringBuffer stringBuffer2 = new StringBuffer(256);
            while ((string4 = bufferedReader.readLine()) != null) {
                stringBuffer2.append(string4);
            }
            bufferedReader.close();
            int n = stringArray.length - 1;
            if (stringBuffer2.length() > 0) {
                string3 = stringBuffer2.toString();
                if (stringBuilder.length() == 0) {
                    theLogger.log(Level.SEVERE, "Cannot generate SQL for" + stringArray[n]);
                    theLogger.log(Level.SEVERE, string3);
                } else {
                    theLogger.log(Level.WARNING, "Warnings generated during SQL generation for " + stringArray[n]);
                    theLogger.log(Level.WARNING, string3);
                }
            }
        }
        catch (Exception exception) {
            theLogger.log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
        }
        stringArray2[0] = string2 = stringBuilder.toString();
        stringArray2[1] = string3;
        return stringArray2;
    }

    private static File generateUnixShellScript(String string) throws IOException {
        File file = null;
        File file2 = null;
        BufferedWriter bufferedWriter = null;
        Object var4_4 = null;
        try {
            file = new File("/tmp");
            file2 = File.createTempFile("SQD" + System.getProperty("pid"), ".sh", file);
            file2.delete();
            file2.createNewFile();
            FileWriter fileWriter = new FileWriter(file2);
            bufferedWriter = new BufferedWriter(fileWriter);
            fileWriter.write("#!/bin/sh\n");
            fileWriter.write("export TT_INTERACTIVE=1\n");
            fileWriter.write(string + "\n");
            file2.deleteOnExit();
            File file3 = file2;
            return file3;
        }
        catch (IOException iOException) {
            throw iOException;
        }
        finally {
            try {
                if (bufferedWriter != null) {
                    bufferedWriter.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    private static File generateWindowsBatFile(String string) throws IOException {
        File file = null;
        File file2 = null;
        BufferedWriter bufferedWriter = null;
        Object var4_4 = null;
        try {
            String string2 = System.getProperty("user.home");
            file = new File(string2);
            file2 = File.createTempFile("SQD" + System.getProperty("pid"), ".bat", file);
            file2.delete();
            file2.createNewFile();
            FileWriter fileWriter = new FileWriter(file2);
            bufferedWriter = new BufferedWriter(fileWriter);
            fileWriter.write("@set TT_INTERACTIVE=1\n");
            fileWriter.write("@" + string + "\n");
            file2.deleteOnExit();
            File file3 = file2;
            return file3;
        }
        catch (IOException iOException) {
            throw iOException;
        }
        finally {
            try {
                if (bufferedWriter != null) {
                    bufferedWriter.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    private static String[] getArgs(String string, String string2, String string3, String string4) {
        String[] stringArray = null;
        String string5 = TTInstanceInformation.getInstance().getInstanceVersion();
        stringArray = string5.indexOf("11.2.1") != -1 ? (TimesTenUtil.isSystemSchema(string3) ? new String[]{string, "-st", theDataSheet.isClientCapable(DataSheet.FeatureType.TTSchemaSqlDeveloperArg) ? "-noplsqlAttrs -caller sqldev" : "-noplsqlAttrs", "-connStr", string2, string4} : new String[]{string, theDataSheet.isClientCapable(DataSheet.FeatureType.TTSchemaSqlDeveloperArg) ? "-noplsqlAttrs -caller sqldev" : "-noplsqlAttrs", "-connStr", string2, string4}) : (TimesTenUtil.isSystemSchema(string3) ? new String[]{string, "-st", "-connStr", string2, string4} : new String[]{string, "-connStr", string2, string4});
        return stringArray;
    }

    private static class TTSchemaTask
    extends RaptorTask<String> {
        private final String[] theArgs;
        private final boolean thePromptFlag;
        private final String thePassword;
        private final TTSchemaSQLTab.ResultCallBack theResultCallBack;
        private boolean theCancelledFlag;

        public TTSchemaTask(TTSchemaSQLTab.ResultCallBack resultCallBack, String string, String[] stringArray, boolean bl, String string2, IRaptorTaskRunMode iRaptorTaskRunMode) {
            super(string, true, iRaptorTaskRunMode);
            this.theArgs = stringArray;
            this.thePromptFlag = bl;
            this.thePassword = string2;
            this.theResultCallBack = resultCallBack;
            this.setCancellable(false);
            this.addListener();
        }

        public TTSchemaTask(TTSchemaSQLTab.ResultCallBack resultCallBack, String string, String[] stringArray, boolean bl, String string2) {
            this(resultCallBack, string, stringArray, bl, string2, IRaptorTaskRunMode.IDE_STATUSBAR);
        }

        protected String doWork() throws TaskException {
            String[] stringArray = TTSchema.run(this.theArgs, this.thePromptFlag, this.thePassword);
            return stringArray[0];
        }

        private void addListener() {
            RaptorTaskAdapter raptorTaskAdapter = new RaptorTaskAdapter(){

                public void taskFinished(RaptorTaskEvent raptorTaskEvent) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            try {
                                theResultCallBack.setResult((String)this.getResult());
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        }
                    });
                }
            };
            this.getDescriptor().addListener((IRaptorTaskListener)raptorTaskAdapter);
        }
    }
}

