/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.timesten.dialogs.table.load;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.Icon;
import oracle.dbtools.raptor.images.RaptorImagesArb;
import oracle.dbtools.raptor.timesten.Messages;

public class Common {
    public static final int MAX_PARALLEL_LOADS = 16;
    public static final int MAX_IDX_LENGTH = 25;
    public static final int UNIQUE_VALUES = 8;
    public static final int SECONDS_TO_UPDATE_COUNT = 5;
    public static final int ORACLE_PASSWORD_ERROR = 15022;
    public static final int ROWS_NEEDED_FOR_PARALLEL_LOAD = 500000;
    public static final int DEFAULT_PARALLEL_THREAD_COUNT = 4;
    public static final int MINIMUM_PARALLEL_THREAD_COUNT = 2;
    public static final int WAITING = 0;
    public static final int IN_PROGRESS = 1;
    public static final int DONE = 2;
    public static final int NONE = 3;
    public static final int ERROR = 4;
    public static final int USERNAME_COLUMN_INDEX = 0;
    public static final int TABLENAME_COLUMN_INDEX = 1;
    public static final int SELECT_COLUMN_INDEX = 2;
    public static final int COUNT_COLUMN_INDEX = 3;
    public static final int CREATE_COLUMN_INDEX = 4;
    public static final int NUMBER_LOADS_COLUMN_INDEX = 5;
    public static final int NUMBER_THREADS_COLUMN_INDEX = 6;
    public static final int STATUS_COLUMN_INDEX = 7;
    public static final int DISABLE_PARALLEL_LOADS = 1;
    public static final int ENABLE_DEFAULT_PARALLEL_LOADS = 2;
    public static final int TABLE_ALREADY_EXIST = 2207;
    public static final int SPACE_EXHAUSTED_EXCEPTION = 802;
    public static final int ROOT = 1;
    public static final int SCHEMA = 2;
    public static final int TABLE = 3;
    public static final String COMMIT = "commit;";
    public static final String TT_IND_PREFIX = "SQLD_";
    public static final String GET_INDEXES = "SELECT OWNER, INDEX_NAME, INDEX_TYPE, TABLE_TYPE, UNIQUENESS FROM ALL_INDEXES WHERE TABLE_OWNER = '#towner#' AND TABLE_NAME = '#tname#' AND STATUS = 'VALID' and INDEX_TYPE IN ('NORMAL', 'FUNCTION-BASED NORMAL', 'BITMAP', 'IOT_TOP') AND TABLE_TYPE IN ('TABLE', 'VIEW') ORDER BY TABLE_OWNER, TABLE_NAME";
    public static final String GET_COLUMNS = "SELECT COLUMN_NAME, COLUMN_POSITION, DESCEND FROM ALL_IND_COLUMNS WHERE INDEX_OWNER = '#iowner#' AND INDEX_NAME = '#iname#' ORDER BY COLUMN_POSITION";
    public static final String GET_COL_EXPR = "SELECT COLUMN_EXPRESSION FROM ALL_IND_EXPRESSIONS WHERE INDEX_OWNER = '#iowner#' AND INDEX_NAME = '#iname#' AND COLUMN_POSITION = #colpos#";
    public static final String GET_PRIMARY_KEYS = "SELECT CONSTRAINT_NAME, INDEX_NAME FROM ALL_CONSTRAINTS WHERE CONSTRAINT_TYPE = 'P' AND STATUS = 'ENABLED' AND VALIDATED = 'VALIDATED' AND OWNER = '#towner#' AND TABLE_NAME = '#tname#'";
    public static final String GET_UNIQUE_KEYS = "SELECT CONSTRAINT_NAME FROM ALL_CONSTRAINTS WHERE CONSTRAINT_TYPE = 'U' AND STATUS = 'ENABLED' AND VALIDATED = 'VALIDATED' AND OWNER = '#towner#' AND TABLE_NAME = '#tname#'";
    public static final String EXIST_INDEX = "SELECT IXTYPE, ISUNIQUE, ISPRIMARY FROM SYS.INDEXES WHERE IXNAME = '#iname#' AND IXOWNER = '#iowner#' AND TBLID = #tblid#";
    public static final String UNIQUE_COL = "SELECT COLOPTIONS FROM SYS.COLUMNS WHERE ID = #id# AND COLNAME = '#colname#'";
    public static final String GET_TABLE_ID = "SELECT TBLID FROM SYS.TABLES WHERE TBLNAME = '#tname#' AND TBLOWNER = '#towner#'";
    public static final String GET_COL_NUM = "SELECT COLNUM FROM SYS.COLUMNS WHERE ID = #id# AND COLNAME = '#colname#'";
    public static final String GET_TT_IDX_NAME = "SELECT IXNAME FROM SYS.INDEXES WHERE TBLID = #tblid# AND KEYCOLS = 0x#keycols#";
    public static final String LOAD_TABLE_FROM_ORACLE = "call ttLoadFromOracle('#tblOwner#','#tblName#', '#Query#', #numThreads#);";
    public static final String USER_TABLES_UNFILTERED = "SELECT table_name FROM all_tables WHERE owner = '#user#'";
    public static final String USER_TABLES_FILTERED = "SELECT table_name FROM all_tables WHERE owner = '#user#' AND table_name #filter#";
    public static final String TABLE_SELECT = "SELECT * from #schema#.#tableName#";
    public static final String TABLE_SCHEMA_LOAD_FROM_ORA = "call ttTableSchemaFromOraQueryGet('#owner#','#table#','#query#');";
    public static final String[] likeOptions = new String[]{"=", "<>", "LIKE", "NOT LIKE"};
    public static final String DO_PASSTHROUGH = "call ttOptSetFlag('PassThrough', 3);";
    public static final String REMOVE_PASSTHROUGH = "call ttOptSetFlag('PassThrough', 1);";
    public static final String ORA_HASH = " WHERE ORA_HASH(ROWID,#SEED#)=#SEEDCOUNT#";
    public static final String ORA_HASH_WITH_WHERE_CLAUSE = " WHERE ORA_HASH(ROWID,#SEED#)=#SEEDCOUNT# AND";
    public static final String UPDATE_TABLE_STATS = "call ttOptUpdateStats('#table#', 1, 0);";
    public static final String[] STATUS_TEXT = new String[]{Messages.getString("LoadTablesFromOracle.waiting"), Messages.getString("LoadTablesFromOracle.inProgress"), Messages.getString("LoadTablesFromOracle.done"), ""};
    public static final String[] HEADER = new String[]{Messages.getString("LoadTablesFromOracle.timesTenUsernameHeader"), Messages.getString("LoadTablesFromOracle.timesTenTableNameHeader"), Messages.getString("LoadTablesFromOracle.timesTenSelectQueryHeader"), Messages.getString("LoadTablesFromOracle.rowCountHeader"), Messages.getString("LoadTablesFromOracle.createStatementHeader"), Messages.getString("LoadTablesFromOracle.parallelLoadHeader"), Messages.getString("LoadTablesFromOracle.parallelThreadHeader"), Messages.getString("LoadTablesFromOracle.statusHeader")};
    public static final String MAX_PARALLEL_LOADS_PROP = "oracle.dbtools.raptor.timesten.maxparallelloads";
    private static final String VALID_QUERY_REGEX = "(SELECT\\s+\\*\\s+FROM\\s+[^\"\\s\\.]+)|(SELECT\\s+\\*\\s+FROM\\s+[^\"\\s\\.]+\\s*\\.\\s*[^\"\\s\\.]+)|(SELECT\\s+\\*\\s+FROM\\s+\"[^\"]+\")|(SELECT\\s+\\*\\s+FROM\\s+\"[^\"]+\"\\s*\\.\\s*[^\"\\s\\.]+)|(SELECT\\s+\\*\\s+FROM\\s+\"[^\"]+\"\\s*\\.\\s*\"[^\"]+\")|(SELECT\\s+\\*\\s+FROM\\s+[^\"\\s\\.]+\\s*\\.\\s*\"[^\"]+\")";
    public static final Icon SCHEMA_FOLDER_ICON = RaptorImagesArb.getIcon((String)"SCHEMA_FOLDER");
    public static final Icon TABLE_ICON = RaptorImagesArb.getIcon((String)"OTHER_TABLES");
    public static final Icon SCHEMA_ICON = RaptorImagesArb.getIcon((String)"SCHEMA");
    public static final Pattern VALID_QUERY_PATTERN = Pattern.compile("(SELECT\\s+\\*\\s+FROM\\s+[^\"\\s\\.]+)|(SELECT\\s+\\*\\s+FROM\\s+[^\"\\s\\.]+\\s*\\.\\s*[^\"\\s\\.]+)|(SELECT\\s+\\*\\s+FROM\\s+\"[^\"]+\")|(SELECT\\s+\\*\\s+FROM\\s+\"[^\"]+\"\\s*\\.\\s*[^\"\\s\\.]+)|(SELECT\\s+\\*\\s+FROM\\s+\"[^\"]+\"\\s*\\.\\s*\"[^\"]+\")|(SELECT\\s+\\*\\s+FROM\\s+[^\"\\s\\.]+\\s*\\.\\s*\"[^\"]+\")");

    public static boolean validQuery(String string) {
        return VALID_QUERY_PATTERN.matcher(string.trim().toUpperCase()).matches();
    }

    public static String getOracleTableFromQuery(String string) {
        int n = -1;
        Matcher matcher = VALID_QUERY_PATTERN.matcher(string = string.trim().toUpperCase());
        if (matcher.matches()) {
            for (int i = 1; i <= matcher.groupCount(); ++i) {
                if (matcher.start(i) < 0) continue;
                n = i;
                break;
            }
        }
        if (n >= 0 && n < matcher.groupCount()) {
            switch (n) {
                case 1: {
                    n = string.indexOf("FROM");
                    return string.substring(n + 4).trim();
                }
                case 2: {
                    n = string.indexOf(".");
                    return string.substring(n + 1).trim();
                }
                case 3: {
                    n = string.indexOf("\"");
                    return string.substring(n);
                }
                case 4: 
                case 5: 
                case 6: {
                    n = string.lastIndexOf(".");
                    return string.substring(n + 1).trim();
                }
            }
        }
        return null;
    }

    public static boolean isParallelLoadEnabled(int n) {
        return n > 1;
    }
}

