/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.timesten.dialogs.cache;

import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.UIManager;
import javax.swing.border.TitledBorder;
import oracle.dbtools.raptor.timesten.Messages;
import oracle.dbtools.raptor.timesten.dialogs.DialogBase;
import oracle.dbtools.raptor.timesten.dialogs.TTDialog;
import oracle.dbtools.raptor.timesten.dialogs.cache.CGAutorefreshPanel;
import oracle.dbtools.raptor.timesten.dialogs.cache.CGCPanel;
import oracle.dbtools.raptor.timesten.dialogs.cache.CGTypeMenuRenderer;
import oracle.dbtools.raptor.timesten.dialogs.cache.CacheGroupNameField;
import oracle.dbtools.raptor.timesten.dialogs.cache.UMPanel;
import oracle.dbtools.raptor.utils.DBObject;

public final class CGCCGPanel
extends DialogBase
implements ItemListener {
    public static final int CG_TYPE_RO = 1;
    public static final int CG_TYPE_AWT = 2;
    public static final int CG_TYPE_SWT = 3;
    public static final int CG_TYPE_UM_RO = 4;
    public static final int CG_TYPE_UM_PA = 5;
    public static final int CG_TYPE_UM_VAR = 6;
    static final String RO = Messages.getString("CGCCGPanel.RO");
    static final String AWT = Messages.getString("CGCCGPanel.AWT");
    static final String SWT = Messages.getString("CGCCGPanel.SWT");
    static final String UM = Messages.getString("CGCCGPanel.UM");
    boolean _autorefresh = true;
    private int _cgType = 1;
    private JPanel _cards;
    private CGAutorefreshPanel _afPanel;
    private UMPanel _umPanel;
    private CacheGroupNameField _name;
    private JComboBox _cgTypeMenu;
    private Object _menuRO;
    private Object _menuAWT;
    private Object _menuSWT;
    private Object _menuUM;
    private CGTypeMenuRenderer _cgTypeMenuRenderer;
    private JCheckBox _globalCG;
    private JCheckBox _dynamicCG;
    private String _lastName;
    private final String _regEx = "[a-zA-Z][_0-9a-zA-Z]{0,29}";
    private Object _curMenuSelection = -1;
    private boolean _byPass = false;

    public int getCGType() {
        return this._cgType < 4 ? this._cgType : this._umPanel.getCGType();
    }

    public boolean isCGTypeDynamic() {
        if (this._dynamicCG == null) {
            return false;
        }
        return this._dynamicCG.isSelected();
    }

    public boolean isCGTypeGlobal() {
        if (this._globalCG == null) {
            return false;
        }
        return this._globalCG.isSelected();
    }

    public String getCGTypeDynamic() {
        return this.isCGTypeDynamic() ? "DYNAMIC " : "";
    }

    public String getCGTypeGlobal() {
        return this.isCGTypeGlobal() ? "GLOBAL " : "";
    }

    public boolean isAutorefresh() {
        return this._autorefresh || this._cgType >= 4 && this._umPanel.isAutorefresh();
    }

    @Override
    public String getName() {
        String string = "";
        try {
            string = this._name.getText().trim();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return string.toUpperCase();
    }

    public CGCCGPanel(DBObject dBObject, String string, List<JComponent> list) {
        super(dBObject, string, "CGCCGPanel", list);
        CGCCGPanel.LOUD("tab 0: cg");
    }

    @Override
    protected void initGUI() {
        JPanel jPanel;
        this.addOwnerAndName(this._dict);
        this._name = new CacheGroupNameField(this._dbObject);
        this._name.setColumns(30);
        this.addRow(Messages.getString("TimesTen.common.name") + ": ", (Component)this._name);
        this._textValues.add(this._name);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 23;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        CGCPanel cGCPanel = CGCPanel.theDialog;
        JPanel jPanel2 = null;
        boolean bl = CGCPanel.allowDynamicCG(this._dbObject);
        if (bl) {
            jPanel2 = new JPanel(new GridBagLayout());
            this._globalCG = new JCheckBox(Messages.getString("CGC.global"), false);
            this._dynamicCG = new JCheckBox(Messages.getString("CGC.dynamic"), false);
            this._textValues.add(this._globalCG);
            this._textValues.add(this._dynamicCG);
            this._globalCG.addItemListener(this);
            this._dynamicCG.addItemListener(this);
            jPanel = new JPanel();
            jPanel.add(this._globalCG);
            jPanel.add(this._dynamicCG);
            jPanel2.add((Component)jPanel, gridBagConstraints);
        }
        jPanel = null;
        jPanel = new JPanel(new GridBagLayout());
        Object object = new String[]{RO, AWT, SWT, UM};
        this._cgTypeMenu = new JComboBox<String>((E[])object);
        this._menuRO = this._cgTypeMenu.getItemAt(0);
        this._menuAWT = this._cgTypeMenu.getItemAt(1);
        this._menuSWT = this._cgTypeMenu.getItemAt(2);
        this._menuUM = this._cgTypeMenu.getItemAt(3);
        this._textValues.add(this._cgTypeMenu);
        this._cgTypeMenu.setEditable(false);
        this._cgTypeMenu.addItemListener(this);
        this._cgTypeMenuRenderer = new CGTypeMenuRenderer((String[])object);
        this._cgTypeMenu.setRenderer(this._cgTypeMenuRenderer);
        jPanel.add((Component)this._cgTypeMenu, gridBagConstraints);
        if (bl) {
            this.addRow(Messages.getString("CGCCGPanel.type"), (Component)jPanel2);
            this.addRow("", (Component)jPanel);
        } else {
            this.addRow(Messages.getString("CGCCGPanel.type"), (Component)jPanel);
        }
        object = new JPanel();
        this._afPanel = new CGAutorefreshPanel(this._dbObject, this._textValues);
        ((Container)object).add(this._afPanel);
        TitledBorder titledBorder = BorderFactory.createTitledBorder(Messages.getString("CGCCGPanel.autorefreshAttributes"));
        ((JComponent)object).setBorder(titledBorder);
        JPanel jPanel3 = new JPanel();
        JPanel jPanel4 = new JPanel();
        this._umPanel = new UMPanel(this._dbObject, null, this._textValues, this);
        titledBorder = BorderFactory.createTitledBorder(Messages.getString("TimesTen.common.tableAttribs"));
        this._umPanel.setBorder(titledBorder);
        this._cards = new JPanel(new CardLayout());
        this._cards.add((Component)object, RO);
        this._cards.add((Component)jPanel3, AWT);
        this._cards.add((Component)jPanel4, SWT);
        this._cards.add((Component)this._umPanel, UM);
        this._cards.setAlignmentX(0.0f);
        this.c.new_row(1);
        this.c.gridwidth = 1;
        this.c.gridheight = 1;
        this.c.fill = 0;
        this.c.insets = new Insets(2, 2, 2, 2);
        this.c.anchor = 18;
        this.c.weightx = 1.0;
        this.c.weighty = 1.0;
        this.gridbag.setConstraints(this._cards, this.c);
        this.add(this._cards);
        this.setBackground(UIManager.getColor("EWTDialog.background"));
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        boolean bl;
        if (this._byPass) {
            return;
        }
        CGCPanel cGCPanel = CGCPanel.theDialog;
        boolean bl2 = cGCPanel.isVanillaCG();
        CardLayout cardLayout = (CardLayout)this._cards.getLayout();
        Object object = itemEvent.getItem();
        boolean bl3 = bl = itemEvent.getStateChange() == 1;
        if (object.equals(this._globalCG)) {
            if (bl) {
                if (!CGCPanel.allowNonDynamicGlobalCG(this._dbObject)) {
                    this._dynamicCG.setSelected(true);
                    this._dynamicCG.setEnabled(false);
                }
                this._cgTypeMenu.setSelectedItem(AWT);
                this._cgTypeMenuRenderer.setEnabled(RO, false);
                this._cgTypeMenuRenderer.setEnabled(SWT, false);
                this._cgTypeMenuRenderer.setEnabled(UM, false);
            } else {
                this._dynamicCG.setEnabled(true);
                this._cgTypeMenuRenderer.setEnabled(RO, true);
                this._cgTypeMenuRenderer.setEnabled(SWT, true);
                this._cgTypeMenuRenderer.setEnabled(UM, true);
            }
        } else if (object.equals(this._dynamicCG)) {
            if (bl) {
                // empty if block
            }
            this.nudgeTheDialog();
        } else {
            if (!bl) {
                this._curMenuSelection = object;
            } else if (!this._cgTypeMenuRenderer.isEnabled(object.toString())) {
                this._byPass = true;
                this._cgTypeMenu.setSelectedItem(this._curMenuSelection);
                this._byPass = false;
            } else {
                this._autorefresh = false;
                if (object == this._menuRO) {
                    this._cgType = 1;
                    this._autorefresh = true;
                } else {
                    this._cgType = object == this._menuAWT ? 2 : (object == this._menuSWT ? 3 : 6);
                }
                this.nudgeTheDialog();
                cardLayout.show(this._cards, (String)object);
            }
            boolean bl4 = CGCPanel.theDialog.isVanillaCG();
            if (bl2 != bl4) {
                // empty if block
            }
            CGCPanel.theDialog.cgTypeChanged();
        }
    }

    void nudgeTheDialog() {
        CGCPanel.theDialog.nudgeTheDialog();
    }

    @Override
    public String getSql() {
        if (!this.isAutorefresh()) {
            return "";
        }
        if (this._cgType >= 4) {
            return this._umPanel.getSql();
        }
        return this._afPanel.getSql();
    }

    @Override
    public boolean validateValues() {
        boolean bl = true;
        StringBuffer stringBuffer = new StringBuffer(128);
        if (this._name.getText().trim().length() == 0) {
            stringBuffer.append(Messages.getString("CGCCGPanel.cacheGroupNameCannotBeempty"));
            bl = false;
        }
        if (!bl) {
            TTDialog.showError(this, stringBuffer.toString());
        }
        return bl;
    }
}

