/*
 * Decompiled with CFR 0.152.
 */
package sqlj.runtime;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.util.Stack;
import oracle.jdbc.OracleCallableStatement;
import oracle.jdbc.OracleConnection;
import oracle.jdbc.OraclePreparedStatement;
import oracle.jdbc.OracleResultSet;
import oracle.sqlj.runtime.OraDynamicClosure;
import sqlj.runtime.ConnectionContext;
import sqlj.runtime.error.RuntimeRefErrors;
import sqlj.runtime.profile.BatchContext;
import sqlj.runtime.profile.ConnectedProfile;
import sqlj.runtime.profile.RTResultSet;
import sqlj.runtime.profile.RTStatement;
import sqlj.runtime.profile.ref.OraCallableStmtWrapper;
import sqlj.runtime.profile.ref.OraPreparedStmtWrapper;
import sqlj.runtime.ref.ConnectionContextImpl;

public class ExecutionContext {
    private int m_maxFieldSize = 0;
    private int m_maxRows = 0;
    private int m_queryTimeout = 0;
    private int m_updateCount = 0;
    private SQLWarning m_warnings = null;
    private int m_batchLimit = 0;
    private boolean m_isBatching = false;
    private BatchContext m_batchContext = null;
    private int[] m_batchUpdateCounts = null;
    private int m_fetchSize = 0;
    private int m_fetchDirection = 0;
    private StatementStack m_statementStack = new StatementStack();
    public static final int QUERY_COUNT = -1;
    public static final int EXCEPTION_COUNT = -2;
    public static final int NEW_BATCH_COUNT = -3;
    public static final int ADD_BATCH_COUNT = -4;
    public static final int EXEC_BATCH_COUNT = -5;
    public static final int UNLIMITED_BATCH = 0;
    public static final int AUTO_BATCH = -1;
    public static final int LIMITED_BATCH = -1;
    private OracleContext m_oc = null;

    public ExecutionContext() {
    }

    public ExecutionContext(ExecutionContext executionContext) {
        this.m_maxFieldSize = executionContext.getMaxFieldSize();
        this.m_maxRows = executionContext.getMaxRows();
        this.m_queryTimeout = executionContext.getQueryTimeout();
        this.m_isBatching = executionContext.isBatching();
        this.m_batchLimit = executionContext.getBatchLimit();
        this.m_fetchSize = executionContext.getFetchSize();
        this.m_fetchDirection = executionContext.getFetchDirection();
    }

    public ExecutionContext(ConnectionContext connectionContext) {
        this(connectionContext.getExecutionContext());
    }

    public synchronized int getMaxFieldSize() {
        return this.m_maxFieldSize;
    }

    public synchronized void setMaxFieldSize(int n) {
        this.m_maxFieldSize = n;
    }

    public synchronized int getMaxRows() {
        return this.m_maxRows;
    }

    public synchronized void setMaxRows(int n) {
        this.m_maxRows = n;
    }

    public synchronized int getQueryTimeout() {
        return this.m_queryTimeout;
    }

    public synchronized void setQueryTimeout(int n) {
        this.m_queryTimeout = n;
    }

    public synchronized SQLWarning getWarnings() {
        return this.m_warnings;
    }

    public synchronized int getUpdateCount() {
        return this.m_updateCount;
    }

    public synchronized void setBatching(boolean bl) {
        this.m_isBatching = bl;
    }

    public synchronized boolean isBatching() {
        return this.m_isBatching;
    }

    public synchronized void setBatchLimit(int n) {
        this.m_batchLimit = n;
    }

    public synchronized int getBatchLimit() {
        return this.m_batchLimit;
    }

    public synchronized int[] getBatchUpdateCounts() {
        return this.m_batchUpdateCounts;
    }

    public synchronized int getFetchSize() {
        return this.m_fetchSize;
    }

    public synchronized void setFetchSize(int n) throws SQLException {
        if (n < 0 || 0 < this.m_maxRows && this.m_maxRows < n) {
            throw new SQLException("Invalid Fetch Size: " + n);
        }
        this.m_fetchSize = n;
    }

    public synchronized int getFetchDirection() {
        return this.m_fetchDirection;
    }

    public synchronized void setFetchDirection(int n) throws SQLException {
        if (n != 0 && n != 1000 && n != 1001 && n != 1002) {
            throw new SQLException("Invalid Fetch Direction");
        }
        this.m_fetchDirection = n;
    }

    public void cancel() throws SQLException {
        if (this.m_oc != null) {
            if (this.m_oc.m_ops != null) {
                if (this.m_oc.m_count > 0) {
                    this.m_oc.m_count = 0;
                    this.m_updateCount = 0;
                    this.m_oc.m_ops.clearBatch();
                }
                this.m_oc.m_ops.cancel();
                this.m_oc.oracleClose();
            }
            return;
        }
        this.m_statementStack.cancelCurrent();
        if (this.m_batchContext != null) {
            this.m_batchContext.clearBatch();
            this.m_batchContext = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RTStatement registerStatement(ConnectionContext connectionContext, Object object, int n) throws SQLException {
        ConnectedProfile connectedProfile = connectionContext.getConnectedProfile(object);
        if (this.m_oc != null) {
            this.m_oc.oracleFlushBatch();
            this.m_oc = null;
        }
        RTStatement rTStatement = this.m_isBatching ? this.m_statementStack.setStatement(connectedProfile, n, this.m_batchContext) : this.m_statementStack.setStatement(connectedProfile, n);
        boolean bl = true;
        try {
            if (this.m_maxRows != 0) {
                rTStatement.setMaxRows(this.m_maxRows);
            }
            if (this.m_maxFieldSize != 0) {
                rTStatement.setMaxFieldSize(this.m_maxFieldSize);
            }
            if (this.m_queryTimeout != 0) {
                rTStatement.setQueryTimeout(this.m_queryTimeout);
            }
            if (this.m_fetchSize != 0) {
                rTStatement.setFetchSize(this.m_fetchSize);
            }
            if (this.m_fetchDirection != 0) {
                rTStatement.setFetchDirection(this.m_fetchDirection);
            }
            bl = false;
        }
        finally {
            if (bl) {
                this.releaseStatement();
            }
        }
        return rTStatement;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int executeUpdate() throws SQLException {
        this.startExec();
        try {
            if (this.m_isBatching) {
                RTStatement rTStatement = this.getStatement().getStatement();
                if (rTStatement.isBatchable() && !this.m_statementStack.isRecursive()) {
                    if (rTStatement.isBatchCompatible()) {
                        if (this.m_batchContext == null) {
                            this.m_batchContext = rTStatement.getBatchContext();
                            this.m_batchContext.setBatchLimit(this.m_batchLimit);
                            this.m_updateCount = -3;
                        } else {
                            this.m_updateCount = -4;
                        }
                        int n = this.m_updateCount;
                        return n;
                    }
                    this.executeBatch();
                    this.m_batchContext = rTStatement.getBatchContext();
                    this.m_batchContext.setBatchLimit(this.m_batchLimit);
                    int n = this.m_updateCount = -3;
                    return n;
                }
                this.executeBatch();
                int n = this.getStatement().executeUpdate();
                return n;
            }
            int n = this.getStatement().executeUpdate();
            return n;
        }
        finally {
            this.endExec();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized int[] executeBatch() throws SQLException {
        if (this.m_oc != null) {
            this.m_oc.oracleFlushBatch();
            return this.m_batchUpdateCounts;
        }
        if (this.m_batchContext == null) {
            return null;
        }
        try {
            int[] nArray = this.m_batchUpdateCounts = this.m_batchContext.executeBatch();
            return nArray;
        }
        finally {
            this.m_updateCount = -5;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RTResultSet executeQuery() throws SQLException {
        this.startExec();
        try {
            if (this.m_isBatching) {
                this.executeBatch();
            }
            RTResultSet rTResultSet = this.getStatement().executeQuery();
            return rTResultSet;
        }
        finally {
            this.endExec();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean execute() throws SQLException {
        this.startExec();
        try {
            if (this.m_isBatching) {
                RTStatement rTStatement = this.getStatement().getStatement();
                if (rTStatement.isBatchable() && !this.m_statementStack.isRecursive()) {
                    if (rTStatement.isBatchCompatible()) {
                        if (this.m_batchContext == null) {
                            this.m_batchContext = rTStatement.getBatchContext();
                            this.m_batchContext.setBatchLimit(this.m_batchLimit);
                            this.m_updateCount = -3;
                        } else {
                            this.m_updateCount = -4;
                        }
                        boolean bl = false;
                        return bl;
                    }
                    this.executeBatch();
                    this.m_batchContext = rTStatement.getBatchContext();
                    this.m_batchContext.setBatchLimit(this.m_batchLimit);
                    this.m_updateCount = -3;
                    boolean bl = false;
                    return bl;
                }
                this.executeBatch();
                boolean bl = this.getStatement().execute();
                return bl;
            }
            boolean bl = this.getStatement().execute();
            return bl;
        }
        finally {
            this.endExec();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized ResultSet getNextResultSet() throws SQLException {
        if (this.m_oc != null) {
            return null;
        }
        StatementFrame statementFrame = this.getStatement();
        if (statementFrame.getStatement() != null) {
            try {
                ResultSet resultSet = statementFrame.getNextResultSet();
                return resultSet;
            }
            finally {
                this.m_warnings = statementFrame.getWarnings();
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releaseStatement() throws SQLException {
        StatementFrame statementFrame = this.getStatement();
        try {
            statementFrame.releaseStatement();
        }
        finally {
            this.m_warnings = statementFrame.getWarnings();
            this.m_updateCount = statementFrame.getUpdateCount();
        }
    }

    private StatementFrame getStatement() {
        return this.m_statementStack.getStatement();
    }

    private void startExec() {
        this.m_statementStack.pushFrame();
    }

    private void endExec() throws SQLException {
        this.m_statementStack.popFrame();
    }

    public OracleContext getOracleContext() {
        if (this.m_oc == null) {
            this.m_oc = new OracleContext(this);
        }
        return this.m_oc;
    }

    public static OracleContext raiseNullExecCtx() throws SQLException {
        RuntimeRefErrors.raise_NULL_EXEC_CTX();
        return null;
    }

    public void close() throws SQLException {
        if (this.m_oc != null) {
            this.m_oc.cleanup();
            this.m_oc = null;
        }
    }

    static /* synthetic */ int[] access$1302(ExecutionContext executionContext, int[] nArray) {
        executionContext.m_batchUpdateCounts = nArray;
        return nArray;
    }

    public static class OracleContext {
        private ExecutionContext m_ec;
        private OraclePreparedStatement m_ops;
        private OracleCallableStatement m_ocs;
        private OraPreparedStmtWrapper m_opsw;
        private OraCallableStmtWrapper m_ocsw;
        private String m_key;
        private boolean m_caching;
        private Object[] m_args = new Object[1];
        private static boolean m_new_cache;
        private boolean m_is_new = false;
        private int m_count = 0;
        private static Method m_oracleSetSavepoint;
        private static Method m_oracleRollback;
        private static Method m_oracleReleaseSavepoint;

        private OracleContext(ExecutionContext executionContext) {
            this.m_ec = executionContext;
        }

        public boolean isNew() {
            return this.m_is_new;
        }

        public OraclePreparedStatement prepareOracleStatement(ConnectionContextImpl connectionContextImpl, String string, String string2) throws SQLException {
            if (this.m_ops != null) {
                this.oracleFlushBatch();
            }
            this.m_key = string;
            if (m_new_cache) {
                this.m_ops = (OraclePreparedStatement)connectionContextImpl.getOracleConnection().getStatementWithKey(this.m_key);
                this.m_opsw = new OraPreparedStmtWrapper(this.m_ops);
            } else {
                boolean bl = this.m_caching = connectionContextImpl.getOracleConnection().getStmtCacheSize() > 0;
                if (this.m_caching) {
                    this.m_ops = (OraclePreparedStatement)connectionContextImpl.getOracleConnection().prepareStatementWithKey(this.m_key);
                    this.m_opsw = new OraPreparedStmtWrapper(this.m_ops);
                }
            }
            if (this.m_ops == null) {
                this.m_is_new = true;
                this.m_ops = (OraclePreparedStatement)connectionContextImpl.getOracleConnection().prepareStatement(string2);
                this.m_opsw = new OraPreparedStmtWrapper(this.m_ops);
                if (this.m_ec.m_maxRows != 0) {
                    this.m_ops.setMaxRows(this.m_ec.m_maxRows);
                }
                if (this.m_ec.m_maxFieldSize != 0) {
                    this.m_ops.setMaxFieldSize(this.m_ec.m_maxFieldSize);
                }
                if (this.m_ec.m_queryTimeout != 0) {
                    this.m_ops.setQueryTimeout(this.m_ec.m_queryTimeout);
                }
                if (this.m_ec.m_fetchSize != 0) {
                    this.m_ops.setFetchSize(this.m_ec.m_fetchSize);
                }
                if (this.m_ec.m_fetchDirection != 0) {
                    this.m_ops.setFetchDirection(this.m_ec.m_fetchDirection);
                }
            } else {
                this.m_is_new = false;
                if (this.m_ec.m_maxRows != this.m_ops.getMaxRows()) {
                    this.m_ops.setMaxRows(this.m_ec.m_maxRows);
                }
                if (this.m_ec.m_maxFieldSize != this.m_ops.getMaxFieldSize()) {
                    this.m_ops.setMaxFieldSize(this.m_ec.m_maxFieldSize);
                }
                if (this.m_ec.m_queryTimeout != this.m_ops.getQueryTimeout()) {
                    this.m_ops.setQueryTimeout(this.m_ec.m_queryTimeout);
                }
                if (this.m_ec.m_fetchSize != this.m_ops.getFetchSize()) {
                    this.m_ops.setFetchSize(this.m_ec.m_fetchSize);
                }
                if (this.m_ec.m_fetchDirection != 0 && this.m_ec.m_fetchDirection != this.m_ops.getFetchDirection()) {
                    this.m_ops.setFetchDirection(this.m_ec.m_fetchDirection);
                }
            }
            return this.m_opsw;
        }

        public OraclePreparedStatement prepareOracleStatement(ConnectionContextImpl connectionContextImpl, String string, String string2, int n, int n2) throws SQLException {
            if (this.m_ops != null) {
                this.oracleFlushBatch();
            }
            this.m_key = string;
            if (m_new_cache) {
                this.m_ops = (OraclePreparedStatement)connectionContextImpl.getOracleConnection().getStatementWithKey(this.m_key);
            } else {
                boolean bl = this.m_caching = connectionContextImpl.getOracleConnection().getStmtCacheSize() > 0;
                if (this.m_caching) {
                    this.m_ops = (OraclePreparedStatement)connectionContextImpl.getOracleConnection().prepareStatementWithKey(this.m_key);
                }
            }
            if (this.m_ops == null) {
                this.m_is_new = true;
                this.m_ops = (OraclePreparedStatement)connectionContextImpl.getOracleConnection().prepareStatement(string2, n, n2);
                if (this.m_ec.m_maxRows != 0) {
                    this.m_ops.setMaxRows(this.m_ec.m_maxRows);
                }
                if (this.m_ec.m_maxFieldSize != 0) {
                    this.m_ops.setMaxFieldSize(this.m_ec.m_maxFieldSize);
                }
                if (this.m_ec.m_queryTimeout != 0) {
                    this.m_ops.setQueryTimeout(this.m_ec.m_queryTimeout);
                }
                if (this.m_ec.m_fetchSize != 0) {
                    this.m_ops.setFetchSize(this.m_ec.m_fetchSize);
                }
                if (this.m_ec.m_fetchDirection != 0) {
                    this.m_ops.setFetchDirection(this.m_ec.m_fetchDirection);
                }
            } else {
                this.m_is_new = false;
                if (this.m_ec.m_maxRows != this.m_ops.getMaxRows()) {
                    this.m_ops.setMaxRows(this.m_ec.m_maxRows);
                }
                if (this.m_ec.m_maxFieldSize != this.m_ops.getMaxFieldSize()) {
                    this.m_ops.setMaxFieldSize(this.m_ec.m_maxFieldSize);
                }
                if (this.m_ec.m_queryTimeout != this.m_ops.getQueryTimeout()) {
                    this.m_ops.setQueryTimeout(this.m_ec.m_queryTimeout);
                }
                if (this.m_ec.m_fetchSize != this.m_ops.getFetchSize()) {
                    this.m_ops.setFetchSize(this.m_ec.m_fetchSize);
                }
                if (this.m_ec.m_fetchDirection != 0 && this.m_ec.m_fetchDirection != this.m_ops.getFetchDirection()) {
                    this.m_ops.setFetchDirection(this.m_ec.m_fetchDirection);
                }
            }
            return this.m_ops;
        }

        public OraclePreparedStatement prepareOracleBatchableStatement(ConnectionContextImpl connectionContextImpl, String string, String string2) throws SQLException {
            int n;
            if (this.m_ec.m_isBatching && string.equals(this.m_key) && ((n = this.m_ec.m_batchLimit) == 0 || this.m_count < n)) {
                this.m_is_new = false;
                return this.m_ops;
            }
            if (this.m_ops != null) {
                this.oracleFlushBatch();
            }
            this.m_count = 0;
            return this.prepareOracleStatement(connectionContextImpl, string, string2);
        }

        public OracleCallableStatement prepareOracleCall(ConnectionContextImpl connectionContextImpl, String string, String string2) throws SQLException {
            if (this.m_ops != null) {
                this.oracleFlushBatch();
            }
            this.m_key = string;
            if (m_new_cache) {
                this.m_ocs = (OracleCallableStatement)connectionContextImpl.getOracleConnection().getCallWithKey(this.m_key);
                this.m_ocsw = new OraCallableStmtWrapper(this.m_ocs);
            } else {
                boolean bl = this.m_caching = connectionContextImpl.getOracleConnection().getStmtCacheSize() > 0;
                if (this.m_caching) {
                    this.m_ocs = (OracleCallableStatement)connectionContextImpl.getOracleConnection().prepareCallWithKey(this.m_key);
                    this.m_ocsw = new OraCallableStmtWrapper(this.m_ocs);
                }
            }
            if (this.m_ocs == null) {
                this.m_is_new = true;
                this.m_ocs = (OracleCallableStatement)connectionContextImpl.getOracleConnection().prepareCall(string2);
                this.m_ocsw = new OraCallableStmtWrapper(this.m_ocs);
                if (this.m_ec.m_maxRows != 0) {
                    this.m_ocs.setMaxRows(this.m_ec.m_maxRows);
                }
                if (this.m_ec.m_maxFieldSize != 0) {
                    this.m_ocs.setMaxFieldSize(this.m_ec.m_maxFieldSize);
                }
                if (this.m_ec.m_queryTimeout != 0) {
                    this.m_ocs.setQueryTimeout(this.m_ec.m_queryTimeout);
                }
                if (this.m_ec.m_fetchSize != 0) {
                    this.m_ocs.setFetchSize(this.m_ec.m_fetchSize);
                }
                if (this.m_ec.m_fetchDirection != 0) {
                    this.m_ocs.setFetchDirection(this.m_ec.m_fetchDirection);
                }
            } else {
                this.m_is_new = false;
                if (this.m_ec.m_maxRows != this.m_ocs.getMaxRows()) {
                    this.m_ocs.setMaxRows(this.m_ec.m_maxRows);
                }
                if (this.m_ec.m_maxFieldSize != this.m_ocs.getMaxFieldSize()) {
                    this.m_ocs.setMaxFieldSize(this.m_ec.m_maxFieldSize);
                }
                if (this.m_ec.m_queryTimeout != this.m_ocs.getQueryTimeout()) {
                    this.m_ocs.setQueryTimeout(this.m_ec.m_queryTimeout);
                }
                if (this.m_ec.m_fetchSize != this.m_ocs.getFetchSize()) {
                    this.m_ocs.setFetchSize(this.m_ec.m_fetchSize);
                }
                if (this.m_ec.m_fetchDirection != 0 && this.m_ec.m_fetchDirection != this.m_ocs.getFetchDirection()) {
                    this.m_ocs.setFetchDirection(this.m_ec.m_fetchDirection);
                }
            }
            this.m_ops = this.m_ocs;
            this.m_opsw = this.m_ocsw;
            return this.m_ocsw;
        }

        public void oracleExecuteUpdate() throws SQLException {
            this.m_ec.m_updateCount = -2;
            ExecutionContext.access$1302(this.m_ec, null);
            this.m_ec.m_updateCount = this.m_ops.executeUpdate();
        }

        public void oracleExecuteBatchableUpdate() throws SQLException {
            if (this.m_ec.m_isBatching) {
                int n = this.m_ec.m_batchLimit;
                this.m_ops.addBatch();
                ++this.m_count;
                this.m_ec.m_updateCount = this.m_count == 1 ? -3 : (this.m_count == n ? -5 : -4);
            } else {
                this.oracleExecuteUpdate();
            }
        }

        public OracleResultSet oracleExecuteQuery() throws SQLException {
            this.m_ec.m_updateCount = -2;
            ExecutionContext.access$1302(this.m_ec, null);
            OracleResultSet oracleResultSet = (OracleResultSet)this.m_ops.executeQuery();
            this.m_ec.m_updateCount = -1;
            return oracleResultSet;
        }

        public void oracleCommit(ConnectionContextImpl connectionContextImpl) throws SQLException {
            this.oracleFlushBatch();
            connectionContextImpl.getOracleConnection().commit();
        }

        public void oracleRollback(ConnectionContextImpl connectionContextImpl) throws SQLException {
            this.oracleFlushBatch();
            connectionContextImpl.getOracleConnection().rollback();
        }

        private void oracleFlushBatch() throws SQLException {
            if (this.m_count > 0) {
                ExecutionContext.access$1302(this.m_ec, this.m_ops.executeBatch());
                this.m_ec.m_updateCount = -5;
                this.m_count = 0;
            }
            this.oracleClose();
        }

        public void oracleClose() throws SQLException {
            if (this.m_ops != null) {
                if (this.m_caching) {
                    if (this.m_opsw != null) {
                        this.m_opsw.closeWithKey(this.m_key);
                    } else {
                        this.m_ops.closeWithKey(this.m_key);
                    }
                } else if (this.m_opsw != null) {
                    this.m_opsw.close();
                } else {
                    this.m_ops.close();
                }
            }
            this.m_ops = null;
            this.m_ocs = null;
            this.m_key = null;
        }

        public void oracleCloseQuery() {
            this.m_ops = null;
            this.m_ocs = null;
            this.m_key = null;
        }

        private void cleanup() {
            try {
                this.oracleClose();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }

        public Object oracleSetSavepoint(ConnectionContextImpl connectionContextImpl, String string) throws SQLException {
            try {
                this.m_args[0] = string;
                return m_oracleSetSavepoint.invoke((Object)connectionContextImpl.getOracleConnection(), this.m_args);
            }
            catch (InvocationTargetException invocationTargetException) {
                throw new SQLException(invocationTargetException.getTargetException().toString());
            }
            catch (Throwable throwable) {
                throw new SQLException("Undefined method: oracle.jdbc.OracleConnection.oracleSetSavepoint(String)");
            }
        }

        public void oracleRollbackToSavepoint(ConnectionContextImpl connectionContextImpl, Object object) throws SQLException {
            try {
                this.m_args[0] = object;
                m_oracleRollback.invoke((Object)connectionContextImpl.getOracleConnection(), this.m_args);
            }
            catch (InvocationTargetException invocationTargetException) {
                throw new SQLException(invocationTargetException.getTargetException().toString());
            }
            catch (Throwable throwable) {
                throw new SQLException("Undefined method: oracle.jdbc.OracleConnection.oracleRollback(oracle.jdbc.OracleSavepoint)");
            }
        }

        public void oracleReleaseSavepoint(ConnectionContextImpl connectionContextImpl, Object object) throws SQLException {
            try {
                this.m_args[0] = object;
                m_oracleReleaseSavepoint.invoke((Object)connectionContextImpl.getOracleConnection(), this.m_args);
            }
            catch (InvocationTargetException invocationTargetException) {
                throw new SQLException(invocationTargetException.getTargetException().toString());
            }
            catch (Throwable throwable) {
                throw new SQLException("Undefined method: oracle.jdbc.OracleConnection.oracleReleaseSavepoint(oracle.jdbc.OracleSavepoint)");
            }
        }

        static {
            Class[] classArray;
            try {
                classArray = OraDynamicClosure.getMethodInstance(OracleConnection.class, "getStatementWithKey", new Class[]{String.class});
                if (classArray != null) {
                    m_new_cache = true;
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            try {
                classArray = new Class[]{Class.forName("oracle.jdbc.OracleSavepoint")};
                m_oracleSetSavepoint = OracleConnection.class.getMethod("oracleSetSavepoint", String.class);
                m_oracleRollback = OracleConnection.class.getMethod("oracleRollback", classArray);
                m_oracleReleaseSavepoint = OracleConnection.class.getMethod("oracleReleaseSavepoint", classArray);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    private static class StatementFrame {
        RTStatement m_stmt = null;
        private int m_updateCount = 0;
        private SQLWarning m_warnings = null;
        private boolean m_executeResult = false;
        private boolean m_holdStmt = false;
        private StatementStack m_lock;
        private boolean m_pendingResults = false;

        StatementFrame(StatementStack statementStack) {
            this.m_lock = statementStack;
        }

        SQLWarning getWarnings() {
            return this.m_warnings;
        }

        int getUpdateCount() {
            return this.m_updateCount;
        }

        void cancel() throws SQLException {
            this.m_stmt.cancel();
        }

        RTStatement getStatement() {
            return this.m_stmt;
        }

        void setStatement(RTStatement rTStatement) {
            this.m_updateCount = -2;
            this.m_warnings = null;
            this.m_holdStmt = false;
            this.m_executeResult = false;
            this.m_stmt = rTStatement;
            this.m_pendingResults = false;
        }

        int executeUpdate() throws SQLException {
            this.m_updateCount = this.m_stmt.executeUpdate();
            return this.m_updateCount;
        }

        RTResultSet executeQuery() throws SQLException {
            RTResultSet rTResultSet = this.m_stmt.executeRTQuery();
            this.m_updateCount = -1;
            return rTResultSet;
        }

        boolean execute() throws SQLException {
            boolean bl = this.m_stmt.execute();
            if (!bl && this.m_stmt.getUpdateCount() != -1) {
                bl = this.m_stmt.getMoreResults();
            }
            this.m_holdStmt = this.m_executeResult = bl;
            this.m_updateCount = -1;
            return bl;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        ResultSet getNextResultSet() throws SQLException {
            if (this.m_stmt == null) {
                return null;
            }
            boolean bl = true;
            try {
                if (this.m_executeResult) {
                    this.m_executeResult = false;
                } else {
                    while (!this.m_stmt.getMoreResults()) {
                        if (this.m_stmt.getUpdateCount() != -1) continue;
                        bl = false;
                        break;
                    }
                }
                if (bl) {
                    ResultSet resultSet = this.m_stmt.getResultSet();
                    this.m_warnings = this.m_stmt.getWarnings();
                    return resultSet;
                }
            }
            catch (SQLException sQLException) {
                this.m_holdStmt = false;
                try {
                    this.releaseStatement();
                }
                catch (SQLException sQLException2) {
                    sQLException.setNextException(sQLException2);
                }
                finally {
                    throw sQLException;
                }
            }
            this.m_holdStmt = false;
            this.releaseStatement();
            return null;
        }

        void cleanupResults() throws SQLException {
            if (this.m_stmt != null) {
                while (this.getNextResultSet() != null) {
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void releaseStatement() throws SQLException {
            if (!this.m_holdStmt) {
                this.m_pendingResults = false;
                RTStatement rTStatement = this.m_stmt;
                this.m_lock.releaseStatement(this);
                try {
                    this.m_warnings = rTStatement.getWarnings();
                }
                finally {
                    rTStatement.executeComplete();
                }
            } else {
                this.m_pendingResults = true;
                this.m_warnings = this.m_stmt.getWarnings();
            }
        }
    }

    private static class StatementStack {
        private int m_callDepth = 0;
        private Stack m_statementStack = new Stack();
        private StatementFrame m_stmt = new StatementFrame(this);

        private StatementStack() {
        }

        StatementFrame getStatement() {
            return this.m_stmt;
        }

        synchronized void cancelCurrent() throws SQLException {
            if (this.m_stmt.getStatement() != null) {
                this.m_stmt.cancel();
            } else if (!this.m_statementStack.empty()) {
                ((StatementFrame)this.m_statementStack.peek()).cancel();
            }
        }

        synchronized RTStatement setStatement(ConnectedProfile connectedProfile, int n) throws SQLException {
            if (this.m_statementStack.size() < this.m_callDepth) {
                this.m_statementStack.push(this.m_stmt);
                this.m_stmt = new StatementFrame(this);
            } else {
                this.m_stmt.cleanupResults();
            }
            RTStatement rTStatement = connectedProfile.getStatement(n);
            this.m_stmt.setStatement(rTStatement);
            return rTStatement;
        }

        synchronized RTStatement setStatement(ConnectedProfile connectedProfile, int n, BatchContext batchContext) throws SQLException {
            if (this.m_statementStack.size() < this.m_callDepth) {
                this.m_statementStack.push(this.m_stmt);
                this.m_stmt = new StatementFrame(this);
            } else {
                this.m_stmt.cleanupResults();
            }
            RTStatement rTStatement = connectedProfile.getStatement(n, batchContext);
            this.m_stmt.setStatement(rTStatement);
            return rTStatement;
        }

        void pushFrame() {
            ++this.m_callDepth;
        }

        void popFrame() throws SQLException {
            --this.m_callDepth;
            if (this.m_statementStack.size() > this.m_callDepth) {
                this.doPopFrame();
            }
        }

        private synchronized void doPopFrame() throws SQLException {
            this.m_stmt.cleanupResults();
            this.m_stmt = (StatementFrame)this.m_statementStack.pop();
        }

        synchronized void releaseStatement(StatementFrame statementFrame) {
            statementFrame.m_stmt = null;
        }

        boolean isRecursive() {
            return 1 < this.m_callDepth;
        }
    }
}

