/*
 * Decompiled with CFR 0.152.
 */
package oracle.diagram.oppparse;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import oracle.diagram.oppparse.AbstractOPPDiagramVisitor;
import oracle.diagram.oppparse.OPPConnectionPoint;
import oracle.diagram.oppparse.OPPContainer;
import oracle.diagram.oppparse.OPPDiagram;
import oracle.diagram.oppparse.OPPDiagramEdge;
import oracle.diagram.oppparse.OPPDiagramNode;
import oracle.diagram.oppparse.OPPDiagramShape;
import oracle.diagram.oppparse.OPPDisplayPreferences;
import oracle.diagram.oppparse.OPPEdgeRoute;
import oracle.diagram.oppparse.OPPGraphicalProperties;
import oracle.diagram.oppparse.OPPParseUtil;
import oracle.diagram.oppparse.OPPShapeState;
import oracle.xml.parser.v2.XMLElement;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public abstract class OPPTopLevelShape
extends OPPDiagramShape {
    private static final List<OPPConnectionPoint> EMPTY_CP_LIST = Collections.unmodifiableList(new ArrayList(0));
    private final OPPGraphicalProperties _gp;
    private final OPPDisplayPreferences _displayPrefs;
    private final List<OPPConnectionPoint> _cps;
    private boolean _deleted = false;

    OPPTopLevelShape(OPPContainer parent, XMLElement xmlSource) {
        super(parent, xmlSource, true);
        XMLElement dp;
        XMLElement cp = OPPParseUtil.getNamedChild(xmlSource, "infoList", "connectionPoints");
        if (cp != null) {
            NodeList cps = cp.getChildrenByTagName("infoMap");
            this._cps = new ArrayList<OPPConnectionPoint>(cps.getLength());
            int isize = cps.getLength();
            for (int i = 0; i < isize; ++i) {
                XMLElement child = (XMLElement)cps.item(i);
                this._cps.add(new OPPConnectionPoint(this, child));
            }
        } else {
            this._cps = EMPTY_CP_LIST;
        }
        this._displayPrefs = (dp = OPPParseUtil.getNamedChild(xmlSource, "infoMap", "displayPreference")) != null ? new OPPDisplayPreferences(this, dp) : null;
        XMLElement gd = OPPParseUtil.getNamedChild(xmlSource, "infoMap", "graphicalData");
        XMLElement gp = OPPParseUtil.getNamedChild(gd, "graphicalProperties", "graphicalProperties");
        this._gp = gp != null ? new OPPGraphicalProperties(this, gp) : null;
    }

    public Collection<OPPTopLevelShape> delete() {
        if (this.isDeleted()) {
            return Collections.emptySet();
        }
        HashSet<OPPTopLevelShape> deleted = new HashSet<OPPTopLevelShape>();
        deleted.add(this);
        this.collectChildren(deleted);
        int size = deleted.size();
        while (true) {
            this.buildDeleteSet(deleted);
            if (deleted.size() == size) break;
            size = deleted.size();
        }
        OPPDiagram diagram = OPPDiagram.getDiagram(this);
        for (OPPTopLevelShape s : deleted) {
            s.setDeleted();
            XMLElement el = s.getXMLSource();
            el.getParentNode().removeChild((Node)el);
            diagram.removeStructureRecord(s);
        }
        return deleted;
    }

    void collectChildren(Set<OPPTopLevelShape> children) {
        for (OPPShapeState state : this.getAvailableStates()) {
            for (OPPTopLevelShape child : this.getChildShapes(state)) {
                children.add(child);
                child.collectChildren(children);
            }
        }
    }

    void buildDeleteSet(final Set<OPPTopLevelShape> deleted) {
        AbstractOPPDiagramVisitor v = new AbstractOPPDiagramVisitor(){

            @Override
            public void visitEdgeShape(OPPDiagramEdge edge) {
                for (OPPEdgeRoute r : edge.getRoutes()) {
                    if (!deleted.contains(r.getSource()) && !deleted.contains(r.getDestination())) continue;
                    deleted.add(edge);
                    edge.collectChildren(deleted);
                }
            }
        };
        OPPDiagram.getDiagram(this).visit(v);
    }

    private void setDeleted() {
        this._deleted = true;
    }

    public boolean isDeleted() {
        return this._deleted;
    }

    public final OPPGraphicalProperties getGraphicalProperties() {
        return this._gp;
    }

    public final OPPDisplayPreferences getDisplayPreferences() {
        return this._displayPrefs;
    }

    public final List<OPPConnectionPoint> getConnectionPoints() {
        return this._cps;
    }

    static OPPTopLevelShape newInstance(OPPContainer parent, XMLElement xmlSource) {
        XMLElement srcRef = OPPParseUtil.getNamedChild(xmlSource, "elemRef", "sourceShapeRef");
        if (srcRef == null) {
            return new OPPDiagramNode(parent, xmlSource);
        }
        return new OPPDiagramEdge(parent, xmlSource);
    }
}

