/*
 * Decompiled with CFR 0.152.
 */
package oracle.diagram.framework.swimlanes.interaction;

import ilog.views.IlvGraphic;
import ilog.views.IlvManager;
import ilog.views.IlvRect;
import ilog.views.event.TransformerChangedEvent;
import ilog.views.event.TransformerListener;
import java.util.Collection;
import java.util.HashMap;
import java.util.Set;
import oracle.bm.javatools.util.MultivaluedMap;
import oracle.diagram.core.context.DiagramContext;
import oracle.diagram.framework.geom.DimensionFloat;
import oracle.diagram.framework.swimlanes.SwimlanesPlugin;
import oracle.diagram.framework.swimlanes.graphic.SwimlaneGraphic;
import oracle.diagram.framework.swimlanes.interaction.AbstractSwimlanesMoveGraphicsHelper;
import oracle.diagram.framework.undo.UndoableStep;

public abstract class NoExpandSwimlanesMoveGraphicsHelper
extends AbstractSwimlanesMoveGraphicsHelper {
    private HashMap<IlvGraphic, IlvRect> _validLocMap = new HashMap();
    private boolean _requiresMapRebuild = true;
    private TransformerListener _listener = new TransformerListener(){

        public void transformerChanged(TransformerChangedEvent transformerChangedEvent) {
            NoExpandSwimlanesMoveGraphicsHelper.this._requiresMapRebuild = true;
        }
    };

    public NoExpandSwimlanesMoveGraphicsHelper(DiagramContext context, SwimlanesPlugin plugin, IlvManager topManager, Set<IlvGraphic> movingGraphics) {
        super(context, plugin, topManager, movingGraphics);
        this._context.getManagerView().addTransformerListener(this._listener);
    }

    private void rebuildValidLocationsMap() {
        if (this._requiresMapRebuild) {
            this._requiresMapRebuild = false;
            MultivaluedMap swimlaneToGraphicsMap = new MultivaluedMap();
            for (IlvGraphic g : this._movingGraphics) {
                swimlaneToGraphicsMap.put((Object)this._plugin.getSwimlaneForGraphic(g), (Object)g);
            }
            Set sgSet = swimlaneToGraphicsMap.keySet();
            for (SwimlaneGraphic sg : sgSet) {
                IlvRect sgBBox = sg.getInteriorBoundingBox(null);
                Collection swimlaneGraphics = swimlaneToGraphicsMap.get((Object)sg);
                for (IlvGraphic g : swimlaneGraphics) {
                    IlvRect r = new IlvRect(sgBBox);
                    r.width -= g.boundingBox(null).width;
                    r.height -= g.boundingBox(null).height;
                    this._validLocMap.put(g, r);
                }
            }
        }
    }

    @Override
    public DimensionFloat getConstrainedMoveVector(float dx, float dy) {
        float cdx = dx;
        float cdy = dy;
        this.rebuildValidLocationsMap();
        for (IlvGraphic g : this._validLocMap.keySet()) {
            IlvRect validLoc = this._validLocMap.get(g);
            IlvRect currentBBox = g.boundingBox(null);
            if (currentBBox.x + cdx < validLoc.x) {
                cdx = validLoc.x - currentBBox.x;
            } else if (currentBBox.x + cdx > validLoc.x + validLoc.width - 1.0f) {
                cdx = validLoc.x + validLoc.width - 1.0f - currentBBox.x;
            }
            if (currentBBox.y + cdy < validLoc.y) {
                cdy = validLoc.y - currentBBox.y;
                continue;
            }
            if (!(currentBBox.y + cdy > validLoc.y + validLoc.height - 1.0f)) continue;
            cdy = validLoc.y + validLoc.height - 1.0f - currentBBox.y;
        }
        return new DimensionFloat(cdx, cdy);
    }

    @Override
    public void cleanUp() {
        this._context.getManagerView().removeTransformerListener(this._listener);
        super.cleanUp();
        this._validLocMap.clear();
        this._validLocMap = null;
    }

    @Override
    public UndoableStep createUndoableStep() {
        return null;
    }
}

