/*
 * Decompiled with CFR 0.152.
 */
package oracle.diagram.framework.preference.propertyeditor;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.beans.PropertyChangeListener;
import java.beans.PropertyEditor;
import java.util.Locale;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import oracle.bali.inspector.PropertyEditorAdapter;
import oracle.bali.inspector.PropertyEditorFactory;
import oracle.bali.inspector.editor.ToStringConverter;
import oracle.ide.Context;

public class PropertyEditorFactoryDelegate
extends PropertyEditorAdapter {
    private PropertyEditorFactory _factory;
    private Context _context;

    public PropertyEditorFactoryDelegate(PropertyEditor pe) {
        super(pe);
    }

    public PropertyEditorFactoryDelegate(PropertyEditor pe, Class type) {
        super(pe, type);
        this.setSelectedItemToStringConverter(new DefaultToStringConverter());
    }

    public PropertyEditorFactoryDelegate(PropertyEditorFactory pef) {
        this(pef, new DefaultPropertyEditor());
    }

    public PropertyEditorFactoryDelegate(PropertyEditorFactory pef, PropertyEditor pe) {
        super(pe);
        this._factory = pef;
    }

    public Object getEditorValue() {
        if (this._factory != null) {
            return this._factory.getEditorValue();
        }
        return super.getEditorValue();
    }

    public void setEditorValue(Object value) {
        if (this._factory != null) {
            this._factory.setEditorValue(value);
        } else {
            super.setEditorValue(value);
        }
    }

    public boolean hasValueRenderer() {
        if (this._factory != null) {
            return this._factory.hasValueRenderer();
        }
        return super.hasValueRenderer();
    }

    public TableCellRenderer getValueRenderer() {
        if (this._factory != null) {
            return this._factory.getValueRenderer();
        }
        return super.getValueRenderer();
    }

    public boolean hasInPlaceEditor() {
        if (this._factory != null) {
            return this._factory.hasInPlaceEditor();
        }
        return super.hasInPlaceEditor();
    }

    public TableCellEditor getInPlaceEditor(Locale editorLocale) {
        if (this._factory != null) {
            return this._factory.getInPlaceEditor(editorLocale);
        }
        return super.getInPlaceEditor(editorLocale);
    }

    public boolean hasTearOffEditor() {
        if (this._factory != null) {
            return this._factory.hasTearOffEditor();
        }
        return super.hasTearOffEditor();
    }

    public Component getTearOffEditor() {
        if (this._factory != null) {
            return this._factory.getTearOffEditor();
        }
        return super.getTearOffEditor();
    }

    public boolean hasAdvancedEditor() {
        if (this._factory != null) {
            return this._factory.hasAdvancedEditor();
        }
        return super.hasAdvancedEditor();
    }

    public Component getAdvancedEditor() {
        if (this._factory != null) {
            return this._factory.getAdvancedEditor();
        }
        return super.getAdvancedEditor();
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        if (this._factory != null) {
            this._factory.addPropertyChangeListener(listener);
        } else {
            super.addPropertyChangeListener(listener);
        }
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        if (this._factory != null) {
            this._factory.removePropertyChangeListener(listener);
        } else {
            super.removePropertyChangeListener(listener);
        }
    }

    public void setContext(Context context) {
        this._context = context;
    }

    public Context getContext() {
        return this._context;
    }

    private static class DefaultToStringConverter
    implements ToStringConverter {
        private DefaultToStringConverter() {
        }

        public String convertToString(Object value) {
            return value instanceof String ? (String)value : value.toString();
        }
    }

    private static class DefaultPropertyEditor
    implements PropertyEditor {
        private DefaultPropertyEditor() {
        }

        @Override
        public void setValue(Object value) {
        }

        @Override
        public Object getValue() {
            return null;
        }

        @Override
        public boolean isPaintable() {
            return false;
        }

        @Override
        public void paintValue(Graphics gfx, Rectangle box) {
        }

        @Override
        public String getJavaInitializationString() {
            return null;
        }

        @Override
        public String getAsText() {
            return null;
        }

        @Override
        public void setAsText(String text) {
        }

        @Override
        public String[] getTags() {
            return new String[0];
        }

        @Override
        public Component getCustomEditor() {
            return null;
        }

        @Override
        public boolean supportsCustomEditor() {
            return false;
        }

        @Override
        public void addPropertyChangeListener(PropertyChangeListener listener) {
        }

        @Override
        public void removePropertyChangeListener(PropertyChangeListener listener) {
        }
    }
}

