/*
 * Decompiled with CFR 0.152.
 */
package oracle.diagram.framework.graphic;

import ilog.views.IlvGraphic;
import ilog.views.IlvPoint;
import ilog.views.IlvRect;
import ilog.views.IlvTransformer;
import ilog.views.graphic.IlvText;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.io.StringReader;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.EditorKit;
import javax.swing.text.Element;
import javax.swing.text.Position;
import javax.swing.text.View;
import javax.swing.text.ViewFactory;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.HTMLEditorKit;
import oracle.diagram.framework.geom.DimensionFloat;
import oracle.diagram.framework.transformer.TransformerUtil;
import oracle.diagram.framework.util.TextType;
import oracle.diagram.framework.util.TextUtil;

public class HTMLTextGraphic
extends IlvText {
    private HTMLEditorKit _kit;
    private HTMLDocument _doc;
    private RootView _view;
    private Rectangle _rect;

    public HTMLTextGraphic(String text) {
        super(new IlvPoint(), text);
        TextUtil.setTextType((IlvGraphic)this, TextType.HTML_TEXT);
        this._kit = TextUtil.createHTMLEditorKit();
        this._doc = new HTMLDocument(TextUtil.getDefaultHTMLStyleSheet());
        this._doc.addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                HTMLTextGraphic.this._view.insertUpdate(e, HTMLTextGraphic.this._rect, HTMLTextGraphic.this._view.getViewFactory());
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                HTMLTextGraphic.this._view.removeUpdate(e, HTMLTextGraphic.this._rect, HTMLTextGraphic.this._view.getViewFactory());
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                HTMLTextGraphic.this._view.changedUpdate(e, HTMLTextGraphic.this._rect, HTMLTextGraphic.this._view.getViewFactory());
            }
        });
        this._view = new RootView();
        View v = this._kit.getViewFactory().create(this._doc.getDefaultRootElement());
        this._view.setView(v);
        this._rect = new Rectangle();
        this.setLabel(text);
    }

    public DimensionFloat getWrappedHMLTextSize(DimensionFloat size) {
        float w = this._view.getMinimumSpan(0);
        float h = this._view.getMinimumSpan(1);
        size.setSize(w, h);
        return size;
    }

    public DimensionFloat getPreferredHMLTextSize(DimensionFloat size) {
        this._view.setSize(2.1474836E9f, 2.1474836E9f);
        float w = this._view.getPreferredSpan(0);
        float h = this._view.getPreferredSpan(1);
        this._view.setSize(this._rect.width, this._rect.height);
        size.setSize(w, h);
        return size;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void draw(Graphics dst, IlvTransformer t) {
        Graphics2D g2d = (Graphics2D)dst.create();
        g2d.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        g2d.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_OFF);
        try {
            IlvRect r = this.boundingBox(t);
            this._rect.setBounds(r.xFloor(), r.yFloor(), r.widthFloor(), r.heightFloor());
            if (t != null) {
                AffineTransform g2d_transform = g2d.getTransform();
                AffineTransform jviews_transform = TransformerUtil.getAffineTransform(t);
                AffineTransform jviews_scale_transform = AffineTransform.getScaleInstance(jviews_transform.getScaleX(), jviews_transform.getScaleY());
                AffineTransform newTransform = new AffineTransform(g2d_transform);
                newTransform.concatenate(jviews_scale_transform);
                g2d.setTransform(newTransform);
                this._rect.x = Double.valueOf((double)r.x / jviews_scale_transform.getScaleX()).intValue();
                this._rect.y = Double.valueOf((double)r.y / jviews_scale_transform.getScaleY()).intValue();
                this._rect.width = Double.valueOf((double)r.width / jviews_scale_transform.getScaleX()).intValue();
                this._rect.height = Double.valueOf((double)r.height / jviews_scale_transform.getScaleY()).intValue();
            }
            this._view.paint(g2d, this._rect);
        }
        catch (Throwable exc) {
            System.out.println(exc);
            exc.printStackTrace();
        }
        finally {
            g2d.dispose();
        }
    }

    public void setLabel(String text) {
        try {
            this._doc.remove(0, this._doc.getLength());
            if (text != null && !text.equals("")) {
                String formattedText = TextUtil.convertSpacesInHTML(text);
                this._kit.read(new StringReader(formattedText), (Document)this._doc, 0);
            }
            super.setLabel(text);
        }
        catch (Exception exc) {
            System.out.println(exc);
            exc.printStackTrace();
        }
    }

    private class RootView
    extends View {
        private View view;

        public RootView() {
            super(null);
        }

        void setView(View v) {
            View oldView = this.view;
            this.view = null;
            if (oldView != null) {
                oldView.setParent(null);
            }
            if (v != null) {
                v.setParent(this);
            }
            this.view = v;
        }

        @Override
        public AttributeSet getAttributes() {
            return null;
        }

        @Override
        public float getPreferredSpan(int axis) {
            if (this.view != null) {
                return this.view.getPreferredSpan(axis);
            }
            return 10.0f;
        }

        @Override
        public float getMinimumSpan(int axis) {
            if (this.view != null) {
                return this.view.getMinimumSpan(axis);
            }
            return 10.0f;
        }

        @Override
        public float getMaximumSpan(int axis) {
            return 2.1474836E9f;
        }

        @Override
        public void preferenceChanged(View child, boolean width, boolean height) {
        }

        @Override
        public float getAlignment(int axis) {
            if (this.view != null) {
                return this.view.getAlignment(axis);
            }
            return 0.0f;
        }

        @Override
        public void paint(Graphics g, Shape allocation) {
            if (this.view != null) {
                Rectangle alloc = allocation instanceof Rectangle ? (Rectangle)allocation : allocation.getBounds();
                this.setSize(alloc.width, alloc.height);
                this.view.paint(g, allocation);
            }
        }

        @Override
        public void setParent(View parent) {
            throw new Error("Can't set parent on root view");
        }

        @Override
        public int getViewCount() {
            return 1;
        }

        @Override
        public View getView(int n) {
            return this.view;
        }

        @Override
        public int getViewIndex(int pos, Position.Bias b) {
            return 0;
        }

        @Override
        public Shape getChildAllocation(int index, Shape a) {
            return a;
        }

        @Override
        public Shape modelToView(int pos, Shape a, Position.Bias b) throws BadLocationException {
            if (this.view != null) {
                return this.view.modelToView(pos, a, b);
            }
            return null;
        }

        @Override
        public Shape modelToView(int p0, Position.Bias b0, int p1, Position.Bias b1, Shape a) throws BadLocationException {
            if (this.view != null) {
                return this.view.modelToView(p0, b0, p1, b1, a);
            }
            return null;
        }

        @Override
        public int viewToModel(float x, float y, Shape a, Position.Bias[] bias) {
            if (this.view != null) {
                int retValue = this.view.viewToModel(x, y, a, bias);
                return retValue;
            }
            return -1;
        }

        @Override
        public int getNextVisualPositionFrom(int pos, Position.Bias b, Shape a, int direction, Position.Bias[] biasRet) throws BadLocationException {
            if (this.view != null) {
                int nextPos = this.view.getNextVisualPositionFrom(pos, b, a, direction, biasRet);
                if (nextPos != -1) {
                    pos = nextPos;
                } else {
                    biasRet[0] = b;
                }
            }
            return pos;
        }

        @Override
        public void insertUpdate(DocumentEvent e, Shape a, ViewFactory f) {
            if (this.view != null) {
                this.view.insertUpdate(e, a, f);
            }
        }

        @Override
        public void removeUpdate(DocumentEvent e, Shape a, ViewFactory f) {
            if (this.view != null) {
                this.view.removeUpdate(e, a, f);
            }
        }

        @Override
        public void changedUpdate(DocumentEvent e, Shape a, ViewFactory f) {
            if (this.view != null) {
                this.view.changedUpdate(e, a, f);
            }
        }

        @Override
        public Document getDocument() {
            return HTMLTextGraphic.this._doc;
        }

        @Override
        public int getStartOffset() {
            if (this.view != null) {
                return this.view.getStartOffset();
            }
            return this.getElement().getStartOffset();
        }

        @Override
        public int getEndOffset() {
            if (this.view != null) {
                return this.view.getEndOffset();
            }
            return this.getElement().getEndOffset();
        }

        @Override
        public Element getElement() {
            if (this.view != null) {
                return this.view.getElement();
            }
            return HTMLTextGraphic.this._doc.getDefaultRootElement();
        }

        public View breakView(int axis, float len, Shape a) {
            throw new Error("Can't break root view");
        }

        @Override
        public int getResizeWeight(int axis) {
            if (this.view != null) {
                return this.view.getResizeWeight(axis);
            }
            return 0;
        }

        @Override
        public void setSize(float width, float height) {
            if (this.view != null) {
                this.view.setSize(width, height);
            }
        }

        @Override
        public Container getContainer() {
            return null;
        }

        @Override
        public ViewFactory getViewFactory() {
            HTMLEditorKit kit = HTMLTextGraphic.this._kit;
            ViewFactory f = ((EditorKit)kit).getViewFactory();
            if (f != null) {
                return f;
            }
            return null;
        }
    }
}

