/*
 * Decompiled with CFR 0.152.
 */
package oracle.diagram.framework.graphic;

import ilog.views.IlvGraphic;
import ilog.views.IlvLinkImage;
import ilog.views.IlvPoint;
import ilog.views.IlvTransformer;
import oracle.diagram.framework.graphic.GraphicConnector;

public abstract class GraphicPin {
    private static final String GRAPHIC_PIN = "oracle.diagram.framework.graphic.GraphicPin";
    private static final String FROM_PIN = "oracle.diagram.framework.graphic.GraphicPin.From";
    private static final String TO_PIN = "oracle.diagram.framework.graphic.GraphicPin.To";
    private GraphicConnector m_connector;
    private IlvLinkImage m_link;
    private boolean m_origin;

    void attach(GraphicConnector connector, IlvLinkImage link, boolean origin) {
        if (connector == null) {
            throw new IllegalArgumentException("Missing connector");
        }
        if (link == null) {
            throw new IllegalArgumentException("Missing link");
        }
        if (GraphicPin.findPin(link, origin) != null) {
            throw new IllegalStateException("Another pin attached to link end");
        }
        this.m_connector = connector;
        this.m_link = link;
        this.m_origin = origin;
        this.m_link.setProperty(origin ? FROM_PIN : TO_PIN, (Object)this);
    }

    public GraphicConnector getConnector() {
        return this.m_connector;
    }

    public IlvLinkImage getLink() {
        return this.m_link;
    }

    public boolean isOrigin() {
        return this.m_origin;
    }

    public IlvGraphic getGraphic() {
        return this.m_connector.getGraphic();
    }

    public abstract void connect(IlvPoint var1, IlvTransformer var2);

    public abstract IlvPoint getConnectionPoint();

    public final void disconnect() {
        this.disconnectImpl();
        this.m_link.removeProperty(this.isOrigin() ? FROM_PIN : TO_PIN);
        this.m_connector.removePin(this);
        this.m_connector = null;
        this.m_link = null;
    }

    protected abstract void disconnectImpl();

    public static GraphicPin findPin(IlvLinkImage link, boolean origin) {
        return (GraphicPin)link.getProperty(origin ? FROM_PIN : TO_PIN);
    }
}

