/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.pdmodel;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterIOException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.List;
import org.apache.pdfbox.cos.COSArray;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSDictionary;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.cos.COSNumber;
import org.apache.pdfbox.cos.COSStream;
import org.apache.pdfbox.pdfviewer.PageDrawer;
import org.apache.pdfbox.pdmodel.PDPageNode;
import org.apache.pdfbox.pdmodel.PDResources;
import org.apache.pdfbox.pdmodel.common.COSArrayList;
import org.apache.pdfbox.pdmodel.common.COSObjectable;
import org.apache.pdfbox.pdmodel.common.PDMetadata;
import org.apache.pdfbox.pdmodel.common.PDRectangle;
import org.apache.pdfbox.pdmodel.common.PDStream;
import org.apache.pdfbox.pdmodel.interactive.action.PDPageAdditionalActions;
import org.apache.pdfbox.pdmodel.interactive.annotation.PDAnnotation;
import org.apache.pdfbox.pdmodel.interactive.pagenavigation.PDThreadBead;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PDPage
implements COSObjectable,
Printable {
    private static final int DEFAULT_USER_SPACE_UNIT_DPI = 72;
    private static final float MM_TO_UNITS = 2.8346457f;
    private static final Color TRANSPARENT_WHITE = new Color(255, 255, 255, 0);
    private COSDictionary page;
    private PDResources pageResources;
    public static final PDRectangle PAGE_SIZE_LETTER = new PDRectangle(612.0f, 792.0f);
    public static final PDRectangle PAGE_SIZE_A0 = new PDRectangle(2383.937f, 3370.3938f);
    public static final PDRectangle PAGE_SIZE_A1 = new PDRectangle(1683.7795f, 2383.937f);
    public static final PDRectangle PAGE_SIZE_A2 = new PDRectangle(1190.5513f, 1683.7795f);
    public static final PDRectangle PAGE_SIZE_A3 = new PDRectangle(841.8898f, 1190.5513f);
    public static final PDRectangle PAGE_SIZE_A4 = new PDRectangle(595.27563f, 841.8898f);
    public static final PDRectangle PAGE_SIZE_A5 = new PDRectangle(419.52756f, 595.27563f);
    public static final PDRectangle PAGE_SIZE_A6 = new PDRectangle(297.63782f, 419.52756f);
    private PDPageNode parent = null;
    private PDRectangle mediaBox = null;

    public PDPage() {
        this.page = new COSDictionary();
        this.page.setItem(COSName.TYPE, (COSBase)COSName.PAGE);
        this.setMediaBox(PAGE_SIZE_LETTER);
    }

    public PDPage(PDRectangle size) {
        this.page = new COSDictionary();
        this.page.setItem(COSName.TYPE, (COSBase)COSName.PAGE);
        this.setMediaBox(size);
    }

    public PDPage(COSDictionary pageDic) {
        this.page = pageDic;
    }

    @Override
    public COSBase getCOSObject() {
        return this.page;
    }

    public COSDictionary getCOSDictionary() {
        return this.page;
    }

    public PDPageNode getParent() {
        COSDictionary parentDic;
        if (this.parent == null && (parentDic = (COSDictionary)this.page.getDictionaryObject(COSName.PARENT, COSName.P)) != null) {
            this.parent = new PDPageNode(parentDic);
        }
        return this.parent;
    }

    public void setParent(PDPageNode parentNode) {
        this.parent = parentNode;
        this.page.setItem(COSName.PARENT, (COSBase)this.parent.getDictionary());
    }

    public void updateLastModified() {
        this.page.setDate(COSName.LAST_MODIFIED, (Calendar)new GregorianCalendar());
    }

    public Calendar getLastModified() throws IOException {
        return this.page.getDate(COSName.LAST_MODIFIED);
    }

    public PDResources getResources() {
        COSDictionary resources;
        if (this.pageResources == null && (resources = (COSDictionary)this.page.getDictionaryObject(COSName.RESOURCES)) != null) {
            this.pageResources = new PDResources(resources);
        }
        return this.pageResources;
    }

    public PDResources findResources() {
        PDResources retval = this.getResources();
        PDPageNode parentNode = this.getParent();
        if (retval == null && this.parent != null) {
            retval = parentNode.findResources();
        }
        return retval;
    }

    public void setResources(PDResources resources) {
        this.pageResources = resources;
        if (resources != null) {
            this.page.setItem(COSName.RESOURCES, (COSObjectable)resources);
        } else {
            this.page.removeItem(COSName.RESOURCES);
        }
    }

    public PDRectangle getMediaBox() {
        COSArray array;
        if (this.mediaBox == null && (array = (COSArray)this.page.getDictionaryObject(COSName.MEDIA_BOX)) != null) {
            this.mediaBox = new PDRectangle(array);
        }
        return this.mediaBox;
    }

    public PDRectangle findMediaBox() {
        PDRectangle retval = this.getMediaBox();
        if (retval == null && this.getParent() != null) {
            retval = this.getParent().findMediaBox();
        }
        return retval;
    }

    public void setMediaBox(PDRectangle mediaBoxValue) {
        this.mediaBox = mediaBoxValue;
        if (mediaBoxValue == null) {
            this.page.removeItem(COSName.MEDIA_BOX);
        } else {
            this.page.setItem(COSName.MEDIA_BOX, (COSBase)mediaBoxValue.getCOSArray());
        }
    }

    public PDRectangle getCropBox() {
        PDRectangle retval = null;
        COSArray array = (COSArray)this.page.getDictionaryObject(COSName.CROP_BOX);
        if (array != null) {
            retval = new PDRectangle(array);
        }
        return retval;
    }

    public PDRectangle findCropBox() {
        PDRectangle retval = this.getCropBox();
        PDPageNode parentNode = this.getParent();
        if (retval == null && parentNode != null) {
            retval = this.findParentCropBox(parentNode);
        }
        if (retval == null) {
            retval = this.findMediaBox();
        }
        return retval;
    }

    private PDRectangle findParentCropBox(PDPageNode node) {
        PDRectangle rect = node.getCropBox();
        PDPageNode parentNode = node.getParent();
        if (rect == null && parentNode != null) {
            rect = this.findParentCropBox(parentNode);
        }
        return rect;
    }

    public void setCropBox(PDRectangle cropBox) {
        if (cropBox == null) {
            this.page.removeItem(COSName.CROP_BOX);
        } else {
            this.page.setItem(COSName.CROP_BOX, (COSBase)cropBox.getCOSArray());
        }
    }

    public PDRectangle getBleedBox() {
        PDRectangle retval = null;
        COSArray array = (COSArray)this.page.getDictionaryObject(COSName.BLEED_BOX);
        retval = array != null ? new PDRectangle(array) : this.findCropBox();
        return retval;
    }

    public void setBleedBox(PDRectangle bleedBox) {
        if (bleedBox == null) {
            this.page.removeItem(COSName.BLEED_BOX);
        } else {
            this.page.setItem(COSName.BLEED_BOX, (COSBase)bleedBox.getCOSArray());
        }
    }

    public PDRectangle getTrimBox() {
        PDRectangle retval = null;
        COSArray array = (COSArray)this.page.getDictionaryObject(COSName.TRIM_BOX);
        retval = array != null ? new PDRectangle(array) : this.findCropBox();
        return retval;
    }

    public void setTrimBox(PDRectangle trimBox) {
        if (trimBox == null) {
            this.page.removeItem(COSName.TRIM_BOX);
        } else {
            this.page.setItem(COSName.TRIM_BOX, (COSBase)trimBox.getCOSArray());
        }
    }

    public PDRectangle getArtBox() {
        PDRectangle retval = null;
        COSArray array = (COSArray)this.page.getDictionaryObject(COSName.ART_BOX);
        retval = array != null ? new PDRectangle(array) : this.findCropBox();
        return retval;
    }

    public void setArtBox(PDRectangle artBox) {
        if (artBox == null) {
            this.page.removeItem(COSName.ART_BOX);
        } else {
            this.page.setItem(COSName.ART_BOX, (COSBase)artBox.getCOSArray());
        }
    }

    public Integer getRotation() {
        Integer retval = null;
        COSNumber value = (COSNumber)this.page.getDictionaryObject(COSName.ROTATE);
        if (value != null) {
            retval = new Integer(value.intValue());
        }
        return retval;
    }

    public int findRotation() {
        int retval = 0;
        Integer rotation = this.getRotation();
        if (rotation != null) {
            retval = rotation;
        } else {
            PDPageNode parentNode = this.getParent();
            if (parentNode != null) {
                retval = parentNode.findRotation();
            }
        }
        return retval;
    }

    public void setRotation(int rotation) {
        this.page.setInt(COSName.ROTATE, rotation);
    }

    public PDStream getContents() throws IOException {
        return PDStream.createFromCOS(this.page.getDictionaryObject(COSName.CONTENTS));
    }

    public void setContents(PDStream contents) {
        this.page.setItem(COSName.CONTENTS, (COSObjectable)contents);
    }

    public List<PDThreadBead> getThreadBeads() {
        COSArray beads = (COSArray)this.page.getDictionaryObject(COSName.B);
        if (beads == null) {
            beads = new COSArray();
        }
        ArrayList<PDThreadBead> pdObjects = new ArrayList<PDThreadBead>();
        for (int i = 0; i < beads.size(); ++i) {
            COSDictionary beadDic = (COSDictionary)beads.getObject(i);
            PDThreadBead bead = null;
            if (beadDic != null) {
                bead = new PDThreadBead(beadDic);
            }
            pdObjects.add(bead);
        }
        return new COSArrayList<PDThreadBead>(pdObjects, beads);
    }

    public void setThreadBeads(List<PDThreadBead> beads) {
        this.page.setItem(COSName.B, (COSBase)COSArrayList.converterToCOSArray(beads));
    }

    public PDMetadata getMetadata() {
        PDMetadata retval = null;
        COSStream stream = (COSStream)this.page.getDictionaryObject(COSName.METADATA);
        if (stream != null) {
            retval = new PDMetadata(stream);
        }
        return retval;
    }

    public void setMetadata(PDMetadata meta) {
        this.page.setItem(COSName.METADATA, (COSObjectable)meta);
    }

    public BufferedImage convertToImage() throws IOException {
        return this.convertToImage(8, 144);
    }

    public BufferedImage convertToImage(int imageType, int resolution) throws IOException {
        PDRectangle cropBox = this.findCropBox();
        float widthPt = cropBox.getWidth();
        float heightPt = cropBox.getHeight();
        float scaling = (float)resolution / 72.0f;
        int widthPx = Math.round(widthPt * scaling);
        int heightPx = Math.round(heightPt * scaling);
        Dimension pageDimension = new Dimension((int)widthPt, (int)heightPt);
        BufferedImage retval = null;
        int rotationAngle = this.findRotation();
        if (rotationAngle < 0) {
            rotationAngle += 360;
        } else if (rotationAngle >= 360) {
            rotationAngle -= 360;
        }
        retval = rotationAngle == 90 || rotationAngle == 270 ? new BufferedImage(heightPx, widthPx, imageType) : new BufferedImage(widthPx, heightPx, imageType);
        Graphics2D graphics = (Graphics2D)retval.getGraphics();
        graphics.setBackground(TRANSPARENT_WHITE);
        graphics.clearRect(0, 0, retval.getWidth(), retval.getHeight());
        if (rotationAngle != 0) {
            int translateX = 0;
            int translateY = 0;
            switch (rotationAngle) {
                case 90: {
                    translateX = retval.getWidth();
                    break;
                }
                case 270: {
                    translateY = retval.getHeight();
                    break;
                }
                case 180: {
                    translateX = retval.getWidth();
                    translateY = retval.getHeight();
                    break;
                }
            }
            graphics.translate(translateX, translateY);
            graphics.rotate((float)Math.toRadians(rotationAngle));
        }
        graphics.scale(scaling, scaling);
        PageDrawer drawer = new PageDrawer();
        drawer.drawPage(graphics, this, pageDimension);
        return retval;
    }

    public PDPageAdditionalActions getActions() {
        COSDictionary addAct = (COSDictionary)this.page.getDictionaryObject(COSName.AA);
        if (addAct == null) {
            addAct = new COSDictionary();
            this.page.setItem(COSName.AA, (COSBase)addAct);
        }
        return new PDPageAdditionalActions(addAct);
    }

    public void setActions(PDPageAdditionalActions actions) {
        this.page.setItem(COSName.AA, (COSObjectable)actions);
    }

    public List<PDAnnotation> getAnnotations() throws IOException {
        COSArrayList<PDAnnotation> retval = null;
        COSArray annots = (COSArray)this.page.getDictionaryObject(COSName.ANNOTS);
        if (annots == null) {
            annots = new COSArray();
            this.page.setItem(COSName.ANNOTS, (COSBase)annots);
            retval = new COSArrayList(new ArrayList(), annots);
        } else {
            ArrayList<PDAnnotation> actuals = new ArrayList<PDAnnotation>();
            for (int i = 0; i < annots.size(); ++i) {
                COSBase item = annots.getObject(i);
                actuals.add(PDAnnotation.createAnnotation(item));
            }
            retval = new COSArrayList<PDAnnotation>(actuals, annots);
        }
        return retval;
    }

    public void setAnnotations(List<PDAnnotation> annots) {
        this.page.setItem(COSName.ANNOTS, (COSBase)COSArrayList.converterToCOSArray(annots));
    }

    @Override
    public int print(Graphics graphics, PageFormat pageFormat, int pageIndex) throws PrinterException {
        try {
            PageDrawer drawer = new PageDrawer();
            PDRectangle cropBox = this.findCropBox();
            drawer.drawPage(graphics, this, cropBox.createDimension());
            return 0;
        }
        catch (IOException io) {
            throw new PrinterIOException(io);
        }
    }

    public boolean equals(Object other) {
        return other instanceof PDPage && ((PDPage)other).getCOSObject() == this.getCOSObject();
    }

    public int hashCode() {
        return this.getCOSDictionary().hashCode();
    }
}

