/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.vcs;

import java.net.URL;
import java.util.ArrayList;
import javax.swing.Icon;
import oracle.ide.feedback.FeedbackManager;
import oracle.ide.model.DefaultElement;
import oracle.ide.model.Locatable;
import oracle.ide.model.NodeFactory;
import oracle.ide.net.URLFileSystem;
import oracle.ide.net.URLFilter;
import oracle.javatools.icons.OracleIcons;

public class VCSModelUtil {
    private VCSModelUtil() {
    }

    public static final Locatable[] findOrCreateNodes(URL[] urls) {
        Locatable[] locatables = new Locatable[urls.length];
        for (int i = 0; i < urls.length; ++i) {
            locatables[i] = NodeFactory.find(urls[i]);
            if (locatables[i] != null) continue;
            if (URLFileSystem.isDirectoryPath((URL)urls[i])) {
                locatables[i] = new LocatableImpl(urls[i]){

                    @Override
                    public Icon getIcon() {
                        return OracleIcons.getIcon((String)"folder.png");
                    }
                };
                continue;
            }
            try {
                if (urls[i] == null) {
                    throw new NullPointerException("url is null");
                }
                locatables[i] = NodeFactory.findOrCreate(urls[i]);
                continue;
            }
            catch (IllegalAccessException iae) {
                FeedbackManager.reportException(iae);
            }
            catch (InstantiationException instantiationException) {
                // empty catch block
            }
            locatables[i] = new LocatableImpl(urls[i]);
        }
        return locatables;
    }

    public static final Locatable[] getValidLocatables(Object[] nodes, URLFilter filter) {
        ArrayList<Locatable> c = new ArrayList<Locatable>();
        for (int i = 0; i < nodes.length; ++i) {
            URL url = VCSModelUtil.getLocatableURL(nodes[i]);
            if (url == null || filter != null && !filter.accept(url)) continue;
            c.add((Locatable)nodes[i]);
        }
        return c.toArray(new Locatable[0]);
    }

    public static final URL getLocatableURL(Object node) {
        return node instanceof Locatable ? ((Locatable)node).getURL() : null;
    }

    private static class LocatableImpl
    extends DefaultElement
    implements Locatable {
        private URL _url;

        LocatableImpl(URL url) {
            this.setURL(url);
        }

        @Override
        public void setURL(URL url) {
            this._url = url;
        }

        @Override
        public URL getURL() {
            return this._url;
        }

        @Override
        public String getShortLabel() {
            return URLFileSystem.getFileName((URL)this.getURL());
        }

        public boolean equals(Object obj) {
            if (obj == null || obj.getClass() != this.getClass()) {
                return false;
            }
            return this.getURL().equals(((LocatableImpl)obj).getURL());
        }

        public int hashCode() {
            return super.hashCode();
        }
    }
}

