/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.docking;

import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import javax.swing.JComponent;
import oracle.ide.docking.Dockable;
import oracle.ideimpl.controls.dockLayout.DockInsertionPoint;
import oracle.ideimpl.controls.dockLayout.DockLayoutConstraint;
import oracle.ideimpl.controls.dockLayout.DockLayoutPanel;
import oracle.ideimpl.docking.DockPanel;
import oracle.ideimpl.docking.DockPanelHost;
import oracle.ideimpl.docking.DockStationImpl;
import oracle.ideimpl.docking.DockableCriteria;
import oracle.ideimpl.docking.DockablePath;
import oracle.ideimpl.docking.MoveFeedback;
import oracle.ideimpl.docking.TitledPanel;

final class MoveDock
extends MoveFeedback {
    private Dockable _dockable;
    private Point _ptLast;
    private DockInsertionPoint _dip;

    MoveDock(Dockable dockable, JComponent c) {
        super(c);
        this._dockable = dockable;
        Point pt = c.getLocationOnScreen();
        Dimension d = c.getSize();
        this._ptLast = new Point(pt.x + d.width / 2, pt.y + d.height / 2);
    }

    @Override
    protected void moveBy(int x, int y) {
        DockStationImpl ds = DockStationImpl.getInstance();
        DockablePath path = new DockablePath();
        ds.getDockablePath(path, new DockableCriteria(this._dockable));
        TitledPanel exludeTitledPanel = path.getTitledPanel();
        Dimension moveBy = new Dimension(x, y);
        double bestDist = Double.MAX_VALUE;
        DockInsertionPoint bestDip = null;
        DockPanelHost[] dockPanelHosts = ds.getAllDockPanelHosts();
        for (int i = 0; i < dockPanelHosts.length; ++i) {
            DockPanelHost dockPanelHost = dockPanelHosts[i];
            DockInsertionPoint closestDip = dockPanelHost.getClosestDockInsertionPoint(this._ptLast, moveBy, exludeTitledPanel);
            if (closestDip == null) continue;
            DockLayoutPanel container = closestDip.getContainer();
            Point ptScreen = container.getLocationOnScreen();
            Point anchor = closestDip.getAnchor();
            Point absoluteAnchor = new Point(anchor.x + ptScreen.x, anchor.y + ptScreen.y);
            double dist = absoluteAnchor.distance(this._ptLast.x, this._ptLast.y);
            if (!(dist < bestDist)) continue;
            bestDip = closestDip;
            bestDist = dist;
        }
        if (bestDip != null) {
            this._dip = bestDip;
            this._ptLast = new Point(this._dip.getAnchor());
            Point ptScreen = this._dip.getContainer().getLocationOnScreen();
            this._ptLast.translate(ptScreen.x, ptScreen.y);
        }
    }

    @Override
    protected void adjustPosition() {
        if (this._dip != null) {
            Point ptTarget = this._dip.getContainer().getLocationOnScreen();
            Rectangle r = this._dip.getFeedback();
            this.setBounds(ptTarget.x + r.x, ptTarget.y + r.y, r.width, r.height);
            this.validate();
        } else {
            Point pt = this._cOver.getLocationOnScreen();
            Dimension d = this._cOver.getSize();
            this.setBounds(pt.x, pt.y, d.width, d.height);
            this.validate();
        }
    }

    @Override
    protected void commit() {
        if (this._dip != null) {
            DockStationImpl ds = DockStationImpl.getInstance();
            DockLayoutConstraint dlc = this._dip.createConstraint();
            if (this._dip.getOrientation() != 4) {
                DockPanel dp = (DockPanel)this._dip.getContainer();
                ds._dock(this._dockable, dp, dlc, true, 0);
            } else {
                TitledPanel tpTarget = (TitledPanel)this._dip.getCenterReferenceComponent();
                tpTarget.addClient(this._dockable, true, 0);
                tpTarget.activateDockable(this._dockable);
                tpTarget.getParent().validate();
            }
        }
    }
}

