/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.docking;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.logging.Logger;
import javax.swing.Action;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.controller.IdeActions;
import oracle.ide.controller.Menubar;
import org.openide.filesystems.FileUtil;

public class FullScreenController
implements Controller {
    public static final String FULL_SCREEN_ACTION_NAME = "oracle.ide.docking.FullScreenAction";
    private static final int FULL_SCREEN_ACTION_ID = Ide.findOrCreateCmdID("oracle.ide.docking.FullScreenAction");
    private Boolean fullScreenNotSupported;
    private final String[] processNames = new String[]{"gnome-session"};

    public FullScreenController() {
        IdeAction mainToolbarAction = IdeActions.getViewMainToolbarAction();
        if (mainToolbarAction != null) {
            mainToolbarAction.addController(this);
        }
    }

    @Override
    public boolean handleEvent(IdeAction action, Context context) {
        int id = action.getCommandId();
        if (id != FULL_SCREEN_ACTION_ID) {
            return false;
        }
        Action fullScreen = this.getFullScreenAction();
        ActionEvent event = new ActionEvent(action, FULL_SCREEN_ACTION_ID, FULL_SCREEN_ACTION_NAME);
        fullScreen.actionPerformed(event);
        return true;
    }

    @Override
    public boolean update(IdeAction action, Context context) {
        this.updateAllShowToolbarItems();
        int id = action.getCommandId();
        if (id == FULL_SCREEN_ACTION_ID) {
            Action fullScreen;
            if (this.fullScreenNotSupported == null) {
                this.fullScreenNotSupported = this.isFullScreenSupported();
            }
            if ((fullScreen = this.getFullScreenAction()) != null) {
                action.setEnabled(this.fullScreenNotSupported);
            }
            return true;
        }
        if (id == 36) {
            boolean enabled = !Ide.getMainWindow().isFullScreenMode();
            action.setEnabled(enabled);
            return true;
        }
        return false;
    }

    private void updateAllShowToolbarItems() {
        boolean enabled = !Ide.getMainWindow().isFullScreenMode();
        JMenu showToolbar = Menubar.getJMenu("ViewToolbars");
        if (showToolbar == null) {
            return;
        }
        for (Component component : showToolbar.getMenuComponents()) {
            IdeAction action;
            if (!(component instanceof JMenuItem)) continue;
            JMenuItem menuItem = (JMenuItem)component;
            if (menuItem.getAction() == null || !(menuItem.getAction() instanceof IdeAction)) {
                menuItem.setEnabled(enabled);
                continue;
            }
            if (!(menuItem.getAction() instanceof IdeAction) || (action = (IdeAction)menuItem.getAction()).getCommandId() != 36) continue;
            boolean selected = Ide.getMainWindow().isFullScreenMode() ? false : Ide.getToolbar().isVisible();
            menuItem.setSelected(selected);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isFullScreenSupported() {
        String os = System.getProperty("os.name");
        if (os == null || !os.contains("Linux")) {
            return true;
        }
        BufferedReader reader = null;
        try {
            String line;
            Process process = Runtime.getRuntime().exec("ps -e");
            reader = new BufferedReader(new InputStreamReader(process.getInputStream()));
            while ((line = reader.readLine()) != null) {
                for (String processName : this.processNames) {
                    if (!line.contains(processName)) continue;
                    boolean bl = false;
                    return bl;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                reader.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return true;
    }

    private Action getFullScreenAction() {
        Action fullScreen = (Action)FileUtil.getConfigObject((String)"/Actions/Window/com-oracle-jdeveloper-nbwindowsystem-FullScreenAction.instance", Action.class);
        if (fullScreen == null) {
            Logger.getAnonymousLogger().warning("The Full Screen action is null");
        }
        return fullScreen;
    }
}

