/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.controller;

import java.awt.Component;
import java.awt.Window;
import javax.ide.util.MetaClass;
import oracle.ide.Context;
import oracle.ide.ExtensionRegistry;
import oracle.ide.Ide;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.controller.TriggerController;
import oracle.ide.javaxide.Util;
import oracle.ide.resource.IdeArb;
import oracle.javatools.dialogs.ExceptionDialog;
import oracle.javatools.dialogs.MessageDialog;

class MetaClassController
implements Controller {
    private final MetaClass _metaClass;
    private final String _owningExtId;
    private Controller _delegate;
    private boolean _callControllerUpdate;
    protected static final Controller NULL_CONTROLLER = new Controller(){

        @Override
        public boolean handleEvent(IdeAction action, Context context) {
            return false;
        }

        @Override
        public boolean update(IdeAction action, Context context) {
            return false;
        }
    };

    MetaClassController(MetaClass controllerMetaClass, String owningExtId, boolean okToCallControllerUpdate) {
        this._metaClass = controllerMetaClass;
        this._owningExtId = owningExtId;
        this._callControllerUpdate = okToCallControllerUpdate;
    }

    @Override
    public final boolean handleEvent(IdeAction action, Context context) {
        if (!this.okToCallControllerUpdate()) {
            boolean updateSuccess = this.handleEventWhenExtensionNotInitialized(action, context);
            return updateSuccess && (!action.isEnabled() || this.getDelegate().handleEvent(action, context));
        }
        return this.getDelegate().handleEvent(action, context);
    }

    protected boolean handleEventWhenExtensionNotInitialized(IdeAction action, Context context) {
        Controller controller = this.getDelegate();
        boolean updateSuccess = controller.update(action, context);
        if (updateSuccess && !action.isEnabled()) {
            try {
                Object msg = ((TriggerController)controller).getInvalidStateMessage(action, context);
                MessageDialog.information((Component)((Object)Ide.getMainWindow()), (Object)msg, (String)IdeArb.format(524, action.getValue("Name")), null);
            }
            catch (ClassCastException e) {
                ExceptionDialog.showExceptionDialog((Window)((Object)Ide.getMainWindow()), (Exception)e, (String)"If the action is enabled, but cannot be performed, the Controller must be type TriggerControllerand inform the user why the action can't be performed in the active context.");
            }
        }
        return updateSuccess;
    }

    @Override
    public boolean update(IdeAction action, Context context) {
        boolean result;
        boolean updateSuccess = this.updateWhenExtensionNotInitialized(action, context);
        if (!this.okToCallControllerUpdate()) {
            return updateSuccess;
        }
        Controller controller = this.getDelegate();
        boolean bl = result = updateSuccess && controller.update(action, context);
        if (result) {
            action.putValue("controller-handling-update", controller.getClass().getName());
        }
        return result;
    }

    protected boolean updateWhenExtensionNotInitialized(IdeAction action, Context context) {
        action.setEnabled(true);
        return true;
    }

    private final boolean okToCallControllerUpdate() {
        return this._callControllerUpdate || this._delegate != null || this.extensionIsLoaded();
    }

    protected final Controller getDelegate() {
        if (this._delegate == null) {
            this._delegate = Util.createInstance(this._metaClass, Controller.class);
            if (this._delegate == null) {
                return NULL_CONTROLLER;
            }
        }
        return this._delegate;
    }

    private boolean extensionIsLoaded() {
        ExtensionRegistry extensionRegistry = ExtensionRegistry.getExtensionRegistry();
        boolean loaded = extensionRegistry.isFullyLoaded(this._owningExtId);
        if (loaded && !this._callControllerUpdate) {
            this._callControllerUpdate = loaded;
        }
        return loaded;
    }

    protected String getOwningExtId() {
        return this._owningExtId;
    }

    protected MetaClass getMetaClass() {
        return this._metaClass;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof MetaClassController)) {
            return false;
        }
        MetaClassController other = (MetaClassController)object;
        return this._metaClass.equals((Object)other._metaClass);
    }

    public int hashCode() {
        return this._metaClass.hashCode();
    }

    public String toString() {
        return super.toString() + "[" + this._metaClass.getClassName() + "]";
    }
}

