/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.refactoring;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import oracle.ide.Context;
import oracle.ide.model.Element;
import oracle.ide.refactoring.AbstractActionHandlerService;
import oracle.ide.refactoring.BaseActionHandler;
import oracle.ide.refactoring.CompositeDeleteHandler;
import oracle.ide.refactoring.DeleteActionHandler;
import oracle.ide.util.Assert;

public final class DeleteHandlerService
extends AbstractActionHandlerService<DeleteActionHandler> {
    private static DeleteHandlerService INSTANCE = new DeleteHandlerService();

    private DeleteHandlerService() {
    }

    public static void registerActionHandler(Class<? extends Element> classKey, Class<? extends DeleteActionHandler> refactoringActionHandlerClass) {
        INSTANCE._registerActionHandler(classKey, refactoringActionHandlerClass);
    }

    public static void registerActionHandler(String elementClassName, String refactoringActionHandlerClassName, String extensionId) {
        INSTANCE._registerActionHandler(elementClassName, refactoringActionHandlerClassName, extensionId);
    }

    public static void registerLookupHelper(BaseActionHandler.LookupHelper<? extends DeleteActionHandler> lookupHelper) {
        INSTANCE._registerLookupHelper(lookupHelper);
    }

    public static Class<? extends DeleteActionHandler> unregisterActionHandler(Class<? extends Element> classKey) {
        return INSTANCE._unregisterActionHandler(classKey);
    }

    public static Class<? extends DeleteActionHandler> unregisterActionHandler(String elementClassName) {
        return INSTANCE._unregisterActionHandler(elementClassName);
    }

    public static DeleteActionHandler createDeleteHandler(Context context) {
        return INSTANCE._createActionHandler(context);
    }

    @Override
    protected DeleteActionHandler _createActionHandler(Context context) {
        Element[] selections = context.getSelection();
        Assert.check((selections != null && selections.length > 0 ? 1 : 0) != 0);
        ArrayList<Element> stillActiveSelections = new ArrayList<Element>(Arrays.asList(selections));
        List<Class<Element>> selectedSubtypes = this.getAllSelectedElementSubtypes(context.getSelection());
        HashMap handlers = new HashMap();
        for (Class<Element> nodeSubtype : selectedSubtypes) {
            if (stillActiveSelections.isEmpty()) break;
            Class actionHandlerClass = this._getHandlerClass(nodeSubtype, context);
            if (actionHandlerClass == null) continue;
            ArrayList<Element> arrayList = new ArrayList<Element>();
            ListIterator iter = stillActiveSelections.listIterator();
            while (iter.hasNext()) {
                Element e = (Element)iter.next();
                if (nodeSubtype.isInstance(e)) {
                    arrayList.add(e);
                    iter.remove();
                    continue;
                }
                Class nextElementHandlerClass = this._getHandlerClass(e.getClass(), context);
                if (nextElementHandlerClass == null || !actionHandlerClass.equals(nextElementHandlerClass)) continue;
                arrayList.add(e);
                iter.remove();
            }
            if (arrayList.isEmpty()) continue;
            handlers.put(actionHandlerClass, arrayList);
        }
        try {
            if (handlers.size() == 1) {
                Iterator iter = handlers.entrySet().iterator();
                final Map.Entry entry = iter.next();
                Constructor c = ((Class)entry.getKey()).getConstructor(Context.class);
                Context context2 = new Context(context);
                context2.setProperty(DeleteActionHandler.SelectedNodesProvider.class.getName(), new DeleteActionHandler.SelectedNodesProvider(){

                    public List<? extends Element> getSelectedNodes() {
                        return (List)entry.getValue();
                    }
                });
                return (DeleteActionHandler)c.newInstance(new Context(context2));
            }
            if (handlers.size() > 1) {
                HashSet<DeleteActionHandler> actionHandlers = new HashSet<DeleteActionHandler>();
                ArrayList allNodes = new ArrayList();
                for (Map.Entry entry : handlers.entrySet()) {
                    Constructor c = ((Class)entry.getKey()).getConstructor(Context.class);
                    Context copy = new Context(context);
                    copy.setProperty(DeleteActionHandler.SelectedNodesProvider.class.getName(), new SelectedNodesProviderImpl((List)entry.getValue()));
                    DeleteActionHandler actionHandler = (DeleteActionHandler)c.newInstance(new Context(copy));
                    allNodes.addAll(actionHandler.getNodes());
                    actionHandlers.add(actionHandler);
                }
                CompositeDeleteHandler composite = new CompositeDeleteHandler(actionHandlers, allNodes);
                return composite;
            }
        }
        catch (InstantiationException e) {
            Assert.fail((Exception)e);
        }
        catch (NoSuchMethodException e) {
            Assert.fail((Exception)e);
        }
        catch (InvocationTargetException e) {
            Assert.fail((Exception)e);
        }
        catch (IllegalAccessException e) {
            Assert.fail((Exception)e);
        }
        return null;
    }

    private static class SelectedNodesProviderImpl
    implements DeleteActionHandler.SelectedNodesProvider {
        private List<Element> _elements;

        SelectedNodesProviderImpl(List<Element> elements) {
            this._elements = elements;
        }

        public List<Element> getSelectedNodes() {
            return this._elements;
        }
    }
}

