/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.refactoring;

import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractButton;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import oracle.ide.resource.DeleteDialogArb;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.dialogs.DetailDialog;
import oracle.javatools.ui.Colors;

public final class ActionHandlerConfirmationDialog
extends DetailDialog {
    private JButton previewButton;
    private JLabel statusLabel;
    private boolean hasPreview;

    private ActionHandlerConfirmationDialog(Frame owner, String title, int buttonMask) {
        super(owner, title, buttonMask);
    }

    public static ActionHandlerConfirmationDialog createDialog(JFrame dialogOwner, String dialogTitle, Component dialogContent, Component detailsComponent) {
        return ActionHandlerConfirmationDialog.createDialog(dialogOwner, dialogTitle, dialogContent, detailsComponent, false);
    }

    public static ActionHandlerConfirmationDialog createDialog(JFrame dialogOwner, String dialogTitle, Component dialogContent, Component detailsComponent, boolean preview) {
        int detailsMask = detailsComponent != null ? 16 : 0;
        ActionHandlerConfirmationDialog dialog = new ActionHandlerConfirmationDialog(dialogOwner, dialogTitle, 7 | detailsMask);
        dialog.setContent(dialogContent);
        dialog.setResizable(true);
        if (detailsComponent != null) {
            dialog.setDetailContent(detailsComponent);
            dialog.initStatusLabel();
            dialog.setDetailVisible(false);
            dialog.setDetailsButtonEnabled(false);
        }
        if (preview) {
            dialog.setupPreviewButton();
        }
        dialog.pack();
        return dialog;
    }

    public final void setPreviewButtonEnabled(boolean enabled) {
        if (this.previewButton != null) {
            this.previewButton.setEnabled(enabled);
        }
    }

    public final boolean hasPreview() {
        return this.hasPreview;
    }

    public final void setDetailsAvailable(boolean detailsAvailable) {
        this.setDetailsButtonEnabled(detailsAvailable);
    }

    public final void setStatus(String text, Icon icon) {
        this.statusLabel.setText(text);
        this.statusLabel.setIcon(icon);
        Container parent = this.statusLabel.getParent();
        if (parent != null) {
            parent.repaint();
        }
    }

    private final void initStatusLabel() {
        this.statusLabel = new JLabel();
        this.statusLabel.setText("");
        this.statusLabel.setIcon(null);
        this.statusLabel.setForeground(Colors.HINT_TEXT);
        this.setDetailsStatusLabel(this.statusLabel);
    }

    private void setupPreviewButton() {
        this.previewButton = new JButton();
        ResourceUtils.resButton((AbstractButton)this.previewButton, (String)DeleteDialogArb.getString(44));
        this.addCustomButton(this.previewButton);
        this.previewButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ActionHandlerConfirmationDialog.this.hasPreview = true;
                ActionHandlerConfirmationDialog.this.closeDialog(false);
            }
        });
    }
}

