/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.model;

import java.awt.BorderLayout;
import java.awt.Component;
import java.net.URL;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.ConcurrentModificationException;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.WeakHashMap;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import javax.swing.UIManager;
import oracle.ide.Ide;
import oracle.ide.IdeMainWindow;
import oracle.ide.cmd.RevertNodeCommand;
import oracle.ide.controller.CommandProcessor;
import oracle.ide.controls.checkboxlist.CheckBoxListModel;
import oracle.ide.dialogs.SelectFilesPanel;
import oracle.ide.docking.Dockable;
import oracle.ide.explorer.ExplorerContext;
import oracle.ide.explorer.TreeExplorer;
import oracle.ide.model.Element;
import oracle.ide.model.ElementAttributes;
import oracle.ide.model.Node;
import oracle.ide.model.NodeFactory;
import oracle.ide.model.Project;
import oracle.ide.model.Workspace;
import oracle.ide.navigator.NavigatorManager;
import oracle.ide.navigator.NavigatorWindow;
import oracle.ide.net.URLFileSystem;
import oracle.ide.performance.PerformanceLogger;
import oracle.ide.resource.IdeArb;
import oracle.ide.util.Assert;
import oracle.javatools.dialogs.MessageDialog;
import oracle.javatools.util.SwingClosure;

public final class NodeUtil {
    @Deprecated
    public static final int RELOAD_PROMPTED = 1;
    @Deprecated
    public static final int RELOAD_PROMPTED_IF_DIRTY = 2;
    @Deprecated
    public static final int RELOAD_SILENTLY = 3;
    private static final boolean VERBOSE_RELOAD = Boolean.getBoolean("verbose_on_activate");
    private static final Comparator<Node> LOCK_ORDER_COMPARATOR = new Comparator<Node>(){

        @Override
        public int compare(Node n1, Node n2) {
            return System.identityHashCode(n1) - System.identityHashCode(n2);
        }
    };
    private static final Object reloadMonitor = new Object();
    private static Thread reloadingThread;
    private static Thread collectingThread;
    private static ReloadStates reloadState;
    private static ActivationStates activationState;
    private static WeakHashMap<Node, Long> timestampMap;
    private static Map<Node, Long> noReloadDecisions;
    private static boolean collected;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void runUnderReadLock(Collection<? extends Node> nodes, Runnable r) {
        if (r == null) {
            throw new IllegalArgumentException("null Runnable");
        }
        Class<?> clazz = null;
        boolean lockedNone = true;
        boolean lockedAll = true;
        for (Node node : nodes) {
            if (node == null) {
                throw new IllegalArgumentException("null node");
            }
            if (clazz == null) {
                clazz = node.getClass();
            } else if (!node.getClass().equals(clazz)) {
                throw new IllegalArgumentException("Node subclass mismatch. Expected class: " + clazz.getName() + " Actual class: " + node.getClass().getName());
            }
            if (node.isReadOrWriteLocked()) {
                lockedNone = false;
                continue;
            }
            lockedAll = false;
        }
        if (!lockedNone && !lockedAll) {
            throw new IllegalMonitorStateException();
        }
        List<Node> list = NodeUtil.getLockOrder(nodes);
        for (Node node : list) {
            node.readLock();
        }
        try {
            r.run();
        }
        finally {
            Collections.reverse(list);
            for (Node node : list) {
                node.readUnlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void runUnderWriteLock(Collection<? extends Node> nodes, Runnable r) {
        if (r == null) {
            throw new IllegalArgumentException("null Runnable");
        }
        Class<?> clazz = null;
        boolean lockedNone = true;
        boolean lockedAll = true;
        for (Node node : nodes) {
            if (node == null) {
                throw new IllegalArgumentException("null node");
            }
            if (clazz == null) {
                clazz = node.getClass();
            } else if (!node.getClass().equals(clazz)) {
                throw new IllegalArgumentException("Node subclass mismatch. Expected class: " + clazz.getName() + " Actual class: " + node.getClass().getName());
            }
            if (node.isReadLocked()) {
                throw new IllegalMonitorStateException("Calling thread already holds a read lock on " + URLFileSystem.getPlatformPathName((URL)node.getURL()));
            }
            if (node.isWriteLocked()) {
                lockedNone = false;
                continue;
            }
            lockedAll = false;
        }
        if (!lockedNone && !lockedAll) {
            throw new IllegalMonitorStateException();
        }
        List<Node> list = NodeUtil.getLockOrder(nodes);
        for (Node node : list) {
            node.writeLock();
        }
        try {
            r.run();
        }
        finally {
            Collections.reverse(list);
            for (Node node : list) {
                node.writeUnlock();
            }
        }
    }

    private static List<Node> getLockOrder(Collection<? extends Node> nodes) {
        ArrayList<Node> list = new ArrayList<Node>(nodes);
        Collections.sort(list, LOCK_ORDER_COMPARATOR);
        return list;
    }

    public static void storeAllTimestamps(Map<Node, Long> timestampMap) {
        NodeUtil.storeTimestampsImpl(timestampMap, NodeFactory.getCachedNodes(), new OpenNodeFilter());
    }

    public static void storeAllTimestamps(Map<Node, Long> timestampMap, oracle.ide.model.NodeFilter nodeFilter) {
        NodeUtil.storeTimestampsImpl(timestampMap, NodeFactory.getCachedNodes(), nodeFilter);
    }

    public static void storeTimestamps(Map<Node, Long> timestampMap, Collection<Node> nodes) {
        NodeUtil.storeTimestampsImpl(timestampMap, nodes.iterator(), new OpenNodeFilter());
    }

    public static void storeTimestamps(Map<Node, Long> timestampMap, Collection<Node> nodes, oracle.ide.model.NodeFilter nodeFilter) {
        NodeUtil.storeTimestampsImpl(timestampMap, nodes.iterator(), nodeFilter);
    }

    private static void storeTimestampsImpl(Map<Node, Long> timestampMap, Iterator<? extends Node> nodesIter, oracle.ide.model.NodeFilter nodeFilter) {
        while (nodesIter.hasNext()) {
            Node node = nodesIter.next();
            if (NodeUtil.isReloadable(node) && nodeFilter.accept(node)) {
                long timestamp = node.getUnmodifiedTimestamp();
                timestampMap.put(node, timestamp);
                continue;
            }
            timestampMap.remove(node);
        }
    }

    private static boolean isReloadable(Node node) {
        if (node == null) {
            return false;
        }
        return !node.getAttributes().isSet(ElementAttributes.NON_RELOADABLE) && URLFileSystem.isLocal((URL)node.getURL());
    }

    public static void reloadBuffers(Map<Node, Long> timestampMap) {
        NodeUtil.reloadBuffers(timestampMap, true);
    }

    public static void reloadBuffers(Map<Node, Long> timestampMap, boolean silentReload) {
        NodeUtil.reloadBuffers(timestampMap, silentReload, false);
    }

    @Deprecated
    public static void reloadBuffers(Map<Node, Long> timestampMap, boolean silentReload, boolean manualReload) {
        if (timestampMap != null) {
            Iterator<Node> iter = timestampMap.keySet().iterator();
            NodeUtil.reloadBuffers(iter, timestampMap, silentReload, manualReload);
        }
    }

    public static void reloadBuffers(Collection<Node> nodes, boolean silentReload) {
        if (nodes != null) {
            NodeUtil.reloadBuffers(nodes.iterator(), null, silentReload, false);
        }
    }

    @Deprecated
    public static void reloadBuffers(Collection<Node> nodes, Map<Node, Long> timestampMap, int reloadMode, boolean manualReload) {
        if (reloadMode != 1 && reloadMode != 2 && reloadMode != 3) {
            throw new IllegalArgumentException("reloadMode must be one of RELOAD_PROMPTED, RELOAD_PROMPTED_IF_DIRTY or RELOAD_SILENTLY. Found " + reloadMode);
        }
        NodeUtil.reloadBuffers(nodes.iterator(), timestampMap, reloadMode, manualReload);
    }

    private static void reloadBuffers(Iterator nodeIterator, Map<Node, Long> timestampMap, boolean silentReload, boolean manualReload) {
        int reloadMode = silentReload ? 2 : 1;
        NodeUtil.reloadBuffers(nodeIterator, timestampMap, reloadMode, manualReload);
    }

    private static void reloadBuffers(Iterator nodeIterator, Map<Node, Long> timestampMap, int reloadMode, boolean manualReload) {
        AbstractSet reloadFlags;
        if (reloadMode == 2) {
            reloadFlags = EnumSet.of(ReloadMode.RELOAD_PROMPTED_IF_DIRTY, ReloadMode.SILENT_RELOAD);
        } else if (reloadMode == 3) {
            reloadFlags = EnumSet.of(ReloadMode.SILENT_RELOAD);
        } else if (reloadMode == 1) {
            reloadFlags = new HashSet();
        } else {
            throw new IllegalArgumentException("reloadMode " + reloadMode);
        }
        if (manualReload) {
            reloadFlags.add(ReloadMode.INFORM_WHEN_NONE_NEED_RELOADING);
        }
        NodeUtil.reloadBuffers(nodeIterator, timestampMap, reloadFlags);
    }

    public static void reloadNodes(Collection<Node> nodesToBeReloaded, Set<ReloadMode> reloadFlags) {
        NodeUtil.checkThatSilentIfOffEventThread(reloadFlags);
        NodeUtil.reloadBuffers(nodesToBeReloaded.iterator(), null, reloadFlags);
    }

    public static void reloadBuffers(Map<Node, Long> node2timestampMap, Set<ReloadMode> reloadFlags) {
        NodeUtil.checkThatSilentIfOffEventThread(reloadFlags);
        if (node2timestampMap != null) {
            Iterator<Node> iter = node2timestampMap.keySet().iterator();
            NodeUtil.reloadBuffers(iter, node2timestampMap, reloadFlags);
        }
    }

    private static void checkThatSilentIfOffEventThread(Set<ReloadMode> reloadFlags) {
        if (!(SwingUtilities.isEventDispatchThread() || reloadFlags.contains((Object)ReloadMode.SILENT_RELOAD) && reloadFlags.size() == 1)) {
            throw new IllegalArgumentException("Method must either be called on the event thread or run in silent mode");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void reloadBuffers(Iterator nodeIterator, Map<Node, Long> node2timestampMap, Set<ReloadMode> reloadFlags) {
        ArrayList<Node> autoReloadNodes = new ArrayList<Node>();
        ArrayList<Node> promptedReloadNodes = new ArrayList<Node>();
        int nodeChecked = 0;
        PerformanceLogger.get().startTiming("NodeUtil.reloadBuffers");
        try {
            while (nodeIterator.hasNext()) {
                Node node = (Node)nodeIterator.next();
                if (node == null || !node.isOpen()) continue;
                ++nodeChecked;
                if (VERBOSE_RELOAD) {
                    Assert.println((String)("Checking open node: " + node.getLongLabel()));
                }
                node.isReadOnly();
                if (node.getAttributes().isSet(ElementAttributes.NON_RELOADABLE)) continue;
                boolean mustReload = false;
                if (node2timestampMap != null) {
                    long storedTimestamp;
                    long urlTimestamp = URLFileSystem.lastModified((URL)node.getURL());
                    if (urlTimestamp != (storedTimestamp = node2timestampMap.get(node).longValue())) {
                        long nodeTimestamp = node.getTimestamp();
                        mustReload = urlTimestamp >= 0L && (urlTimestamp > nodeTimestamp || urlTimestamp < nodeTimestamp && urlTimestamp < storedTimestamp);
                    }
                } else {
                    mustReload = true;
                }
                if (!mustReload) continue;
                if (node.isDirty() && reloadFlags.contains((Object)ReloadMode.RELOAD_PROMPTED_IF_DIRTY) || !reloadFlags.contains((Object)ReloadMode.SILENT_RELOAD)) {
                    promptedReloadNodes.add(node);
                    continue;
                }
                autoReloadNodes.add(node);
            }
            NodeUtil.performReload(autoReloadNodes, promptedReloadNodes, reloadFlags);
        }
        finally {
            PerformanceLogger.get().stopTiming("NodeUtil.reloadBuffers", "Checked " + nodeChecked + " open nodes", 500);
        }
    }

    private static void performReload(final ArrayList<Node> autoReloadNodes, final ArrayList<Node> promptedReloadNodes, final Set<ReloadMode> reloadFlags) {
        try {
            SwingClosure closure = new SwingClosure(true){

                protected void runImpl() throws Exception {
                    if (promptedReloadNodes.size() == 0 && autoReloadNodes.size() == 0 && reloadFlags.contains((Object)ReloadMode.INFORM_WHEN_NONE_NEED_RELOADING)) {
                        String title = IdeArb.getString(255);
                        String message = IdeArb.getString(256);
                        IdeMainWindow parentComponent = Ide.getMainWindow();
                        JOptionPane.showMessageDialog((Component)((Object)parentComponent), message, title, 1);
                        return;
                    }
                    ArrayList<Node> problemNodes = new ArrayList<Node>();
                    if (CommandProcessor.getInstance().isTransactionActive()) {
                        problemNodes.addAll(promptedReloadNodes);
                        promptedReloadNodes.clear();
                        problemNodes.addAll(autoReloadNodes);
                        autoReloadNodes.clear();
                    } else {
                        Node node;
                        Iterator i = autoReloadNodes.iterator();
                        while (i.hasNext()) {
                            node = (Node)i.next();
                            if (!node.isReadOrWriteLocked()) continue;
                            problemNodes.add(node);
                            i.remove();
                        }
                        i = promptedReloadNodes.iterator();
                        while (i.hasNext()) {
                            node = (Node)i.next();
                            if (!node.isReadOrWriteLocked()) continue;
                            problemNodes.add(node);
                            i.remove();
                        }
                    }
                    NodeUtil.autoReload(autoReloadNodes);
                    NodeUtil.promptedReload(promptedReloadNodes, true);
                    NodeUtil.problemReload(problemNodes);
                }
            };
            closure.run();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void autoReload(ArrayList<Node> nodes) {
        NodeUtil.tryRevert(nodes);
    }

    private static void promptedReload(ArrayList<Node> nodes, boolean viewRefresh) {
        CheckBoxListModel listModel = new CheckBoxListModel();
        for (Node node : nodes) {
            Icon icon = node.getIcon();
            String label = URLFileSystem.getPlatformPathName((URL)node.getURL());
            listModel.addElement((Object)node, icon, true, true, label);
        }
        int size = listModel.getSize();
        if (size > 0) {
            int response = 0;
            response = viewRefresh ? SelectFilesPanel.showDialog(IdeArb.getString(326), IdeArb.format(418, listModel.findTextForElement(0)), IdeArb.getString(221), listModel, true, 0, "f1_ideviewrefreshedfiles_html") : SelectFilesPanel.showDialog(IdeArb.getString(255), IdeArb.format(218, listModel.findTextForElement(0)), IdeArb.getString(221), listModel, true, 0, "f1_idedexternallymodifiedfiles_html");
            long current = System.currentTimeMillis();
            if (response == 0) {
                ArrayList<Node> selNodes = new ArrayList<Node>();
                for (int i = size - 1; i >= 0; --i) {
                    Node node = (Node)listModel.getUserObjectAt(i);
                    if (listModel.isElementSelected(i)) {
                        noReloadDecisions.remove(node);
                        selNodes.add(node);
                        continue;
                    }
                    noReloadDecisions.put(node, current);
                }
                NodeUtil.tryRevert(selNodes);
            }
            if (response == 1 || response == 2) {
                for (int i = size - 1; i >= 0; --i) {
                    noReloadDecisions.put((Node)listModel.getUserObjectAt(i), current);
                }
            }
        }
    }

    private static void promptedReload(ArrayList<Node> nodes) {
        NodeUtil.promptedReload(nodes, false);
    }

    private static void tryRevert(List<Node> nodes) {
        if (nodes == null || nodes.isEmpty()) {
            return;
        }
        ArrayList<Node> marked = new ArrayList<Node>();
        for (Node node : nodes) {
            if (!(node instanceof Project) && !(node instanceof Workspace)) continue;
            node.getTransientProperties().put("PROJECT.reload.external.change", Boolean.TRUE);
            marked.add(node);
        }
        for (Node node : nodes) {
            NodeUtil.tryRevert(node);
        }
        for (Node node : marked) {
            node.getTransientProperties().remove("PROJECT.reload.external.change");
        }
    }

    private static Map<TreeExplorer, List> saveExplorerState(List<Node> auto, List<Node> prompted) {
        ArrayList<Node> nodes = new ArrayList<Node>();
        if (auto != null) {
            nodes.addAll(auto);
        }
        if (prompted != null) {
            nodes.addAll(prompted);
        }
        if (nodes.isEmpty()) {
            return null;
        }
        boolean storeState = false;
        Workspace aw = Ide.getActiveWorkspace();
        if (aw != null) {
            HashSet<Project> projects = new HashSet<Project>();
            Iterator<Element> it = aw.getChildren();
            while (it.hasNext()) {
                Element e = it.next();
                if (!(e instanceof Project)) continue;
                projects.add((Project)e);
            }
            for (Node node : nodes) {
                if (node instanceof Workspace && aw.equals(node)) {
                    storeState = true;
                    break;
                }
                if (!(node instanceof Project) || !projects.contains(node)) continue;
                storeState = true;
                break;
            }
        }
        NavigatorManager anm = NavigatorManager.getApplicationNavigatorManager();
        HashMap<TreeExplorer, List> states = new HashMap<TreeExplorer, List>();
        if (storeState) {
            for (Dockable dockable : anm.getNavigatorWindow().getHostedDockables()) {
                NavigatorWindow nw;
                TreeExplorer tex;
                if (!(dockable instanceof NavigatorWindow) || (tex = (nw = (NavigatorWindow)dockable).getTreeExplorer()) == null) continue;
                states.put(tex, ExplorerContext.storeExpansionState(tex.getRoot(), tex));
            }
        }
        return states;
    }

    private static void restoreExplorerState(final Map<TreeExplorer, List> state) {
        if (state == null) {
            return;
        }
        new SwingWorker(){

            protected Object doInBackground() {
                try {
                    Thread.sleep(200L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                return null;
            }

            @Override
            public void done() {
                for (Map.Entry e : state.entrySet()) {
                    ExplorerContext.restoreExpansionState(((TreeExplorer)e.getKey()).getRoot(), (TreeExplorer)e.getKey(), (List)e.getValue());
                }
            }
        }.execute();
    }

    private static void tryRevert(Node node) {
        try {
            RevertNodeCommand.reload(node);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void problemReload(ArrayList<Node> problemNodes) {
        if (!problemNodes.isEmpty()) {
            IdeMainWindow parentComponent = Ide.getMainWindow();
            JComponent header = NodeUtil.createLabel(IdeArb.getString(487));
            JList list = NodeUtil.createList(problemNodes, 8);
            JComponent footer = NodeUtil.createLabel(IdeArb.getString(488));
            JPanel message = new JPanel(new BorderLayout(10, 10));
            message.add((Component)header, "North");
            message.add((Component)new JScrollPane(list), "Center");
            message.add((Component)footer, "South");
            String title = IdeArb.getString(489);
            String helpTopic = "f1_idedexternallymodifiedfilesproblem_html";
            MessageDialog.error((Component)((Object)parentComponent), (Object)message, (String)title, (String)helpTopic);
        }
    }

    private static JComponent createLabel(String text) {
        JTextArea label = new JTextArea(text, 0, 60);
        label.setLineWrap(true);
        label.setWrapStyleWord(true);
        label.setBorder(null);
        label.setEditable(false);
        label.setOpaque(false);
        label.setForeground(UIManager.getColor("Label.foreground"));
        label.setBackground(UIManager.getColor("Label.background"));
        return label;
    }

    private static JList createList(ArrayList<Node> nodes, int visibleRowCount) {
        JList<Object> list = new JList<Object>(nodes.toArray());
        list.setVisibleRowCount(visibleRowCount);
        list.setCellRenderer(new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                Node node = (Node)value;
                String text = node.getShortLabel() + " (" + URLFileSystem.getPlatformPathName((URL)URLFileSystem.getParent((URL)node.getURL())) + ")";
                return super.getListCellRendererComponent((JList<?>)list, text, index, isSelected, cellHasFocus);
            }
        });
        return list;
    }

    private NodeUtil() {
    }

    public static void startReloading(boolean silentReload, boolean manualReload, boolean checkTimeStamp) {
        AbstractSet reloadFlags;
        int reloadMode;
        int n = reloadMode = silentReload ? 2 : 1;
        if (reloadMode == 2) {
            reloadFlags = EnumSet.of(ReloadMode.RELOAD_PROMPTED_IF_DIRTY, ReloadMode.SILENT_RELOAD);
        } else if (reloadMode == 3) {
            reloadFlags = EnumSet.of(ReloadMode.SILENT_RELOAD);
        } else if (reloadMode == 1) {
            reloadFlags = new HashSet();
        } else {
            throw new IllegalArgumentException("reloadMode " + reloadMode);
        }
        if (manualReload) {
            reloadFlags.add(ReloadMode.INFORM_WHEN_NONE_NEED_RELOADING);
        }
        NodeUtil.startReloading(reloadFlags, checkTimeStamp);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void startReloading(final Set<ReloadMode> reloadFlags, final boolean checkTimeStamp) {
        Object object = reloadMonitor;
        synchronized (object) {
            activationState = ActivationStates.ACTIVATED;
            switch (reloadState) {
                case IDLE: {
                    reloadingThread = new Thread(new Runnable(){

                        @Override
                        public void run() {
                            NodeUtil.reloadAsynchronously(reloadFlags, new OpenNodeFilter(), checkTimeStamp);
                        }
                    });
                    reloadState = ReloadStates.COMPARING;
                    reloadingThread.start();
                    break;
                }
                case COMPARING: {
                    break;
                }
                case RESETTING: {
                    reloadState = ReloadStates.COMPARING;
                    break;
                }
                case RESET: {
                    reloadMonitor.notify();
                    break;
                }
                case RELOADING: {
                    break;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void stopReloading() {
        Object object = reloadMonitor;
        synchronized (object) {
            activationState = ActivationStates.DEACTIVATED;
            switch (reloadState) {
                case IDLE: {
                    break;
                }
                case COMPARING: {
                    reloadState = ReloadStates.RESETTING;
                    break;
                }
                case RESETTING: {
                    break;
                }
                case RESET: {
                    break;
                }
                case RELOADING: {
                    break;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void reloadAsynchronously(Set<ReloadMode> reloadFlags, oracle.ide.model.NodeFilter nodeFilter, boolean checkTimeStamp) {
        ArrayList<Node> allReloadNodes = new ArrayList<Node>();
        int nodeChecked = 0;
        Iterator<Node> nodeIterator = NodeFactory.getLoadedNodes();
        PerformanceLogger.get().startTiming("NodeUtil.reloadBuffers");
        try {
            Object node;
            while (nodeIterator.hasNext()) {
                boolean mustReload;
                block38: {
                    block37: {
                        long storedTimestamp;
                        Object object = reloadMonitor;
                        synchronized (object) {
                            switch (reloadState) {
                                case RESETTING: {
                                    reloadState = ReloadStates.RESET;
                                    try {
                                        reloadMonitor.wait();
                                    }
                                    catch (InterruptedException interruptedException) {
                                        // empty catch block
                                    }
                                }
                                case RESET: {
                                    allReloadNodes = new ArrayList();
                                    nodeChecked = 0;
                                    nodeIterator = NodeFactory.getLoadedNodes();
                                    if (!nodeIterator.hasNext()) {
                                        reloadState = ReloadStates.IDLE;
                                        return;
                                    }
                                    reloadState = ReloadStates.COMPARING;
                                    break;
                                }
                            }
                        }
                        try {
                            node = nodeIterator.next();
                        }
                        catch (NoSuchElementException e) {
                            Object object2 = reloadMonitor;
                            synchronized (object2) {
                                reloadState = ReloadStates.RESET;
                            }
                            try {
                                Thread.sleep(2000L);
                            }
                            catch (InterruptedException interruptedException) {}
                            continue;
                        }
                        catch (ConcurrentModificationException e) {
                            Object object3 = reloadMonitor;
                            synchronized (object3) {
                                reloadState = ReloadStates.RESET;
                            }
                            try {
                                Thread.sleep(2000L);
                            }
                            catch (InterruptedException interruptedException) {}
                            continue;
                        }
                        if (node == null || !NodeUtil.isReloadable((Node)node)) continue;
                        ++nodeChecked;
                        ((Node)node).isReadOnly();
                        if (((Node)node).getAttributes().isSet(ElementAttributes.NON_RELOADABLE)) continue;
                        mustReload = false;
                        if (!checkTimeStamp) break block37;
                        long urlTimestamp = URLFileSystem.lastModified((URL)((Node)node).getURL());
                        if (urlTimestamp != (storedTimestamp = ((Node)node).getUnmodifiedTimestamp())) {
                            Long nd;
                            long nodeTimestamp = ((Node)node).getTimestamp();
                            boolean bl = mustReload = urlTimestamp >= 0L && (urlTimestamp > nodeTimestamp || urlTimestamp < nodeTimestamp && urlTimestamp < storedTimestamp);
                            if (mustReload && (nd = noReloadDecisions.get(node)) != null && urlTimestamp < nd) {
                                mustReload = false;
                            }
                        }
                        break block38;
                    }
                    mustReload = true;
                }
                if (!mustReload) continue;
                allReloadNodes.add((Node)node);
            }
            node = reloadMonitor;
            synchronized (node) {
                switch (reloadState) {
                    case RESETTING: {
                        reloadState = ReloadStates.RESET;
                        return;
                    }
                }
                reloadState = ReloadStates.RELOADING;
            }
            NodeUtil.performReloadNonBlocking(allReloadNodes, reloadFlags);
            return;
        }
        catch (Exception e) {
            e.printStackTrace();
            return;
        }
        finally {
            PerformanceLogger.get().stopTiming("NodeUtil.reloadBuffers", "Checked " + nodeChecked + " open nodes", 500);
        }
    }

    public static WeakHashMap<Node, Long> getTimeStampMap() {
        collected = false;
        timestampMap = new WeakHashMap();
        NodeUtil.storeTimestampsImpl(timestampMap, NodeFactory.getLoadedNodes(), new OpenNodeFilter());
        collected = true;
        return timestampMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void performReloadNonBlocking(final ArrayList<Node> allReloadNodes, final Set<ReloadMode> reloadFlags) {
        final ArrayList promptedReloadNodes = new ArrayList();
        final ArrayList autoReloadNodes = new ArrayList();
        try {
            SwingClosure closure = new SwingClosure(true){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                protected void runImpl() throws Exception {
                    for (Node node : allReloadNodes) {
                        if (node.isDirty() && reloadFlags.contains((Object)ReloadMode.RELOAD_PROMPTED_IF_DIRTY) || !reloadFlags.contains((Object)ReloadMode.SILENT_RELOAD)) {
                            promptedReloadNodes.add(node);
                            continue;
                        }
                        autoReloadNodes.add(node);
                    }
                    if (promptedReloadNodes.size() == 0 && autoReloadNodes.size() == 0 && reloadFlags.contains((Object)ReloadMode.INFORM_WHEN_NONE_NEED_RELOADING)) {
                        String title = IdeArb.getString(255);
                        String message = IdeArb.getString(256);
                        IdeMainWindow parentComponent = Ide.getMainWindow();
                        JOptionPane.showMessageDialog((Component)((Object)parentComponent), message, title, 1);
                        return;
                    }
                    ArrayList<Node> problemNodes = new ArrayList<Node>();
                    if (CommandProcessor.getInstance().isTransactionActive()) {
                        problemNodes.addAll(promptedReloadNodes);
                        promptedReloadNodes.clear();
                        problemNodes.addAll(autoReloadNodes);
                        autoReloadNodes.clear();
                    } else {
                        Node node;
                        Iterator i = autoReloadNodes.iterator();
                        while (i.hasNext()) {
                            node = (Node)i.next();
                            if (!node.isReadOrWriteLocked()) continue;
                            problemNodes.add(node);
                            i.remove();
                        }
                        i = promptedReloadNodes.iterator();
                        while (i.hasNext()) {
                            node = (Node)i.next();
                            if (!node.isReadOrWriteLocked()) continue;
                            problemNodes.add(node);
                            i.remove();
                        }
                    }
                    Map state = NodeUtil.saveExplorerState(autoReloadNodes, promptedReloadNodes);
                    NodeUtil.autoReload(autoReloadNodes);
                    NodeUtil.promptedReload(promptedReloadNodes);
                    NodeUtil.problemReload(problemNodes);
                    NodeUtil.restoreExplorerState(state);
                    Object object = reloadMonitor;
                    synchronized (object) {
                        reloadState = ReloadStates.IDLE;
                    }
                }
            };
            closure.run();
        }
        catch (Exception e) {
            Object object = reloadMonitor;
            synchronized (object) {
                reloadState = ReloadStates.IDLE;
            }
            e.printStackTrace();
        }
    }

    static {
        reloadState = ReloadStates.IDLE;
        activationState = ActivationStates.INIT;
        noReloadDecisions = new WeakHashMap<Node, Long>();
        collected = false;
    }

    private static enum ActivationStates {
        INIT,
        ACTIVATED,
        DEACTIVATED;

    }

    private static enum ReloadStates {
        IDLE,
        COMPARING,
        RESETTING,
        RESET,
        RELOADING;

    }

    private static class OpenNodeFilter
    implements oracle.ide.model.NodeFilter {
        private OpenNodeFilter() {
        }

        @Override
        public boolean accept(Node node) {
            return node != null && node.isLoaded();
        }
    }

    @Deprecated
    public static interface NodeFilter
    extends oracle.ide.model.NodeFilter {
    }

    public static enum ReloadMode {
        SILENT_RELOAD,
        RELOAD_PROMPTED_IF_DIRTY,
        INFORM_WHEN_NONE_NEED_RELOADING;

    }
}

