/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.model;

import java.util.Iterator;
import oracle.ide.Version;
import oracle.ide.migration.MigrationInfo;
import oracle.ide.migration.NodeMigrator;
import oracle.ide.model.HashStructureNodeMigrator;
import oracle.ide.model.Node;
import oracle.ide.resource.IdeArb;
import oracle.ide.util.IdeUtil;

public final class HeadlessMigratorUtil {
    private static String _failFastIfMigrationNeededProperty = System.getProperty("ide.failFastIfMigrationNeeded");
    private static boolean _failFastIfMigrationNeeded = _failFastIfMigrationNeededProperty != null ? !_failFastIfMigrationNeededProperty.equalsIgnoreCase("false") : true;

    private HeadlessMigratorUtil() {
    }

    public static boolean nodeNeedsMigration(Node node) {
        boolean skipMigration = Boolean.getBoolean("ide.skipmigration");
        if (!skipMigration) {
            NodeMigrator migrator = NodeMigrator.getNodeMigrator(NodeMigrator.getLookupKey(node));
            if (migrator != null && migrator instanceof HashStructureNodeMigrator) {
                MigrationInfo mi = migrator.getMigrationInfo(node);
                if (mi.getVersionStatus() == MigrationInfo.VERSION_NEWER) {
                    return true;
                }
                if (mi instanceof HashStructureNodeMigrator.HSNodeMigrationInfo) {
                    HashStructureNodeMigrator.HSNodeMigrationInfo hsmi = (HashStructureNodeMigrator.HSNodeMigrationInfo)mi;
                    if (mi.getVersionDirectly() == null) {
                        hsmi.ensureVersionInfoImpl(false);
                    }
                }
                Iterator<MigrationInfo.ErrorInformation> errors = mi.getErrors();
                MigrationInfo.MigrationStatus migrationStatus = mi.getMigrationStatusDirectly();
                return !errors.hasNext() && migrationStatus != MigrationInfo.MIGRATION_NOT_POSSIBLE && migrationStatus != MigrationInfo.MIGRATION_NOT_NEEDED;
            }
            return false;
        }
        return false;
    }

    public static String getNodeNeedsMigrationError(Node node) {
        return IdeArb.format(387, node.getLongLabel());
    }

    public static boolean failFastIfNodeNeedsMigration(Node node) {
        if (IdeUtil.isHeadless() && Version.DEBUG_BUILD != 0 && _failFastIfMigrationNeeded) {
            return HeadlessMigratorUtil.nodeNeedsMigration(node);
        }
        return false;
    }
}

