/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.log;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ContainerEvent;
import java.awt.event.ContainerListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleHyperlink;
import javax.accessibility.AccessibleHypertext;
import javax.accessibility.AccessibleText;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.JEditorPane;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import javax.swing.event.MouseInputAdapter;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Caret;
import javax.swing.text.DefaultStyledDocument;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import javax.swing.text.StyledDocument;
import oracle.bali.share.nls.StringUtils;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.config.EnvironOptions;
import oracle.ide.config.Preferences;
import oracle.ide.controller.ContextMenu;
import oracle.ide.controller.ContextMenuListener;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.controller.MenuConstants;
import oracle.ide.controls.JAutoScrollPane;
import oracle.ide.controls.MenuToolButton;
import oracle.ide.controls.ToggleAction;
import oracle.ide.controls.Toolbar;
import oracle.ide.controls.WaitCursor;
import oracle.ide.controls.WrappingTextPane;
import oracle.ide.dialogs.DialogUtil;
import oracle.ide.help.HelpInfo;
import oracle.ide.help.HelpSystem;
import oracle.ide.keyboard.KeyUtil;
import oracle.ide.layout.ViewId;
import oracle.ide.log.AbstractLogManager;
import oracle.ide.log.AbstractLogPage;
import oracle.ide.log.Href;
import oracle.ide.log.LogManager;
import oracle.ide.log.StyledMessage;
import oracle.ide.model.UpdateMessage;
import oracle.ide.net.DefaultURLFilter;
import oracle.ide.net.URLChooser;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.ide.net.URLFilter;
import oracle.ide.print.api.PrintProvider;
import oracle.ide.resource.EnvironOptionsArb;
import oracle.ide.resource.IdeArb;
import oracle.ide.resource.LogArb;
import oracle.ide.util.IdeUtil;
import oracle.javatools.dialogs.MessageDialog;
import oracle.javatools.ui.search.MiniSearchDialog;
import oracle.javatools.ui.search.SearchEvent;
import oracle.javatools.ui.search.SearchField;
import oracle.javatools.ui.search.SearchListener;
import oracle.javatools.ui.search.TextComponentSearchSupport;
import oracle.javatools.util.ModelUtil;

public class MessagePage
extends AbstractLogPage {
    public static final String MESSAGE_PAGE_ID = "MessagePage";
    private static final SimpleDateFormat logDateFormat = new SimpleDateFormat("yyyyMMddHHmmss");
    private static final String NAME = LogArb.getString(2);
    private static URL _lastSaveToFileURL = null;
    private static final int WRAP_LOG_LINE_CMD_ID = Ide.findOrCreateCmdID("WRAP_LOG_LINE_CMD_ID");
    private static final char EOL = '\n';
    private static final int FREEZE_AUTOSCROLL_CMD_ID = Ide.findOrCreateCmdID("FREEZE_LOG_AUTOSCROLL_CMD_ID");
    private static final Object CLEAR = new Object();
    protected JTextComponent _textComponent;
    private JTextComponent _component;
    private int _lineCount;
    private int _deletedLines;
    protected JAutoScrollPane _scrollPane;
    private JScrollPane _privateScrollPane;
    private Timer _timer;
    private Controller _baseController;
    private PrintStream _diskLogFile;
    private String _diskLogFileName;
    private TextComponentSearchSupport searchSupport;
    private JPanel guiPanel;
    private Toolbar toolbar;
    private SearchField toolbarSearchField;
    private MenuToolButton actionButton;
    private AncestorListener ghostListener;
    private IdeAction autoScrollAction;
    private IdeAction wrapAction;
    private Boolean headlessOverride;
    private boolean unitTestMode;
    private TimerListener _timerListener;
    private StringBuffer _currentBuffer = new StringBuffer();
    private int _clearOffset = -1;
    private String _toAppend = null;
    private int _toClear = -1;
    private List _styles = new ArrayList();
    private List _hrefs = new ArrayList();
    private static Comparator _styleComparator = new Comparator(){

        public int compare(Object o1, Object o2) {
            return this.getSortValue(o1) - this.getSortValue(o2);
        }

        private int getSortValue(Object o) {
            if (o instanceof StyledMessage) {
                return ((StyledMessage)o).getStartOffset();
            }
            if (o instanceof Integer) {
                return (Integer)o;
            }
            return 0;
        }
    };
    private Map _hrefsToHyperlink = new HashMap();

    public MessagePage() {
        this(new ViewId(MESSAGE_PAGE_ID, NAME));
    }

    protected MessagePage(ViewId viewId) {
        this(viewId, null);
    }

    protected MessagePage(ViewId viewId, Icon icon) {
        this(viewId, icon, true);
    }

    public MessagePage(ViewId viewId, Icon icon, boolean addPage) {
        this(viewId, icon, addPage, true);
    }

    protected MessagePage(ViewId viewId, Icon icon, boolean addPage, boolean showStyledText) {
        super(viewId, icon, addPage);
        this._timerListener = new TimerListener();
        this._timer = new Timer(250, this._timerListener);
        this._timer.setRepeats(false);
        this._baseController = new MessagePaneBaseController();
        if (!this.isHeadless()) {
            this.createWrapAction();
            this.createFreezeAutoscrollAction();
        }
    }

    public void addListener(MessagePageListener l) {
        this._timerListener.addListener(l);
    }

    private IdeAction createWrapAction() {
        if (this.wrapAction == null) {
            this.wrapAction = IdeAction.get(WRAP_LOG_LINE_CMD_ID, null, StringUtils.stripMnemonic((String)LogArb.getString(26)), null, StringUtils.getMnemonicKeyCode((String)LogArb.getString(26)), null, null, true);
            this.wrapAction = this.wrapAction.newLocalAction(this);
            this.wrapAction.putValue("Check", Boolean.TRUE);
        }
        return this.wrapAction;
    }

    private IdeAction createFreezeAutoscrollAction() {
        if (this.autoScrollAction == null) {
            this.autoScrollAction = IdeAction.get(FREEZE_AUTOSCROLL_CMD_ID, null, LogArb.getString(37), null, StringUtils.getMnemonicKeyCode((String)LogArb.getString(37)), null, null, true);
            this.autoScrollAction = this.autoScrollAction.newLocalAction(this);
            this.autoScrollAction.putValue("Check", Boolean.TRUE);
        }
        return this.autoScrollAction;
    }

    public final MenuToolButton getActionButton() {
        return this.actionButton;
    }

    private void showFindDialog(Context context) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                MiniSearchDialog dlg = MessagePage.this.searchSupport.getMiniSearchDialog();
                final JPanel basePanel = dlg.getBasePanel();
                final boolean beforeSearchAutoscrollState = MessagePage.this.getDisableAutoScrolling();
                MessagePage.this.ghostListener = new AncestorListener(){

                    @Override
                    public void ancestorAdded(AncestorEvent event) {
                    }

                    @Override
                    public void ancestorRemoved(AncestorEvent event) {
                        MessagePage.this.setDisableAutoScrolling(beforeSearchAutoscrollState);
                        basePanel.removeAncestorListener(MessagePage.this.ghostListener);
                        MessagePage.this.ghostListener = null;
                    }

                    @Override
                    public void ancestorMoved(AncestorEvent event) {
                    }
                };
                MessagePage.this.searchSupport.setSearchForwardsTitle(LogArb.format(35, MessagePage.this.getTitleName()));
                MessagePage.this.searchSupport.showSearchPrompt();
                MessagePage.this.setDisableAutoScrolling(false);
                basePanel.addAncestorListener(MessagePage.this.ghostListener);
            }
        });
    }

    private void saveToFile(Context context) {
        URL url;
        String title = LogArb.getString(13);
        URLChooser chooser = DialogUtil.newURLChooser(context);
        chooser.setHelpID("f1_idedsaveasrename_html");
        chooser.clearChooseableURLFilters();
        DefaultURLFilter filter = new DefaultURLFilter(IdeArb.getString(535), ".txt");
        chooser.addChooseableURLFilter((URLFilter)filter);
        chooser.setURLFilter((URLFilter)filter);
        if (_lastSaveToFileURL != null) {
            chooser.setSelectedURL(_lastSaveToFileURL);
        } else {
            String userHomeDir = Ide.getTrueUserHomeDirectory();
            if (ModelUtil.hasLength((String)userHomeDir)) {
                chooser.setSelectedURL(URLFactory.newFileURL((String)(userHomeDir + IdeArb.getString(536))));
            }
        }
        if (chooser.showSaveDialog((Component)((Object)Ide.getMainWindow()), title) == 0 && (url = chooser.getSelectedURL()) != null) {
            _lastSaveToFileURL = url;
            WaitCursor wc = Ide.getWaitCursor();
            wc.show();
            try {
                String encoding = EnvironOptions.getInstance(Preferences.getPreferences()).getEncoding();
                OutputStream os = URLFileSystem.openOutputStream((URL)url);
                PrintStream ps = encoding == null ? new PrintStream(os) : new PrintStream(os, false, encoding);
                int start = this._component.getSelectionStart();
                int end = this._component.getSelectionEnd();
                if (end - start > 0) {
                    String str = this._component.getText(start, end - start);
                    ps.print(str);
                } else {
                    ps.print(this._component.getText());
                }
                ps.flush();
                ps.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            wc.hide();
        }
    }

    @Override
    public ContextMenu getContextMenu() {
        ContextMenu cm = LogManager.getLogManager().getContextMenu();
        return cm;
    }

    private void openLogFile() {
        String realName = this._diskLogFileName + "_" + logDateFormat.format(new Date()) + ".log";
        try {
            if (this._diskLogFile != null) {
                this._diskLogFile.close();
            }
            String encoding = EnvironOptions.getInstance(Preferences.getPreferences()).getEncoding();
            OutputStream os = URLFileSystem.openOutputStream((URL)URLFactory.newFileURL((String)realName));
            this._diskLogFile = encoding == null ? new PrintStream(os) : new PrintStream(os, false, encoding);
        }
        catch (IOException e) {
            this._diskLogFileName = null;
            MessageDialog.error((Component)((Object)Ide.getMainWindow()), (Object)EnvironOptionsArb.format(31, realName), (String)EnvironOptionsArb.getString(30), null);
        }
    }

    private void closeLogFile() {
        if (this._diskLogFile != null) {
            this._diskLogFile.close();
        }
        this._diskLogFile = null;
    }

    protected boolean checkLogOpen() {
        if (this._diskLogFileName == null) {
            return false;
        }
        if (this._diskLogFile == null) {
            this.openLogFile();
        }
        return this._diskLogFileName != null;
    }

    protected void setLogFileName(String fn) {
        if (!fn.equals(this._diskLogFileName)) {
            this.closeLogFile();
        }
        this._diskLogFileName = fn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clearAll() {
        MessagePage messagePage = this;
        synchronized (messagePage) {
            if (this._privateScrollPane == null) {
                return;
            }
            this.logMsg(CLEAR);
        }
    }

    @Override
    public void addMouseListener(MouseListener listener) {
        if (!this.isHeadless()) {
            this.getGUI();
            if (this._component != null) {
                this._component.addMouseListener(listener);
            }
        }
    }

    @Override
    public void removeMouseListener(MouseListener listener) {
        if (this._component != null) {
            this._component.removeMouseListener(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Component getGUI() {
        MessagePage messagePage = this;
        synchronized (messagePage) {
            if (!this.isHeadless() && this.guiPanel == null) {
                this.guiPanel = new JPanel(new BorderLayout());
                if (!this.unitTestMode) {
                    this.createToolbar();
                }
                this.createTextComponent();
                this._scrollPane = new JAutoScrollPane(this._component);
                this._privateScrollPane = this._scrollPane;
                this._privateScrollPane.setBorder(BorderFactory.createEmptyBorder());
                this._privateScrollPane.setOpaque(false);
                this._privateScrollPane.getViewport().setOpaque(false);
                this.guiPanel.add((Component)this._privateScrollPane, "Center");
                if (!this.unitTestMode) {
                    ContextMenu cm = LogManager.getLogManager().getContextMenu();
                    cm.addContextMenuListener(new ContextMenuListener(){

                        @Override
                        public void menuWillShow(ContextMenu popup) {
                            Context ctxt;
                            if (popup != null && (ctxt = popup.getContext()) != null && ctxt.getView() == MessagePage.this) {
                                IdeAction action = IdeAction.find(18);
                                action.addController(MessagePage.this.getController());
                                JMenuItem copyMenu = popup.createMenuItem(action, MenuConstants.WEIGHT_EDIT_COPY);
                                action = IdeAction.find(22);
                                action.addController(MessagePage.this.getController());
                                JMenuItem selectAllMenu = popup.createMenuItem(action, MenuConstants.WEIGHT_EDIT_SELECT_ALL);
                                action = MessagePage.this.createWrapAction();
                                JMenuItem wrapLines = popup.createMenuItem(action, 1.0f);
                                action = MessagePage.this.createFreezeAutoscrollAction();
                                action.setState(!MessagePage.this.getDisableAutoScrolling());
                                JMenuItem freezeAutoScrolling = popup.createMenuItem(action, MenuConstants.increment(1.0f));
                                action = IdeAction.find(12);
                                action.addController(MessagePage.this.getController());
                                JMenuItem saveAsMenu = popup.createMenuItem(action, MenuConstants.WEIGHT_LOG_WINDOW_SAVE_AS);
                                action = IdeAction.find(23);
                                action.addController(MessagePage.this.getController());
                                JMenuItem findMenu = popup.createMenuItem(action, 1.0f);
                                popup.add((Component)copyMenu, MenuConstants.SECTION_EDIT_CTXT_MENU);
                                popup.add((Component)selectAllMenu, MenuConstants.SECTION_EDIT_CTXT_MENU);
                                popup.add((Component)wrapLines, MenuConstants.SECTION_LOG_WINDOW_CTXT_MENU);
                                popup.add((Component)freezeAutoScrolling, MenuConstants.SECTION_LOG_WINDOW_CTXT_MENU);
                                popup.add((Component)saveAsMenu, MenuConstants.SECTION_LOG_WINDOW_CTXT_MENU);
                                popup.add((Component)findMenu, MenuConstants.SECTION_LOG_WINDOW_CTXT_MENU);
                            }
                        }

                        @Override
                        public void menuWillHide(ContextMenu popup) {
                            IdeAction action = IdeAction.find(18);
                            action.removeController(MessagePage.this.getController());
                            action = IdeAction.find(22);
                            action.removeController(MessagePage.this.getController());
                            action = IdeAction.find(12);
                            action.removeController(MessagePage.this.getController());
                            action = IdeAction.find(23);
                            action.removeController(MessagePage.this.getController());
                        }

                        @Override
                        public boolean handleDefaultAction(Context context) {
                            return false;
                        }
                    });
                }
            }
            return this.guiPanel;
        }
    }

    protected void createToolbar() {
        this.toolbar = new Toolbar();
        this.toolbar.setVisible(false);
        this.toolbarSearchField = new SearchField();
        this.toolbarSearchField.setMaximumSize(new Dimension(400, 20));
        this.toolbarSearchField.setPreferredSize(new Dimension(230, this.toolbarSearchField.getPreferredSize().height - 3));
        this.toolbarSearchField.setStyle(SearchField.Style.FIND);
        this.toolbarSearchField.setAutoFind(true);
        this.toolbarSearchField.addSearchListener(new SearchListener(){

            public void searchPerformed(SearchEvent se) {
                MessagePage.this.searchSupport.search(se.getDirection(), se.getSearchText());
            }

            public void searchCategoryChanged(SearchEvent se) {
            }
        });
        this.toolbar.add((Component)this.toolbarSearchField);
        this.toolbar.setPrimaryViewToolbar(true);
        this.toolbarSearchField.getTextField().addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
            }

            @Override
            public void focusLost(FocusEvent e) {
                MessagePage.this.searchSupport.clearHighlighting();
            }
        });
        ToggleAction menuAction = new ToggleAction("Actions", null){

            @Override
            public void actionPerformed(ActionEvent e) {
                MessagePage.this.activate();
            }
        };
        this.actionButton = new MenuToolButton(menuAction);
        String buttonText = LogArb.getString(36);
        this.actionButton.setText(buttonText);
        this.actionButton.setToolTipText(buttonText);
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                MessagePage.this.actionButton.addPopupItem(MessagePage.this.createLocalAction(IdeAction.find(18)));
                MessagePage.this.actionButton.addPopupItem(MessagePage.this.createLocalAction(IdeAction.find(22)));
                MessagePage.this.actionButton.getPopupMenu().addSeparator();
                MessagePage.this.actionButton.addPopupItem(MessagePage.this.createWrapAction());
                MessagePage.this.actionButton.addPopupItem(MessagePage.this.createFreezeAutoscrollAction());
                IdeAction clearAction = IdeAction.find(AbstractLogManager.CLEAR_LOG_CMD_ID);
                if (clearAction != null) {
                    MessagePage.this.actionButton.addPopupItem(clearAction);
                }
                MessagePage.this.actionButton.addPopupItem(MessagePage.this.createLocalAction(IdeAction.find(12)));
            }
        };
        if (SwingUtilities.isEventDispatchThread()) {
            runnable.run();
        } else {
            SwingUtilities.invokeLater(runnable);
        }
        this.actionButton.addPopupMenuListener(new PopupMenuListener(){

            @Override
            public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
                MessagePage.this.activate();
            }

            @Override
            public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
            }

            @Override
            public void popupMenuCanceled(PopupMenuEvent e) {
            }
        });
        final Component filler = Box.createHorizontalGlue();
        this.toolbar.add(filler);
        this.toolbar.add(this.actionButton);
        this.toolbar.addContainerListener(new ContainerListener(){
            private boolean adjusting = false;

            @Override
            public void componentAdded(ContainerEvent e) {
                if (this.adjusting) {
                    return;
                }
                this.adjusting = true;
                try {
                    int i = MessagePage.this.toolbar.getComponentCount();
                    if (MessagePage.this.toolbar.getComponentAtIndex(i - 2) != filler) {
                        MessagePage.this.toolbar.remove(filler);
                        MessagePage.this.toolbar.remove(MessagePage.this.actionButton);
                        MessagePage.this.toolbar.add(filler);
                        MessagePage.this.toolbar.add(MessagePage.this.actionButton);
                    }
                }
                finally {
                    this.adjusting = false;
                }
            }

            @Override
            public void componentRemoved(ContainerEvent e) {
            }
        });
    }

    private IdeAction createLocalAction(IdeAction a) {
        return a.newLocalAction(this);
    }

    @Override
    public HelpInfo getHelpInfo() {
        return new HelpInfo("f1_idelogwindowgen_html");
    }

    @Override
    public Controller getController() {
        return this._baseController;
    }

    public void setController(Controller controller) {
        this._baseController = controller;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void logMsg(Object msg) {
        MessagePage messagePage = this;
        synchronized (messagePage) {
            this.getGUI();
            if (msg == CLEAR) {
                this._clearOffset = this._currentBuffer.length();
            } else {
                if (msg instanceof StyledMessage) {
                    StyledMessage styledMessage = (StyledMessage)msg;
                    int startOffset = this.getTextLength();
                    styledMessage.setStartOffset(startOffset);
                    this.addStyle(styledMessage);
                    msg = styledMessage.getText();
                    styledMessage.clearText();
                }
                this._currentBuffer.append(msg);
            }
        }
        if (!this._timer.isRunning()) {
            this._timer.start();
        }
    }

    private void createTextComponent() {
        final CustomTextPane textPane = this.createStyledTextPane();
        textPane.setDocument(new DefaultStyledDocument());
        textPane.setEditable(false);
        textPane.setLineWrap(EnvironOptions.getInstance(Preferences.getPreferences()).isWrapLogLines());
        MouseInputAdapter mouseInputListener = new MouseInputAdapter(){

            @Override
            public void mouseMoved(MouseEvent e) {
                Href href = null;
                try {
                    int offset = textPane.getUI().viewToModel(textPane, e.getPoint());
                    href = MessagePage.this.findHrefByOffset(offset);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (href != null) {
                    textPane.setCursor(href.getCursor());
                } else {
                    textPane.setCursor(null);
                }
            }

            @Override
            public void mouseClicked(MouseEvent e) {
                try {
                    int offset;
                    Href href;
                    if ((e.getModifiers() & 0x10) != 0 && e.getClickCount() == 1 && (href = MessagePage.this.findHrefByOffset(offset = textPane.getUI().viewToModel(textPane, e.getPoint()))) != null) {
                        href.go();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        };
        textPane.addMouseListener(mouseInputListener);
        textPane.addMouseMotionListener(mouseInputListener);
        this._textComponent = this._component = textPane;
        KeyUtil.removeCtrlTabFromTraversalKeys(this._component);
        this._component.setToolTipText(this.getToolTip());
        Font oldFont = new JTextArea().getFont();
        this._component.setFont(new Font("DialogInput", oldFont.getStyle(), oldFont.getSize()));
        if (!this.unitTestMode) {
            this.searchSupport = new TextComponentSearchSupport(this._component);
            HelpSystem hsys = HelpSystem.getHelpSystem();
            if (hsys != null) {
                hsys.registerTopic(this.searchSupport.getMiniSearchDialog().getBasePanel(), "f1_idedsearchmessages_html");
            }
        }
    }

    protected CustomTextPane createStyledTextPane() {
        CustomTextPane customTextPane = new CustomTextPane();
        customTextPane.putClientProperty("print.name", this.getTabName());
        return customTextPane;
    }

    protected void updateToolTipText() {
        this._component.setToolTipText(this.getToolTip());
    }

    protected boolean getDisableAutoScrolling() {
        JAutoScrollPane autoscrollPane = MessagePage.getJAutoScrollPane(this._component);
        if (autoscrollPane != null) {
            return autoscrollPane.isAutoScrollDisabled();
        }
        return false;
    }

    protected boolean getWrapLines() {
        WrappingTextPane textPane = (WrappingTextPane)this._component;
        return textPane.getLineWrap();
    }

    protected void setDisableAutoScrolling(boolean autoscroll) {
        JAutoScrollPane autoscrollPane = MessagePage.getJAutoScrollPane(this._component);
        if (autoscrollPane != null) {
            autoscrollPane.setAutoScrollDisabled(autoscroll);
        }
    }

    protected void setWrapLines(boolean wrap) {
        WrappingTextPane textPane = (WrappingTextPane)this._component;
        textPane.setLineWrap(wrap);
        EnvironOptions.getInstance(Preferences.getPreferences()).setWrapLogLines(wrap);
    }

    protected final String getText() {
        try {
            Document document = this._component.getDocument();
            int documentLength = document.getLength();
            return document.getText(0, documentLength);
        }
        catch (BadLocationException badLocationException) {
            return this._component.getText();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void appendToTextComponent(String msg, int maxLogLines) {
        if (msg == null) {
            return;
        }
        if (!this.isHeadless()) {
            String text;
            MessagePage messagePage = this;
            synchronized (messagePage) {
                WrappingTextPane textPane = (WrappingTextPane)this._component;
                Document document = textPane.getDocument();
                int oldDocumentLength = document.getLength();
                try {
                    document.insertString(oldDocumentLength, msg, null);
                }
                catch (BadLocationException badLocationException) {
                    // empty catch block
                }
                if (msg.length() > 0) {
                    if (oldDocumentLength == 0) {
                        ++this._lineCount;
                    }
                    int eol = msg.indexOf(10);
                    while (eol != -1) {
                        ++this._lineCount;
                        eol = msg.indexOf(10, eol + 1);
                    }
                }
                int newDocumentLength = document.getLength();
                this.setRecentAttributes(oldDocumentLength, newDocumentLength);
                if (this._lineCount > maxLogLines) {
                    int linesToDelete = this._lineCount - maxLogLines;
                    String text2 = this.getText();
                    int length = text2.length();
                    int offset = 0;
                    for (int count = 0; count < linesToDelete; ++count) {
                        if ((offset = text2.indexOf(10, offset + 1)) != -1) continue;
                        offset = length;
                        break;
                    }
                    this.deleteFromStartOfTextComponent(linesToDelete, ++offset);
                }
            }
            if (!msg.endsWith("\n")) {
                text = this.getText();
                int caret = text.lastIndexOf(10) + 1;
                this._component.setCaretPosition(caret);
            } else {
                text = this.getText();
                int caret = text.length();
                this._component.setCaretPosition(caret);
            }
        }
    }

    protected void deleteFromStartOfTextComponent(int linesToDelete, int offset) {
        WrappingTextPane textPane = (WrappingTextPane)this._component;
        try {
            Document document = textPane.getDocument();
            document.remove(0, offset);
            this._lineCount -= linesToDelete;
            this._deletedLines += linesToDelete;
            if (this._deletedLines > 5000) {
                this.replaceTextComponentDocument();
            }
        }
        catch (Exception document) {
            // empty catch block
        }
        JScrollBar sb = this._privateScrollPane.getVerticalScrollBar();
        sb.setValue(sb.getMaximum());
        String text = this.getText();
        int caret = text.lastIndexOf(10) + 1;
        this._component.setCaretPosition(caret);
        this.adjustStyleOffsets(offset);
    }

    protected void replaceTextComponentDocument() {
        String text = this.getText();
        DefaultStyledDocument document = new DefaultStyledDocument();
        this._component.setDocument(document);
        this._component.setText(text);
        this.replaceAttributes();
        this._deletedLines = 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void clearTextComponent() {
        MessagePage messagePage = this;
        synchronized (messagePage) {
            int offset = this._component.getDocument().getLength() + this._toClear;
            this._component.setText("");
            this._component.setCaretPosition(0);
            this._lineCount = 0;
            this.clearAttributes(offset);
        }
    }

    public void addHref(Href href) {
        this.addStyle(href);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addStyle(StyledMessage styledMessage) {
        MessagePage messagePage = this;
        synchronized (messagePage) {
            StyledMessage smBefore;
            int stBeforeEnd;
            int start = styledMessage.getStartOffset();
            int end = styledMessage.getEndOffset();
            int i = Collections.binarySearch(this._styles, styledMessage, _styleComparator);
            if (i < 0) {
                i = -i - 1;
            }
            if (i > 0 && (stBeforeEnd = (smBefore = (StyledMessage)this._styles.get(i - 1)).getEndOffset()) > start) {
                smBefore.setEndOffset(start);
                if (stBeforeEnd > end) {
                    this._styles.add(i, new StyledMessage(smBefore.getAttributes(), end, stBeforeEnd));
                }
            }
            while (i < this._styles.size() - 1) {
                boolean styleRemoved = false;
                StyledMessage smAtPoint = (StyledMessage)this._styles.get(i);
                int stAtPointStart = smAtPoint.getStartOffset();
                int stAtPointEnd = smAtPoint.getEndOffset();
                if (end > stAtPointStart) {
                    if (end >= stAtPointEnd) {
                        this._styles.remove(i);
                        if (smAtPoint instanceof Href) {
                            this.removeHref((Href)smAtPoint);
                        }
                        styleRemoved = true;
                    } else {
                        smAtPoint.setStartOffset(end);
                        smAtPoint.setEndOffset(stAtPointEnd);
                    }
                }
                if (styleRemoved) continue;
                break;
            }
            this._styles.add(i, styledMessage);
            if (styledMessage instanceof Href) {
                i = Collections.binarySearch(this._hrefs, styledMessage, _styleComparator);
                if (i < 0) {
                    i = -i - 1;
                }
                this._hrefs.add(i, styledMessage);
            }
            this.setAttributes(styledMessage);
        }
    }

    private static JAutoScrollPane getJAutoScrollPane(Component comp) {
        Component c;
        for (c = comp; c != null && !(c instanceof JAutoScrollPane); c = c.getParent()) {
        }
        if (c instanceof JAutoScrollPane) {
            return (JAutoScrollPane)c;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setRecentAttributes(int oldDocumentLength, int newDocumentLength) {
        MessagePage messagePage = this;
        synchronized (messagePage) {
            for (int i = this._styles.size() - 1; i >= 0; --i) {
                StyledMessage styledMessage = (StyledMessage)this._styles.get(i);
                if (styledMessage.getStartOffset() >= newDocumentLength) continue;
                if (styledMessage.getEndOffset() <= oldDocumentLength) break;
                this.setAttributes(styledMessage);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setUnitTestMode(boolean unitTesting) {
        MessagePage messagePage = this;
        synchronized (messagePage) {
            this.unitTestMode = unitTesting;
            if (unitTesting) {
                this.headlessOverride = Boolean.FALSE;
            }
        }
    }

    private boolean isHeadless() {
        if (this.headlessOverride != null) {
            return this.headlessOverride;
        }
        try {
            return IdeUtil.isHeadless();
        }
        catch (Exception ex) {
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void adjustStyleOffsets(int offset) {
        MessagePage messagePage = this;
        synchronized (messagePage) {
            for (int i = this._styles.size() - 1; i >= 0; --i) {
                StyledMessage styledMessage = (StyledMessage)this._styles.get(i);
                if (styledMessage.getStartOffset() >= offset) {
                    styledMessage.updateOffsets(-offset);
                    continue;
                }
                this._styles.remove(i);
                if (!(styledMessage instanceof Href)) continue;
                this.removeHref((Href)styledMessage);
            }
        }
    }

    private void removeHref(Href href) {
        this._hrefs.remove(href);
        Hyperlink hyperlink = (Hyperlink)this._hrefsToHyperlink.remove(href);
        if (hyperlink != null) {
            hyperlink.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void replaceAttributes() {
        MessagePage messagePage = this;
        synchronized (messagePage) {
            this.replaceAttributes(this._styles);
        }
    }

    private void replaceAttributes(List list) {
        for (int i = list.size() - 1; i >= 0; --i) {
            StyledMessage styledMessage = (StyledMessage)list.get(i);
            this.setAttributes(styledMessage);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clearAttributes(int offset) {
        MessagePage messagePage = this;
        synchronized (messagePage) {
            this.adjustStyleOffsets(offset);
        }
    }

    private void setAttributes(StyledMessage styledMessage) {
        Document document = this._component.getDocument();
        if (document instanceof StyledDocument) {
            int docLength = document.getLength();
            int start = styledMessage.getStartOffset();
            if (start < docLength) {
                AttributeSet attributeSet;
                int end = styledMessage.getEndOffset();
                if (end > docLength) {
                    end = docLength;
                }
                if ((attributeSet = styledMessage.getAttributes()) != null) {
                    StyledDocument styledDocument = (StyledDocument)document;
                    styledDocument.setCharacterAttributes(start, end - start, attributeSet, true);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Href findHrefByOffset(int offset) {
        MessagePage messagePage = this;
        synchronized (messagePage) {
            Href href;
            int i = Collections.binarySearch(this._hrefs, offset, _styleComparator);
            if (i < 0) {
                i = -i - 1;
            }
            if (i > 0 && offset >= (href = (Href)this._hrefs.get(i - 1)).getStartOffset() && offset < href.getEndOffset()) {
                return href;
            }
            if (i < this._hrefs.size() && offset >= (href = (Href)this._hrefs.get(i)).getStartOffset() && offset < href.getEndOffset()) {
                return href;
            }
        }
        return null;
    }

    @Override
    public Toolbar getToolbar() {
        return this.toolbar;
    }

    @Override
    public void setToolbarVisible(boolean visible) {
        this.toolbar.setVisible(visible);
    }

    @Override
    public void updateVisibleActions(UpdateMessage updateMessage) {
        super.updateVisibleActions(updateMessage);
        MessagePage.updateToolbarActions(this.toolbar);
    }

    public SearchField getToolbarSearchField() {
        return this.toolbarSearchField;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getTextLength() {
        MessagePage messagePage = this;
        synchronized (messagePage) {
            int length = this._component.getDocument().getLength();
            if (this._toAppend != null) {
                length += this._toAppend.length();
            }
            return length += this._currentBuffer.length();
        }
    }

    public static interface MessagePageListener {
        public void fireMessagePageChange(MessagePageEvent var1);
    }

    public static class MessagePageEvent {
        private String _prependText;
        private String _postpendText;
        private boolean _clear;

        public MessagePageEvent(String prependText, String postpendText, boolean clear) {
            this._prependText = prependText;
            this._postpendText = postpendText;
            this._clear = clear;
        }

        public String getPrependText() {
            return this._prependText;
        }

        public String getPostpendText() {
            return this._postpendText;
        }

        public boolean isClearing() {
            return this._clear;
        }
    }

    protected class CustomTextPane
    extends WrappingTextPane
    implements PrintProvider.Text {
        private AccessibleContextWithHypertext a = null;

        protected CustomTextPane() {
        }

        @Override
        public void scrollRectToVisible(Rectangle aRect) {
            JAutoScrollPane jautoScrollPane = MessagePage.getJAutoScrollPane(this);
            if (jautoScrollPane == null || !jautoScrollPane.isAutoScrollDisabled()) {
                super.scrollRectToVisible(aRect);
            }
        }

        @Override
        public AccessibleContext getAccessibleContext() {
            if (this.a == null) {
                this.a = new AccessibleContextWithHypertext();
            }
            return this.a;
        }

        class AccessibleContextWithHypertext
        extends JEditorPane.AccessibleJEditorPane
        implements AccessibleHypertext {
            AccessibleContextWithHypertext() {
                super(CustomTextPane.this);
            }

            @Override
            public AccessibleText getAccessibleText() {
                return this;
            }

            @Override
            public int getLinkCount() {
                return MessagePage.this._hrefs.size();
            }

            @Override
            public AccessibleHyperlink getLink(int linkIndex) {
                Href href = (Href)MessagePage.this._hrefs.get(linkIndex);
                if (href != null) {
                    AccessibleHyperlink accessibleHyperlink = (AccessibleHyperlink)MessagePage.this._hrefsToHyperlink.get(href);
                    if (accessibleHyperlink == null) {
                        accessibleHyperlink = new Hyperlink(href);
                        MessagePage.this._hrefsToHyperlink.put(href, accessibleHyperlink);
                    }
                    return accessibleHyperlink;
                }
                return null;
            }

            @Override
            public int getLinkIndex(int charIndex) {
                Href href = MessagePage.this.findHrefByOffset(charIndex);
                if (href != null) {
                    return MessagePage.this._hrefs.indexOf(href);
                }
                return -1;
            }
        }
    }

    private class TimerListener
    implements ActionListener,
    Runnable {
        private MessagePageListener _listener;

        private TimerListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void actionPerformed(ActionEvent e) {
            MessagePage messagePage = MessagePage.this;
            synchronized (messagePage) {
                if (MessagePage.this._currentBuffer.length() != 0) {
                    MessagePage.this._toAppend = MessagePage.this._currentBuffer.toString();
                    if (MessagePage.this._currentBuffer.capacity() > 1024) {
                        MessagePage.this._currentBuffer = new StringBuffer(1024);
                    } else {
                        MessagePage.this._currentBuffer.delete(0, Integer.MAX_VALUE);
                    }
                }
                MessagePage.this._toClear = MessagePage.this._clearOffset;
                MessagePage.this._clearOffset = -1;
                if (MessagePage.this._toAppend != null || MessagePage.this._toClear != -1) {
                    SwingUtilities.invokeLater(this);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            MessagePage messagePage = MessagePage.this;
            synchronized (messagePage) {
                if (!MessagePage.this.isHeadless()) {
                    boolean cleared;
                    MessagePage.this.getGUI();
                    String prepend = null;
                    String postpend = null;
                    if (MessagePage.this._toAppend != null) {
                        if (MessagePage.this._toClear == -1) {
                            prepend = MessagePage.this._toAppend;
                        } else {
                            prepend = MessagePage.this._toAppend.length() == 0 ? null : MessagePage.this._toAppend.substring(0, MessagePage.this._toClear);
                            postpend = MessagePage.this._toAppend.length() < MessagePage.this._toClear ? null : MessagePage.this._toAppend.substring(MessagePage.this._toClear);
                        }
                    }
                    this.writeToFile(prepend);
                    if (MessagePage.this._toClear == -1) {
                        this.writeToDisplay(prepend);
                    }
                    boolean bl = cleared = MessagePage.this._toClear != -1;
                    if (cleared) {
                        MessagePage.this.closeLogFile();
                        MessagePage.this.clearTextComponent();
                        MessagePage.this._toClear = -1;
                    }
                    if (postpend != null) {
                        this.writeToFile(postpend);
                        this.writeToDisplay(postpend);
                    }
                    if (this._listener != null) {
                        this._listener.fireMessagePageChange(new MessagePageEvent(prepend, postpend, cleared));
                    }
                } else {
                    System.out.println(MessagePage.this._toAppend);
                }
                MessagePage.this._toAppend = null;
            }
        }

        private void addListener(MessagePageListener l) {
            this._listener = l;
        }

        private void writeToFile(String text) {
            if (MessagePage.this.checkLogOpen() && text != null) {
                MessagePage.this._diskLogFile.print(text);
            }
        }

        private void writeToDisplay(String text) {
            if (text != null) {
                MessagePage.this.appendToTextComponent(text, EnvironOptions.getInstance(Preferences.getPreferences()).getMaxLogLines());
            }
        }
    }

    private static class Hyperlink
    extends AccessibleHyperlink {
        private Href _href;

        Hyperlink(Href href) {
            this._href = href;
        }

        void clear() {
            this._href = null;
        }

        @Override
        public boolean isValid() {
            return this._href != null;
        }

        @Override
        public int getAccessibleActionCount() {
            if (this._href != null) {
                return 1;
            }
            return 0;
        }

        @Override
        public boolean doAccessibleAction(int i) {
            if (this._href != null && i == 0) {
                this._href.go();
                return true;
            }
            return false;
        }

        @Override
        public String getAccessibleActionDescription(int i) {
            if (this._href != null && i == 0) {
                return this._href.getText();
            }
            return null;
        }

        @Override
        public Object getAccessibleActionObject(int i) {
            if (this._href != null && i == 0) {
                return this._href.getURL();
            }
            return null;
        }

        @Override
        public Object getAccessibleActionAnchor(int i) {
            if (this._href != null && i == 0) {
                return this._href.getText();
            }
            return null;
        }

        @Override
        public int getStartIndex() {
            if (this._href != null) {
                return this._href.getStartOffset();
            }
            return 0;
        }

        @Override
        public int getEndIndex() {
            if (this._href != null) {
                return this._href.getEndOffset();
            }
            return 0;
        }
    }

    private class MessagePaneBaseController
    implements Controller {
        private MessagePaneBaseController() {
        }

        @Override
        public boolean handleEvent(IdeAction action, Context context) {
            int cmdId = action.getCommandId();
            if (cmdId == 18) {
                if (MessagePage.this._component != null) {
                    MessagePage.this._component.copy();
                }
            } else if (cmdId == 22) {
                if (MessagePage.this._component != null) {
                    Caret caret = MessagePage.this._component.getCaret();
                    caret.setSelectionVisible(true);
                    MessagePage.this._component.selectAll();
                    MessagePage.this._component.copy();
                }
            } else if (cmdId == 12) {
                MessagePage.this.saveToFile(context);
            } else if (cmdId == WRAP_LOG_LINE_CMD_ID) {
                MessagePage.this.setWrapLines(action.getState());
            } else if (cmdId == FREEZE_AUTOSCROLL_CMD_ID) {
                MessagePage.this.setDisableAutoScrolling(!action.getState());
            } else if (cmdId == 23) {
                Toolbar toolbar = MessagePage.this.getToolbar();
                SearchField sf = MessagePage.this.getToolbarSearchField();
                if (sf != null && sf.isVisible() && toolbar != null && toolbar.isVisible()) {
                    sf.requestFocus();
                } else {
                    MessagePage.this.showFindDialog(context);
                }
            } else {
                return false;
            }
            return true;
        }

        @Override
        public boolean update(IdeAction action, Context context) {
            int cmdId = action.getCommandId();
            if (cmdId == 17) {
                action.setEnabled(false);
            } else if (cmdId == 18) {
                boolean enabled = false;
                if (MessagePage.this._component != null) {
                    enabled = MessagePage.this._component.getSelectionEnd() - MessagePage.this._component.getSelectionStart() > 0;
                }
                action.setEnabled(enabled);
            } else if (cmdId == 22 || cmdId == 12 || cmdId == 23) {
                boolean enabled = MessagePage.this._component != null && MessagePage.this._component.getDocument().getLength() > 0;
                action.setEnabled(enabled);
            } else if (cmdId == WRAP_LOG_LINE_CMD_ID) {
                action.setEnabled(true);
                action.setState(MessagePage.this.getWrapLines());
            } else if (cmdId == FREEZE_AUTOSCROLL_CMD_ID) {
                action.setEnabled(true);
                action.setState(!MessagePage.this.getDisableAutoScrolling());
            } else {
                return false;
            }
            return true;
        }
    }
}

