/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.layout;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.naming.Context;
import javax.swing.Icon;
import oracle.ide.Addin;
import oracle.ide.ExtensionRegistry;
import oracle.ide.Ide;
import oracle.ide.Version;
import oracle.ide.controls.Toolbar;
import oracle.ide.editor.Editor;
import oracle.ide.editor.EditorManager;
import oracle.ide.feedback.FeedbackManager;
import oracle.ide.layout.BaseLayoutListener;
import oracle.ide.layout.IdeLayout;
import oracle.ide.layout.Layout;
import oracle.ide.layout.LayoutActivator;
import oracle.ide.layout.LayoutListener;
import oracle.ide.layout.LayoutResetListener;
import oracle.ide.layout.LayoutSelector;
import oracle.ide.layout.SimpleLayout;
import oracle.ide.layout.ViewId;
import oracle.ide.model.Attributes;
import oracle.ide.model.DefaultAttributes;
import oracle.ide.model.Element;
import oracle.ide.model.Folder;
import oracle.ide.model.UpdateMessage;
import oracle.ide.net.DefaultNameGenerator;
import oracle.ide.net.NameGenerator;
import oracle.ide.net.URLFactory;
import oracle.ide.performance.PerformanceLogger;
import oracle.ide.resource.LayoutArb;
import oracle.ide.util.Assert;
import oracle.ide.util.ModelUtil;
import oracle.ide.view.View;
import oracle.javatools.jndi.Names;

public class Layouts
implements Folder,
Addin {
    public static final String DATA_KEY = "layout-options";
    public static final String LAYOUT_EXT = ".layout";
    private static final String DESIGN_LAYOUT_NAME = LayoutArb.getString(1);
    public static final String DESIGN_FILENAME_BASE = "Editing";
    public static final String DESIGN_FILENAME = "Editing.layout";
    private static final String LAYOUTS_NAME = "ide/layouts";
    private static String _basename = LayoutArb.getString(3);
    private static DefaultNameGenerator _nameGenerator = new DefaultNameGenerator(_basename, ".layout");
    private static URL _directoryURL;
    private HashMap<URL, Element> _layoutsMap = new HashMap();
    private IdeLayout _activeLayout;
    private IdeLayout _design;
    private boolean _useEditorPreferredLayout = true;
    private boolean _showLayoutActivator = true;
    private boolean _useActiveLayoutInEditor = true;
    private transient HashMap _startupListeners = new HashMap();
    private transient HashMap _listeners = new HashMap();
    private transient String _layoutsLabel;
    private transient LayoutActivator _layoutActivator;
    private final List<LayoutResetListener> layoutResetListeners = new CopyOnWriteArrayList<LayoutResetListener>();

    public static Layouts getLayouts() {
        return (Layouts)Names.lookup((Context)Names.newInitialContext(), (String)LAYOUTS_NAME);
    }

    public static void setLayouts(Layouts layouts) {
        Names.bind((Context)Names.newInitialContext(), (String)LAYOUTS_NAME, (Object)layouts);
    }

    public synchronized void addLayoutListener(String viewName, LayoutListener listener) {
        this._listeners.put(viewName, listener);
    }

    public synchronized void addStartupLayoutListener(String viewName, LayoutListener listener) {
        this._startupListeners.put(viewName, listener);
    }

    @Override
    public void initialize() {
        if (Version.DEBUG_BUILD == 1 && this.isShowLayoutActivator()) {
            Toolbar toolbar = Ide.getStatusBar().getToolbar();
            this._layoutActivator = new LayoutActivator(this);
            toolbar.addComponent(this._layoutActivator.getGUI(), 0);
        }
    }

    public IdeLayout getActiveLayout() {
        if (this._activeLayout == null) {
            this._activeLayout = this.getDesignLayout();
        }
        return this._activeLayout;
    }

    public Layout getActiveSubLayout() {
        return this.getActiveLayout().getActiveLayout();
    }

    public Layout getActive() {
        Layout active = this.getActiveSubLayout();
        return active == null ? this.getActiveLayout() : active;
    }

    public void activateLayout(IdeLayout layout) {
        if (this._activeLayout != null) {
            this.close(this._activeLayout);
        }
        this._activeLayout = layout;
        if (this._activeLayout != null) {
            this.activate(this._activeLayout, this._listeners);
            this._activeLayout.setActive(true);
            if (this._layoutActivator != null && this._layoutActivator.getLastActive() != layout) {
                this._layoutActivator.update();
            }
        }
    }

    public void activateLayout(IdeLayout layout, boolean startup) {
        if (startup) {
            this._activeLayout = layout;
            this.activate(this._activeLayout, this._listeners);
            this.activate(Ide.getIdeProperties(), this._startupListeners);
            this._activeLayout.setActive(true);
            if (this._layoutActivator != null) {
                this._layoutActivator.update();
            }
        } else {
            this.activateLayout(layout);
        }
    }

    public boolean isDesignActive() {
        return this.getActiveLayout() == this.getDesignLayout();
    }

    public void activatePreferredLayout(LayoutSelector selector) {
        Layout preferredLayout;
        if (!(this.isUseEditorPreferredLayout() && this.isDesignActive() && selector.isReady())) {
            return;
        }
        URL preferredLayoutURL = selector.getPreferredLayoutURL();
        if (preferredLayoutURL != null && (preferredLayout = this.getDesignLayout().findLayout(preferredLayoutURL)) != null && !preferredLayoutURL.equals(this.getDesignLayout().getActiveLayout().getURL())) {
            selector.initializeLayout(preferredLayout);
            this.activateLayout(preferredLayout);
            selector.initializeActiveLayout();
        }
    }

    public void activateLayout(Layout child) {
        if (child == null) {
            return;
        }
        IdeLayout owner = child.getOwner();
        if (owner == null) {
            Logger.getAnonymousLogger().log(Level.WARNING, "Owner object is null. Layout " + this);
            Thread.dumpStack();
            return;
        }
        if (!owner.isActive()) {
            owner.setActiveLayout(child);
            return;
        }
        if (this._activeLayout != null) {
            this.close(this._activeLayout);
        }
        owner.setActiveLayout(child);
        this._activeLayout = owner;
        this.activate(this._activeLayout, this._listeners);
        owner.setActive(true);
        if (this.isUseEditorPreferredLayout() && this.isUseActiveLayoutInEditor() && this.isDesignActive()) {
            this.updateEditorPreferredLayout(child);
        }
        if (this._layoutActivator != null && this._layoutActivator.getSelectedLayout() != child) {
            this._layoutActivator.setSelectedLayout(child);
        }
        this.applyMenuFilter(child);
    }

    private void applyMenuFilter(Layout child) {
        if (child == null) {
            return;
        }
        Ide.getMenubar().clearGlobalFilter();
        if (child.getMenuFilter() != null) {
            Ide.getMenubar().applyGlobalFilter(child.getMenuFilter());
        }
    }

    public void activateDefaultDesignLayout() {
        Layout defaultLayout = this.getDesignLayout().getDefaults();
        if (!defaultLayout.isActive()) {
            boolean temp = this.isUseActiveLayoutInEditor();
            this.setUseActiveLayoutInEditor(false);
            this.activateLayout(defaultLayout);
            this.setUseActiveLayoutInEditor(temp);
        }
    }

    public URL buildLayoutURL(String baseName) {
        URL parentURL = Layouts.getDirectoryURL();
        String filename = baseName + LAYOUT_EXT;
        return URLFactory.newURL((URL)parentURL, (String)filename);
    }

    public Layout newDesignLayout(URL url) {
        SimpleLayout layout = new SimpleLayout(url);
        IdeLayout owner = this.getDesignLayout();
        owner.add(layout);
        UpdateMessage.fireStructureChanged(owner);
        return layout;
    }

    public Layout newLayout(IdeLayout parent) {
        URL fileURL = this.generateLayoutURL();
        return this.newLayout(parent, fileURL);
    }

    public Layout newLayout(IdeLayout parent, URL fileURL) {
        SimpleLayout layout = new SimpleLayout(fileURL);
        layout.ensureOpen();
        this.update(layout);
        try {
            layout.save();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        parent.add(layout);
        return layout;
    }

    public synchronized IdeLayout getDesignLayout() {
        if (this._design == null) {
            URL fileURL = URLFactory.newURL((URL)Layouts.getDirectoryURL(), (String)DESIGN_FILENAME);
            this._design = new IdeLayout(fileURL, DESIGN_LAYOUT_NAME, LayoutArb.getInstance(), 0);
            this.add(this._design);
        }
        return this._design;
    }

    public void update(Layout layout) {
        this.update(layout, this._listeners.values().iterator());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveAll() {
        Assert.startTiming((String)(this.getClass().getName() + ".saveAll"), null, (boolean)false);
        Iterator<Element> iter = null;
        HashMap<URL, Element> hashMap = this._layoutsMap;
        synchronized (hashMap) {
            iter = this._layoutsMap.values().iterator();
        }
        while (iter.hasNext()) {
            Layout layout = (Layout)iter.next();
            if (!layout.isDirty()) continue;
            this.update(layout);
            try {
                layout.save();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        this.updateStartupLayout();
        Assert.endTiming((String)(this.getClass().getName() + ".saveAll"), (String)"Layouts.saveAll()", null, (boolean)false);
    }

    public View getView(ViewId id) {
        if (!id.isValid()) {
            return null;
        }
        LayoutListener listener = (LayoutListener)this._listeners.get(id.getType());
        if (listener == null && (listener = (LayoutListener)this._startupListeners.get(id.getType())) == null) {
            return null;
        }
        long startTime = System.nanoTime();
        View view = listener.getView(id);
        long endTime = System.nanoTime();
        PerformanceLogger.get().log("LayoutListener.getView", listener.getClass().getName(), endTime - startTime);
        return view;
    }

    public void addView(ViewId id, View view) {
        if (!id.isValid()) {
            return;
        }
        LayoutListener listener = (LayoutListener)this._listeners.get(id.getType());
        if (listener == null && (listener = (LayoutListener)this._startupListeners.get(id.getType())) == null) {
            return;
        }
        long startTime = System.nanoTime();
        listener.addView(id, view);
        long endTime = System.nanoTime();
        PerformanceLogger.get().log("LayoutListener.addView", listener.getClass().getName(), endTime - startTime);
    }

    public BaseLayoutListener getLayoutListener(String type) {
        return (BaseLayoutListener)this._listeners.get(type);
    }

    @Override
    public String getShortLabel() {
        if (this._layoutsLabel == null) {
            this._layoutsLabel = LayoutArb.getString(2);
        }
        return this._layoutsLabel;
    }

    @Override
    public String getLongLabel() {
        return this.getShortLabel();
    }

    @Override
    public Icon getIcon() {
        return null;
    }

    @Override
    public boolean mayHaveChildren() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterator getChildren() {
        HashMap<URL, Element> hashMap = this._layoutsMap;
        synchronized (hashMap) {
            return this._layoutsMap.values().iterator();
        }
    }

    @Override
    public String getToolTipText() {
        return this.getShortLabel();
    }

    @Override
    public Object getData() {
        return this;
    }

    @Override
    public Attributes getAttributes() {
        return DefaultAttributes.EMPTY_ATTRIBUTES;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean add(Element element) {
        HashMap<URL, Element> hashMap = this._layoutsMap;
        synchronized (hashMap) {
            this._layoutsMap.put(((IdeLayout)element).getURL(), element);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean remove(Element element) {
        HashMap<URL, Element> hashMap = this._layoutsMap;
        synchronized (hashMap) {
            this._layoutsMap.remove(((IdeLayout)element).getURL());
        }
        return true;
    }

    @Override
    public boolean canRemove(Element element) {
        return element != this._activeLayout;
    }

    @Override
    public boolean canAdd(Element element) {
        return element instanceof IdeLayout;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean containsChild(Element child) {
        HashMap<URL, Element> hashMap = this._layoutsMap;
        synchronized (hashMap) {
            return this._layoutsMap.containsValue(child);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int size() {
        HashMap<URL, Element> hashMap = this._layoutsMap;
        synchronized (hashMap) {
            return this._layoutsMap.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeAll() {
        HashMap<URL, Element> hashMap = this._layoutsMap;
        synchronized (hashMap) {
            this._layoutsMap.clear();
        }
    }

    public boolean isUseEditorPreferredLayout() {
        return this._useEditorPreferredLayout;
    }

    public void setUseEditorPreferredLayout(boolean useEditorPreferredLayout) {
        this._useEditorPreferredLayout = useEditorPreferredLayout;
    }

    public boolean isShowLayoutActivator() {
        return this._showLayoutActivator;
    }

    public void setShowLayoutActivator(boolean showActivator) {
        this._showLayoutActivator = showActivator;
        if (this._layoutActivator == null) {
            return;
        }
        if (showActivator) {
            this._layoutActivator.show();
        } else {
            this._layoutActivator.hide();
        }
    }

    public boolean isUseActiveLayoutInEditor() {
        return this._useActiveLayoutInEditor;
    }

    public void setUseActiveLayoutInEditor(boolean useActiveLayoutInEditor) {
        this._useActiveLayoutInEditor = useActiveLayoutInEditor;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || o.getClass() != this.getClass()) {
            return false;
        }
        return this.equalsImpl((Layouts)o);
    }

    public int hashCode() {
        return super.hashCode();
    }

    protected final boolean equalsImpl(Layouts other) {
        return this._useEditorPreferredLayout == other._useEditorPreferredLayout && this._useActiveLayoutInEditor == other._useActiveLayoutInEditor && this._showLayoutActivator == other._showLayoutActivator && ModelUtil.areEqual(this._layoutsMap, other._layoutsMap);
    }

    protected final void copyToImpl(Layouts copy) {
        copy._useEditorPreferredLayout = this._useEditorPreferredLayout;
        copy._useActiveLayoutInEditor = this._useActiveLayoutInEditor;
        copy._showLayoutActivator = this._showLayoutActivator;
        copy._showLayoutActivator = this._showLayoutActivator;
        ModelUtil.deepCopy(this._layoutsMap, copy._layoutsMap);
        copy._activeLayout = (IdeLayout)copy._layoutsMap.get(this._activeLayout.getURL());
        copy._activeLayout.setActive(true);
        copy._design = (IdeLayout)copy._layoutsMap.get(this._design.getURL());
    }

    protected static String getBaseName() {
        return _basename;
    }

    protected static URL getDirectoryURL() {
        if (_directoryURL == null) {
            ExtensionRegistry er = ExtensionRegistry.getExtensionRegistry();
            _directoryURL = er.getSystemDirectory("oracle.ide");
        }
        return _directoryURL;
    }

    protected URL generateLayoutURL() {
        return URLFactory.newUniqueURL((URL)Layouts.getDirectoryURL(), (NameGenerator)_nameGenerator);
    }

    protected void close(Layout layout) {
        for (BaseLayoutListener listener : this._listeners.values()) {
            try {
                long startTime = System.nanoTime();
                listener.close(layout);
                long endTime = System.nanoTime();
                PerformanceLogger.get().log("BaseLayoutListener.close", listener.getClass().getName(), endTime - startTime);
            }
            catch (Exception e) {
                FeedbackManager.reportException(e);
            }
        }
        layout.setActive(false);
    }

    protected void activate(Layout layout, HashMap listeners) {
        for (BaseLayoutListener listener : listeners.values()) {
            try {
                long startTime = System.nanoTime();
                listener.init(layout);
                long endTime = System.nanoTime();
                PerformanceLogger.get().log("BaseLayoutListener.init", listener.getClass().getName(), endTime - startTime);
            }
            catch (Exception e) {
                FeedbackManager.reportException(e);
            }
        }
        Iterator<Object> iter = listeners.values().iterator();
        ArrayList openedList = new ArrayList();
        while (iter.hasNext()) {
            LayoutListener listener = (LayoutListener)iter.next();
            try {
                long startTime = System.nanoTime();
                listener.addOpenedViews(layout, openedList);
                long endTime = System.nanoTime();
                PerformanceLogger.get().log("LayoutListener.addOpenedViews", listener.getClass().getName(), endTime - startTime);
            }
            catch (Exception e) {
                FeedbackManager.reportException(e);
            }
        }
        for (View view : openedList) {
            view.show();
        }
    }

    protected void updateStartupLayout() {
        this.update(Ide.getIdeProperties(), this._startupListeners.values().iterator());
    }

    protected void update(Layout layout, Iterator iter) {
        while (iter.hasNext()) {
            BaseLayoutListener listener = (BaseLayoutListener)iter.next();
            try {
                long startTime = System.nanoTime();
                listener.save(layout);
                long endTime = System.nanoTime();
                PerformanceLogger.get().log("BaseLayoutListener.save", listener.getClass().getName(), endTime - startTime);
            }
            catch (Exception e) {
                FeedbackManager.reportException(e);
            }
        }
    }

    private void updateEditorPreferredLayout(Layout layout) {
        Editor editor = EditorManager.getEditorManager().getCurrentEditor();
        if (editor != null && !editor.getPreferredLayoutURL().equals(layout.getURL())) {
            editor.setPreferredLayoutURL(layout.getURL());
        }
    }

    public void addLayoutResetListener(LayoutResetListener l) {
        if (this.layoutResetListeners.contains(l)) {
            return;
        }
        this.layoutResetListeners.add(l);
    }

    public void removeLayoutResetListener(LayoutResetListener l) {
        this.layoutResetListeners.remove(l);
    }

    public List<LayoutResetListener> layoutResetListeners() {
        return new ArrayList<LayoutResetListener>(this.layoutResetListeners);
    }

    public Map<URL, Element> getAllLayouts() {
        return Collections.unmodifiableMap(this._layoutsMap);
    }

    public static synchronized IdeLayout findLayout(String name) {
        for (Element layout_ : Layouts.getLayouts().getAllLayouts().values()) {
            IdeLayout ideLayout;
            if (!(layout_ instanceof IdeLayout) || !name.equals((ideLayout = (IdeLayout)layout_).getName())) continue;
            return ideLayout;
        }
        return null;
    }
}

