/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.keyboard;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.text.BreakIterator;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.accessibility.AccessibleState;
import javax.accessibility.AccessibleStateSet;
import javax.accessibility.AccessibleText;
import javax.swing.FocusManager;
import javax.swing.JComponent;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.text.AttributeSet;
import oracle.ide.keyboard.KeyStrokeControler;
import oracle.ide.keyboard.KeyStrokeModel;
import oracle.ide.keyboard.KeyStrokesConstraint;
import oracle.javatools.util.SwingUtils;

public final class KeyStrokeField
extends JComponent
implements KeyListener,
MouseListener,
FocusListener,
Accessible {
    private final KeyStrokeControler _controler;
    private final int _nColumns = 10;
    private Dimension _charSize = null;
    private static final Color _clrBack = (Color)UIManager.get("window");
    private static final Color _clrText = (Color)UIManager.get("textText");
    private boolean _bAteATab = false;

    public KeyStrokeField() {
        this._controler = new KeyStrokeControler();
        this.init();
    }

    public KeyStrokeField(KeyStrokeControler controler) {
        this._controler = controler;
        this.init();
    }

    public void clear() {
        this._controler.clear();
        this.whenFieldChanges();
    }

    public KeyStrokeModel getModel() {
        return this._controler.getModel();
    }

    public void setConstraint(KeyStrokesConstraint ksc) {
        this._controler.setConstraint(ksc);
    }

    private void init() {
        this.addKeyListener(this);
        this.addMouseListener(this);
        this.addFocusListener(this);
        Border border = UIManager.getBorder("TextField.border");
        this.setBorder(border);
    }

    @Override
    public boolean isFocusTraversable() {
        return this.isEnabled();
    }

    protected Dimension getCharSize() {
        Font font;
        if (this._charSize == null && (font = this.getFont()) != null) {
            FontMetrics fm = this.getFontMetrics(font);
            this._charSize = new Dimension(fm.charWidth('m'), fm.getHeight() + 3);
            if (this._charSize.width % 2 == 0) {
                ++this._charSize.width;
            }
            if (this._charSize.height % 2 == 0) {
                ++this._charSize.height;
            }
        }
        return this._charSize;
    }

    @Override
    public void setFont(Font font) {
        super.setFont(font);
        this._charSize = null;
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension d = this.getCharSize();
        if (d != null) {
            d = new Dimension(d);
            d.width = d.width * 10 + 3;
            d.height += 3;
        } else {
            d = new Dimension(400, 400);
        }
        return d;
    }

    @Override
    protected void paintComponent(Graphics g) {
        g.setColor(_clrBack);
        Dimension d = this.getSize();
        Insets insets = this.getInsets();
        int x = insets.left;
        int y = insets.top;
        int width = d.width - (insets.left + insets.right);
        int height = d.height - (insets.top + insets.bottom);
        g.fillRect(x, y, width, height);
        String s = this._controler.toString();
        g.setColor(_clrText);
        SwingUtils.drawString((Graphics)g, (String)s, (int)(x + 1), (int)(height - 1));
        if (this.hasFocus()) {
            g.setColor(_clrText);
            KeyStrokeField.drawDashedRect(g, x + 1, y + 1, width - 1, height - 1);
        }
    }

    private static void drawDashedRect(Graphics g, int x, int y, int width, int height) {
        for (int vx = x; vx < x + width; vx += 2) {
            g.drawLine(vx, y, vx, y);
            g.drawLine(vx, y + height - 1, vx, y + height - 1);
        }
        for (int vy = y; vy < y + height; vy += 2) {
            g.drawLine(x, vy, x, vy);
            g.drawLine(x + width - 1, vy, x + width - 1, vy);
        }
    }

    private void whenFieldChanges() {
        this.repaint();
        if (this.accessibleContext != null) {
            ((AccessibleKeyStrokeField)this.accessibleContext).actionPerformed(null);
        }
    }

    @Override
    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessibleKeyStrokeField();
        }
        return this.accessibleContext;
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (this.isEnabled() && SwingUtilities.isLeftMouseButton(e)) {
            this.requestFocus();
        }
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void focusGained(FocusEvent e) {
        this.repaint();
    }

    @Override
    public void focusLost(FocusEvent e) {
        this.repaint();
    }

    @Override
    public void keyPressed(KeyEvent e) {
        if (this.isEnabled()) {
            this._bAteATab = false;
            KeyStrokeModel ksm = this.getModel();
            KeyStroke ksTop = ksm.top();
            if (ksTop == null || ksTop.getKeyCode() != 9) {
                this._controler.keyPressed(e);
            } else {
                ksm.pop();
                FocusManager fm = FocusManager.getCurrentManager();
                if ((e.getModifiers() & 1) == 0) {
                    fm.focusNextComponent(this);
                } else {
                    fm.focusPreviousComponent(this);
                }
            }
            this.whenFieldChanges();
            e.consume();
        }
    }

    @Override
    public void keyTyped(KeyEvent e) {
        if (this.isEnabled()) {
            if (!this._bAteATab) {
                KeyStrokeControler.keyTyped(e);
                this.whenFieldChanges();
            }
            e.consume();
        }
    }

    @Override
    public void keyReleased(KeyEvent e) {
        if (this.isEnabled()) {
            if (!this._bAteATab) {
                this._controler.keyReleased(e);
                this.whenFieldChanges();
            }
            e.consume();
        }
    }

    @Override
    public boolean isManagingFocus() {
        return this.isEnabled();
    }

    private final class AccessibleKeyStrokeField
    extends JComponent.AccessibleJComponent
    implements ActionListener,
    AccessibleText {
        AccessibleKeyStrokeField() {
            super(KeyStrokeField.this);
        }

        @Override
        public final AccessibleStateSet getAccessibleStateSet() {
            AccessibleStateSet states = super.getAccessibleStateSet();
            states.add(AccessibleState.EDITABLE);
            states.add(AccessibleState.SINGLE_LINE);
            states.add(AccessibleState.OPAQUE);
            return states;
        }

        @Override
        public final AccessibleRole getAccessibleRole() {
            return AccessibleRole.TEXT;
        }

        @Override
        public final AccessibleText getAccessibleText() {
            return this;
        }

        private String getNonNullText() {
            String s = KeyStrokeField.this._controler.toString();
            return s == null ? "" : s;
        }

        private String getText(int offset) {
            return this.getNonNullText().substring(offset, offset + 1);
        }

        @Override
        public final void actionPerformed(ActionEvent event) {
            final String s = this.getNonNullText();
            if (SwingUtilities.isEventDispatchThread()) {
                this.firePropertyChange("AccessibleText", null, s);
                this.firePropertyChange("AccessibleCaret", 0, s.length());
            } else {
                Runnable doFire = new Runnable(){

                    @Override
                    public void run() {
                        AccessibleKeyStrokeField.this.firePropertyChange("AccessibleText", null, s);
                        AccessibleKeyStrokeField.this.firePropertyChange("AccessibleCaret", 0, s.length());
                    }
                };
                SwingUtilities.invokeLater(doFire);
            }
        }

        @Override
        public final int getIndexAtPoint(Point p) {
            return -1;
        }

        @Override
        public final Rectangle getCharacterBounds(int i) {
            return new Rectangle();
        }

        @Override
        public final int getCharCount() {
            int i = this.getNonNullText().length();
            return i;
        }

        @Override
        public final int getCaretPosition() {
            int i = this.getNonNullText().length();
            return i;
        }

        @Override
        public final String getAtIndex(int part, int index) {
            String sRet = null;
            try {
                switch (part) {
                    case 1: {
                        sRet = this.getText(index);
                        break;
                    }
                    case 2: {
                        String s = this.getNonNullText();
                        BreakIterator words = BreakIterator.getWordInstance();
                        words.setText(s);
                        int end = words.following(index);
                        sRet = s.substring(words.previous(), end);
                        break;
                    }
                    case 3: {
                        String s = this.getNonNullText();
                        BreakIterator sentence = BreakIterator.getSentenceInstance();
                        sentence.setText(s);
                        int end = sentence.following(index);
                        sRet = s.substring(sentence.previous(), end);
                        break;
                    }
                }
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            return sRet;
        }

        @Override
        public final String getAfterIndex(int part, int index) {
            String sRet = null;
            try {
                switch (part) {
                    case 1: {
                        sRet = this.getText(index + 1);
                        break;
                    }
                    case 2: {
                        String s = this.getNonNullText();
                        BreakIterator words = BreakIterator.getWordInstance();
                        words.setText(s);
                        int start = words.following(index);
                        if (start == -1 || start >= s.length()) break;
                        int end = words.following(start);
                        if (end != -1 && end < s.length()) {
                            sRet = s.substring(start, end);
                        }
                        break;
                    }
                    case 3: {
                        String s = this.getNonNullText();
                        BreakIterator sentence = BreakIterator.getSentenceInstance();
                        sentence.setText(s);
                        int start = sentence.following(index);
                        if (start == -1 || start >= s.length()) break;
                        int end = sentence.following(start);
                        if (end != -1 && end < s.length()) {
                            sRet = s.substring(start, end);
                        }
                        break;
                    }
                }
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            return sRet;
        }

        @Override
        public final String getBeforeIndex(int part, int index) {
            String sRet = null;
            if (index >= 0 && index <= this.getCharCount() - 1) {
                try {
                    switch (part) {
                        case 1: {
                            sRet = this.getText(index - 1);
                            break;
                        }
                        case 2: {
                            String s = this.getNonNullText();
                            BreakIterator words = BreakIterator.getWordInstance();
                            words.setText(s);
                            int end = words.following(index);
                            end = words.previous();
                            int start = words.previous();
                            if (start == -1) break;
                            sRet = s.substring(start, end);
                            break;
                        }
                        case 3: {
                            String s = this.getNonNullText();
                            BreakIterator sentence = BreakIterator.getSentenceInstance();
                            sentence.setText(s);
                            int end = sentence.following(index);
                            end = sentence.previous();
                            int start = sentence.previous();
                            if (start == -1) break;
                            sRet = s.substring(start, end);
                            break;
                        }
                    }
                }
                catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
            }
            return sRet;
        }

        @Override
        public final AttributeSet getCharacterAttribute(int i) {
            return null;
        }

        @Override
        public final int getSelectionStart() {
            int i = this.getCharCount();
            return i;
        }

        @Override
        public final int getSelectionEnd() {
            int i = this.getCharCount();
            return i;
        }

        @Override
        public final String getSelectedText() {
            return "";
        }
    }
}

