/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.keyboard;

import java.awt.event.KeyEvent;
import javax.swing.KeyStroke;
import oracle.ide.keyboard.KeyStrokeFilter;
import oracle.ide.keyboard.KeyStrokeModel;
import oracle.ide.keyboard.KeyStrokesConstraint;

final class KeyStrokeControler {
    private final KeyStrokeModel _model;
    private KeyStrokesConstraint _constraints;
    private final KeyStrokeFilter _ksf = new KeyStrokeFilter();
    private KeyStroke _ksBack = KeyStroke.getKeyStroke(8, 0);

    public void setBackSpaceKey(KeyStroke ksBack) {
        this._ksBack = ksBack;
    }

    KeyStrokeControler() {
        this._model = new KeyStrokeModel();
    }

    KeyStrokeControler(KeyStrokeModel model) {
        this._model = model;
    }

    public void clear() {
        this._ksf.clear();
        this.getModel().clear();
    }

    public KeyStrokeModel getModel() {
        return this._model;
    }

    public void setConstraint(KeyStrokesConstraint ksc) {
        this._constraints = ksc;
    }

    private static String toString(KeyStroke ks) {
        StringBuffer ret = new StringBuffer();
        int keyMod = ks.getModifiers();
        int keyCode = ks.getKeyCode();
        if (keyMod != 0) {
            ret.append(KeyEvent.getKeyModifiersText(keyMod) + "+");
        }
        ret.append(KeyEvent.getKeyText(keyCode));
        return ret.toString();
    }

    public String toString() {
        String sPending;
        StringBuffer ret = new StringBuffer();
        String sSep = "";
        int nSize = this._model.size();
        for (int i = 0; i < nSize; ++i) {
            ret.append(sSep);
            KeyStroke ks = this._model.get(i);
            ret.append(KeyStrokeControler.toString(ks));
            sSep = ", ";
        }
        if (nSize == 0 && (sPending = this._ksf.toString(true)) != null) {
            ret.append(sSep);
            ret.append(sPending);
        }
        return ret.toString();
    }

    private void addKeyStroke(KeyStroke ks) {
        if (ks != null) {
            this._model.add(ks);
        }
    }

    void keyPressed(KeyEvent e) {
        if (this._ksBack.equals(KeyStroke.getKeyStrokeForEvent(e))) {
            this._model.pop();
        } else if (this._ksf.keyPressed(e)) {
            KeyStroke ks = this._ksf.getKeyStroke();
            if (!this._model.authorizeNewKeys()) {
                this._model.clear();
            }
            if (this.isAcceptableKey(ks)) {
                this.addKeyStroke(ks);
            }
        }
        e.consume();
    }

    static void keyTyped(KeyEvent e) {
        e.consume();
    }

    void keyReleased(KeyEvent e) {
        this._ksf.keyReleased(e);
        e.consume();
    }

    protected boolean isAcceptableKey(KeyStroke ksNew) {
        return this._constraints == null || this._constraints.isAcceptableKey(this.getModel().getKeyStrokes(), ksNew);
    }
}

