/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.help;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.net.URL;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import oracle.bali.share.nls.StringUtils;
import oracle.ide.ExtensionRegistry;
import oracle.ide.IdeClipboard;
import oracle.ide.Version;
import oracle.ide.config.EnvironOptions;
import oracle.ide.config.Preferences;
import oracle.ide.controls.MenuToolButton;
import oracle.ide.controls.ToggleAction;
import oracle.ide.dialogs.DialogUtil;
import oracle.ide.editor.EditorUtil;
import oracle.ide.help.AboutBoxModel;
import oracle.ide.help.AboutBoxPage;
import oracle.ide.help.HelpSystem;
import oracle.ide.net.URLChooser;
import oracle.ide.net.URLFileSystem;
import oracle.ide.osgi.boot.api.IdeBootUtil;
import oracle.ide.resource.IdeArb;
import oracle.ide.util.IdeUtil;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.dialogs.MessageDialog;

final class AboutBox
extends JPanel {
    private JTabbedPane tabbedPane = new JTabbedPane();
    private JLabel lblTitle = new JLabel();
    private Icon iconTitle;
    private JTextField lblVersion = new JTextField();
    private JTextField lblBuild = new JTextField();
    private JLabel lblCopyright = new JLabel();
    private MenuToolButton mtbExport;
    private JPanel _topPanel;
    private Container _mainPanel;
    private AboutBoxModel _model;

    AboutBox(AboutBoxModel model) {
        if (model == null) {
            throw new NullPointerException("Null about box model");
        }
        this.addControls();
        this.setModel(model);
        this.configureTextField(this.lblBuild);
        this.configureTextField(this.lblVersion);
    }

    PageContainer addPage(AboutBoxPage page) {
        PageContainer pc = new PageContainer(page);
        this.tabbedPane.addTab(page.getName(), pc);
        return pc;
    }

    private void configureTextField(JTextField tf) {
        tf.setBorder(null);
        tf.setEditable(false);
        tf.setOpaque(false);
    }

    private void setModel(AboutBoxModel model) {
        this._model = model;
        this.lblVersion.setText(this.getVersionString());
        this.lblBuild.setText(this.getBuildString());
        BufferedImage copyrightImage = IdeBootUtil.getCopyrightImage();
        if (copyrightImage != null) {
            ImageIcon copyrightIcon = new ImageIcon(copyrightImage);
            this.lblCopyright.setIcon(copyrightIcon);
        }
        this.iconTitle = this._model.getBannerImage();
        if (this.iconTitle != null) {
            this.lblTitle.setIcon(this.iconTitle);
        }
        this._mainPanel.validate();
    }

    private void addControls() {
        this.lblVersion.setFont(this.lblVersion.getFont().deriveFont(0));
        this.lblBuild.setFont(this.lblBuild.getFont().deriveFont(1));
        AboutBoxPage mainPage = new AboutBoxPage(){

            @Override
            protected void populate() {
            }

            @Override
            public String dump() {
                StringBuilder sb = new StringBuilder();
                sb.append(AboutBox.this._model.getProductName() + " " + AboutBox.this._model.getProductVersion());
                sb.append('\n');
                sb.append(AboutBox.this.lblVersion.getText());
                sb.append('\n');
                sb.append(AboutBox.this.lblBuild.getText());
                sb.append('\n');
                sb.append(AboutBox.this.lblCopyright.getText());
                sb.append('\n');
                sb.append("IDE Version: " + ExtensionRegistry.getExtensionRegistry().findExtension("oracle.ide").getVersion());
                if (Version.DEBUG_BUILD == 1) {
                    sb.append(" (DEBUG BUILD)");
                }
                sb.append('\n');
                sb.append("Product ID: " + System.getProperty("ide.product"));
                sb.append('\n');
                sb.append("Product Version: " + ExtensionRegistry.getExtensionRegistry().findExtension(System.getProperty("ide.product")).getVersion());
                sb.append('\n');
                return sb.toString();
            }
        };
        this._mainPanel = this.createMainPanel();
        mainPage.setComponent(this._mainPanel);
        mainPage.setInitialFocus(null);
        mainPage.setName(IdeArb.getString(427));
        this.addPage(mainPage).selected();
        this.setLayout(new BorderLayout());
        this.mtbExport = this.createExportDropDown();
        this._topPanel = new JPanel();
        this._topPanel.setLayout(new BorderLayout());
        this._topPanel.add((Component)this.mtbExport, "After");
        this.add((Component)this._topPanel, "First");
        this.add((Component)this.tabbedPane, "Center");
        this.tabbedPane.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                PageContainer container = (PageContainer)AboutBox.this.tabbedPane.getSelectedComponent();
                container.selected();
                container.validate();
            }
        });
        HelpSystem helpSystem = HelpSystem.getHelpSystem();
        if (helpSystem != null) {
            helpSystem.registerTopic(this, "f1_helpaboutjdev_html");
        }
    }

    private MenuToolButton createExportDropDown() {
        ToggleAction action = new ToggleAction("", null){

            @Override
            public void actionPerformed(ActionEvent e) {
            }
        };
        MenuToolButton result = new MenuToolButton(action);
        result.setFocusable(true);
        result.setFocusPainted(true);
        ToggleAction save = new ToggleAction("", null){

            @Override
            public void actionPerformed(ActionEvent e) {
                AboutBox.this.saveDataToFile();
            }
        };
        this.resToggleAction(save, 480);
        result.getPopupMenu().add(save);
        ToggleAction copy = new ToggleAction("", null){

            @Override
            public void actionPerformed(ActionEvent e) {
                AboutBox.this.saveDataToClipboard();
            }
        };
        this.resToggleAction(copy, 481);
        result.getPopupMenu().add(copy);
        ToggleAction copyBuildToClipboard = new ToggleAction("", null){

            @Override
            public void actionPerformed(ActionEvent e) {
                AboutBox.this.saveBuildToClipboard();
            }
        };
        this.resToggleAction(copyBuildToClipboard, 484);
        result.getPopupMenu().add(copyBuildToClipboard);
        ResourceUtils.resButton((AbstractButton)result, (String)IdeArb.getString(479));
        return result;
    }

    private void saveDataToFile() {
        this.forcePopulateAllPages();
        String data = this.dumpAll();
        URLChooser u = DialogUtil.newURLChooser();
        int result = u.showSaveDialog(this);
        if (result != 0) {
            return;
        }
        URL url = u.getSelectedURL();
        if (URLFileSystem.exists((URL)url) && !MessageDialog.confirm((Component)this, (Object)IdeArb.getString(482), (String)IdeArb.getString(483), null, (boolean)true)) {
            return;
        }
        if (!URLFileSystem.canCreate((URL)url)) {
            MessageDialog.error((Component)this, (Object)IdeArb.format(245, URLFileSystem.getPlatformPathName((URL)url)), (String)IdeArb.getString(244), null);
            return;
        }
        OutputStreamWriter pw = null;
        try {
            EnvironOptions env = EnvironOptions.getInstance(Preferences.getPreferences());
            pw = new OutputStreamWriter(URLFileSystem.openOutputStream((URL)url), env.getEncoding());
            pw.write(data, 0, data.length());
        }
        catch (IOException ioe) {
            try {
                throw new RuntimeException(ioe);
            }
            catch (Throwable throwable) {
                IdeUtil.close(pw);
                throw throwable;
            }
        }
        IdeUtil.close(pw);
        if (URLFileSystem.exists((URL)url)) {
            EditorUtil.openDefaultEditorInFrame(url);
        }
    }

    private void copyToClipboard(String text) {
        IdeClipboard.getClipboard().setContents(new StringSelection(text), new ClipboardOwner(){

            @Override
            public void lostOwnership(Clipboard clipboard, Transferable contents) {
            }
        });
    }

    private void saveBuildToClipboard() {
        String buildNumber = this._model.getBuildString();
        if (buildNumber == null) {
            return;
        }
        int lastSpace = buildNumber.lastIndexOf(" ");
        if (lastSpace >= 0 && lastSpace < buildNumber.length() - 1) {
            buildNumber = buildNumber.substring(lastSpace + 1);
        }
        this.copyToClipboard(buildNumber);
    }

    private void saveDataToClipboard() {
        this.forcePopulateAllPages();
        this.copyToClipboard(this.dumpAll());
    }

    private void forcePopulateAllPages() {
        int currentSelection = this.tabbedPane.getSelectedIndex();
        for (int i = 0; i < this.tabbedPane.getTabCount(); ++i) {
            Component c = this.tabbedPane.getComponent(i);
            if (!(c instanceof PageContainer)) continue;
            ((PageContainer)c).selected();
        }
        ((PageContainer)this.tabbedPane.getComponent(currentSelection)).selected();
    }

    private String dumpAll() {
        String lf = EnvironOptions.getInstance(Preferences.getPreferences()).getLineBreakSequence();
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < this.tabbedPane.getTabCount(); ++i) {
            String title = this.tabbedPane.getTitleAt(i);
            if (title == null) {
                title = "";
            }
            sb.append(title);
            sb.append(lf);
            for (int j = 0; j < title.length(); ++j) {
                sb.append('-');
            }
            sb.append(lf);
            sb.append(lf);
            PageContainer pc = (PageContainer)this.tabbedPane.getComponent(i);
            sb.append(pc._page.dump());
            sb.append(lf);
        }
        return sb.toString();
    }

    private void resToggleAction(ToggleAction a, int key) {
        String value = IdeArb.getString(key);
        a.putValue("Name", StringUtils.stripMnemonic((String)value));
        a.putValue("MnemonicKey", StringUtils.getMnemonicKeyCode((String)value));
    }

    private Container createMainPanel() {
        JPanel result = new JPanel(){

            @Override
            public void paintComponent(Graphics g) {
                super.paintComponent(g);
                g.setColor(new Color(157, 163, 170));
                int height = 35;
                int verticalOffset = AboutBox.this.lblCopyright.getHeight() / 2 - height / 2;
                g.fillRect(0, AboutBox.this.lblCopyright.getY() + verticalOffset, this.getWidth(), height);
            }
        };
        result.setLayout(new GridBagLayout());
        result.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        this.lblTitle.setHorizontalAlignment(0);
        this.lblVersion.setHorizontalAlignment(0);
        this.lblBuild.setHorizontalAlignment(0);
        this.lblCopyright.setHorizontalAlignment(0);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.fill = 2;
        gbc.anchor = 10;
        gbc.insets = new Insets(0, 0, 0, 0);
        result.add((Component)this.lblTitle, gbc);
        ++gbc.gridy;
        gbc.weighty = 0.0;
        gbc.insets = new Insets(0, 0, 5, 0);
        result.add((Component)this.lblVersion, gbc);
        ++gbc.gridy;
        gbc.insets = new Insets(0, 0, 10, 0);
        result.add((Component)this.lblBuild, gbc);
        ++gbc.gridy;
        ++gbc.gridy;
        gbc.weighty = 0.5;
        result.add((Component)this.lblCopyright, gbc);
        return result;
    }

    JComponent getInitialFocusedComponent() {
        return this.tabbedPane;
    }

    private final String getVersionString() {
        return this._model.getVersionString();
    }

    private final String getBuildString() {
        return this._model.getBuildString();
    }

    private static class PageContainer
    extends JPanel {
        private final AboutBoxPage _page;

        PageContainer(AboutBoxPage page) {
            this._page = page;
            this.setLayout(new BorderLayout());
        }

        void selected() {
            if (this.getComponentCount() == 0) {
                this.add(this._page.getComponent(), "Center");
                this._page.populate();
            }
        }
    }
}

