/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.controller;

import java.util.HashMap;
import java.util.Map;
import oracle.ide.Context;
import oracle.ide.ProductInformation;
import oracle.ide.controller.IdeAction;
import oracle.ide.controller.LabelUpdater;
import oracle.ide.model.Displayable;
import oracle.ide.model.Element;
import oracle.ide.model.Node;
import oracle.ide.model.Project;
import oracle.ide.model.WorkingSets;
import oracle.ide.model.Workspace;
import oracle.ide.util.macro.StringMacroConverter;

public class ContextAwareLabelUpdater
implements LabelUpdater {
    private String _enabledFormat;
    private String _disabledFormat;
    private StringMacroConverter macroConverter = StringMacroConverter.getConverter(3);
    protected static String ACTION_NAME_MACRO = "action.name";
    protected static String WORKSPACE_NAME_MACRO = "workspace.name";
    protected static String PROJECT_NAME_MACRO = "project.name";
    protected static String ELEMENT_NAME_MACRO = "element.name";
    protected static String NODE_NAME_MACRO = "node.name";
    protected static String PRODUCT_NAME_MACRO = "product.short.name";
    protected static String WORKINGSET_NAME_MACRO = "working.set.name";
    private static String[] MACROS = new String[]{ACTION_NAME_MACRO, WORKSPACE_NAME_MACRO, PROJECT_NAME_MACRO, ELEMENT_NAME_MACRO, NODE_NAME_MACRO, PRODUCT_NAME_MACRO, WORKINGSET_NAME_MACRO};

    @Override
    public String labelWhenEnabled(Context context, IdeAction action, String originalLabel) {
        return this.resolveLabel(context, action, originalLabel, this._enabledFormat);
    }

    @Override
    public String labelWhenDisabled(Context context, IdeAction action, String originalLabel) {
        return this.resolveLabel(context, action, originalLabel, this._disabledFormat);
    }

    private String resolveLabel(Context context, IdeAction action, String originalLabel, String format) {
        if (format == null) {
            return originalLabel;
        }
        if (!ContextAwareLabelUpdater.containsMacro(format)) {
            return format;
        }
        Map macros = this.configureDefaultMacros(context, action, originalLabel);
        String expandString = this.macroConverter.expandString(format, macros);
        if (format.equals(expandString)) {
            return originalLabel;
        }
        return expandString;
    }

    @Override
    public void setEnabledFormat(String format) {
        if (format == null) {
            throw new NullPointerException("format cannot be null");
        }
        this._enabledFormat = format;
    }

    @Override
    public void setDisabledFormat(String format) {
        if (format == null) {
            throw new NullPointerException("format cannot be null");
        }
        this._disabledFormat = format;
    }

    private Map configureDefaultMacros(Context context, IdeAction action, String originalLabel) {
        HashMap macros = (HashMap)context.getProperty("oracle.ide.label_updater_macros");
        if (macros == null) {
            macros = new HashMap();
            context.setProperty("oracle.ide.label_updater_macros", macros);
        }
        this.configureProductMacros(context, action, originalLabel, macros);
        this.configureActionMacros(context, action, originalLabel, macros);
        this.configureWorkspaceMacros(context, action, originalLabel, macros);
        this.configureProjectMacros(context, action, originalLabel, macros);
        this.configureElementMacros(context, action, originalLabel, macros);
        this.configureNodeMacros(context, action, originalLabel, macros);
        this.configureWorkingSetMacros(context, action, originalLabel, macros);
        this.configureExtraMacros(context, action, originalLabel, macros);
        return macros;
    }

    protected void configureActionMacros(Context context, IdeAction action, String originalLabel, Map macros) {
        macros.put(ACTION_NAME_MACRO, originalLabel);
    }

    protected void configureProjectMacros(Context context, IdeAction action, String originalLabel, Map macros) {
        Project project = context.getProject();
        if (project != null) {
            macros.put(PROJECT_NAME_MACRO, new LazyLabel(project));
        }
    }

    protected void configureWorkspaceMacros(Context context, IdeAction action, String originalLabel, Map macros) {
        Workspace workspace = context.getWorkspace();
        if (workspace != null) {
            macros.put(WORKSPACE_NAME_MACRO, new LazyLabel(workspace));
        }
    }

    protected void configureElementMacros(Context context, IdeAction action, String originalLabel, Map macros) {
        Element element = context.getElement();
        if (element != null) {
            macros.put(ELEMENT_NAME_MACRO, new LazyLabel(element));
        }
    }

    protected void configureNodeMacros(Context context, IdeAction action, String originalLabel, Map macros) {
        Node node = context.getNode();
        if (node != null) {
            macros.put(NODE_NAME_MACRO, new LazyLabel(node));
        }
    }

    protected void configureWorkingSetMacros(Context context, IdeAction action, String originalLabel, Map macros) {
        Workspace workspace = context.getWorkspace();
        if (workspace != null) {
            WorkingSets workingSet = WorkingSets.getInstance(workspace);
            macros.put(WORKINGSET_NAME_MACRO, workingSet.getCurrentWorkingSetName());
        }
    }

    protected void configureExtraMacros(Context context, IdeAction action, String originalLabel, Map macros) {
    }

    protected void configureProductMacros(Context context, IdeAction action, String originalLabel, Map macros) {
        String productShortName = ProductInformation.getProductInformation().getShortName();
        if (productShortName != null) {
            macros.put(PRODUCT_NAME_MACRO, productShortName);
        }
    }

    public static final boolean containsMacro(String formattedText) {
        if (formattedText != null && formattedText.trim().length() > 0) {
            for (String macro : MACROS) {
                if (formattedText.indexOf(macro) == -1) continue;
                return true;
            }
        }
        return false;
    }

    private static class LazyLabel {
        final Displayable displayable;

        public LazyLabel(Displayable displayable) {
            this.displayable = displayable;
        }

        public String toString() {
            return this.displayable.getShortLabel();
        }
    }
}

