/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide;

import java.awt.Component;
import java.awt.Image;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URL;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.Timer;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import oracle.ide.Addin;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.IdeActivationEvent;
import oracle.ide.IdeActivationListener;
import oracle.ide.IdeArgs;
import oracle.ide.IdeCore;
import oracle.ide.IdeViewHandler;
import oracle.ide.cmd.OpenCommand;
import oracle.ide.cmd.SaveAllCommand;
import oracle.ide.config.EnvironOptions;
import oracle.ide.config.Preferences;
import oracle.ide.controller.Controller;
import oracle.ide.controller.DynamicMenuListener;
import oracle.ide.controller.IdeAction;
import oracle.ide.controller.Menubar;
import oracle.ide.controls.StatusBar;
import oracle.ide.controls.StatusBarControl;
import oracle.ide.controls.Toolbar;
import oracle.ide.keyboard.KeyStrokeOptions;
import oracle.ide.keyboard.MultiInputMap;
import oracle.ide.keyboard.MultiMapAdapter;
import oracle.ide.layout.IdeLayout;
import oracle.ide.layout.Layouts;
import oracle.ide.model.Node;
import oracle.ide.model.NodeFactory;
import oracle.ide.model.NodeUtil;
import oracle.ide.model.UpdateMessage;
import oracle.ide.navigator.NavigatorWindow;
import oracle.ide.performance.PerformanceLogger;
import oracle.ide.resource.IdeArb;
import oracle.ide.util.Assert;
import oracle.ide.util.IdeUtil;
import oracle.ide.view.ActiveViewListener;
import oracle.ide.view.View;
import oracle.ideimpl.controller.MenubarImpl;
import oracle.javatools.controls.MainWindow;
import oracle.javatools.dialogs.ExceptionDialog;
import oracle.javatools.util.CommandParser;

public abstract class IdeMainWindow
extends MainWindow
implements Addin {
    public static final String MENU_FILE = "File";
    public static final String MENU_FILE_REOPEN = "FileReopen";
    public static final String MENU_EDIT = "Edit";
    public static final String MENU_VIEW = "View";
    @Deprecated
    public static final String MENU_VIEW_OPTIONS = "ViewOptions";
    public static final String MENU_VIEW_TOOLBARS = "ViewToolbars";
    public static final String MENU_SEARCH = "Search";
    public static final String MENU_NAVIGATE = "Navigate";
    public static final String MENU_RUN = "Run";
    public static final String MENU_TOOLS = "Tools";
    public static final String MENU_WINDOW = "Window";
    public static final String MENU_HELP = "Help";
    public static final String ACTION_CATEGORY_FILE = IdeArb.getString(22);
    public static final String ACTION_CATEGORY_EDIT = IdeArb.getString(79);
    public static final String ACTION_CATEGORY_VIEW = IdeArb.getString(151);
    public static final String ACTION_CATEGORY_SEARCH = IdeArb.getString(108);
    public static final String ACTION_CATEGORY_APPLICATION = IdeArb.getString(495);
    public static final String ACTION_CATEGORY_NAVIGATE = IdeArb.getString(147);
    public static final String ACTION_CATEGORY_TOOLS = IdeArb.getString(180);
    public static final String ACTION_CATEGORY_WINDOWS = IdeArb.getString(191);
    public static final String ACTION_CATEGORY_HELP = IdeArb.getString(421);
    public static final String WINDOW_MANAGER_MIGRATTION_PROP = "window.manager.migration";
    private Image _mainIcon;
    private List<? extends Image> m_productIcons;
    private static final Logger LOG = Logger.getLogger(IdeCore.class.getName());
    private View _view;
    private static final String NAME_ID_PROP = "MainWindow";
    private Menubar _menubar;
    private Toolbar _toolbar;
    private StatusBar _statusBar;
    private ActionMap _actionMap;
    private InputMap _inputMap;
    private MultiInputMap _topInputMap;
    private IdeViewHandler _viewHandler;
    private NodeReloader _nodeReloader;

    public abstract void registerView(View var1);

    public abstract void registerView(View var1, Component var2);

    public abstract void unregisterView(View var1);

    public abstract View getLastActiveView();

    public abstract List<View> getVisibleViews();

    public abstract ControllerContext getControllerContext();

    public abstract void addActiveViewListener(ActiveViewListener var1);

    public abstract void removeActiveViewListener(ActiveViewListener var1);

    public abstract void addIdeActivationListener(IdeActivationListener var1);

    public abstract void removeIdeActivationListener(IdeActivationListener var1);

    public abstract void addDynamicMenuListener(DynamicMenuListener var1);

    public void reloadNodes(Set<NodeUtil.ReloadMode> reloadFlags) {
        NodeUtil.reloadBuffers(this._nodeReloader.getTimestampMap(), reloadFlags);
    }

    public abstract void removeDynamicMenuListener(DynamicMenuListener var1);

    public static final void updateVisibleActions() {
        IdeMainWindow.updateVisibleActions(Controller.UPDATE_FROM_USER_EXTENSION);
    }

    protected View createIdeMainWindowView() {
        View mainWindowView = new View(NAME_ID_PROP){

            @Override
            public void close() {
                IdeMainWindow.this.close();
            }

            @Override
            public void show() {
                IdeMainWindow.this.show();
            }

            @Override
            public void updateTitle(Object ctx) {
                IdeMainWindow.this.updateTitle(ctx);
            }

            @Override
            public boolean isVisible() {
                return IdeMainWindow.this.isVisible();
            }

            @Override
            public Component getGUI() {
                return IdeMainWindow.this;
            }

            @Override
            public void updateVisibleActions(UpdateMessage updateMessage) {
                try {
                    UpdateVisibleActions.scheduleUpdate(updateMessage);
                }
                catch (Exception e) {
                    ExceptionDialog.showExceptionDialog((Window)((Object)IdeMainWindow.this), (Exception)e);
                }
            }

            @Override
            public Toolbar getToolbar() {
                if (IdeMainWindow.this._toolbar == null) {
                    IdeMainWindow.this._toolbar = IdeMainWindow.this.createToolbar();
                    String visibleProp = Ide.getProperty("MainWindow.Toolbar.visible", "true");
                    boolean visible = Boolean.valueOf(visibleProp);
                    IdeMainWindow.this._toolbar.setVisible(visible);
                    IdeAction action = IdeAction.find(36);
                    if (action != null) {
                        action.setState(visible);
                    }
                    IdeMainWindow.this.getContentPane().add((Component)IdeMainWindow.this._toolbar, "North");
                }
                return IdeMainWindow.this._toolbar;
            }

            @Override
            public void setToolbarVisible(boolean visible) {
                Toolbar tb = this.getToolbar();
                if (tb != null) {
                    tb.setVisible(visible);
                    Ide.setProperty("MainWindow.Toolbar.visible", visible ? "TRUE" : "FALSE");
                }
            }
        };
        this.registerView(mainWindowView);
        return mainWindowView;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final View getIdeMainWindowView() {
        IdeMainWindow ideMainWindow = this;
        synchronized (ideMainWindow) {
            if (this._view == null) {
                this._view = this.createIdeMainWindowView();
            }
        }
        return this._view;
    }

    public void close() {
        this.setVisible(false);
        this.dispose();
    }

    @Deprecated
    public void updateTitle(Object ctx) {
    }

    public void updateTitle() {
        this.updateTitle(this.getLastActiveView());
    }

    public void setStatusBarVisible(boolean visible) {
        StatusBar statusBar = this.getStatusBar();
        if (statusBar != null) {
            statusBar.getGUI().setVisible(visible);
            Ide.setProperty("MainWindow.Statusbar.visible", visible ? "TRUE" : "FALSE");
        }
    }

    public void preInitialize() {
        super.preInitialize();
        if (this._actionMap != null) {
            this.getRootPane().setActionMap(this._actionMap);
        }
    }

    @Override
    public void initialize() {
        super.initialize();
        this.getInputMap();
        this._viewHandler = new IdeViewHandler();
        this.addActiveViewListener(this._viewHandler);
        this._nodeReloader = new NodeReloader();
        this.addIdeActivationListener(this._nodeReloader);
    }

    protected void postInitialize(IdeArgs ideArgs) {
    }

    public String getMainTitle() {
        return IdeUtil.getProgramName();
    }

    @Deprecated
    public void setMainTitle(String title) {
        IdeUtil.setProgramName(title);
        this.setTitle(this.getMainTitle());
    }

    public Image getMainIcon() {
        return this._mainIcon;
    }

    public void setMainIcon(Image image) {
        this._mainIcon = image;
    }

    public List<? extends Image> getBrandingIcons() {
        return this.m_productIcons;
    }

    public void setBrandingIcons(List<? extends Image> images) {
        this.m_productIcons = images;
        this.setIconImages(images);
    }

    protected final Menubar getMenubar() {
        if (this._menubar == null) {
            this._menubar = this.createMenubar();
        }
        return this._menubar;
    }

    protected Menubar createMenubar() {
        return new MenubarImpl(this.getIdeMainWindowView());
    }

    protected Toolbar createToolbar() {
        Toolbar tb = new Toolbar();
        tb.forcePrimaryViewToolbar(false);
        return tb;
    }

    protected final StatusBar getStatusBar() {
        if (this._statusBar == null) {
            this._statusBar = this.createStatusBar();
            this.updateStatusBarAction();
        }
        return this._statusBar;
    }

    protected void updateStatusBarAction() {
        String visibleProp = Ide.getProperty("MainWindow.Statusbar.visible", "true");
        boolean visible = Boolean.valueOf(visibleProp);
        this.getStatusBar().getGUI().setVisible(visible);
        IdeAction action = IdeAction.find(69);
        if (action != null) {
            action.setState(visible);
        }
    }

    protected StatusBar createStatusBar() {
        return new StatusBarControl();
    }

    protected ActionMap getActionMap() {
        if (this._actionMap == null) {
            this._actionMap = new ActionMap();
            ActionMap original = this.getRootPane().getActionMap();
            this._actionMap.setParent(original);
            this._actionMap.put(MultiInputMap.NULL_ACTION_BIND, MultiInputMap.NULL_ACTION);
            this.getRootPane().setActionMap(this._actionMap);
        }
        return this._actionMap;
    }

    protected InputMap getInputMap() {
        if (this._inputMap == null) {
            this._topInputMap = new MultiInputMap(true);
            KeyStrokeOptions kso = Ide.getSettings().getKeyStrokeOptions();
            kso.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    IdeMainWindow.this.refreshInputMap();
                }
            });
            this._inputMap = this.getRootPane().getInputMap(1);
            this._inputMap.setParent(this._topInputMap);
            this.refreshInputMap();
        }
        return this._inputMap;
    }

    protected final void terminateIde() {
        IdeLayout layout = Layouts.findLayout("Editing");
        if (layout != null && layout != Layouts.getLayouts().getActive()) {
            Layouts.getLayouts().activateLayout(layout);
        }
        Ide.terminate();
    }

    NavigatorWindow getLastActiveNavigator() {
        return this._viewHandler.getLastActiveNavigator();
    }

    Map<Node, Long> getTimestampMap() {
        return this._nodeReloader.getTimestampMap();
    }

    private void refreshInputMap() {
        KeyStrokeOptions kso = Ide.getSettings().getKeyStrokeOptions();
        MultiMapAdapter.fillGlobalMap(this._topInputMap, kso);
    }

    public static final void updateVisibleActions(int updateSource) {
        if (Ide.getMainWindow() != null) {
            Ide.getMainWindow().getIdeMainWindowView().updateVisibleActions(new UpdateMessage(updateSource, null));
        }
    }

    public void requestViewsUpdate() {
    }

    protected void processCommandLine(IdeArgs ideArgs) throws Exception {
        CommandParser.Converter urlConverter = null;
        String[] args = ideArgs.getArgs();
        for (int i = 0; i < args.length; ++i) {
            String arg = args[i];
            if (arg == null || arg.length() <= 0 || arg.startsWith("-")) continue;
            if (urlConverter == null) {
                urlConverter = new CommandParser().getConverter(URL.class);
            }
            URL url = (URL)urlConverter.convert(arg, URL.class);
            Node node = NodeFactory.findOrCreate(url);
            OpenCommand cmd = new OpenCommand();
            cmd.setContext(Context.newIdeContext(node));
            cmd.openURL(url);
        }
    }

    public void beforeShutDown() {
    }

    public void beforeShutDown(int status) {
    }

    public static void showStartupTime() {
        long end = System.currentTimeMillis();
        Long start = Long.getLong("oracle.ide.launcher.startup.time");
        if (start == null || LOG == null) {
            return;
        }
        long result = end - start;
        LOG.log(Level.FINE, "IDE started in " + result + " millisec");
    }

    public void notifyWindowOpened() {
        IdeCore core = Ide.getIdeCore();
        if (core == null) {
            return;
        }
        core.fireMainWindowEvent(2);
    }

    public abstract boolean isFullScreenMode();

    public static boolean isWindowManagerMigrationDisabled() {
        return System.getProperty(WINDOW_MANAGER_MIGRATTION_PROP) != null && !Boolean.getBoolean(WINDOW_MANAGER_MIGRATTION_PROP);
    }

    private static final class NodeReloader
    implements IdeActivationListener {
        private NodeReloader() {
        }

        @Override
        public void activated(IdeActivationEvent e) {
            EnvironOptions envOpts = EnvironOptions.getInstance(Preferences.getPreferences());
            if (envOpts.getAutoReloadExtMod()) {
                NodeUtil.startReloading(envOpts.getSilentReload(), false, true);
            }
        }

        @Override
        public void deactivated(IdeActivationEvent e) {
            EnvironOptions envOpts = EnvironOptions.getInstance(Preferences.getPreferences());
            if (envOpts.getSaveOnDeactivation()) {
                try {
                    SaveAllCommand.saveAll();
                }
                catch (Exception e1) {
                    Assert.printStackTrace((Throwable)e1);
                }
            }
            if (envOpts.getAutoReloadExtMod()) {
                NodeUtil.stopReloading();
            }
        }

        public Map<Node, Long> getTimestampMap() {
            return NodeUtil.getTimeStampMap();
        }
    }

    private static class UpdateVisibleActions
    implements ActionListener {
        private static final int UPDATE_INTERVAL = 250;
        private static Timer _timer;
        private static UpdateMessage _updateMessage;
        private static int updateCount;

        private UpdateVisibleActions() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        static void scheduleUpdate(UpdateMessage updateMessage) {
            Class<UpdateVisibleActions> clazz = UpdateVisibleActions.class;
            synchronized (UpdateVisibleActions.class) {
                if (_timer == null) {
                    _timer = new Timer(250, new UpdateVisibleActions());
                    _timer.setRepeats(false);
                }
                _timer.restart();
                _updateMessage = updateMessage;
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void actionPerformed(ActionEvent e) {
            Class<UpdateVisibleActions> clazz = UpdateVisibleActions.class;
            synchronized (UpdateVisibleActions.class) {
                _timer = null;
                UpdateMessage updateMessage = _updateMessage;
                _updateMessage = null;
                // ** MonitorExit[var3_2] (shouldn't be in output)
                this.fireUpdate(updateMessage);
                return;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void fireUpdate(UpdateMessage updateMessage) {
            ++updateCount;
            String ALL_ID = "IdeMainWindow.updateVisibleActions";
            String VIEW_ID = "IdeMainWindow.updateVisibleActions/view";
            PerformanceLogger logger = PerformanceLogger.get();
            logger.startTiming("IdeMainWindow.updateVisibleActions");
            try {
                IdeMainWindow mainWindow = Ide.getMainWindow();
                if (mainWindow != null) {
                    for (View view : mainWindow.getVisibleViews()) {
                        logger.startTiming("IdeMainWindow.updateVisibleActions/view");
                        if (view != mainWindow.getIdeMainWindowView()) {
                            view.updateVisibleActions(updateMessage);
                        } else {
                            View.updateToolbarActions(view.getToolbar());
                        }
                        logger.stopTiming("IdeMainWindow.updateVisibleActions/view", 20, "Updated view {0}", new Object[]{view});
                    }
                }
            }
            catch (Throwable throwable) {
                logger.stopTiming("IdeMainWindow.updateVisibleActions", 20, "Updated all views ({0})", new Object[]{updateCount});
                throw throwable;
            }
            logger.stopTiming("IdeMainWindow.updateVisibleActions", 20, "Updated all views ({0})", new Object[]{updateCount});
        }

        static {
            updateCount = 0;
        }
    }

    public static interface ControllerContext {
        public List getControllerProviders(View var1);
    }
}

