/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.insight.completion.ui;

import java.awt.Color;
import java.awt.Font;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.UIManager;
import oracle.ide.insight.completion.CompletionContext;
import oracle.ide.insight.completion.ui.DetailView;
import oracle.ide.insight.completion.ui.InsightCellRenderer;
import oracle.ide.insight.completion.ui.InsightPopup;
import oracle.javatools.ui.ColorUtils2;

public class InsightViewCustomizer {
    private JList list;
    public static final Color DEFAULT_BACKGROUND = UIManager.getColor("ToolTip.background");
    private Color regularBackground = DEFAULT_BACKGROUND;
    private Color preferredBackground = ColorUtils2.getTetrad((Color)DEFAULT_BACKGROUND, (int)3);
    private Color preferredBackgroundSelected = UIManager.getColor("List.selectionBackground");
    private Font optionsFont = InsightPopup.OPTIONS_FONT;
    private JComponent options = null;
    private CompletionContext insightContext;
    private DetailView detailView = null;
    private boolean showFilterByOption = true;
    private RelativeLocation relativeLocation = RelativeLocation.SOUTH;

    public InsightViewCustomizer(JList list, CompletionContext insightContext) {
        this.list = list;
        this.insightContext = insightContext;
        list.setCellRenderer(new InsightCellRenderer(this));
    }

    public final void setRelativeLocation(RelativeLocation relativeLocation) {
        this.relativeLocation = relativeLocation;
    }

    public final RelativeLocation getRelativeLocation() {
        return this.relativeLocation;
    }

    public void setRenderer(ListCellRenderer renderer) {
        this.list.setCellRenderer(renderer);
    }

    public ListCellRenderer getRenderer() {
        return this.list.getCellRenderer();
    }

    public void setPreferredBackground(Color preferredBackground) {
        this.preferredBackground = preferredBackground;
    }

    public Color getPreferredBackground() {
        return this.preferredBackground;
    }

    public void setRegularBackground(Color regularBackground) {
        this.regularBackground = regularBackground;
    }

    public Color getRegularBackground() {
        return this.regularBackground;
    }

    public void setPreferredSelectionBackground(Color preferredBackgroundSelected) {
        this.preferredBackgroundSelected = preferredBackgroundSelected;
    }

    public Color getPreferredSelectionBackground() {
        return this.preferredBackgroundSelected;
    }

    public void setForeground(Color foreground) {
        this.list.setForeground(foreground);
    }

    public Color getForeground() {
        return this.list.getForeground();
    }

    public void setFont(Font font) {
        this.list.setFont(font);
    }

    public Font getFont() {
        return this.list.getFont();
    }

    void setOptionsFont(Font optionsFont) {
        this.list.setFont(optionsFont);
    }

    public Font getOptionsFont() {
        return this.optionsFont;
    }

    public void setOptions(JComponent options) {
        this.options = options;
    }

    JComponent getOptions() {
        return this.options;
    }

    public CompletionContext getInsightContext() {
        return this.insightContext;
    }

    public void setDetailView(DetailView detailView) {
        this.detailView = detailView;
    }

    DetailView getDetailView() {
        return this.detailView;
    }

    public void repaint() {
        this.list.repaint();
    }

    public final void setShowFilterByOption(boolean showFilterByOption) {
        this.showFilterByOption = showFilterByOption;
    }

    public final boolean isShowFilterByOption() {
        return this.showFilterByOption;
    }

    public static enum RelativeLocation {
        SOUTH,
        NORTH;

        private static final int[] SOUTH_LOCATIONS;
        private static final int[] NORTH_LOCATIONS;

        public int[] getLocations() {
            switch (this) {
                case NORTH: {
                    return NORTH_LOCATIONS;
                }
                case SOUTH: {
                    return SOUTH_LOCATIONS;
                }
            }
            return SOUTH_LOCATIONS;
        }

        static {
            SOUTH_LOCATIONS = new int[]{8, 4};
            NORTH_LOCATIONS = new int[]{4, 8};
        }
    }
}

