/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.insight.completion.ui;

import java.awt.BorderLayout;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.UIManager;
import javax.swing.text.BadLocationException;
import javax.swing.text.JTextComponent;
import oracle.ide.insight.InsightBundle;
import oracle.ide.insight.InsightContext;
import oracle.ide.insight.completion.ui.InsightViewCustomizer;
import oracle.javatools.icons.OracleIcons;
import oracle.javatools.ui.popup.PopupWindow;
import oracle.javatools.ui.popup.PopupWindowListener;
import oracle.javatools.ui.popup.PopupWindowManager;

public final class BusyPopup {
    private JTextComponent textComponent;
    private Rectangle caretRect;
    private PopupWindow busyPopup;
    private static final String BUSY_POPUP = "busy popup";
    private State state = State.HIDE;
    private Timer waitTimer = new Timer(1000, new AbstractAction(){

        @Override
        public void actionPerformed(ActionEvent e) {
            BusyPopup.this.reallyShow();
        }
    });
    private JPanel content;

    public BusyPopup() {
        this.waitTimer.setRepeats(false);
        this.content = new JPanel(new BorderLayout());
        this.content.setBorder(UIManager.getBorder("ToolTip.border"));
        this.content.setBackground(InsightViewCustomizer.DEFAULT_BACKGROUND);
        JLabel label = new JLabel(InsightBundle.get("INSIGHT_LOADING"), OracleIcons.getIcon((String)"gutter/throbber_small.gif"), 0);
        label.setBorder(BorderFactory.createEmptyBorder(0, 1, 0, 1));
        label.setFont(label.getFont().deriveFont(2, 11.0f));
        this.content.add(label);
    }

    public void hide() {
        if (!SwingUtilities.isEventDispatchThread()) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    BusyPopup.this.hide();
                }
            });
            return;
        }
        if (this.busyPopup != null) {
            PopupWindowManager.dismissPopup((PopupWindow)this.busyPopup);
        }
        this.hidden();
    }

    private void hidden() {
        this.state = State.HIDE;
        this.busyPopup = null;
    }

    public void show(InsightContext insightContext) {
        if (this.state != State.HIDE) {
            this.hidden();
            return;
        }
        this.state = State.WAIT;
        try {
            this.textComponent = insightContext.getTextComponent();
            this.caretRect = this.textComponent.modelToView(this.textComponent.getCaretPosition());
            this.waitTimer.restart();
        }
        catch (BadLocationException e) {
            Logger.getLogger("global").log(Level.SEVERE, "Can't position busy insight", e);
        }
    }

    private void reallyShow() {
        if (this.state != State.WAIT) {
            this.hidden();
            return;
        }
        if (this.textComponent == null || !this.textComponent.isShowing()) {
            this.hidden();
            return;
        }
        for (PopupWindow w : PopupWindowManager.getPopupWindows((JComponent)this.textComponent)) {
            if (!w.getWindow().isShowing() || w.getClientProperty((Object)BUSY_POPUP) != Boolean.TRUE) continue;
            PopupWindowManager.dismissPopup((PopupWindow)w);
        }
        this.busyPopup = PopupWindowManager.showPopup((JComponent)this.textComponent, (JComponent)this.content, (boolean)false, (Rectangle)this.caretRect, (int[])new int[]{8}, (boolean)true);
        this.busyPopup.putClientProperty((Object)"popup-key-insight", (Object)Boolean.TRUE);
        this.busyPopup.putClientProperty((Object)BUSY_POPUP, (Object)Boolean.TRUE);
        this.busyPopup.addPopupWindowListener(new PopupWindowListener(){

            public void popupClosed(PopupWindow popupWindow, int how) {
                popupWindow.removePopupWindowListener((PopupWindowListener)this);
                BusyPopup.this.hidden();
            }

            public void parentFocusGained(PopupWindow popupWindow) {
            }

            public void parentFocusLost(PopupWindow popupWindow, boolean isTemporary) {
            }
        });
        this.state = State.SHOW;
    }

    private static enum State {
        HIDE,
        WAIT,
        SHOW;

    }
}

