/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.bookmarks;

import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.AbstractButton;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JRadioButton;
import oracle.ide.Ide;
import oracle.ide.bookmarks.BookmarkOptions;
import oracle.ide.bookmarks.Bookmarks;
import oracle.ide.panels.ApplyEvent;
import oracle.ide.panels.ApplyListener;
import oracle.ide.panels.DefaultTraversablePanel;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;
import oracle.ide.util.ResourceUtils;

final class BookmarkOptionsPanel
extends DefaultTraversablePanel
implements ApplyListener {
    private JCheckBox checkbox_discardClose;
    private JCheckBox checkbox_discardExit;
    private JRadioButton radio_traverseCurrent;
    private JRadioButton radio_traverseOpen;
    private JRadioButton radio_traverseAll;
    private JRadioButton radio_missingMove;
    private JRadioButton radio_missingDiscard;

    public BookmarkOptionsPanel() {
        this.setHelpID("f1_idedidesetbookmarks_html");
        this.setLayout(new GridBagLayout());
        this.initializeComponent();
    }

    public void onEntry(TraversableContext tc) {
        BookmarkOptions options = this.findOptions(tc);
        this.loadSettingsFrom(options);
    }

    public void onExit(TraversableContext tc) throws TraversalException {
        BookmarkOptions options = this.findOptions(tc);
        this.saveSettingsTo(options);
    }

    private BookmarkOptions findOptions(TraversableContext tc) {
        BookmarkOptions options = BookmarkOptions.getInstance(tc.getPropertyStorage());
        return options;
    }

    public void apply(ApplyEvent event) {
        TraversableContext tc = (TraversableContext)event.getSource();
        BookmarkOptions options = this.findOptions(tc);
        BookmarkOptionsPanel.applyOptions(options);
    }

    public void cancel(ApplyEvent e) {
    }

    public static void applyOptions(BookmarkOptions options) {
    }

    void loadSettingsFrom(BookmarkOptions options) {
        boolean discardClose = options.getDiscardOnClose();
        boolean discardExit = options.getDiscardOnExit();
        int traverseBehavior = options.getTraverseBehavior();
        int missingBehavior = options.getMissingLineBehavior();
        this.checkbox_discardClose.setSelected(discardClose);
        this.checkbox_discardExit.setSelected(discardExit);
        switch (traverseBehavior) {
            case 1: {
                this.radio_traverseCurrent.setSelected(true);
                break;
            }
            case 2: {
                this.radio_traverseOpen.setSelected(true);
                break;
            }
            case 3: {
                this.radio_traverseAll.setSelected(true);
                break;
            }
            default: {
                throw new IllegalStateException("behavior: " + traverseBehavior);
            }
        }
        switch (missingBehavior) {
            case 1: {
                this.radio_missingMove.setSelected(true);
                break;
            }
            case 2: {
                this.radio_missingDiscard.setSelected(true);
                break;
            }
            default: {
                throw new IllegalStateException("behavior: " + missingBehavior);
            }
        }
    }

    void saveSettingsTo(BookmarkOptions options) throws TraversalException {
        boolean discardClose = this.checkbox_discardClose.isSelected();
        boolean discardExit = this.checkbox_discardExit.isSelected();
        int traverseBehavior = 1;
        if (this.radio_traverseOpen.isSelected()) {
            traverseBehavior = 2;
        } else if (this.radio_traverseAll.isSelected()) {
            traverseBehavior = 3;
        }
        int missingBehavior = 1;
        if (this.radio_missingDiscard.isSelected()) {
            missingBehavior = 2;
        }
        options.setDiscardOnClose(discardClose);
        options.setDiscardOnExit(discardExit);
        options.setTraverseBehavior(traverseBehavior);
        options.setMissingLineBehavior(missingBehavior);
    }

    private void initializeComponent() {
        String discardCloseText = Bookmarks.get("CHECKBOX_DISCARD_CLOSE");
        this.checkbox_discardClose = new JCheckBox();
        ResourceUtils.resButton((AbstractButton)this.checkbox_discardClose, (String)discardCloseText);
        String discardExitText = Bookmarks.format("CHECKBOX_DISCARD_EXIT", Ide.getProgramShortName());
        this.checkbox_discardExit = new JCheckBox();
        ResourceUtils.resButton((AbstractButton)this.checkbox_discardExit, (String)discardExitText);
        String traverseText = Bookmarks.get("LABEL_TRAVERSE");
        JLabel label_traverse = new JLabel(traverseText);
        String traverseCurrentText = Bookmarks.get("RADIO_CURRENT");
        String traverseOpenText = Bookmarks.get("RADIO_OPEN");
        String traverseAllText = Bookmarks.get("RADIO_ALL");
        this.radio_traverseCurrent = new JRadioButton();
        this.radio_traverseOpen = new JRadioButton();
        this.radio_traverseAll = new JRadioButton();
        ResourceUtils.resButton((AbstractButton)this.radio_traverseCurrent, (String)traverseCurrentText);
        ResourceUtils.resButton((AbstractButton)this.radio_traverseOpen, (String)traverseOpenText);
        ResourceUtils.resButton((AbstractButton)this.radio_traverseAll, (String)traverseAllText);
        ButtonGroup group_traverse = new ButtonGroup();
        group_traverse.add(this.radio_traverseCurrent);
        group_traverse.add(this.radio_traverseOpen);
        group_traverse.add(this.radio_traverseAll);
        String missingText = Bookmarks.get("LABEL_EXIST");
        JLabel label_missing = new JLabel(missingText);
        String missingMoveText = Bookmarks.get("RADIO_MOVE");
        String missingDiscardText = Bookmarks.get("RADIO_REMOVE");
        this.radio_missingMove = new JRadioButton();
        this.radio_missingDiscard = new JRadioButton();
        ResourceUtils.resButton((AbstractButton)this.radio_missingMove, (String)missingMoveText);
        ResourceUtils.resButton((AbstractButton)this.radio_missingDiscard, (String)missingDiscardText);
        ButtonGroup group_missing = new ButtonGroup();
        group_missing.add(this.radio_missingMove);
        group_missing.add(this.radio_missingDiscard);
        Insets indentedInsets = new Insets(0, 30, 2, 5);
        Insets defaultInsets = new Insets(2, 5, 2, 5);
        Insets emptyInsets = new Insets(0, 0, 0, 0);
        GridBagConstraints constraints = new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 0, defaultInsets, 0, 0);
        this.add(this.checkbox_discardClose, constraints);
        constraints = new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 17, 0, defaultInsets, 0, 0);
        this.add(this.checkbox_discardExit, constraints);
        constraints = new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 17, 1, defaultInsets, 0, 0);
        this.add(Box.createVerticalStrut(5), constraints);
        constraints = new GridBagConstraints(0, 3, 1, 1, 1.0, 0.0, 17, 0, defaultInsets, 0, 0);
        this.add(label_traverse, constraints);
        constraints = new GridBagConstraints(0, 4, 1, 1, 1.0, 0.0, 17, 0, indentedInsets, 0, 0);
        this.add(this.radio_traverseCurrent, constraints);
        constraints = new GridBagConstraints(0, 5, 1, 1, 1.0, 0.0, 17, 0, indentedInsets, 0, 0);
        this.add(this.radio_traverseOpen, constraints);
        constraints = new GridBagConstraints(0, 6, 1, 1, 1.0, 0.0, 17, 0, indentedInsets, 0, 0);
        this.add(this.radio_traverseAll, constraints);
        constraints = new GridBagConstraints(0, 7, 1, 1, 1.0, 0.0, 17, 1, defaultInsets, 0, 0);
        this.add(Box.createVerticalStrut(5), constraints);
        constraints = new GridBagConstraints(0, 11, 1, 1, 1.0, 1.0, 17, 1, emptyInsets, 0, 0);
        this.add(Box.createGlue(), constraints);
    }
}

