/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.worksheet.editor;

import com.adbs.querybuilder.QueryBuilder;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.net.URL;
import java.sql.Connection;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.InputMap;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import oracle.bali.share.nls.StringUtils;
import oracle.dbtools.proformatter.SQLDevFormatter;
import oracle.dbtools.raptor.backgroundTask.IRaptorTaskListener;
import oracle.dbtools.raptor.backgroundTask.IRaptorTaskRunMode;
import oracle.dbtools.raptor.backgroundTask.IRaptorTaskStatus;
import oracle.dbtools.raptor.backgroundTask.RaptorTask;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskAdapter;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskDescriptor;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskEvent;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskManager;
import oracle.dbtools.raptor.backgroundTask.TaskException;
import oracle.dbtools.raptor.backgroundTask.internal.SimpleRaptorTaskUI;
import oracle.dbtools.raptor.backgroundTask.ui.ITaskUI;
import oracle.dbtools.raptor.backgroundTask.ui.ITaskViewer;
import oracle.dbtools.raptor.config.DBConfig;
import oracle.dbtools.raptor.controls.ConnectionSelectorUI;
import oracle.dbtools.raptor.controls.IDBConnectionComboBoxListener;
import oracle.dbtools.raptor.controls.UIUtils;
import oracle.dbtools.raptor.editors.IDBEditor;
import oracle.dbtools.raptor.navigator.plsql.GoToSrc;
import oracle.dbtools.raptor.newscriptrunner.IGetHandlePauseProvider;
import oracle.dbtools.raptor.newscriptrunner.IGetPromptedConnectFieldsProvider;
import oracle.dbtools.raptor.newscriptrunner.IGetPromptedFieldProvider;
import oracle.dbtools.raptor.newscriptrunner.IGetPromptedPasswordFieldsProvider;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.plsql.BackgroundParser;
import oracle.dbtools.raptor.plsql.EquippedWithParser;
import oracle.dbtools.raptor.proformatter.ICoreFormatter;
import oracle.dbtools.raptor.scriptrunner.GuiScriptRunnerContext;
import oracle.dbtools.raptor.utils.ConnectionCanceledException;
import oracle.dbtools.raptor.utils.Connections;
import oracle.dbtools.raptor.utils.ExceptionHandler;
import oracle.dbtools.worksheet.ActionProvider;
import oracle.dbtools.worksheet.TextView;
import oracle.dbtools.worksheet.WorksheetAction;
import oracle.dbtools.worksheet.WorksheetContext;
import oracle.dbtools.worksheet.WorksheetResources;
import oracle.dbtools.worksheet.WorksheetResultPanel;
import oracle.dbtools.worksheet.WorksheetTaskWrapper;
import oracle.dbtools.worksheet.commands.autotrace.AutotracePanel;
import oracle.dbtools.worksheet.commands.scriptrunner.providers.GuiHandlePauseProvider;
import oracle.dbtools.worksheet.commands.scriptrunner.providers.GuiHandleSetPauseProvider;
import oracle.dbtools.worksheet.commands.scriptrunner.providers.GuiPromptedAcceptProvider;
import oracle.dbtools.worksheet.commands.scriptrunner.providers.GuiPromptedConnectFieldsProvider;
import oracle.dbtools.worksheet.commands.scriptrunner.providers.GuiPromptedPasswordFieldsProvider;
import oracle.dbtools.worksheet.commands.scriptrunner.providers.GuiPromptedSubstitutionProvider;
import oracle.dbtools.worksheet.commands.scriptrunner.task.RunScriptPanel;
import oracle.dbtools.worksheet.commands.sqltuningadvisor.SqlTuningAdvisorPanel;
import oracle.dbtools.worksheet.editor.ConnComboBox;
import oracle.dbtools.worksheet.editor.ConnKeySelectionManager;
import oracle.dbtools.worksheet.editor.WorksheetGUI;
import oracle.dbtools.worksheet.editor.WorksheetTabbedPane;
import oracle.dbtools.worksheet.extension.WorksheetHook;
import oracle.dbtools.worksheet.extension.WorksheetURLFileSystemHelper;
import oracle.dbtools.worksheet.sqlhistory.db.HistoryDB;
import oracle.dbtools.worksheet.utils.WorksheetUtil;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.ceditor.CodeEditorConstants;
import oracle.ide.ceditor.find.AbstractFindToolbarController;
import oracle.ide.ceditor.find.BasicFindToolbarController;
import oracle.ide.ceditor.find.FindToolbarController;
import oracle.ide.cmd.ExitCommand;
import oracle.ide.cmd.ShutdownHook;
import oracle.ide.controller.ContextMenu;
import oracle.ide.controller.ContextMenuListener;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.controls.ActionMenuToolButton;
import oracle.ide.controls.ToggleAction;
import oracle.ide.controls.ToolButton;
import oracle.ide.controls.Toolbar;
import oracle.ide.db.model.SqlNode;
import oracle.ide.editor.Editor;
import oracle.ide.editor.EditorManager;
import oracle.ide.help.HelpInfo;
import oracle.ide.keyboard.KeyStrokeContext;
import oracle.ide.keyboard.KeyStrokeContextRegistry;
import oracle.ide.keyboard.KeyStrokeMap;
import oracle.ide.keyboard.KeyStrokeOptions;
import oracle.ide.keyboard.KeyStrokes;
import oracle.ide.keyboard.MultiInputMap;
import oracle.ide.keyboard.MultiMapAdapter;
import oracle.ide.layout.ViewId;
import oracle.ide.log.AbstractLogPage;
import oracle.ide.log.DefaultLogPage;
import oracle.ide.log.LogManager;
import oracle.ide.model.ElementAttributes;
import oracle.ide.model.Node;
import oracle.ide.model.UpdateMessage;
import oracle.ide.net.DefaultNameGenerator;
import oracle.ide.net.NameGenerator;
import oracle.ide.net.URLFactory;
import oracle.ide.view.StatusProvider;
import oracle.ide.view.View;
import oracle.javatools.buffer.ExpiredTextBufferException;
import oracle.javatools.buffer.LineMap;
import oracle.javatools.db.DBException;
import oracle.javatools.db.Database;
import oracle.javatools.editor.BasicCaret;
import oracle.javatools.editor.BasicDocument;
import oracle.javatools.editor.BasicEditorPane;
import oracle.javatools.editor.BasicEditorPaneContainer;
import oracle.javatools.editor.EditorSelection;
import oracle.javatools.editor.EditorSelectionColumns;
import oracle.javatools.editor.EditorSelectionWrap;
import oracle.javatools.icons.OracleIcons;
import oracle.javatools.util.ModelUtil;
import oracle.javatools.util.StringUtil;
import oracle.jdeveloper.JDeveloperMenuConstants;
import org.jdesktop.jxlayer.JXLayer;

public class Worksheet
extends Editor
implements BasicEditorPaneContainer,
StatusProvider,
IDBEditor,
TextView,
EquippedWithParser,
GoToSrc {
    public static final String SCRIPRUNNERCONTEXT = "ScriptRunnerContext";
    public static final String GUISCRIPRUNNERCONTEXT = "GuiScriptRunnerContext";
    public static final String GLOGIN = "GLOGIN";
    private static Object LOCKPROPERTYUPDATE = new Object();
    private ConnectionOpener connOpener = null;
    public static final String ACCEL_FILE = "oracle/dbtools/worksheet/editor/accelerators.xml";
    private static final Logger LOGGER = Logger.getLogger(Worksheet.class.getName());
    private static SqlWorksheetLogPage m_logpage;
    private static CL s_listener;
    protected Map<String, IdeAction> m_actionMap = new HashMap<String, IdeAction>();
    private ChangeListener m_cl;
    private ConnComboBox m_connCombo;
    protected Controller m_controller = new WorksheetController();
    protected Set<WorksheetAction> m_ctxMenuActions = new TreeSet<WorksheetAction>();
    private WorksheetGUI m_gui;
    protected Map<String, ActionProvider<?>> m_idMap = new HashMap();
    private boolean m_isBusy;
    private JPanel m_progressPanel;
    protected List<ActionProvider<?>> m_providers = new ArrayList();
    private ToolbarTaskViewer m_taskViewer = new ToolbarTaskViewer();
    private ButtonToolbarTaskViewer m_buttonTaskViewer = new ButtonToolbarTaskViewer();
    private JLabel m_timingLable;
    protected Toolbar m_toolbar;
    protected Set<WorksheetAction> m_toolbarActions = new TreeSet<WorksheetAction>();
    private static ShutdownHook worksheetShutdownHook;
    private JPanel topMargin;
    private ConnOpenListener connOpenListener = new ConnOpenListener();
    private BasicFindToolbarController findToolbarController;

    private static boolean canPerformCut(Component component) {
        if (component instanceof JTextComponent) {
            if (component instanceof BasicEditorPane) {
                return ((BasicEditorPane)component).canCut();
            }
            JTextComponent jTextComponent = (JTextComponent)component;
            return jTextComponent.isEditable() && jTextComponent.isEnabled() && Worksheet.hasSelection(jTextComponent);
        }
        return false;
    }

    private static boolean canPerformPaste(Component component) {
        if (component instanceof JTextComponent) {
            if (component instanceof BasicEditorPane) {
                return ((BasicEditorPane)component).canPaste();
            }
            JTextComponent jTextComponent = (JTextComponent)component;
            return jTextComponent.isEnabled() && jTextComponent.isEditable();
        }
        return false;
    }

    private static boolean canPerformSelectAll(Component component) {
        if (component instanceof JTextComponent) {
            JTextComponent jTextComponent = (JTextComponent)component;
            return jTextComponent.isEnabled();
        }
        return component instanceof JTable;
    }

    private static boolean hasSelection(JTextComponent jTextComponent) {
        int n;
        int n2 = jTextComponent.getSelectionStart();
        return n2 != (n = jTextComponent.getSelectionEnd());
    }

    protected static void maybeInitListener() {
        if (s_listener == null) {
            s_listener = new CL();
            EditorManager.getEditorManager().getContextMenu().addContextMenuListener((ContextMenuListener)s_listener);
        }
    }

    public Worksheet() {
        Worksheet.maybeInitListener();
        this.initActions();
        try {
            HistoryDB.getInstance();
        }
        catch (Exception exception) {
            System.out.println("HistoryDB.getInstance() failed: " + exception.getMessage());
        }
    }

    protected void addButtons(String[] stringArray) {
        if (stringArray.length == 1) {
            IdeAction ideAction = this.m_actionMap.get(stringArray[0]).newLocalAction((View)this);
            this.setupAcceleratorToolTip(ideAction);
            ToolButton toolButton = this.m_toolbar.add((ToggleAction)ideAction);
            toolButton.setName(ideAction.getValue("Name").toString());
            this.m_toolbar.add((Component)toolButton);
        } else {
            Component[] componentArray;
            IdeAction[] ideActionArray = new IdeAction[stringArray.length - 1];
            IdeAction ideAction = this.m_actionMap.get(stringArray[0]);
            this.setupAcceleratorToolTip(ideAction);
            for (int i = 1; i < stringArray.length; ++i) {
                componentArray = this.m_actionMap.get(stringArray[i]);
                if (componentArray == null) continue;
                ideActionArray[i - 1] = componentArray;
            }
            ActionMenuToolButton actionMenuToolButton = new ActionMenuToolButton((Action)ideAction);
            actionMenuToolButton.setMenuActions((Action[])ideActionArray);
            this.m_toolbar.add((Component)actionMenuToolButton);
            for (Component component : componentArray = actionMenuToolButton.getPopup().getComponents()) {
                AbstractButton abstractButton;
                IdeAction ideAction2;
                if (!(component instanceof AbstractButton) || (ideAction2 = (IdeAction)(abstractButton = (AbstractButton)component).getAction()) == null) continue;
                if (ideAction2 instanceof IdeAction) {
                    UIUtils.setupAccelerator((IdeAction)ideAction2);
                }
                abstractButton.setName(ideAction2.getValue("Name").toString());
            }
        }
    }

    private void setupAcceleratorToolTip(IdeAction ideAction) {
        try {
            KeyStrokeOptions keyStrokeOptions = Ide.getSettings().getKeyStrokeOptions();
            KeyStrokeContextRegistry keyStrokeContextRegistry = Ide.getKeyStrokeContextRegistry();
            KeyStrokeMap keyStrokeMap = keyStrokeOptions.getLocalKeyMap(keyStrokeContextRegistry.getContext(ACCEL_FILE));
            List list = keyStrokeMap.getKeyStrokesFor(ideAction.getCommandId());
            if (list != null && list.size() > 0) {
                String string = StringUtil.textWithoutMnemonic((Action)ideAction);
                KeyStrokes keyStrokes = (KeyStrokes)list.get(0);
                StringBuffer stringBuffer = new StringBuffer(20);
                stringBuffer.append(" (");
                for (int i = 0; i < keyStrokes.getLength(); ++i) {
                    KeyStroke keyStroke = keyStrokes.getKeyStroke(i);
                    if (keyStroke == null) continue;
                    String string2 = KeyEvent.getKeyModifiersText(keyStroke.getModifiers());
                    if (string2 != null && string2.length() > 0) {
                        stringBuffer.append(string2);
                        stringBuffer.append("+");
                    }
                    stringBuffer.append(KeyEvent.getKeyText(keyStroke.getKeyCode()));
                }
                stringBuffer.append(")");
                ideAction.putValueDirectly("last-tooltip-suffix", (Object)stringBuffer.toString());
            }
        }
        catch (Exception exception) {
            LOGGER.log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
        }
    }

    @Override
    public void appendText(String string) {
        if (string == null) {
            return;
        }
        BasicEditorPane basicEditorPane = this.getFocusedEditorPane();
        if (basicEditorPane.isEditable()) {
            Document document = basicEditorPane.getDocument();
            try {
                document.insertString(basicEditorPane.getCaretPosition(), string, null);
                basicEditorPane.requestFocusInWindow();
            }
            catch (BadLocationException badLocationException) {
                LOGGER.log(Level.WARNING, badLocationException.getStackTrace()[0].toString(), badLocationException);
            }
        }
    }

    private boolean canPerformCopy(Component component) {
        if (component instanceof JTextComponent) {
            if (component instanceof BasicEditorPane) {
                return ((BasicEditorPane)component).canCopy();
            }
            JTextComponent jTextComponent = (JTextComponent)component;
            return jTextComponent.isEnabled() && Worksheet.hasSelection(jTextComponent);
        }
        return false;
    }

    private boolean canPerformDelete(Component component) {
        if (component instanceof JTextComponent) {
            JTextComponent jTextComponent = (JTextComponent)component;
            return jTextComponent.isEnabled() && jTextComponent.isEditable();
        }
        return false;
    }

    public void close() {
        super.close();
        WorksheetTabbedPane worksheetTabbedPane = this.m_gui.getWorksheetTabbedPane();
        try {
            worksheetTabbedPane.removeAllTabs();
        }
        catch (Exception exception) {
            LOGGER.log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
        }
        this.releaseGUI();
    }

    public boolean closeOnConnDisconnect() {
        return DBConfig.getInstance().getBoolean("WORKSHEETCLOSE");
    }

    private ConnComboBox createCombo() {
        ConnComboBox connComboBox = new ConnComboBox();
        String string = this.getConnectionFromContext();
        if (string != null) {
            connComboBox.setCurrentConnection(string);
            this.m_gui.updateWorksheetConnection(string);
            ((WorksheetGUI)this.getGUI()).invokeInsight(string);
        }
        return connComboBox;
    }

    public void setComboConnection(String string) {
        this.m_connCombo.setCurrentConnection(string);
    }

    private void createGUI() {
        this.m_gui = new WorksheetGUI(this);
        for (ActionProvider<?> actionProvider : this.m_providers) {
            int n = actionProvider.getPanelCount();
            for (int i = 0; i < n; ++i) {
                this.m_gui.addPanel(actionProvider.getPanelAt(i));
            }
        }
        final KeyStrokeOptions keyStrokeOptions = Ide.getSettings().getKeyStrokeOptions();
        this.m_cl = new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                if (changeEvent.getSource() == keyStrokeOptions) {
                    Worksheet.this.updateKeyMap(keyStrokeOptions);
                }
            }
        };
        keyStrokeOptions.addChangeListener(this.m_cl);
        this.updateKeyMap(keyStrokeOptions);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected WorksheetContext createWorksheetContext() {
        WorksheetContext worksheetContext = new WorksheetContext();
        this.m_gui.updateContext(worksheetContext);
        String string = this.getConnectionName();
        if (ModelUtil.hasLength((String)string)) {
            worksheetContext.setConnectionName(string);
        }
        worksheetContext.setTaskViewer(this.m_taskViewer);
        worksheetContext.setButtonTaskViewer(this.m_buttonTaskViewer);
        URL uRL = this.getContext().getNode().getURL();
        worksheetContext.setFileURL(uRL);
        worksheetContext.setIsTemporaryFile(WorksheetURLFileSystemHelper.isWorksheetURL(uRL));
        if (worksheetContext.isTemporaryFile()) {
            this.getContext().getNode().getAttributes().unset(ElementAttributes.EDITOR_SAVEABLE_AS);
        }
        worksheetContext.setProviders(this.m_idMap);
        worksheetContext.setBusy(this.m_isBusy);
        Object object = worksheetContext.getEditor().getProperty(SCRIPRUNNERCONTEXT);
        GuiScriptRunnerContext guiScriptRunnerContext = (GuiScriptRunnerContext)object;
        if (guiScriptRunnerContext == null) {
            Object object2 = LOCKPROPERTYUPDATE;
            synchronized (object2) {
                Properties properties = Connections.getInstance().getConnectionInfo(worksheetContext.getConnectionName());
                GuiScriptRunnerContext guiScriptRunnerContext2 = null;
                if (properties != null) {
                    guiScriptRunnerContext2 = (GuiScriptRunnerContext)properties.get(GLOGIN);
                }
                if ((guiScriptRunnerContext = guiScriptRunnerContext2 == null ? (GuiScriptRunnerContext)worksheetContext.getEditor().getProperty(SCRIPRUNNERCONTEXT) : guiScriptRunnerContext2.clone()) == null) {
                    guiScriptRunnerContext = new GuiScriptRunnerContext();
                    guiScriptRunnerContext.setPromptedFieldProvider((IGetPromptedFieldProvider)new GuiPromptedAcceptProvider());
                    guiScriptRunnerContext.setSubstitutionFieldProvider((IGetPromptedFieldProvider)new GuiPromptedSubstitutionProvider());
                    guiScriptRunnerContext.setPasswordFieldsProvider((IGetPromptedPasswordFieldsProvider)new GuiPromptedPasswordFieldsProvider());
                    guiScriptRunnerContext.setConnectFieldsProvider((IGetPromptedConnectFieldsProvider)new GuiPromptedConnectFieldsProvider());
                    guiScriptRunnerContext.setHandlePauseProvider((IGetHandlePauseProvider)new GuiHandlePauseProvider());
                    guiScriptRunnerContext.setHandleSetPauseProvider((IGetHandlePauseProvider)new GuiHandleSetPauseProvider());
                    guiScriptRunnerContext.setSQLPlusFormatter((ICoreFormatter)new SQLDevFormatter());
                    guiScriptRunnerContext.setSQLPlusCodingStyleOptions(null);
                }
                worksheetContext.getEditor().putProperty(SCRIPRUNNERCONTEXT, (Object)guiScriptRunnerContext);
                worksheetContext.setScriptRunnerContext((ScriptRunnerContext)guiScriptRunnerContext);
            }
        } else {
            worksheetContext.setScriptRunnerContext((ScriptRunnerContext)guiScriptRunnerContext);
        }
        guiScriptRunnerContext.node = this.getContext().getNode();
        worksheetContext.setQueryBuilderEditPanel(this.m_gui.getQueryBuilderEditPanel());
        return worksheetContext;
    }

    public String getConnectionName() {
        return this.m_connCombo != null ? this.m_connCombo.getCurrentConnectionName() : this.getConnectionFromContext();
    }

    private String getConnectionFromContext() {
        return this._context != null ? (String)this._context.getProperty("Connections.db_name") : null;
    }

    public synchronized Context getContext(EventObject eventObject) {
        Context context = super.getContext(eventObject);
        if (context != null && this.m_connCombo != null) {
            context.setProperty("Connections.db_name", (Object)this.m_connCombo.getCurrentConnectionName());
        }
        return context;
    }

    private URL getNewURL() {
        URL uRL = URLFactory.newDirURL((String)Ide.getTrueUserHomeDirectory());
        URL uRL2 = URLFactory.newUniqueURL((URL)uRL, (NameGenerator)new DefaultNameGenerator("Untitled", ".sql", -1));
        return uRL2;
    }

    public Controller getController() {
        return this.m_controller;
    }

    public JComponent[] getCustomCells() {
        if (this.m_gui != null) {
            return this.m_gui.getEdtiorStatusBar().getStatusBarCells();
        }
        return null;
    }

    public Component getDefaultFocusComponent() {
        BasicEditorPane basicEditorPane = this.getFocusedEditorPane();
        return basicEditorPane != null ? basicEditorPane : super.getDefaultFocusComponent();
    }

    public Object getEditorAttribute(String string) {
        if ("horizontal_scrollbar_policy".equals(string)) {
            return new Integer(31);
        }
        if ("vertical_scrollbar_policy".equals(string)) {
            return new Integer(21);
        }
        if ("scrollable".equals(string)) {
            return Boolean.FALSE;
        }
        if ("menu_id".equals(string)) {
            return '&' + CodeEditorConstants.CATEGORY_SOURCE_MENU;
        }
        return super.getEditorAttribute(string);
    }

    private Component getFocusComponent() {
        return this.m_gui != null ? this.m_gui.getFocusComponent() : null;
    }

    private Component getHelpFocusComponent() {
        return this.m_gui != null ? this.m_gui.getHelpFocusComponent() : null;
    }

    public BasicEditorPane getFocusedEditorPane() {
        BasicEditorPane basicEditorPane = this.m_gui != null ? this.m_gui.getEditorPane() : null;
        Component component = this.getFocusComponent();
        if (component instanceof BasicEditorPane) {
            return (BasicEditorPane)component;
        }
        return basicEditorPane instanceof BasicEditorPane ? basicEditorPane : null;
    }

    public Component getGUI() {
        return this.getWorksheetGUI();
    }

    public HelpInfo getHelpInfo() {
        Object object;
        boolean bl = false;
        String string = "f1_sqlviewer_html";
        Component component = this.getHelpFocusComponent();
        if (component != null) {
            if (component instanceof JXLayer && (object = (JXLayer)component).getView() instanceof QueryBuilder) {
                string = "f1_popupquerybuilder_html";
                bl = true;
            }
            if (component instanceof AutotracePanel) {
                string = ((AutotracePanel)component).isExplainPlanGetter() ? "f1_explainplan_html" : "f1_autotrace_html";
                bl = true;
            }
            if (component instanceof RunScriptPanel) {
                string = "f1_scriptoutput_html";
                bl = true;
            }
            if (component instanceof SqlTuningAdvisorPanel) {
                string = "f1_sqltuningadvisor_html";
                bl = true;
            }
        }
        if (component != null && !bl) {
            object = null;
            for (object = component.getParent(); object != null; object = ((Component)object).getParent()) {
                if (object instanceof AutotracePanel) {
                    if (((AutotracePanel)object).isExplainPlanGetter()) {
                        string = "f1_explainplan_html";
                        break;
                    }
                    string = "f1_autotrace_html";
                    break;
                }
                if (object instanceof RunScriptPanel) {
                    string = "f1_scriptoutput_html";
                    break;
                }
                if (object instanceof SqlTuningAdvisorPanel) {
                    string = "f1_sqltuningadvisor_html";
                    break;
                }
                Component component2 = this.getGUI();
                if (component2 != null && object.getClass().equals(component2.getParent().getClass())) break;
            }
        }
        return new HelpInfo(string);
    }

    public AbstractLogPage getLogPage() {
        return (AbstractLogPage)LogManager.getLogManager().getMsgPage();
    }

    public BackgroundParser getParser() {
        return this.m_gui.m_foldingPlugin.parser;
    }

    public WorksheetResultPanel getSelectedResultPanel() {
        return this.m_gui.getSelectedResultPanel();
    }

    public Toolbar getToolbar() {
        if (this.m_toolbar == null) {
            this.m_toolbar = this.getWorksheetGUI().getToolbar();
            this.initToolbar();
        }
        return this.m_toolbar;
    }

    private void initToolbar() {
        Object object;
        this.m_toolbar.removeAll();
        Iterator<WorksheetAction> iterator = this.m_toolbarActions.iterator();
        if (iterator.hasNext()) {
            object = iterator.next();
            int n = ((WorksheetAction)object).getSection();
            String[] stringArray = ((WorksheetAction)object).getIds();
            this.addButtons(stringArray);
            while (iterator.hasNext()) {
                object = iterator.next();
                int n2 = ((WorksheetAction)object).getSection();
                if (((WorksheetAction)object).getSection() > n) {
                    n = n2;
                    this.m_toolbar.addSeparator();
                }
                stringArray = ((WorksheetAction)object).getIds();
                this.addButtons(stringArray);
            }
        }
        this.m_toolbar.addSeparator();
        this.m_toolbar.addFiller();
        this.m_progressPanel = new JPanel(new BorderLayout());
        this.m_progressPanel.setOpaque(false);
        this.m_timingLable = new JLabel();
        this.m_toolbar.add((Component)this.m_progressPanel);
        this.m_progressPanel.setVisible(false);
        this.m_toolbar.add((Component)new Box.Filler(new Dimension(0, 0), new Dimension(Short.MAX_VALUE, 0), new Dimension(Short.MAX_VALUE, 0)));
        this.m_connCombo = this.createCombo();
        this.m_connCombo.addConnectionOpenListener(this.connOpenListener, null);
        object = this.m_connCombo.getJComboBox();
        this.m_toolbar.add((Component)object);
        this.m_connCombo.getJComboBox().setKeySelectionManager(new ConnKeySelectionManager((JComboBox)object));
    }

    public void addActionProvider(ArrayList<ActionProvider> arrayList) {
        for (ActionProvider actionProvider : arrayList) {
            int n = actionProvider.getActionsCount();
            for (int i = 0; i < n; ++i) {
                String[] stringArray;
                WorksheetAction worksheetAction = actionProvider.getActionAt(i);
                for (String string : stringArray = worksheetAction.getIds()) {
                    this.m_idMap.put(string, actionProvider);
                    IdeAction ideAction = worksheetAction.getIdeAction(string);
                    this.m_actionMap.put(string, ideAction);
                }
                WorksheetAction.ActionType object = worksheetAction.getType();
                if (object.isToolbarAction()) {
                    this.m_toolbarActions.add(worksheetAction);
                    if (this.m_toolbar != null) {
                        // empty if block
                    }
                }
                if (!object.isContextMenuAction()) continue;
                this.m_ctxMenuActions.add(worksheetAction);
            }
        }
        this.m_toolbar = null;
        this.getToolbar();
        this.getGUI().repaint();
    }

    public Component getFixedTopMargin() {
        if (null == this.topMargin) {
            this.topMargin = new JPanel();
            this.topMargin.setLayout(new BoxLayout(this.topMargin, 3));
            this.topMargin.add((Component)this.getToolbar());
            this.topMargin.add(this.getFindToolbarComponent());
        }
        return this.topMargin;
    }

    private WorksheetGUI getWorksheetGUI() {
        if (this.m_gui == null) {
            this.createGUI();
        }
        return this.m_gui;
    }

    private void handleMenuPopup(ContextMenu contextMenu) {
        BasicEditorPane basicEditorPane = this.getFocusedEditorPane();
        if (basicEditorPane == null || !basicEditorPane.hasFocus()) {
            return;
        }
        float f = JDeveloperMenuConstants.SECTION_DYNAMIC_CTXT_MENU - 0.01f;
        for (WorksheetAction worksheetAction : this.m_ctxMenuActions) {
            String string;
            String[] stringArray = worksheetAction.getIds();
            if (stringArray.length == 1) {
                string = this.m_actionMap.get(stringArray[0]);
                if (string == null) continue;
                contextMenu.add((Component)contextMenu.createMenuItem((ToggleAction)string.newLocalAction((View)this)), f);
                continue;
            }
            string = worksheetAction.getMenuLabel();
            JMenu jMenu = contextMenu.createSubMenu(StringUtils.stripMnemonic((String)string), Integer.valueOf(StringUtils.getMnemonicKeyCode((String)string)));
            jMenu.setIcon(OracleIcons.getIcon((String)"explain.png"));
            jMenu.setText(WorksheetResources.getString("EXPLAIN"));
            for (int i = 0; i < stringArray.length; ++i) {
                String string2 = stringArray[i];
                IdeAction ideAction = this.m_actionMap.get(string2);
                if (ideAction == null) continue;
                jMenu.add(contextMenu.createMenuItem((ToggleAction)ideAction.newLocalAction((View)this)));
            }
            contextMenu.add((Component)jMenu, f);
        }
    }

    protected void initActions() {
        ActionProvider actionProvider;
        IdeAction ideAction = WorksheetHook.getProviders();
        while (ideAction.hasNext()) {
            try {
                actionProvider = (ActionProvider)ideAction.next().newInstance();
                this.m_providers.add(actionProvider);
                int n = actionProvider.getActionsCount();
                for (int i = 0; i < n; ++i) {
                    String[] stringArray;
                    WorksheetAction worksheetAction = actionProvider.getActionAt(i);
                    for (String string : stringArray = worksheetAction.getIds()) {
                        this.m_idMap.put(string, actionProvider);
                        IdeAction ideAction2 = worksheetAction.getIdeAction(string);
                        this.m_actionMap.put(string, ideAction2);
                    }
                    WorksheetAction.ActionType object = worksheetAction.getType();
                    if (object.isToolbarAction()) {
                        this.m_toolbarActions.add(worksheetAction);
                    }
                    if (!object.isContextMenuAction()) continue;
                    this.m_ctxMenuActions.add(worksheetAction);
                }
            }
            catch (InstantiationException instantiationException) {
                LOGGER.log(Level.WARNING, instantiationException.getStackTrace()[0].toString(), instantiationException);
            }
            catch (IllegalAccessException illegalAccessException) {
                LOGGER.log(Level.WARNING, illegalAccessException.getStackTrace()[0].toString(), illegalAccessException);
            }
            catch (ClassNotFoundException classNotFoundException) {
                LOGGER.log(Level.WARNING, classNotFoundException.getStackTrace()[0].toString(), classNotFoundException);
            }
        }
        ideAction = IdeAction.find((int)73);
        if (ideAction != null) {
            ideAction.addController(this.m_controller);
        }
        if ((actionProvider = IdeAction.find((int)74)) != null) {
            actionProvider.addController(this.m_controller);
        }
        IdeAction ideAction3 = IdeAction.get((int)81);
        IdeAction.find((String)"oracle.ide.ceditor.find.next").updateAction();
    }

    public boolean isExpandable(JComponent jComponent) {
        return false;
    }

    public void open() {
        this.getDefaultFocusComponent().requestFocusInWindow();
    }

    private void performCopy(Component component) {
        if (component instanceof JTextComponent) {
            JTextComponent jTextComponent = (JTextComponent)component;
            jTextComponent.copy();
            component.requestFocusInWindow();
        }
    }

    private void performCut(Component component) {
        if (component instanceof JTextComponent) {
            JTextComponent jTextComponent = (JTextComponent)component;
            jTextComponent.cut();
            component.requestFocusInWindow();
        }
    }

    private void performDelete(Component component) {
        if (component instanceof JTextComponent) {
            if (component instanceof BasicEditorPane) {
                BasicEditorPane basicEditorPane = (BasicEditorPane)component;
                basicEditorPane.invokeAction("delete-next");
            } else {
                Action action;
                JTextComponent jTextComponent = (JTextComponent)component;
                ActionMap actionMap = jTextComponent.getActionMap();
                if (actionMap != null && (action = actionMap.get("delete-next")) != null) {
                    ActionEvent actionEvent = new ActionEvent(jTextComponent, 1001, "delete-next");
                    action.actionPerformed(actionEvent);
                }
            }
            component.requestFocusInWindow();
        }
    }

    private void performPaste(Component component) {
        if (component instanceof JTextComponent) {
            JTextComponent jTextComponent = (JTextComponent)component;
            jTextComponent.paste();
            component.requestFocusInWindow();
        }
    }

    private void performSelectAll(Component component) {
        if (component instanceof JTextComponent) {
            JTextComponent jTextComponent = (JTextComponent)component;
            jTextComponent.selectAll();
            component.requestFocusInWindow();
        }
    }

    private void releaseGUI() {
        if (this.m_gui != null) {
            BasicEditorPane basicEditorPane;
            FindToolbarController findToolbarController;
            KeyStrokeOptions keyStrokeOptions = Ide.getSettings().getKeyStrokeOptions();
            keyStrokeOptions.removeChangeListener(this.m_cl);
            if (this.m_connCombo != null) {
                if (Connections.isUnsharedWorksheetConnection((String)this.m_connCombo.getCurrentConnectionName())) {
                    Connections.getInstance().closeConnection(this.m_connCombo.getCurrentConnectionName(), true);
                }
                this.m_connCombo.setCurrentConnection(null);
                this.m_connCombo.removeConnectionOpenListener();
                this.m_connCombo.dispose();
            }
            if ((findToolbarController = AbstractFindToolbarController.getFindController((BasicEditorPane)(basicEditorPane = this.getWorksheetGUI().getEditorPane()))) != null) {
                findToolbarController.dispose();
            }
            this.m_gui.dispose();
            this.m_gui = null;
        }
    }

    @Override
    public void replaceText(String string) {
        if (string == null) {
            return;
        }
        BasicEditorPane basicEditorPane = this.getFocusedEditorPane();
        String string2 = basicEditorPane.getSelectedText();
        if (string2 != null) {
            basicEditorPane.replaceSelection(string);
        } else {
            basicEditorPane.setText(string);
        }
        basicEditorPane.requestFocusInWindow();
    }

    public synchronized void setContext(Context context) {
        super.setContext(context);
    }

    public void update(Object object, UpdateMessage updateMessage) {
    }

    private void updateKeyMap(KeyStrokeOptions keyStrokeOptions) {
        KeyStrokeContextRegistry keyStrokeContextRegistry;
        KeyStrokeContext keyStrokeContext;
        if (keyStrokeOptions != null && (keyStrokeContext = (keyStrokeContextRegistry = Ide.getKeyStrokeContextRegistry()).getContext(ACCEL_FILE)) != null) {
            MultiInputMap multiInputMap = MultiMapAdapter.getLocalMap((KeyStrokeOptions)keyStrokeOptions, (KeyStrokeContext)keyStrokeContext);
            if (this.m_gui != null && multiInputMap != null) {
                this.m_gui.setInputMap(1, (InputMap)multiInputMap);
            }
        }
    }

    public void updateTimer(long l) {
        if (this.m_progressPanel != null) {
            float f = 0.0f;
            if (l > 0L) {
                f = Float.parseFloat(l + "") / 1000.0f;
            }
            Object[] objectArray = new Object[]{new Float(f)};
            String string = MessageFormat.format(WorksheetResources.getString("WORKSHEET_TIMING_FORMAT"), objectArray);
            this.m_timingLable.setText(" " + string);
            this.m_progressPanel.add(this.m_timingLable);
            this.m_toolbar.revalidate();
            this.m_toolbar.repaint();
        }
    }

    public Connection getConnection() {
        Connection connection = null;
        try {
            connection = Connections.getInstance().getConnection(this.m_connCombo.getCurrentConnectionName());
        }
        catch (DBException dBException) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, dBException.getStackTrace()[0].toString(), dBException);
        }
        return connection;
    }

    public Database getDatabase() {
        Database database = null;
        try {
            database = Connections.getInstance().getDatabase(this.m_connCombo.getCurrentConnectionName());
        }
        catch (DBException dBException) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, dBException.getStackTrace()[0].toString(), dBException);
        }
        return database;
    }

    public void goTo(int n, int n2) {
        BasicEditorPane basicEditorPane = this.getFocusedEditorPane();
        BasicDocument basicDocument = (BasicDocument)basicEditorPane.getDocument();
        LineMap lineMap = basicDocument.getLineMap();
        int n3 = lineMap.getLineCount();
        if (--n < 0 || n >= n3) {
            n = n < 0 ? 0 : n3 - 1;
        }
        int n4 = lineMap.getLineStartOffset(n);
        int n5 = lineMap.getLineEndOffset(n);
        int n6 = Math.min(n5, n4 + n2);
        basicEditorPane.setCaretPositionCenter(n5);
        basicEditorPane.moveCaretPositionCenter(n4);
        basicEditorPane.getCaret().setSelectionVisible(true);
        basicEditorPane.requestFocusInWindow();
    }

    private JComponent getFindToolbarComponent() {
        if (null == this.findToolbarController) {
            BasicEditorPane basicEditorPane = this.getWorksheetGUI().getEditorPane();
            this.findToolbarController = UIUtils.createFindToolbarController((BasicEditorPane)basicEditorPane);
        }
        return this.findToolbarController.getToolbarsComponent();
    }

    static {
        worksheetShutdownHook = new ShutdownHook(){

            public boolean canShutdown() {
                return true;
            }

            public void shutdown() {
                try {
                    final EditorManager editorManager = EditorManager.getEditorManager();
                    List list = editorManager.getAllEditors();
                    final ArrayList<Editor> arrayList = new ArrayList<Editor>();
                    for (Editor editor : list) {
                        URL uRL = this.getNodeURL(this.getEditorNode(editor));
                        if (!WorksheetURLFileSystemHelper.isWorksheetURL(uRL)) continue;
                        arrayList.add(editor);
                    }
                    for (Editor editor : arrayList) {
                        this.getEditorNode(editor).markDirty(false);
                    }
                    SwingUtilities.invokeAndWait(new Runnable(){

                        @Override
                        public void run() {
                            editorManager.closeEditors(arrayList);
                        }
                    });
                }
                catch (Exception exception) {
                    oracle.dbtools.util.Logger.ignore(this.getClass(), (Throwable)exception);
                }
            }

            private Node getEditorNode(Editor editor) {
                assert (editor != null);
                return null == editor.getContext() ? null : editor.getContext().getNode();
            }

            private URL getNodeURL(Node node) {
                return null == node ? null : node.getURL();
            }
        };
        ExitCommand.addShutdownHook((ShutdownHook)worksheetShutdownHook);
    }

    private class ConnOpenListener
    implements IDBConnectionComboBoxListener {
        private ConnOpenListener() {
        }

        public void connectionOpening() {
        }

        public void connectionOpened(Connection connection) {
            Object object;
            String string = Connections.getInstance().getConnectionName(connection);
            if (Worksheet.this.getContext().getNode() instanceof SqlNode && (object = (SqlNode)Worksheet.this.getContext().getNode()) != null) {
                WorksheetUtil.setWorksheetTabName(object.getURL(), Connections.getDisplayName((String)string));
            }
            if (Worksheet.this.m_gui != null) {
                Worksheet.this.m_gui.updateWorksheetConnection(string);
                object = Connections.getInstance().getConnectionInfo(string);
                GuiScriptRunnerContext guiScriptRunnerContext = null;
                if (object != null) {
                    guiScriptRunnerContext = (GuiScriptRunnerContext)((Properties)object).get(Worksheet.GLOGIN);
                }
                if (guiScriptRunnerContext == null) {
                    guiScriptRunnerContext = new GuiScriptRunnerContext();
                    guiScriptRunnerContext.setPromptedFieldProvider((IGetPromptedFieldProvider)new GuiPromptedAcceptProvider());
                    guiScriptRunnerContext.setSubstitutionFieldProvider((IGetPromptedFieldProvider)new GuiPromptedSubstitutionProvider());
                    guiScriptRunnerContext.setPasswordFieldsProvider((IGetPromptedPasswordFieldsProvider)new GuiPromptedPasswordFieldsProvider());
                    guiScriptRunnerContext.setConnectFieldsProvider((IGetPromptedConnectFieldsProvider)new GuiPromptedConnectFieldsProvider());
                    guiScriptRunnerContext.setHandlePauseProvider((IGetHandlePauseProvider)new GuiHandlePauseProvider());
                    guiScriptRunnerContext.setHandleSetPauseProvider((IGetHandlePauseProvider)new GuiHandleSetPauseProvider());
                    guiScriptRunnerContext.setSQLPlusFormatter((ICoreFormatter)new SQLDevFormatter());
                    guiScriptRunnerContext.setSQLPlusCodingStyleOptions(null);
                }
                Worksheet.this.m_gui.getEditorPane().putProperty(Worksheet.SCRIPRUNNERCONTEXT, (Object)guiScriptRunnerContext);
            }
            ((WorksheetGUI)Worksheet.this.getGUI()).invokeInsight(string);
            View.updateToolbarActions((Toolbar)Worksheet.this.m_toolbar);
        }

        public void connectionFailed(RaptorTaskEvent raptorTaskEvent) {
            Throwable throwable = raptorTaskEvent.getThrowable();
            if (!(throwable instanceof ConnectionCanceledException) && throwable instanceof Exception) {
                ExceptionHandler.handleException((Throwable)((Exception)throwable));
            }
            this.resetConnCombo();
        }

        public void connectionCanceled(RaptorTaskEvent raptorTaskEvent) {
            Throwable throwable = raptorTaskEvent.getThrowable();
            if (!(throwable instanceof ConnectionCanceledException) && throwable instanceof Exception) {
                ExceptionHandler.handleException((Throwable)((Exception)throwable));
            }
            this.resetConnCombo();
        }

        private void resetConnCombo() {
            String string = Worksheet.this.getConnectionFromContext();
            Worksheet.this.m_connCombo.setCurrentConnection(string);
        }
    }

    private class WorksheetController<V>
    implements Controller {
        private WorksheetController() {
        }

        public ActionProvider<?> getProvider(String string) {
            return string != null ? Worksheet.this.m_idMap.get(string) : null;
        }

        public boolean handleEvent(IdeAction ideAction, Context context) {
            boolean bl = false;
            int n = ideAction.getCommandId();
            final String string = Ide.findCmdName((int)n);
            final ActionProvider<?> actionProvider = this.getProvider(string);
            this.clearTheTimerFromTheToolbar();
            View view = context.getView();
            if (actionProvider != null) {
                String string2 = actionProvider.getClass().getSimpleName();
                if (Worksheet.this.getConnectionName() == null && this.needConnection(string2)) {
                    RaptorTask<Object> raptorTask = new RaptorTask<Object>("", false, IRaptorTaskRunMode.IDE_STATUSBAR){

                        protected Object doWork() throws TaskException {
                            Runnable runnable = new Runnable(){

                                @Override
                                public void run() {
                                    String string = "";
                                    string = ConnectionSelectorUI.getConnection((String)WorksheetResources.getString("SELECT_CONNECTION"), (String)WorksheetResources.getString("CHOOSE_EXISTING"), (String)string, (boolean)false);
                                    if (WorksheetController.this.testConnection(string)) {
                                        Worksheet.this.m_connCombo.setCurrentConnection(string);
                                    } else {
                                        Worksheet.this.m_connCombo.setCurrentConnection(null);
                                    }
                                }
                            };
                            try {
                                SwingUtilities.invokeAndWait(runnable);
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                            return null;
                        }
                    };
                    raptorTask.getDescriptor().addListener((IRaptorTaskListener)new RaptorTaskAdapter(){

                        public void taskFinished(RaptorTaskEvent raptorTaskEvent) {
                            WorksheetTaskWrapper worksheetTaskWrapper;
                            if (Worksheet.this.getConnectionName() != null && (worksheetTaskWrapper = actionProvider.doAction(string, Worksheet.this.createWorksheetContext())) != null) {
                                RaptorTaskManager.getInstance().addTask(worksheetTaskWrapper);
                            }
                        }
                    });
                    RaptorTaskManager.getInstance().addTask((RaptorTask)raptorTask);
                } else {
                    WorksheetTaskWrapper<?> worksheetTaskWrapper = actionProvider.doAction(string, Worksheet.this.createWorksheetContext());
                    if (worksheetTaskWrapper != null) {
                        RaptorTaskManager.getInstance().addTask(worksheetTaskWrapper);
                    }
                }
                bl = true;
            } else {
                Component component;
                if (IDBEditor.CONN_CLOSED_CMD_ID == ideAction.getCommandId()) {
                    if (Worksheet.this.closeOnConnDisconnect()) {
                        component = IdeAction.get((int)48);
                        try {
                            bl = EditorManager.getEditorManager().handleEvent((IdeAction)component, context);
                        }
                        catch (ExpiredTextBufferException expiredTextBufferException) {}
                    } else {
                        Worksheet.this.m_connCombo.setCurrentConnection(null);
                        bl = true;
                    }
                }
                if ((component = Worksheet.this.getFocusComponent()) != null) {
                    if (n == 18) {
                        Worksheet.this.performCopy(component);
                        bl = true;
                    } else if (n == 17) {
                        Worksheet.this.performCut(component);
                        bl = true;
                    } else if (n == 19) {
                        Worksheet.this.performPaste(component);
                        bl = true;
                    } else if (n == 20) {
                        Worksheet.this.performDelete(component);
                        bl = true;
                    } else if (n == 22) {
                        Worksheet.this.performSelectAll(component);
                        bl = true;
                    } else if (n == 74) {
                        WorksheetTabbedPane worksheetTabbedPane;
                        if (context.getView() == Worksheet.this && (worksheetTabbedPane = Worksheet.this.getWorksheetGUI().getWorksheetTabbedPane()) != null && this.tabHasFocus()) {
                            worksheetTabbedPane.navigateForward();
                            bl = true;
                        }
                    } else if (n == 73) {
                        WorksheetTabbedPane worksheetTabbedPane;
                        if (context.getView() == Worksheet.this && (worksheetTabbedPane = Worksheet.this.getWorksheetGUI().getWorksheetTabbedPane()) != null && this.tabHasFocus()) {
                            worksheetTabbedPane.navigateBack();
                            bl = true;
                        }
                    } else if (n == 81) {
                        for (Editor editor : EditorManager.getEditorManager().getAllEditors()) {
                            EditorSelectionWrap editorSelectionWrap;
                            BasicEditorPane basicEditorPane;
                            if (!(editor instanceof Worksheet) || !((basicEditorPane = Worksheet.this.getWorksheetGUI().getEditorPane()).getCaret() instanceof BasicCaret)) continue;
                            BasicCaret basicCaret = (BasicCaret)basicEditorPane.getCaret();
                            basicCaret.getEditorSelection().deinstall();
                            if (ideAction.getState()) {
                                editorSelectionWrap = new EditorSelectionWrap();
                                basicEditorPane.putIntegerProperty("caret-editor-selection-type", 20);
                            } else {
                                editorSelectionWrap = new EditorSelectionColumns();
                                basicEditorPane.putIntegerProperty("caret-editor-selection-type", 21);
                            }
                            basicCaret.setEditorSelection((EditorSelection)editorSelectionWrap);
                            editorSelectionWrap.install(basicEditorPane);
                        }
                        bl = true;
                    }
                }
            }
            return bl;
        }

        private boolean testConnection(String string) {
            try {
                return Connections.getInstance().getConnection(string) != null;
            }
            catch (DBException dBException) {
                ExceptionHandler.handleException((Throwable)dBException);
                return false;
            }
        }

        private boolean testConnectionOpen() {
            try {
                return Connections.getInstance().isConnectionOpen(Worksheet.this.m_connCombo.getCurrentConnectionName());
            }
            catch (Exception exception) {
                return false;
            }
        }

        private boolean needConnection(String string) {
            return !string.equals("ScratchEditorProvider") && !string.equals("CaseChangeActionProvider") && !string.equals("ClearActionProvider") && !string.equals("BabelfishWorksheetProvider");
        }

        private void clearTheTimerFromTheToolbar() {
            SwingUtilities.invokeLater(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    if (Worksheet.this.m_progressPanel != null && Worksheet.this.m_timingLable != null) {
                        JPanel jPanel = Worksheet.this.m_progressPanel;
                        synchronized (jPanel) {
                            Worksheet.this.m_progressPanel.remove(Worksheet.this.m_timingLable);
                        }
                    }
                }
            });
        }

        private boolean tabHasFocus() {
            BasicEditorPane basicEditorPane = Worksheet.this.getFocusedEditorPane();
            if (basicEditorPane != null) {
                return !basicEditorPane.hasFocus();
            }
            return false;
        }

        public boolean update(IdeAction ideAction, Context context) {
            boolean bl = false;
            int n = ideAction.getCommandId();
            String string = Ide.findCmdName((int)n);
            ActionProvider<?> actionProvider = this.getProvider(string);
            if (actionProvider != null) {
                ideAction.setEnabled(actionProvider.checkActionEnabled(string, Worksheet.this.createWorksheetContext()));
                bl = true;
            } else {
                Component component = Worksheet.this.getFocusComponent();
                if (component != null) {
                    WorksheetTabbedPane worksheetTabbedPane;
                    if (n == 18) {
                        ideAction.setEnabled(Worksheet.this.canPerformCopy(component));
                        bl = true;
                    } else if (n == 17) {
                        ideAction.setEnabled(Worksheet.canPerformCut(component));
                        bl = true;
                    } else if (n == 19) {
                        ideAction.setEnabled(Worksheet.canPerformPaste(component));
                        bl = true;
                    } else if (n == 20) {
                        ideAction.setEnabled(Worksheet.this.canPerformDelete(component));
                        bl = true;
                    } else if (n == 22) {
                        ideAction.setEnabled(Worksheet.canPerformSelectAll(component));
                        bl = true;
                    } else if (n == 74) {
                        WorksheetTabbedPane worksheetTabbedPane2;
                        if (context.getView() == Worksheet.this && (worksheetTabbedPane2 = Worksheet.this.getWorksheetGUI().getWorksheetTabbedPane()) != null && this.tabHasFocus()) {
                            ideAction.setEnabled(true);
                            bl = true;
                        }
                    } else if (n == 81) {
                        ideAction.setEnabled(true);
                        bl = true;
                    } else if (n == 73 && context.getView() == Worksheet.this && (worksheetTabbedPane = Worksheet.this.getWorksheetGUI().getWorksheetTabbedPane()) != null && this.tabHasFocus()) {
                        ideAction.setEnabled(true);
                        bl = true;
                    }
                }
            }
            return bl;
        }
    }

    private class ToolbarTaskViewer
    implements ITaskViewer {
        Map<RaptorTaskDescriptor, ITaskUI> descUIMap = new HashMap<RaptorTaskDescriptor, ITaskUI>();

        private ToolbarTaskViewer() {
        }

        public void addTaskUI(ITaskUI iTaskUI) {
        }

        public void makeProgressPanelVisible() {
            Worksheet.this.m_progressPanel.setVisible(true);
        }

        public void callUpdateTimer(long l) {
            Worksheet.this.updateTimer(l);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public ITaskUI createTaskUI(RaptorTaskDescriptor raptorTaskDescriptor) {
            SimpleRaptorTaskUI simpleRaptorTaskUI = new SimpleRaptorTaskUI(raptorTaskDescriptor);
            JPanel jPanel = Worksheet.this.m_progressPanel;
            synchronized (jPanel) {
                this.descUIMap.put(raptorTaskDescriptor, (ITaskUI)simpleRaptorTaskUI);
            }
            raptorTaskDescriptor.addListener((IRaptorTaskListener)new RaptorTaskAdapter((ITaskUI)simpleRaptorTaskUI){
                final /* synthetic */ ITaskUI val$ui;
                {
                    this.val$ui = iTaskUI;
                }

                private void addTask() {
                    SwingUtilities.invokeLater(new Runnable(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void run() {
                            JPanel jPanel = Worksheet.this.m_progressPanel;
                            synchronized (jPanel) {
                                Worksheet.this.m_progressPanel.remove(Worksheet.this.m_timingLable);
                                Worksheet.this.m_progressPanel.add(val$ui.getPanel(), "West");
                                Dimension dimension = val$ui.getPanel().getPreferredSize();
                                Worksheet.this.m_progressPanel.setMinimumSize(dimension);
                                ToolbarTaskViewer.this.makeProgressPanelVisible();
                                View.updateToolbarActions((Toolbar)Worksheet.this.m_toolbar);
                                Worksheet.this.m_toolbar.revalidate();
                                Worksheet.this.m_toolbar.repaint();
                            }
                        }
                    });
                }

                private void removeTask(final RaptorTaskEvent raptorTaskEvent) {
                    Runnable runnable = new Runnable(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void run() {
                            JPanel jPanel = Worksheet.this.m_progressPanel;
                            synchronized (jPanel) {
                                RaptorTaskDescriptor raptorTaskDescriptor = raptorTaskEvent.getTaskDescriptor();
                                if (!IRaptorTaskStatus.isAlive((IRaptorTaskStatus)raptorTaskDescriptor.getStatus())) {
                                    ITaskUI iTaskUI = ToolbarTaskViewer.this.getTaskUI(raptorTaskDescriptor);
                                    if (iTaskUI != null) {
                                        Worksheet.this.m_progressPanel.remove(iTaskUI.getPanel());
                                    }
                                    ToolbarTaskViewer.this.descUIMap.remove(raptorTaskDescriptor);
                                    Worksheet.this.m_progressPanel.add(Box.createHorizontalStrut(100));
                                    ToolbarTaskViewer.this.callUpdateTimer(raptorTaskEvent.getTaskDescriptor().getElapsedTime());
                                    View.updateToolbarActions((Toolbar)Worksheet.this.m_toolbar);
                                    Worksheet.this.m_toolbar.revalidate();
                                    Worksheet.this.m_toolbar.repaint();
                                }
                            }
                        }
                    };
                    SwingUtilities.invokeLater(runnable);
                }

                public void taskFailed(RaptorTaskEvent raptorTaskEvent) {
                    Worksheet.this.m_isBusy = false;
                    this.removeTask(raptorTaskEvent);
                }

                public void taskCancelled(RaptorTaskEvent raptorTaskEvent) {
                    Worksheet.this.m_isBusy = false;
                    this.removeTask(raptorTaskEvent);
                }

                public void taskFinished(RaptorTaskEvent raptorTaskEvent) {
                    Worksheet.this.m_isBusy = false;
                    this.removeTask(raptorTaskEvent);
                }

                public void taskRunning(RaptorTaskEvent raptorTaskEvent) {
                    Worksheet.this.m_isBusy = true;
                    this.addTask();
                }
            });
            return simpleRaptorTaskUI;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public ITaskUI getTaskUI(RaptorTaskDescriptor raptorTaskDescriptor) {
            JPanel jPanel = Worksheet.this.m_progressPanel;
            synchronized (jPanel) {
                Component[] componentArray;
                ITaskUI iTaskUI = this.descUIMap.get(raptorTaskDescriptor);
                for (Component component : componentArray = Worksheet.this.m_progressPanel.getComponents()) {
                    if (component != iTaskUI) continue;
                    return iTaskUI;
                }
            }
            return null;
        }

        public void taskCancelRequested(RaptorTaskDescriptor raptorTaskDescriptor) {
            ITaskUI iTaskUI = this.getTaskUI(raptorTaskDescriptor);
            if (iTaskUI != null) {
                iTaskUI.cancelClicked(raptorTaskDescriptor);
            }
        }

        public void taskPauseRequested(RaptorTaskDescriptor raptorTaskDescriptor) {
            ITaskUI iTaskUI = this.getTaskUI(raptorTaskDescriptor);
            if (iTaskUI != null) {
                iTaskUI.pauseClicked(raptorTaskDescriptor);
            }
        }

        public void removeTaskUI(ITaskUI iTaskUI) {
        }
    }

    private final class ButtonToolbarTaskViewer
    extends ToolbarTaskViewer {
        private ButtonToolbarTaskViewer() {
        }

        @Override
        public void makeProgressPanelVisible() {
            Worksheet.this.m_progressPanel.setVisible(false);
        }

        @Override
        public void callUpdateTimer(long l) {
        }
    }

    static final class SqlWorksheetLogPage
    extends DefaultLogPage {
        public SqlWorksheetLogPage() {
            super(new ViewId("SqlWorksheetLogPage", StringUtils.stripMnemonic((String)WorksheetResources.getString("WORKSHEET_NEW"))), null, false, HIDE_FIX_SOURCE_MENU | HIDE_GOTO_SOURCE_MENU);
        }
    }

    private class ConnectionOpenedListener
    extends RaptorTaskAdapter {
        private ConnectionOpenedListener() {
        }

        public void taskFinished(RaptorTaskEvent raptorTaskEvent) {
            try {
                Connection connection = (Connection)Worksheet.this.connOpener.getResult();
                final String string = Connections.getInstance().getConnectionName(connection);
                Runnable runnable = new Runnable(){

                    @Override
                    public void run() {
                        SqlNode sqlNode;
                        if (Worksheet.this.getContext().getNode() instanceof SqlNode && (sqlNode = (SqlNode)Worksheet.this.getContext().getNode()) != null) {
                            WorksheetUtil.setWorksheetTabName(sqlNode.getURL(), Connections.getDisplayName((String)string));
                        }
                        if (Worksheet.this.m_gui != null) {
                            Worksheet.this.m_gui.updateWorksheetConnection(string);
                        }
                        View.updateToolbarActions((Toolbar)Worksheet.this.m_toolbar);
                    }
                };
                SwingUtilities.invokeLater(runnable);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        public void taskFailed(RaptorTaskEvent raptorTaskEvent) {
            Throwable throwable = raptorTaskEvent.getThrowable();
            if (!(throwable instanceof ConnectionCanceledException) && throwable instanceof Exception) {
                ExceptionHandler.handleException((Throwable)((Exception)throwable));
            }
        }

        public void taskCancelled(RaptorTaskEvent raptorTaskEvent) {
            Throwable throwable = raptorTaskEvent.getThrowable();
            if (!(throwable instanceof ConnectionCanceledException) && throwable instanceof Exception) {
                ExceptionHandler.handleException((Throwable)((Exception)throwable));
            }
        }
    }

    private class ConnectionOpener
    extends RaptorTask<Connection> {
        String selectedConnName;

        public ConnectionOpener(String string, boolean bl, IRaptorTaskRunMode iRaptorTaskRunMode, String string2) {
            super(string, bl, iRaptorTaskRunMode);
            this.selectedConnName = string2;
        }

        protected Connection doWork() throws TaskException {
            try {
                return Connections.getInstance().getConnection(this.selectedConnName);
            }
            catch (DBException dBException) {
                throw new TaskException((Throwable)dBException);
            }
        }
    }

    private static class CL
    implements ContextMenuListener {
        private CL() {
        }

        public boolean handleDefaultAction(Context context) {
            return false;
        }

        public void menuWillHide(ContextMenu contextMenu) {
        }

        public void menuWillShow(ContextMenu contextMenu) {
            Context context = contextMenu.getContext();
            View view = context.getView();
            if (view instanceof Worksheet) {
                ((Worksheet)view).handleMenuPopup(contextMenu);
            }
        }
    }
}

