/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.worksheet.commands.scriptrunner.task;

import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.concurrent.CancellationException;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.text.Document;
import oracle.dbtools.logging.IStatusMessageConsumer;
import oracle.dbtools.raptor.backgroundTask.ui.IImageRegistry;
import oracle.dbtools.worksheet.AbstractWorksheetTaskResultPanel;
import oracle.dbtools.worksheet.Messages;
import oracle.dbtools.worksheet.WorksheetResources;
import oracle.dbtools.worksheet.WorksheetState;
import oracle.dbtools.worksheet.commands.scriptrunner.task.ITabListener;
import oracle.dbtools.worksheet.commands.scriptrunner.task.StatementRunnerTask;
import oracle.ide.db.util.IconWithSmallOverlay;
import oracle.ide.help.HelpSystem;
import oracle.javatools.buffer.ReadWriteLock;
import oracle.javatools.buffer.TextBufferFactory;
import oracle.javatools.editor.BasicDocument;
import oracle.javatools.editor.BasicEditorPane;
import oracle.javatools.icons.OracleIcons;
import org.jdesktop.jxlayer.plaf.ext.LockableUI;

public class RunScriptPanel
extends AbstractWorksheetTaskResultPanel {
    private WorksheetState m_state = WorksheetState.CLOSED;
    protected BasicEditorPane m_txt = new BasicEditorPane();
    private JScrollPane m_sp = null;
    private String m_id = null;
    private String m_tabLabel = null;
    private ArrayList<ITabListener> tabListeners = new ArrayList();
    private Icon _ranOkIcon = null;
    private Icon _waitingIcon = null;
    private Icon _runningIcon = null;
    private Icon _problemIcon = null;
    private Icon _tabIcon = null;

    public RunScriptPanel(String string) {
        this.m_txt.setDocument((Document)new BasicDocument(TextBufferFactory.createTextBuffer((ReadWriteLock)new ReadWriteLock())));
        this.m_id = string;
        this.m_tabLabel = StatementRunnerTask.STATEMENTSCRIPTRUNNER_TASKNAME.equals(string) ? Messages.getString("StatementRunnerTask.StatementScriptRunnerTabName") : WorksheetResources.get("SCRIPT_OUTPUT");
        this.setupIcons();
        this.m_txt.setEditable(false);
        this.m_txt.setFont(new Font("Courier", 0, 12));
        this.m_sp = new JScrollPane((Component)this.m_txt, 22, 30);
        this._resultsPanel.add((Component)this.m_sp, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 11, 1, new Insets(0, 0, 0, 0), 0, 0));
        this._toolbar.addSeparator();
        this._toolbar.add(Box.createHorizontalStrut(5));
        this.getStatusPanel().setOpaque(false);
        this.getStatusLabel().setOpaque(false);
        this._toolbar.add((Component)this.getStatusPanel());
        this.setLockableUI(new LockableUI());
        HelpSystem.getHelpSystem().registerTopic((JComponent)this, "f1_scriptoutput_html");
    }

    private void setupIcons() {
        this._ranOkIcon = this.getBaseIcon();
        this._waitingIcon = new IconWithSmallOverlay(this.getBaseIcon(), IImageRegistry.LIGHT_YELLOW);
        this._runningIcon = new IconWithSmallOverlay(OracleIcons.getIcon((String)"throbber.gif"), this.getBaseIcon());
        this._problemIcon = new IconWithSmallOverlay(this.getBaseIcon(), OracleIcons.getIcon((String)"exception.png"));
        this._tabIcon = this.getWaitingIcon();
    }

    public BasicEditorPane getTextPane() {
        return this.m_txt;
    }

    @Override
    public JComponent getGUI() {
        return this;
    }

    @Override
    public WorksheetState getState() {
        return this.m_state;
    }

    @Override
    public void setState(WorksheetState worksheetState) {
        this.m_state = worksheetState;
    }

    @Override
    public Icon getTabIcon() {
        return this._tabIcon;
    }

    @Override
    public String getTabLabel() {
        return this.m_tabLabel;
    }

    @Override
    public void setTabLabel(String string) {
        this.m_tabLabel = string;
    }

    public void tabClosed() {
        this.setState(WorksheetState.CLOSED);
        this.clear();
        this.callTabListeners(WorksheetState.CLOSED);
    }

    private void callTabListeners(WorksheetState worksheetState) {
        if (worksheetState == WorksheetState.CLOSED) {
            for (ITabListener iTabListener : this.tabListeners) {
                iTabListener.tabClosed(this);
            }
        }
    }

    public JScrollPane getScrollBar() {
        return this.m_sp;
    }

    @Override
    public String getID() {
        return this.m_id;
    }

    @Override
    public String getTabToolTip() {
        return this.getTabLabel();
    }

    @Override
    public String getLastStatusMessage() {
        return null;
    }

    @Override
    public void publishStatusMessage(String string, Exception exception) {
        if (exception.getCause() instanceof CancellationException) {
            this.setTabIcon(this.getProblemIcon());
        }
    }

    @Override
    public void registerConsumer(IStatusMessageConsumer iStatusMessageConsumer) {
    }

    public void setStatusMessage(String string) {
    }

    @Override
    public void clear() {
        this.m_txt.setEditable(true);
        this.m_txt.setText("");
        this.m_txt.setEditable(false);
        System.gc();
    }

    @Override
    public String getConnectionName() {
        return this.getContext().getConnectionName();
    }

    @Override
    public String getOutputText() {
        return this.getTextPane().getText();
    }

    @Override
    protected void initCommands() {
    }

    @Override
    public String getSQL() {
        return "";
    }

    @Override
    public boolean isCloseable() {
        return true;
    }

    public void addTabListener(ITabListener iTabListener) {
        this.tabListeners.add(iTabListener);
    }

    @Override
    protected void createErrorComp(Throwable throwable) {
        this.setTabIcon(this.getProblemIcon());
    }

    @Override
    public Icon getRunningIcon() {
        return this._runningIcon;
    }

    @Override
    public Icon getWaitingIcon() {
        return this._waitingIcon;
    }

    @Override
    public Icon getRanOKIcon() {
        return this._ranOkIcon;
    }

    public Icon getProblemIcon() {
        return this._problemIcon;
    }

    @Override
    public void setTabIcon(Icon icon) {
        this._tabIcon = icon;
    }

    private Icon getBaseIcon() {
        return StatementRunnerTask.STATEMENTSCRIPTRUNNER_TASKNAME == this.m_id ? OracleIcons.getIcon((String)"run.png") : WorksheetResources.getIcon("RUN_SCRIPT_ICON");
    }
}

