/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.worksheet.commands.autotrace;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.net.URL;
import java.util.TreeMap;
import javax.swing.table.TableColumn;
import oracle.ide.ExtensionRegistry;
import oracle.ide.net.URLFactory;
import oracle.javatools.ui.treetable.JTreeTable;

public class SerializedData
implements Serializable {
    TreeMap<Object, Integer> columnWidths = new TreeMap();
    public boolean collapsePredNodes = false;
    int dividerLocation = 600;
    private static SerializedData instance = null;
    private static final String fname = "stuff.serial";

    public static SerializedData getInstance() {
        if (instance == null) {
            try {
                instance = SerializedData.read();
            }
            catch (Exception exception) {
                instance = new SerializedData();
            }
        }
        return instance;
    }

    public static void write() {
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(SerializedData.getURL().getFile());
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(fileOutputStream);
            objectOutputStream.writeObject(SerializedData.getInstance());
            objectOutputStream.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static SerializedData read() throws IOException, ClassNotFoundException {
        InputStream inputStream = SerializedData.getURL().openStream();
        ObjectInputStream objectInputStream = new ObjectInputStream(inputStream);
        SerializedData serializedData = (SerializedData)objectInputStream.readObject();
        objectInputStream.close();
        return serializedData;
    }

    private static URL getURL() {
        ExtensionRegistry extensionRegistry = ExtensionRegistry.getExtensionRegistry();
        URL uRL = extensionRegistry.getSystemDirectory("oracle.sqldeveloper.worksheet");
        return URLFactory.newURL((URL)uRL, (String)fname);
    }

    public static void initColumnWidths(JTreeTable jTreeTable) {
        TableColumn tableColumn;
        int n;
        SerializedData serializedData = SerializedData.getInstance();
        for (n = 0; n < jTreeTable.getColumnModel().getColumnCount(); ++n) {
            tableColumn = jTreeTable.getColumnModel().getColumn(n);
            Object object = tableColumn.getHeaderValue();
            if (object != null && serializedData.columnWidths.get(object) != null) {
                tableColumn.setPreferredWidth(serializedData.columnWidths.get(object));
                continue;
            }
            tableColumn.setPreferredWidth(n == 0 ? 300 : 200);
        }
        for (n = 0; n < jTreeTable.getColumnModel().getColumnCount(); ++n) {
            tableColumn = jTreeTable.getColumnModel().getColumn(n);
            tableColumn.addPropertyChangeListener(new ColumnsListener());
        }
    }

    public void setColumnWidths(TreeMap<Object, Integer> treeMap) {
        this.columnWidths = treeMap;
    }

    public TreeMap<Object, Integer> getColumnWidths() {
        return this.columnWidths;
    }

    public void setDividerLocation(int n) {
        this.dividerLocation = n;
    }

    public int getDividerLocation() {
        return this.dividerLocation;
    }

    private static class ColumnsListener
    implements PropertyChangeListener {
        private ColumnsListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            TableColumn tableColumn = (TableColumn)propertyChangeEvent.getSource();
            Object object = tableColumn.getHeaderValue();
            int n = tableColumn.getWidth();
            SerializedData serializedData = SerializedData.getInstance();
            Integer n2 = serializedData.columnWidths.get(object);
            if (n2 == null || Math.abs(n - n2) > 10) {
                serializedData.columnWidths.put(object, n);
            }
            SerializedData.write();
        }
    }
}

