/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.debugger;

import java.net.URL;
import oracle.javatools.data.HashStructure;
import oracle.javatools.data.ListStructure;
import oracle.javatools.util.Copyable;
import oracle.jdevimpl.debugger.BreakpointMarkerAPI;
import oracle.jdevimpl.debugger.BreakpointsWindowSettings;
import oracle.jdevimpl.debugger.DbgArb;

public final class BreakpointSettings
implements Copyable {
    public static final int BP_PACKAGE_FILE_LINE = 0;
    public static final int BP_METHOD = 1;
    public static final int BP_EXCEPTION = 2;
    public static final int BP_DEADLOCK = 3;
    public static final int BP_CLASS = 4;
    public static final int BP_URL_LINE = 5;
    public static final int BP_WATCHPOINT = 6;
    public static final int BP_METHOD_OFFSET = 7;
    public static final int BP_PROPERTIES = 8;
    private HashStructure hash;
    private boolean _defaultActionHalt;
    private boolean _defaultActionBeep;
    private boolean _defaultActionLog;
    private String _defaultActionLogTag;
    private String _defaultActionLogExpr;
    private boolean _defaultActionLogStack;
    private String _defaultActionEnableOther;
    private String _defaultActionDisableOther;
    private BreakpointMarkerAPI marker;
    private static final String OWNER_URL = "owner_url";
    private static final String PERSISTENT = "persistent";
    private static final String JAVA_SPECIFIC = "java_specific";
    private static final String TYPE = "type";
    private static final String PACKAGE = "package";
    private static final String FILE = "file";
    private static final String LINE = "line";
    private static final String METHOD = "method";
    private static final String OFFSET = "offset";
    private static final String EXCEPTION = "exception";
    private static final String CAUGHT = "caught";
    private static final String UNCAUGHT = "uncaught";
    private static final String CLASS_NAME = "class_name";
    private static final String URL = "url";
    private static final String PROJECT_URL = "project_url";
    private static final String FIELD_NAME = "field_name";
    private static final String ACCESS = "access";
    private static final String MODIFY = "modify";
    private static final String ENABLED = "enabled";
    private static final String GROUP_NAME = "group_name";
    private static final String EDIT_GROUP_NAME = "edit_group_name";
    private static final String CONDITION = "condition";
    private static final String EDIT_CONDITION = "edit_condition";
    private static final String HIDDEN_CONDITION = "hidden_condition";
    private static final String THREAD_NAME = "thread_name";
    private static final String THREAD_NAME_NOT = "thread_name_not";
    private static final String EDIT_BREAK_FOR_THREADS = "edit_break_for_threads";
    private static final String PASS_COUNT = "pass_count";
    private static final String EDIT_PASS_COUNT = "edit_pass_count";
    private static final String ACTION_HALT = "action_halt";
    private static final String ACTION_BEEP = "action_beep";
    private static final String ACTION_LOG = "action_log";
    private static final String ACTION_LOG_TAG = "action_log_tag";
    private static final String ACTION_LOG_EXPR = "action_log_expr";
    private static final String ACTION_LOG_STACK = "action_log_stack";
    private static final String ACTION_ENABLE_OTHER = "action_enable_other";
    private static final String ACTION_DISABLE_OTHER = "action_disable_other";
    private static final String EDIT_BREAKPOINT_HIT_ACTIONS = "edit_breakpoint_hit_actions";
    private static final String CUSTOM_DESCRIPTION = "custom_description";
    private static final String CUSTOM_TYPE_STRING = "custom_type_string";
    private static final String DEBUGGER_EXTENDER_ID = "debugger_extender_id";
    private static final String PROPERTY_KEYS = "property_keys";
    private static final String PROPERTY_VALUES = "property_values";
    private static final String CREATION_TIMESTAMP = "creation_timestamp";

    public BreakpointSettings() {
        this.defaultInit();
        this.setCreationTimestamp(System.nanoTime());
    }

    BreakpointSettings(HashStructure hash) {
        this.defaultInit();
        hash.copyTo(this.hash);
    }

    public BreakpointSettings(BreakpointSettings that) {
        this.defaultInit();
        if (that != null) {
            that.copyToImpl(this);
        }
    }

    HashStructure getHash() {
        this.syncLineFromMarker();
        this.syncOffsetFromMarker();
        return this.hash;
    }

    private void defaultInit() {
        this.hash = HashStructure.newInstance();
        this.setDefaultActions();
    }

    private void setDefaultActions() {
        BreakpointsWindowSettings bpWindowSettings = BreakpointsWindowSettings.getInstance();
        this._defaultActionHalt = bpWindowSettings.getDefaultActionHalt();
        this._defaultActionBeep = bpWindowSettings.getDefaultActionBeep();
        this._defaultActionLog = bpWindowSettings.getDefaultActionLog();
        this._defaultActionLogTag = bpWindowSettings.getDefaultActionLogTag();
        this._defaultActionLogExpr = bpWindowSettings.getDefaultActionLogExpr();
        this._defaultActionLogStack = bpWindowSettings.getDefaultActionLogStack();
        this._defaultActionEnableOther = bpWindowSettings.getDefaultActionEnableOther();
        this._defaultActionDisableOther = bpWindowSettings.getDefaultActionDisableOther();
    }

    static String getTypeString(int type) {
        switch (type) {
            case 0: {
                return DbgArb.getString(27);
            }
            case 1: {
                return DbgArb.getString(25);
            }
            case 7: {
                return DbgArb.getString(39);
            }
            case 2: {
                return DbgArb.getString(29);
            }
            case 3: {
                return DbgArb.getString(31);
            }
            case 4: {
                return DbgArb.getString(33);
            }
            case 5: {
                return DbgArb.getString(35);
            }
            case 6: {
                return DbgArb.getString(37);
            }
            case 8: {
                return DbgArb.getString(40);
            }
        }
        return "";
    }

    public static int getTypeStringMnemonic(int type) {
        switch (type) {
            case 0: {
                return DbgArb.getInteger(28);
            }
            case 1: {
                return DbgArb.getInteger(26);
            }
            case 2: {
                return DbgArb.getInteger(30);
            }
            case 3: {
                return DbgArb.getInteger(32);
            }
            case 4: {
                return DbgArb.getInteger(34);
            }
            case 5: {
                return DbgArb.getInteger(36);
            }
            case 6: {
                return DbgArb.getInteger(38);
            }
        }
        return -1;
    }

    void setMarker(BreakpointMarkerAPI marker) {
        this.marker = marker;
    }

    BreakpointMarkerAPI getMarker() {
        return this.marker;
    }

    public Object copyTo(Object object) {
        BreakpointSettings copy = object != null ? (BreakpointSettings)object : new BreakpointSettings();
        this.copyToImpl(copy);
        return copy;
    }

    protected final void copyToImpl(BreakpointSettings copy) {
        this.hash.copyTo(copy.hash);
    }

    private String getString(String name, String defaultValue) {
        if (this.hash.containsKey(name)) {
            return this.hash.getString(name);
        }
        return defaultValue;
    }

    private void setString(String name, String value, String defaultValue) {
        if (value != null && value.trim().length() > 0 && !value.equals(defaultValue)) {
            this.hash.putString(name, value);
        } else {
            this.hash.remove(name);
        }
    }

    private int getInt(String name, int defaultValue) {
        if (this.hash.containsKey(name)) {
            return this.hash.getInt(name);
        }
        return defaultValue;
    }

    private void setInt(String name, int value, int defaultValue) {
        if (value != defaultValue) {
            this.hash.putInt(name, value);
        } else {
            this.hash.remove(name);
        }
    }

    private long getLong(String name, long defaultValue) {
        if (this.hash.containsKey(name)) {
            return this.hash.getLong(name);
        }
        return defaultValue;
    }

    private void setLong(String name, long value, long defaultValue) {
        if (value != defaultValue) {
            this.hash.putLong(name, value);
        } else {
            this.hash.remove(name);
        }
    }

    private boolean getBoolean(String name, boolean defaultValue) {
        if (this.hash.containsKey(name)) {
            return this.hash.getBoolean(name);
        }
        return defaultValue;
    }

    private void setBoolean(String name, boolean value, boolean defaultValue) {
        if (value != defaultValue) {
            this.hash.putBoolean(name, value);
        } else {
            this.hash.remove(name);
        }
    }

    private URL getURL(String name) {
        return this.hash.getURL(name);
    }

    private void setURL(String name, URL url) {
        if (url != null) {
            this.hash.putURL(name, url);
        } else {
            this.hash.remove(name);
        }
    }

    private String[] getStrings(String name) {
        ListStructure list = this.hash.getListStructure(name);
        if (list == null) {
            return null;
        }
        String[] strings = new String[list.size()];
        for (int x = 0; x < list.size(); ++x) {
            Object object = list.get(x);
            strings[x] = object == null ? "" : object.toString();
        }
        return strings;
    }

    private void setStrings(String name, String[] strings) {
        if (strings != null && strings.length > 0) {
            ListStructure list = ListStructure.newInstance();
            for (String s : strings) {
                list.add((Object)s);
            }
            this.hash.putListStructure(name, list);
        } else {
            this.hash.remove(name);
        }
    }

    public URL getOwnerURL() {
        return this.getURL(OWNER_URL);
    }

    public void setOwnerURL(URL ownerURL) {
        this.setURL(OWNER_URL, ownerURL);
    }

    public boolean isPersistent() {
        return this.getBoolean(PERSISTENT, false);
    }

    public void setPersistent(boolean persistent) {
        this.setBoolean(PERSISTENT, persistent, false);
    }

    public boolean isJavaSpecific() {
        return this.getBoolean(JAVA_SPECIFIC, false);
    }

    public void setJavaSpecific(boolean javaSpecific) {
        this.setBoolean(JAVA_SPECIFIC, javaSpecific, false);
    }

    public int getType() {
        return this.getInt(TYPE, -1);
    }

    public void setType(int type) {
        this.setInt(TYPE, type, -1);
    }

    public String getPkg() {
        return this.getString(PACKAGE, "");
    }

    public void setPkg(String pkg) {
        this.setString(PACKAGE, pkg, "");
    }

    public String getFile() {
        return this.getString(FILE, "");
    }

    public void setFile(String file) {
        this.setString(FILE, file, "");
    }

    public int getLine() {
        if (this.marker != null) {
            return this.marker.line();
        }
        return this.getInt(LINE, 0);
    }

    public void setLine(int line) {
        if (this.marker != null) {
            this.marker.line(line);
        }
        this.setInt(LINE, line, 0);
    }

    private void syncLineFromMarker() {
        if (this.marker == null) {
            return;
        }
        this.setInt(LINE, this.marker.line(), -1);
    }

    public String getMethod() {
        return this.getString(METHOD, "");
    }

    public void setMethod(String method) {
        this.setString(METHOD, method, "");
    }

    public int getOffset() {
        if (this.marker != null) {
            return this.marker.offset();
        }
        return this.getInt(OFFSET, -1);
    }

    public void setOffset(int offset) {
        if (this.marker != null) {
            this.marker.offset(offset);
        }
        this.setInt(OFFSET, offset, -1);
    }

    private void syncOffsetFromMarker() {
        if (this.marker == null) {
            return;
        }
        this.setInt(OFFSET, this.marker.offset(), -1);
    }

    public String getException() {
        return this.getString(EXCEPTION, "");
    }

    public void setException(String exception) {
        this.setString(EXCEPTION, exception, "");
    }

    public boolean isCaught() {
        return this.getBoolean(CAUGHT, true);
    }

    public void setCaught(boolean caught) {
        this.setBoolean(CAUGHT, caught, true);
    }

    public boolean isUncaught() {
        return this.getBoolean(UNCAUGHT, true);
    }

    public void setUncaught(boolean uncaught) {
        this.setBoolean(UNCAUGHT, uncaught, true);
    }

    public String getClassName() {
        return this.getString(CLASS_NAME, "");
    }

    public void setClassName(String className) {
        this.setString(CLASS_NAME, className, "");
    }

    public URL getURL() {
        return this.getURL(URL);
    }

    public void setURL(URL url) {
        this.setURL(URL, url);
    }

    public URL getProjectURL() {
        return this.getURL(PROJECT_URL);
    }

    public void setProjectURL(URL url) {
        this.setURL(PROJECT_URL, url);
    }

    public String getFieldName() {
        return this.getString(FIELD_NAME, "");
    }

    public void setFieldName(String fieldName) {
        this.setString(FIELD_NAME, fieldName, "");
    }

    public boolean isAccess() {
        return this.getBoolean(ACCESS, false);
    }

    public void setAccess(boolean access) {
        this.setBoolean(ACCESS, access, false);
    }

    public boolean isModify() {
        return this.getBoolean(MODIFY, true);
    }

    public void setModify(boolean modify) {
        this.setBoolean(MODIFY, modify, true);
    }

    public boolean isEnabled() {
        return this.getBoolean(ENABLED, true);
    }

    public void setEnabled(boolean enabled) {
        this.setBoolean(ENABLED, enabled, true);
    }

    public String getGroupName() {
        return this.getString(GROUP_NAME, "");
    }

    public void setGroupName(String groupName) {
        this.setString(GROUP_NAME, groupName, "");
    }

    public boolean isEditGroupName() {
        return this.getBoolean(EDIT_GROUP_NAME, true);
    }

    public void setEditGroupName(boolean isEditGroupName) {
        this.setBoolean(EDIT_GROUP_NAME, isEditGroupName, true);
    }

    public String getCondition() {
        return this.getString(CONDITION, "");
    }

    public void setCondition(String condition) {
        this.setString(CONDITION, condition, "");
    }

    public boolean isEditCondition() {
        return this.getBoolean(EDIT_CONDITION, true);
    }

    public void setEditCondition(boolean isEditCondition) {
        this.setBoolean(EDIT_CONDITION, isEditCondition, true);
    }

    public String getHiddenCondition() {
        return this.getString(HIDDEN_CONDITION, "");
    }

    public void setHiddenCondition(String hiddenCondition) {
        this.setString(HIDDEN_CONDITION, hiddenCondition, "");
    }

    public String getThreadName() {
        return this.getString(THREAD_NAME, "");
    }

    public void setThreadName(String threadName) {
        this.setString(THREAD_NAME, threadName, "");
    }

    public String getThreadNameNot() {
        return this.getString(THREAD_NAME_NOT, "");
    }

    public void setThreadNameNot(String threadNameNot) {
        this.setString(THREAD_NAME_NOT, threadNameNot, "");
    }

    public boolean isEditBreakForThreads() {
        return this.getBoolean(EDIT_BREAK_FOR_THREADS, true);
    }

    public void setEditBreakForThreads(boolean isEditBreakForThreads) {
        this.setBoolean(EDIT_BREAK_FOR_THREADS, isEditBreakForThreads, true);
    }

    public int getPassCount() {
        return this.getInt(PASS_COUNT, 0);
    }

    public void setPassCount(int passCount) {
        this.setInt(PASS_COUNT, passCount, 0);
    }

    public boolean isEditPassCount() {
        return this.getBoolean(EDIT_PASS_COUNT, true);
    }

    public void setEditPassCount(boolean isEditPassCount) {
        this.setBoolean(EDIT_PASS_COUNT, isEditPassCount, true);
    }

    public boolean isActionHalt() {
        return this.getBoolean(ACTION_HALT, this._defaultActionHalt);
    }

    public void setActionHalt(boolean actionHalt) {
        this.setBoolean(ACTION_HALT, actionHalt, this._defaultActionHalt);
    }

    public boolean isActionBeep() {
        return this.getBoolean(ACTION_BEEP, this._defaultActionBeep);
    }

    public void setActionBeep(boolean actionBeep) {
        this.setBoolean(ACTION_BEEP, actionBeep, this._defaultActionBeep);
    }

    public boolean isActionLog() {
        return this.getBoolean(ACTION_LOG, this._defaultActionLog);
    }

    public void setActionLog(boolean actionLog) {
        this.setBoolean(ACTION_LOG, actionLog, this._defaultActionLog);
    }

    public String getActionLogTag() {
        return this.getString(ACTION_LOG_TAG, this._defaultActionLogTag);
    }

    public void setActionLogTag(String actionLogTag) {
        this.setString(ACTION_LOG_TAG, actionLogTag, this._defaultActionLogTag);
    }

    public String getActionLogExpr() {
        return this.getString(ACTION_LOG_EXPR, this._defaultActionLogExpr);
    }

    public void setActionLogExpr(String actionLogExpr) {
        this.setString(ACTION_LOG_EXPR, actionLogExpr, this._defaultActionLogExpr);
    }

    public boolean isActionLogStack() {
        return this.getBoolean(ACTION_LOG_STACK, this._defaultActionLogStack);
    }

    public void setActionLogStack(boolean actionLogStack) {
        this.setBoolean(ACTION_LOG_STACK, actionLogStack, this._defaultActionLogStack);
    }

    public String getActionEnableOther() {
        return this.getString(ACTION_ENABLE_OTHER, this._defaultActionEnableOther);
    }

    public void setActionEnableOther(String actionEnableOther) {
        this.setString(ACTION_ENABLE_OTHER, actionEnableOther, this._defaultActionEnableOther);
    }

    public String getActionDisableOther() {
        return this.getString(ACTION_DISABLE_OTHER, this._defaultActionDisableOther);
    }

    public void setActionDisableOther(String actionDisableOther) {
        this.setString(ACTION_DISABLE_OTHER, actionDisableOther, this._defaultActionDisableOther);
    }

    public boolean isEditBreakpointHitActions() {
        return this.getBoolean(EDIT_BREAKPOINT_HIT_ACTIONS, true);
    }

    public void setEditBreakpointHitActions(boolean isEditBreakpointHitActions) {
        this.setBoolean(EDIT_BREAKPOINT_HIT_ACTIONS, isEditBreakpointHitActions, true);
    }

    public String getCustomDescription() {
        return this.getString(CUSTOM_DESCRIPTION, null);
    }

    public void setCustomDescription(String customDescription) {
        this.setString(CUSTOM_DESCRIPTION, customDescription, null);
    }

    public String getCustomTypeString() {
        return this.getString(CUSTOM_TYPE_STRING, null);
    }

    public void setCustomTypeString(String customTypeString) {
        this.setString(CUSTOM_TYPE_STRING, customTypeString, null);
    }

    public boolean isCustom() {
        return this.getCustomTypeString() != null;
    }

    public String getTypeString() {
        if (this.getCustomTypeString() != null) {
            return this.getCustomTypeString();
        }
        return BreakpointSettings.getTypeString(this.getType());
    }

    public String getDebuggerExtenderID() {
        return this.getString(DEBUGGER_EXTENDER_ID, null);
    }

    public void setDebuggerExtenderID(String debuggerExtenderID) {
        this.setString(DEBUGGER_EXTENDER_ID, debuggerExtenderID, null);
    }

    public String[] getPropertyKeys() {
        return this.getStrings(PROPERTY_KEYS);
    }

    public void setPropertyKeys(String[] propertyKeys) {
        this.setStrings(PROPERTY_KEYS, propertyKeys);
    }

    public String[] getPropertyValues() {
        return this.getStrings(PROPERTY_VALUES);
    }

    public void setPropertyValues(String[] propertyValues) {
        this.setStrings(PROPERTY_VALUES, propertyValues);
    }

    public long getCreationTimestamp() {
        long timestamp = this.getLong(CREATION_TIMESTAMP, 0L);
        if (timestamp == 0L) {
            timestamp = System.nanoTime();
            this.setCreationTimestamp(timestamp);
        }
        return timestamp;
    }

    public void setCreationTimestamp(long timestamp) {
        this.setLong(CREATION_TIMESTAMP, timestamp, 0L);
    }

    public boolean equals(Object o) {
        if (o == null || o.getClass() != this.getClass()) {
            return false;
        }
        return this.equalsImpl((BreakpointSettings)o);
    }

    protected final boolean equalsImpl(BreakpointSettings that) {
        return this.hash.equals((Object)that.hash);
    }
}

