/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.util.shell;

import oracle.kv.util.shell.Shell;
import oracle.kv.util.shell.ShellException;

public abstract class ShellCommand
implements Cloneable {
    protected static final String eol = Shell.eol;
    protected static final String eolt = Shell.eolt;
    protected final String name;
    protected final int prefixMatchLength;
    protected Shell.VariablesMap cmdVariables = null;
    private String prompt = null;

    protected ShellCommand(String name, int prefixMatchLength) {
        assert (name.length() >= prefixMatchLength);
        this.name = name;
        this.prefixMatchLength = prefixMatchLength;
        this.cmdVariables = new Shell.VariablesMap();
    }

    protected boolean isHidden() {
        return false;
    }

    protected boolean isDeprecated() {
        return false;
    }

    protected String getCommandName() {
        return this.name;
    }

    protected String getCommandSyntax() {
        return this.getCommandName();
    }

    protected abstract String getCommandDescription();

    protected boolean matches(String commandName) {
        return Shell.matches(commandName, this.name, this.prefixMatchLength);
    }

    public abstract String execute(String[] var1, Shell var2) throws ShellException;

    protected String getHelp(String[] args, Shell shell) {
        return this.getVerboseHelp();
    }

    protected String getVerboseHelp() {
        return this.getBriefHelp() + eolt + this.getCommandDescription();
    }

    protected String getBriefHelp() {
        return "Usage: " + this.getCommandSyntax();
    }

    public void setPrompt(String myPrompt) {
        this.prompt = myPrompt;
    }

    public String getPrompt() {
        return this.prompt;
    }

    public ShellCommand clone() {
        try {
            ShellCommand cmd = (ShellCommand)super.clone();
            cmd.cmdVariables = this.cmdVariables.clone();
            return cmd;
        }
        catch (CloneNotSupportedException neverHappens) {
            return null;
        }
    }

    public void addVariable(String varName, Object value) {
        this.cmdVariables.add(varName, value);
    }

    public void removeVariable(String varName) {
        this.cmdVariables.remove(varName);
    }

    public void clearVariables() {
        this.cmdVariables.reset();
    }

    public Object getVariable(String varName) {
        return this.cmdVariables.get(varName);
    }
}

