/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.util.kvlite;

import com.sleepycat.je.rep.NodeType;
import java.util.HashSet;
import java.util.List;
import oracle.kv.impl.admin.param.BootstrapParams;
import oracle.kv.impl.admin.param.GlobalParams;
import oracle.kv.impl.admin.param.RepNodeParams;
import oracle.kv.impl.admin.param.StorageNodeParams;
import oracle.kv.impl.metadata.Metadata;
import oracle.kv.impl.metadata.MetadataInfo;
import oracle.kv.impl.sna.StorageNodeAgentAPI;
import oracle.kv.impl.test.TestStatus;
import oracle.kv.impl.topo.Datacenter;
import oracle.kv.impl.topo.DatacenterType;
import oracle.kv.impl.topo.Partition;
import oracle.kv.impl.topo.RepGroup;
import oracle.kv.impl.topo.RepNode;
import oracle.kv.impl.topo.RepNodeId;
import oracle.kv.impl.topo.StorageNode;
import oracle.kv.impl.topo.StorageNodeId;
import oracle.kv.impl.topo.Topology;

public class KVLiteRepNode {
    private final StorageNodeAgentAPI sna;
    private final String kvstore;
    private Topology topo;
    private final BootstrapParams bp;

    public KVLiteRepNode(String kvstore, StorageNodeAgentAPI sna, BootstrapParams bp, int numPartitions) {
        this.bp = bp;
        this.sna = sna;
        this.kvstore = kvstore;
        this.createTopology(numPartitions);
    }

    public void run() throws Exception {
        this.registerSNA();
        this.createRepNode();
        TestStatus.setActive(true);
    }

    private void registerSNA() throws Exception {
        StorageNodeParams snp = new StorageNodeParams(new StorageNodeId(1), this.bp.getHostname(), this.bp.getRegistryPort(), "");
        GlobalParams gp = new GlobalParams(this.kvstore);
        this.sna.register(gp.getMap(), snp.getMap(), false);
    }

    private void createTopology(int numPartitions) {
        this.topo = new Topology(this.kvstore);
        Datacenter dc = Datacenter.newInstance(this.kvstore, 1, DatacenterType.PRIMARY);
        this.topo.add(dc);
        StorageNode sn = new StorageNode(dc, this.bp.getHostname(), this.bp.getRegistryPort());
        this.topo.add(sn);
        RepGroup rg = new RepGroup();
        this.topo.add(rg);
        RepNode rn = new RepNode((StorageNodeId)sn.getResourceId());
        rg.add(rn);
        for (int i = 0; i < numPartitions; ++i) {
            this.topo.add(new Partition(rg));
        }
        rn = this.topo.get(new RepNodeId(1, 1));
    }

    private RepNodeParams createRepNodeParams() {
        String host = this.bp.getHostname();
        int nodeHAPort = this.bp.getRegistryPort() + 1;
        String mountPoint = null;
        List<String> mountPoints = this.bp.getMountPoints();
        if (mountPoints != null && mountPoints.size() > 0) {
            mountPoint = mountPoints.get(0);
        }
        RepNodeParams rnp = new RepNodeParams(new StorageNodeId(1), new RepNodeId(1, 1), false, host, nodeHAPort, host, nodeHAPort, mountPoint, NodeType.ELECTABLE);
        return rnp;
    }

    private void createRepNode() throws Exception {
        RepNodeParams rnp = this.createRepNodeParams();
        HashSet<Metadata<? extends MetadataInfo>> metadataSet = new HashSet<Metadata<? extends MetadataInfo>>(1);
        metadataSet.add(this.topo);
        this.sna.createRepNode(rnp.getMap(), metadataSet);
    }
}

