/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.util.kvlite;

import java.io.File;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import oracle.kv.KVVersion;
import oracle.kv.impl.admin.param.BootstrapParams;
import oracle.kv.impl.param.ParameterMap;
import oracle.kv.impl.security.login.LoginHandle;
import oracle.kv.impl.security.login.LoginManager;
import oracle.kv.impl.sna.StorageNodeAgentAPI;
import oracle.kv.impl.sna.StorageNodeAgentImpl;
import oracle.kv.impl.topo.RepNodeId;
import oracle.kv.impl.topo.StorageNodeId;
import oracle.kv.impl.util.CommandParser;
import oracle.kv.impl.util.ConfigUtils;
import oracle.kv.impl.util.ConfigurableService;
import oracle.kv.impl.util.ServiceUtils;
import oracle.kv.impl.util.registry.RegistryUtils;
import oracle.kv.impl.util.server.LoggerUtils;
import oracle.kv.util.kvlite.KVLiteAdmin;
import oracle.kv.util.kvlite.KVLiteRepNode;

public class KVLite {
    public static final String CONFIG_NAME = "config.xml";
    public static final int DEFAULT_NUM_PARTITIONS = 10;
    private static final String DEFAULT_ROOT = "./kvroot";
    private static final String DEFAULT_STORE = "kvstore";
    private static final int DEFAULT_PORT = 5000;
    private static final int DEFAULT_ADMIN = 5001;
    private static final LoginHandle NULL_LOGIN_HDL = null;
    private static final LoginManager NULL_LOGIN_MGR = null;
    public static final String COMMAND_NAME = "kvlite";
    public static final String COMMAND_DESC = "start KVLite; note all args (-host, -port, etc) have defaults";
    public static final String COMMAND_ARGS = KVLite.mkArgLine(CommandParser.getRootUsage(), "./kvroot") + "\n\t" + KVLite.mkArgLine(CommandParser.getStoreUsage(), "kvstore") + "\n\t" + KVLite.mkArgLine(CommandParser.getHostUsage(), "local host name") + "\n\t" + KVLite.mkArgLine(CommandParser.getPortUsage(), String.valueOf(5000)) + "\n\t" + KVLite.mkArgLine(CommandParser.getAdminUsage(), String.valueOf(5001));
    private String haPortRange;
    private String servicePortRange = null;
    private String host;
    private String kvroot;
    private String kvstore;
    private String mountPoint;
    private int port;
    private int adminPort;
    private int numPartitions;
    private StorageNodeAgentImpl sna;
    private StorageNodeAgentAPI snaAPI;
    private boolean useThreads;
    private boolean verbose;
    private boolean enableJmx;
    private ParameterMap policyMap;

    private static String mkArgLine(String argUsage, String defaultValue) {
        StringBuilder builder = new StringBuilder();
        builder.append(CommandParser.optional(argUsage));
        while (builder.length() < 30) {
            builder.append(' ');
        }
        builder.append("# defaults to: ");
        builder.append(defaultValue);
        return builder.toString();
    }

    public KVLite(String kvroot, String kvstore, int registryPort, int adminPort, String hostname, String haPortRange, String servicePortRange, int numPartitions, String mountPoint, boolean useThreads) {
        this.kvroot = kvroot;
        this.kvstore = kvstore;
        this.port = registryPort;
        this.adminPort = adminPort;
        this.host = hostname;
        this.haPortRange = haPortRange;
        this.servicePortRange = servicePortRange;
        this.useThreads = useThreads;
        this.mountPoint = mountPoint;
        this.sna = null;
        this.policyMap = null;
        this.verbose = true;
        this.enableJmx = false;
        this.numPartitions = numPartitions;
    }

    private KVLite() {
        this(null, null, 0, 0, "localhost", null, null, 10, null, true);
    }

    public ParameterMap getPolicyMap() {
        return this.policyMap;
    }

    public void setPolicyMap(ParameterMap map) {
        this.policyMap = map;
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    public boolean getVerbose() {
        return this.verbose;
    }

    public void setEnableJmx(boolean enableJmx) {
        this.enableJmx = enableJmx;
    }

    public boolean getEnableJmx() {
        return this.enableJmx;
    }

    public int getNumPartitions() {
        return this.numPartitions;
    }

    public void setNumPartitions(int numPartitions) {
        this.numPartitions = numPartitions;
    }

    public File getMountPoint() {
        if (this.mountPoint != null) {
            return new File(this.mountPoint);
        }
        return null;
    }

    public StorageNodeId getStorageNodeId() {
        return new StorageNodeId(1);
    }

    private BootstrapParams generateBootstrapDir() throws Exception {
        File rootDir = new File(this.kvroot);
        rootDir.mkdir();
        File configfile = new File(this.kvroot + File.separator + CONFIG_NAME);
        File secfile = new File(this.kvroot + File.separator + "security.policy");
        if (configfile.exists()) {
            return ConfigUtils.getBootstrapParams(configfile);
        }
        if (this.kvstore == null || this.port == 0) {
            System.err.println("Store does not exist and there are insufficient arguments to create it.");
            new KVLiteParser(new String[0]).usage(null);
        }
        ArrayList<String> mountPoints = null;
        if (this.mountPoint != null) {
            mountPoints = new ArrayList<String>();
            mountPoints.add(this.mountPoint);
        }
        if (this.haPortRange == null) {
            this.haPortRange = this.port + 5 + "," + (this.port + 7);
        }
        BootstrapParams bp = new BootstrapParams(this.kvroot, this.host, this.host, this.haPortRange, this.servicePortRange, null, this.port, this.adminPort, 1, mountPoints, false);
        if (this.enableJmx) {
            bp.setMgmtClass("oracle.kv.impl.mgmt.jmx.JmxAgent");
        }
        ConfigUtils.createBootstrapConfig(bp, configfile.toString());
        if (!secfile.exists()) {
            ConfigUtils.createSecurityPolicyFile(secfile);
        }
        return bp;
    }

    private void startSNA() throws Exception {
        String[] snaArgs = this.useThreads ? new String[]{"-root", this.kvroot, "-config", CONFIG_NAME, "-threads"} : new String[]{"-root", this.kvroot, "-config", CONFIG_NAME};
        this.sna = new StorageNodeAgentImpl(this.adminPort != 0);
        try {
            this.sna.parseArgs(snaArgs);
            this.sna.start();
            if (!this.useThreads) {
                this.sna.addShutdownHook();
            }
        }
        catch (Exception e) {
            this.sna = null;
            throw e;
        }
        this.snaAPI = StorageNodeAgentAPI.wrap(this.sna, NULL_LOGIN_HDL);
    }

    private void showVersion() {
        System.out.println(KVVersion.CURRENT_VERSION);
        System.exit(0);
    }

    private boolean parseArgs(String[] args) {
        String localHostname = "localhost";
        try {
            localHostname = InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException e) {
            // empty catch block
        }
        KVLiteParser kp = new KVLiteParser(args);
        kp.setDefaults(DEFAULT_ROOT, DEFAULT_STORE, localHostname, 5000, 5001);
        kp.parseArgs();
        this.kvroot = kp.getRootDir();
        this.kvstore = kp.getStoreName();
        this.port = kp.getRegistryPort();
        this.adminPort = kp.getAdminPort();
        this.host = kp.getHostname();
        return kp.getShutdown();
    }

    public void shutdownStore(boolean force) {
        File configfile = new File(this.kvroot + File.separator + CONFIG_NAME);
        if (!configfile.exists()) {
            System.err.println("Cannot find configuration file for root: " + this.kvroot);
            return;
        }
        try {
            BootstrapParams bp = ConfigUtils.getBootstrapParams(configfile);
            String name = RegistryUtils.bindingName(bp.getStoreName(), this.getStorageNodeId().getFullName(), RegistryUtils.InterfaceType.MAIN);
            StorageNodeAgentAPI snai = RegistryUtils.getStorageNodeAgent(bp.getHostname(), bp.getRegistryPort(), name, NULL_LOGIN_MGR);
            System.err.println("Shutting down store " + bp.getStoreName() + " in kvroot: " + this.kvroot);
            snai.shutdown(true, force);
        }
        catch (Exception e) {
            System.err.println("Exception in shutdown, maybe the service is not running: " + e.getMessage());
        }
    }

    public void start() {
        this.start(false);
    }

    public void start(boolean waitForServices) {
        try {
            BootstrapParams bp = this.generateBootstrapDir();
            this.startSNA();
            if (this.sna.isRegistered()) {
                if (this.verbose) {
                    System.out.println("Opened existing kvlite store with config:\n-root " + this.kvroot + " " + "-store" + " " + this.sna.getStoreName() + " " + "-host" + " " + this.sna.getStorageNodeAgent().getHostname() + " " + "-port" + " " + this.sna.getRegistryPort() + " " + "-admin" + " " + this.sna.getStorageNodeAgent().getBootstrapParams().getAdminHttpPort());
                }
                return;
            }
            if (this.numPartitions == 0) {
                this.numPartitions = 10;
            }
            if (this.adminPort != 0) {
                new KVLiteAdmin(this.kvstore, bp, this.policyMap, this.numPartitions).run();
            } else {
                new KVLiteRepNode(this.kvstore, this.snaAPI, bp, this.numPartitions).run();
            }
            if (this.verbose) {
                System.err.println("Created new kvlite store with args:\n-root " + this.kvroot + " " + "-store" + " " + this.kvstore + " " + "-host" + " " + this.host + " " + "-port" + " " + this.port + " " + "-admin" + " " + this.adminPort);
            }
            if (waitForServices) {
                if (this.verbose) {
                    System.out.println("Waiting for services to start");
                }
                if (this.adminPort != 0) {
                    if (this.verbose) {
                        System.out.println("Waiting for admin at " + this.host + ":" + this.port);
                    }
                    ServiceUtils.waitForAdmin(this.host, this.port, NULL_LOGIN_MGR, 10L, ConfigurableService.ServiceStatus.RUNNING);
                }
                ConfigurableService.ServiceStatus[] target = new ConfigurableService.ServiceStatus[]{ConfigurableService.ServiceStatus.RUNNING};
                if (this.verbose) {
                    System.out.println("Waiting for RepNode for store " + this.kvstore + " at " + this.host + ":" + this.port);
                }
                ServiceUtils.waitForRepNodeAdmin(this.kvstore, this.host, this.port, new RepNodeId(1, 1), this.getStorageNodeId(), NULL_LOGIN_MGR, 10L, target);
            }
        }
        catch (Exception e) {
            String trace = LoggerUtils.getStackTrace(e);
            System.err.println("KVLite: exception in start: " + trace);
        }
    }

    public void stop(boolean force) {
        if (this.verbose) {
            System.out.println("Stopping KVLite store " + this.kvstore);
        }
        if (this.sna == null) {
            return;
        }
        try {
            this.snaAPI.shutdown(true, force);
        }
        catch (Exception e) {
            System.err.println("Exception in stop: " + e.getMessage());
        }
    }

    public StorageNodeAgentImpl getSNA() {
        return this.sna;
    }

    public StorageNodeAgentAPI getSNAPI() {
        return this.snaAPI;
    }

    public static void main(String[] args) {
        KVLite store = new KVLite();
        boolean shutdown = store.parseArgs(args);
        if (shutdown) {
            store.shutdownStore(false);
        } else {
            store.start();
        }
    }

    class KVLiteParser
    extends CommandParser {
        private static final String NOTHREADS_FLAG = "-nothreads";
        private static final String VERSION_FLAG = "-version";
        private static final String PARTITION_FLAG = "-partitions";
        private static final String HARANGE_FLAG = "-harange";
        private static final String SERVICERANGE_FLAG = "-servicerange";
        private static final String MOUNT_FLAG = "-storagedir";
        private static final String OLD_MOUNT_FLAG = "-mount";
        private static final String JMX_FLAG = "-jmx";
        private boolean shutdown;

        public KVLiteParser(String[] args) {
            super(args);
            this.shutdown = false;
        }

        public boolean getShutdown() {
            return this.shutdown;
        }

        @Override
        protected void verifyArgs() {
            if (this.getRootDir() == null) {
                this.missingArg("-root");
            }
        }

        @Override
        protected boolean checkArg(String arg) {
            if (arg.equals("-shutdown")) {
                this.shutdown = true;
                return true;
            }
            if (arg.equals(NOTHREADS_FLAG)) {
                KVLite.this.useThreads = false;
                return true;
            }
            if (arg.equals(JMX_FLAG)) {
                KVLite.this.enableJmx = true;
                return true;
            }
            if (arg.equals(VERSION_FLAG)) {
                KVLite.this.showVersion();
                return true;
            }
            if (arg.equals(HARANGE_FLAG)) {
                KVLite.this.haPortRange = this.nextArg(arg);
                return true;
            }
            if (arg.equals(SERVICERANGE_FLAG)) {
                KVLite.this.servicePortRange = this.nextArg(arg);
                return true;
            }
            if (arg.equals(PARTITION_FLAG)) {
                KVLite.this.numPartitions = Integer.parseInt(this.nextArg(arg));
                return true;
            }
            if (arg.equals(MOUNT_FLAG)) {
                KVLite.this.mountPoint = this.nextArg(arg);
                return true;
            }
            if (arg.equals(OLD_MOUNT_FLAG)) {
                KVLite.this.mountPoint = this.nextArg(arg);
                return true;
            }
            return false;
        }

        @Override
        public void usage(String errorMsg) {
            if (errorMsg != null) {
                System.err.println(errorMsg);
            }
            System.err.println("Usage: java -jar KVHOME/lib/kvstore.jar kvlite\n\t" + COMMAND_ARGS);
            System.exit(1);
        }
    }
}

