/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.shell;

import java.rmi.RemoteException;
import java.util.StringTokenizer;
import oracle.kv.FaultException;
import oracle.kv.StatementResult;
import oracle.kv.impl.admin.client.CommandShell;
import oracle.kv.util.shell.Shell;
import oracle.kv.util.shell.ShellCommand;
import oracle.kv.util.shell.ShellException;
import oracle.kv.util.shell.ShellUsageException;

public class ExecuteCommand
extends ShellCommand {
    private static final String GRANT_USAGE = "To grant roles to a user or a role, use the syntax of:" + eol + "GRANT role_name (,role_name)* TO (USER user_name | " + "ROLE role_name)" + eol + eol + "To grant system privileges to a role, use the syntax of:" + eol + "GRANT (system_privilege | ALL PRIVILEGES) " + "(,(system_privilege | ALL PRIVILEGES))* TO role_name" + eol + eol + "To grant object privileges to a role, use the syntax of:" + eol + "GRANT (object_privilege | ALL [PRIVILEGES]) " + "(,(object_privilege | ALL [PRIVILEGES]))* ON object TO role_name";
    private static final String REVOKE_USAGE = "To revoke roles from a user or a role, use the syntax of:" + eol + "REVOKE role_name (,role_name)* FROM (USER user_name | " + "ROLE role_name)" + eol + eol + "To revoke system privileges from a role, use the syntax of:" + eol + "REVOKE (system_privilege | ALL PRIVILEGES) " + "(,(system_privilege | ALL PRIVILEGES))* FROM role_name" + eol + eol + "To revoke object privileges from a role, use the syntax of:" + eol + "REVOKE (object_privilege | ALL [PRIVILEGES]) " + "(,(object_privilege | ALL [PRIVILEGES]))* ON object FROM role_name";

    public ExecuteCommand() {
        super("execute", 4);
    }

    @Override
    public String execute(String[] args, Shell shell) throws ShellException {
        String ddlStatement;
        if (args.length != 2) {
            shell.badArgCount(this);
        }
        if ((ddlStatement = args[1]).length() == 0) {
            throw new ShellUsageException("Empty statement", this);
        }
        CommandShell cmd = (CommandShell)shell;
        StatementResult result = null;
        try {
            result = cmd.getStore().executeSync(ddlStatement);
            return this.displayResults(result);
        }
        catch (IllegalArgumentException iae) {
            StringBuilder sb = new StringBuilder();
            sb.append(iae.getMessage());
            sb.append("\nUsage:\n\n");
            sb.append(this.getUsage(ddlStatement)).append("\n");
            return sb.toString();
        }
        catch (FaultException e) {
            if (e.getCause() != null && e.getCause().getClass().equals(RemoteException.class)) {
                RemoteException re = (RemoteException)e.getCause();
                cmd.noAdmin(re);
                return "failed";
            }
            return e.getMessage();
        }
    }

    private String getUsage(String ddlStatement) {
        StringTokenizer t = new StringTokenizer(ddlStatement);
        String keyword = t.nextToken();
        if (keyword.equalsIgnoreCase("create")) {
            String secondWord = null;
            if (t.hasMoreTokens()) {
                secondWord = t.nextToken();
            }
            if ("index".equalsIgnoreCase(secondWord)) {
                return "CREATE INDEX [IF NOT EXISTS]\n     index_name on table_name (fieldName [,fieldName]*)";
            }
            if ("user".equalsIgnoreCase(secondWord)) {
                return "CREATE USER user_name IDENTIFIED BY password\n  [ACCOUNT LOCK|UNLOCK] [ADMIN] [PASSWORD EXPIRE]\n  [PASSWORD LIFETIME duration]";
            }
            if ("role".equalsIgnoreCase(secondWord)) {
                return "CREATE ROLE role_name";
            }
            return "CREATE TABLE [IF NOT EXISTS] table_name (\n  (table_definition (,table_definition)*),\n   primary_key_definition";
        }
        if (keyword.equalsIgnoreCase("drop")) {
            String secondWord = null;
            if (t.hasMoreTokens()) {
                secondWord = t.nextToken();
            }
            if ("index".equalsIgnoreCase(secondWord)) {
                return "DROP INDEX [IF EXISTS] index_name ON table_name";
            }
            if ("user".equalsIgnoreCase(secondWord)) {
                return "DROP USER user_name";
            }
            if ("role".equalsIgnoreCase(secondWord)) {
                return "DROP ROLE role_name";
            }
            return "DROP TABLE [IF EXISTS] table_name";
        }
        if (keyword.equalsIgnoreCase("alter")) {
            String secondWord = null;
            if (t.hasMoreTokens()) {
                secondWord = t.nextToken();
            }
            if ("user".equalsIgnoreCase(secondWord)) {
                return "ALTER USER user_name\n  [IDENTIFIED BY password [RETAIN CURRENT PASSWORD]]\n  [CLEAR RETAINED PASSWORD] [PASSWORD EXPIRE]\n  [PASSWORD LIFETIME duration] [ACCOUNT UNLOCK|LOCK]";
            }
            return "ALTER TABLE table_name (\n  ADD field_name field_type\n| DROP field_name)";
        }
        if (keyword.equalsIgnoreCase("grant")) {
            return GRANT_USAGE;
        }
        if (keyword.equalsIgnoreCase("revoke")) {
            return REVOKE_USAGE;
        }
        if (keyword.equalsIgnoreCase("show")) {
            return "SHOW [AS JSON]\n  TABLES\n  USERS\n  ROLES\n  | TABLE table_name\n  | USER user_name\n  | ROLE role_name\n  | INDEXES ON table_name";
        }
        if (keyword.equalsIgnoreCase("describe") || keyword.equalsIgnoreCase("desc")) {
            return "(DESCRIBE|DESC) [AS JSON]\n  TABLE table_name (field_name (,field_name)*)?\n  | INDEX index_name ON table_name";
        }
        return "Unknown statement";
    }

    private String displayResults(StatementResult result) {
        if (result.getErrorMessage() != null) {
            return result.getErrorMessage() + "\n" + result.getInfo();
        }
        if (!result.isDone()) {
            return "Statement did not complete.";
        }
        if (result.isSuccessful()) {
            if (result.getResult() != null) {
                return result.getResult();
            }
            if (result.getInfo().equals("Statement did not require execution")) {
                return result.getInfo();
            }
            return "Statement completed successfully";
        }
        return "Statement did not complete successfully:\n" + result.getInfo();
    }

    @Override
    protected String getCommandSyntax() {
        return this.name + " <statement>";
    }

    @Override
    protected String getCommandDescription() {
        return "Executes the specified statement synchronously. The statement" + eolt + "must be enclosed in single or double quotes.";
    }
}

