/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.util;

import java.util.Arrays;
import java.util.List;
import java.util.StringTokenizer;

public class PortRange {
    public static final String UNCONSTRAINED = "0";
    public static final int PORTS_PER_SN = 3;
    public static final int PORTS_PER_RN = 3;
    public static final int PORTS_PER_ADMIN = 2;
    public static final int SECURE_PORTS_PER_SN = 1;
    public static final int SECURE_PORTS_PER_RN = 1;
    public static final int SECURE_PORTS_PER_ADMIN = 1;

    public static void validateHA(String portRange) throws IllegalArgumentException {
        String problem = portRange + " is not valid; format should be [firstPort,secondPort]";
        StringTokenizer tokenizer = new StringTokenizer(portRange, ",");
        if (tokenizer.countTokens() != 2) {
            throw new IllegalArgumentException(problem);
        }
        try {
            int firstPort = Integer.parseInt(tokenizer.nextToken());
            int secondPort = Integer.parseInt(tokenizer.nextToken());
            if (firstPort < 1 || secondPort < 1) {
                throw new IllegalArgumentException(problem + ", ports must be > 0");
            }
            if (firstPort > secondPort) {
                throw new IllegalArgumentException(problem + ", firstPort must be <= secondPort");
            }
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException(problem + ", not a valid number " + e.getMessage());
        }
    }

    public static void validateService(String portRange) throws IllegalArgumentException {
        if (PortRange.isUnconstrained(portRange)) {
            return;
        }
        PortRange.validateHA(portRange);
    }

    public static boolean isUnconstrained(String portRange) {
        return UNCONSTRAINED.equals(portRange);
    }

    public static void validateDisjoint(String portRange, String otherRange) {
        if (PortRange.isUnconstrained(portRange) || PortRange.isUnconstrained(otherRange)) {
            return;
        }
        List<Integer> r1 = PortRange.getRange(portRange);
        List<Integer> r2 = PortRange.getRange(otherRange);
        if (r1.get(0) < r2.get(0) && r1.get(1) < r2.get(0)) {
            return;
        }
        if (r2.get(0) < r1.get(0) && r2.get(1) < r1.get(0)) {
            return;
        }
        throw new IllegalArgumentException("Overlapping port ranges: " + portRange + " " + otherRange);
    }

    public static int rangeSize(String portRange) {
        if (PortRange.isUnconstrained(portRange)) {
            return Integer.MAX_VALUE;
        }
        List<Integer> r = PortRange.getRange(portRange);
        return r.get(1) - r.get(0) + 1;
    }

    public static void validateSufficientPorts(String portRange, int capacity, boolean isSecure, boolean includeAdmin, int mgmtPorts) {
        int required;
        int size = PortRange.rangeSize(portRange);
        int n = isSecure ? 4 + 4 * capacity + mgmtPorts + (includeAdmin ? 3 : 0) : (required = 3 + 3 * capacity + mgmtPorts + (includeAdmin ? 2 : 0));
        if (size < required) {
            throw new IllegalArgumentException("Service port range is too small. " + size + " ports were specified and " + required + " are required");
        }
    }

    public static List<Integer> getRange(String portRange) {
        if (PortRange.isUnconstrained(portRange)) {
            throw new IllegalArgumentException("Unconstrained port range");
        }
        StringTokenizer tokenizer = new StringTokenizer(portRange, ",");
        if (tokenizer.countTokens() != 2) {
            throw new IllegalArgumentException(portRange + " is not a valid port range expression");
        }
        return Arrays.asList(Integer.parseInt(tokenizer.nextToken()), Integer.parseInt(tokenizer.nextToken()));
    }

    public static boolean contains(String portRange, int port) {
        List<Integer> range = PortRange.getRange(portRange);
        return range.get(0) <= port && range.get(1) >= port;
    }
}

