/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.util.Enumeration;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.kv.impl.util.server.LoggerUtils;
import oracle.kv.util.MessageFileProcessor;

public class NoSQLMessagesResourceBundle
extends ResourceBundle {
    protected LineNumberReader messageFile = null;
    private Logger logger = null;
    private String resourceName = null;

    private NoSQLMessagesResourceBundle(LineNumberReader msgLnReader) {
        this.messageFile = msgLnReader;
        this.logger = LoggerUtils.getLogger(this.getClass(), this.getClass().getName());
    }

    public NoSQLMessagesResourceBundle() {
        this.logger = LoggerUtils.getLogger(this.getClass(), this.getClass().getName());
        NoSQLMessagesResourceBundle rb = (NoSQLMessagesResourceBundle)ResourceBundle.getBundle("messages", new ResourceBundle.Control(){

            @Override
            public ResourceBundle newBundle(String baseName, Locale locale, String format, ClassLoader loader, boolean reload) throws IllegalAccessException, InstantiationException, IOException {
                String bundleName = this.toBundleName(baseName, locale);
                NoSQLMessagesResourceBundle.this.resourceName = this.toResourceName(bundleName, "properties");
                InputStream stream = loader.getResourceAsStream(NoSQLMessagesResourceBundle.this.resourceName);
                if (stream != null) {
                    NoSQLMessagesResourceBundle.this.messageFile = new LineNumberReader(new BufferedReader(new InputStreamReader(stream)));
                    return new NoSQLMessagesResourceBundle(NoSQLMessagesResourceBundle.this.messageFile);
                }
                throw new InstantiationException("Unable to locate " + baseName + " in classpath");
            }
        });
        this.logger = rb.logger;
        this.messageFile = rb.messageFile;
    }

    @Override
    public Enumeration<String> getKeys() {
        throw new RuntimeException(NoSQLMessagesResourceBundle.class.getName() + ".getKeys() called but not implemented!");
    }

    @Override
    public Object handleGetObject(String key) {
        try {
            return MessageFileProcessor.getMessageForKey(key, this.messageFile);
        }
        catch (Exception e) {
            this.logger.log(Level.SEVERE, "Unable to read message for key " + key + " from message file " + this.resourceName + " error: " + e.toString());
            return null;
        }
    }
}

