/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.util;

import java.io.InputStream;
import java.io.PrintStream;
import java.util.Arrays;
import java.util.List;
import oracle.kv.KVVersion;
import oracle.kv.impl.diagnostic.DiagnosticCollectCommand;
import oracle.kv.impl.diagnostic.DiagnosticSetupCommand;
import oracle.kv.impl.diagnostic.DiagnosticVerifyCommand;
import oracle.kv.impl.diagnostic.ssh.SSHClientManager;
import oracle.kv.impl.util.CommandParser;
import oracle.kv.util.shell.Shell;
import oracle.kv.util.shell.ShellCommand;
import oracle.kv.util.shell.ShellException;

public class DiagnosticShell
extends Shell {
    public static final String COMMAND_NAME = "diagnostics";
    public static final String COMMAND_DESC = "runs the diagnostics command line interface";
    public static final String COMMAND_ARGS = "(setup|collect|" + eol + "verify)[args]";
    private boolean noprompt = false;
    private String[] commandToRun;
    private int nextCommandIdx = 0;
    private DiagnosticParser parser;
    static final String prompt = "diagnostics-> ";
    static final String usageHeader = "Oracle NoSQL Database Diagnostic Utility Commands:" + eol;
    static final String versionString = " (" + KVVersion.CURRENT_VERSION.getNumericVersionString() + ")";
    private static List<? extends ShellCommand> commands = Arrays.asList(new DiagnosticSetupCommand(), new DiagnosticCollectCommand(), new DiagnosticVerifyCommand(), new Shell.ExitCommand(), new Shell.HelpCommand());

    public DiagnosticShell(InputStream input, PrintStream output) {
        super(input, output);
    }

    @Override
    public void init() {
    }

    @Override
    public void shutdown() {
        SSHClientManager.clearClients();
    }

    @Override
    public List<? extends ShellCommand> getCommands() {
        return commands;
    }

    @Override
    public String getPrompt() {
        return this.noprompt ? null : prompt;
    }

    @Override
    public String getUsageHeader() {
        return usageHeader;
    }

    @Override
    public boolean doRetry() {
        return false;
    }

    public void start() {
        this.init();
        if (this.commandToRun != null) {
            try {
                this.run(this.commandToRun[0], this.commandToRun);
            }
            catch (ShellException se) {
                this.handleShellException(this.commandToRun[0], se);
            }
            catch (Exception e) {
                this.handleUnknownException(this.commandToRun[0], e);
            }
        } else {
            this.loop();
        }
        this.shutdown();
    }

    public void parseArgs(String[] args) {
        this.parser = new DiagnosticParser(args);
        this.parser.parseArgs();
    }

    public static void main(String[] args) {
        DiagnosticShell shell = new DiagnosticShell(System.in, System.out);
        shell.parseArgs(args);
        shell.start();
        if (shell.getExitCode() != 0) {
            System.exit(shell.getExitCode());
        }
    }

    static /* synthetic */ String[] access$002(DiagnosticShell x0, String[] x1) {
        x0.commandToRun = x1;
        return x1;
    }

    private class DiagnosticParser
    extends CommandParser {
        public static final String NOPROMPT_FLAG = "-noprompt";

        private DiagnosticParser(String[] args) {
            super(args, true);
        }

        @Override
        protected void verifyArgs() {
            if (DiagnosticShell.this.commandToRun != null && DiagnosticShell.this.nextCommandIdx < DiagnosticShell.this.commandToRun.length) {
                this.usage("Flags may not follow commands");
            }
        }

        @Override
        public void usage(String errorMsg) {
            if (errorMsg != null) {
                System.err.println(errorMsg);
            }
            System.err.println("Usage: java -jar KVHOME/lib/kvstore.jar diagnostics" + Shell.eolt + COMMAND_ARGS);
            System.exit(1);
        }

        @Override
        protected boolean checkArg(String arg) {
            if (NOPROMPT_FLAG.equals(arg)) {
                DiagnosticShell.this.noprompt = true;
                return true;
            }
            this.addToCommand(arg);
            return true;
        }

        private void addToCommand(String arg) {
            if (DiagnosticShell.this.commandToRun == null) {
                DiagnosticShell.access$002(DiagnosticShell.this, new String[this.getNRemainingArgs() + 1]);
            }
            ((DiagnosticShell)DiagnosticShell.this).commandToRun[((DiagnosticShell)DiagnosticShell.this).nextCommandIdx++] = arg;
        }
    }
}

