/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.util;

import java.io.IOException;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicLong;
import oracle.kv.AuthenticationFailureException;
import oracle.kv.KVStoreException;
import oracle.kv.PasswordCredentials;
import oracle.kv.impl.rep.RepNodeStatus;
import oracle.kv.impl.rep.admin.RepNodeAdminAPI;
import oracle.kv.impl.security.login.RepNodeLoginManager;
import oracle.kv.impl.security.util.KVStoreLogin;
import oracle.kv.impl.topo.RepGroup;
import oracle.kv.impl.topo.RepGroupId;
import oracle.kv.impl.topo.RepNode;
import oracle.kv.impl.topo.RepNodeId;
import oracle.kv.impl.topo.Topology;
import oracle.kv.impl.util.FormatUtils;
import oracle.kv.impl.util.KVThreadFactory;
import oracle.kv.impl.util.TopologyLocator;
import oracle.kv.impl.util.registry.RegistryUtils;

public class AwaitQuiesce {
    private final Topology topology;
    private final RegistryUtils regUtils;
    private final ThreadPoolExecutor threadPool;
    private final AtomicLong storewideVLSNsum = new AtomicLong(0L);
    private final Map<RepGroupId, List<QuiesceStatus>> awaitRGs;

    private AwaitQuiesce(Topology topology) {
        this.topology = topology;
        this.regUtils = new RegistryUtils(topology, null);
        KVThreadFactory factory = new KVThreadFactory("awaitQuiesce", null){

            @Override
            public Thread.UncaughtExceptionHandler makeUncaughtExceptionHandler() {
                return new Thread.UncaughtExceptionHandler(){

                    @Override
                    public void uncaughtException(Thread t, Throwable e) {
                        System.err.println("Exiting thread:" + t);
                        e.printStackTrace(System.err);
                    }
                };
            }
        };
        this.threadPool = new ThreadPoolExecutor(0, 100, 100000L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(), factory);
        this.awaitRGs = new ConcurrentHashMap<RepGroupId, List<QuiesceStatus>>();
    }

    private long await(long quiescePeriodMs, long timeoutMs) throws InterruptedException, TimeoutException {
        long quiesceStartMs = System.currentTimeMillis();
        long limitMs = quiesceStartMs + timeoutMs;
        long prevTimeMs = quiesceStartMs;
        long prevStoreCumVLSN = 0L;
        while (System.currentTimeMillis() < limitMs) {
            CountDownLatch threadExitLatch = new CountDownLatch(this.topology.getRepGroupIds().size());
            this.awaitRGs.clear();
            for (RepGroup rg : this.topology.getRepGroupMap().getAll()) {
                this.threadPool.execute(new CheckRepGroup(rg, threadExitLatch));
            }
            long currTimeMs = System.currentTimeMillis();
            long latchWaitMs = limitMs - currTimeMs;
            if (latchWaitMs <= 0L || !threadExitLatch.await(latchWaitMs, TimeUnit.MILLISECONDS)) break;
            long vlsnDelta = this.storewideVLSNsum.get() - prevStoreCumVLSN;
            if (vlsnDelta == 0L && this.awaitRGs.size() == 0) {
                return System.currentTimeMillis() - quiesceStartMs;
            }
            if (prevStoreCumVLSN == 0L) {
                String fmt = "Cumulative store VLSN: %,d on %s. \n";
                System.err.printf("Cumulative store VLSN: %,d on %s. \n", this.storewideVLSNsum.get(), AwaitQuiesce.currUTC());
            } else if (prevStoreCumVLSN > 0L && vlsnDelta > 0L) {
                long deltaMs = System.currentTimeMillis() - prevTimeMs;
                String fmt = "Store is being actively updated on %s. Cumulative store VLSN: %,d Storewide VLSN delta: %,d, rate: ~%,d VLSNs/sec\n";
                System.err.printf("Store is being actively updated on %s. Cumulative store VLSN: %,d Storewide VLSN delta: %,d, rate: ~%,d VLSNs/sec\n", AwaitQuiesce.currUTC(), this.storewideVLSNsum.get(), vlsnDelta, vlsnDelta * 1000L / deltaMs);
            } else {
                this.printLaggingRG();
            }
            prevTimeMs = currTimeMs;
            Thread.sleep(quiescePeriodMs);
            prevStoreCumVLSN = this.storewideVLSNsum.getAndSet(0L);
        }
        String msg = String.format("Could not quiesce in %,d ms", timeoutMs);
        throw new TimeoutException(msg);
    }

    private static String currUTC() {
        return FormatUtils.formatDateAndTime(System.currentTimeMillis());
    }

    private void printLaggingRG() {
        String fmt = "Cumulative store VLSN: %,d on %s. \n";
        System.err.printf("Cumulative store VLSN: %,d on %s. \n", this.storewideVLSNsum.get(), AwaitQuiesce.currUTC());
        for (Map.Entry<RepGroupId, List<QuiesceStatus>> rge : this.awaitRGs.entrySet()) {
            System.err.printf("Rep Group: %s in flux\n", rge.getKey().toString());
            for (QuiesceStatus rnqw : rge.getValue()) {
                System.err.println(" RN:" + rnqw.rnId + " Reason: " + rnqw.getReason());
            }
        }
    }

    public static long await(Topology topology, long quiescePeriodMs, long timeoutMs) throws InterruptedException, TimeoutException {
        return new AwaitQuiesce(topology).await(quiescePeriodMs, timeoutMs);
    }

    public static void main(String[] args) throws KVStoreException, InterruptedException, TimeoutException {
        if (args.length < 3 || args.length > 5) {
            System.err.println("Usage: java " + AwaitQuiesce.class.getName() + " <topoHost:port> <quiescePeriodSec>" + " <quiesceTimeoutSec> [userName] [securityFile]");
            System.exit(1);
        }
        String user = null;
        String securityFile = null;
        try {
            user = args[3];
            securityFile = args[4];
        }
        catch (IndexOutOfBoundsException ioobe) {
            // empty catch block
        }
        KVStoreLogin storeLogin = new KVStoreLogin(user, securityFile);
        storeLogin.loadSecurityProperties();
        storeLogin.prepareRegistryCSF();
        String regHostPort = args[0];
        RepNodeLoginManager loginMgr = null;
        if (storeLogin.foundSSLTransport()) {
            try {
                PasswordCredentials creds = storeLogin.makeShellLoginCredentials();
                loginMgr = KVStoreLogin.getRepNodeLoginMgr(new String[]{regHostPort}, creds, null);
            }
            catch (AuthenticationFailureException afe) {
                System.err.println("Login failed: " + afe.getMessage());
                return;
            }
            catch (IOException ioe) {
                System.err.println("Failed to get login credentials: " + ioe.getMessage());
                return;
            }
        }
        Topology topology = TopologyLocator.get(new String[]{regHostPort}, 0, loginMgr, null);
        long quiescePeriodMs = TimeUnit.SECONDS.toMillis(Integer.parseInt(args[1]));
        long timeoutMs = TimeUnit.SECONDS.toMillis(Integer.parseInt(args[2]));
        String headerFmt = "Waiting for the KVS:%s to be quiescent for %,d sec. Timeout: %,d sec\n";
        System.err.printf("Waiting for the KVS:%s to be quiescent for %,d sec. Timeout: %,d sec\n", topology.getKVStoreName(), TimeUnit.MILLISECONDS.toSeconds(quiescePeriodMs), TimeUnit.MILLISECONDS.toSeconds(timeoutMs));
        long quiesceMs = new AwaitQuiesce(topology).await(quiescePeriodMs, timeoutMs);
        System.err.printf("%s took %,d sec to become quiescent. It has been quiescent for the preceding %,d sec on %s\n", topology.getKVStoreName(), TimeUnit.MILLISECONDS.toSeconds(quiesceMs), TimeUnit.MILLISECONDS.toSeconds(quiescePeriodMs), AwaitQuiesce.currUTC());
    }

    private class CheckRepGroup
    implements Runnable {
        final RepGroup rg;
        final CountDownLatch latch;
        final HashMap<RepNodeId, RepNodeStatus> groupStatus = new HashMap();
        final List<QuiesceStatus> quiesceStatus = new LinkedList<QuiesceStatus>();

        private CheckRepGroup(RepGroup rg, CountDownLatch latch) {
            this.rg = rg;
            this.latch = latch;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                this.runInternal();
                if (this.quiesceStatus.size() != 0) {
                    AwaitQuiesce.this.awaitRGs.put(this.rg.getResourceId(), this.quiesceStatus);
                }
            }
            finally {
                this.latch.countDown();
            }
        }

        public void runInternal() {
            RepNodeStatus mRNStatus = this.locateMaster();
            if (mRNStatus == null) {
                for (Map.Entry<RepNodeId, RepNodeStatus> rne : this.groupStatus.entrySet()) {
                    this.quiesceStatus.add(new QuiesceLag(rne.getKey(), "master unavailable", rne.getValue()));
                }
                return;
            }
            long masterVLSN = mRNStatus.getVlsn();
            AwaitQuiesce.this.storewideVLSNsum.getAndAdd(masterVLSN);
            for (Map.Entry<RepNodeId, RepNodeStatus> rne : this.groupStatus.entrySet()) {
                RepNodeStatus status = rne.getValue();
                if (masterVLSN == status.getVlsn()) continue;
                String message = String.format(" Replica lagging. VLSN delta: %,d. Master at VLSN: %,d replica at VLSN:%,d.", mRNStatus.getVlsn() - status.getVlsn(), mRNStatus.getVlsn(), status.getVlsn());
                this.quiesceStatus.add(new QuiesceLag(rne.getKey(), message, rne.getValue()));
            }
        }

        private RepNodeStatus locateMaster() {
            RepNodeStatus mRNStatus = null;
            for (RepNode rn : this.rg.getRepNodes()) {
                try {
                    RepNodeAdminAPI rna = AwaitQuiesce.this.regUtils.getRepNodeAdmin((RepNodeId)rn.getResourceId());
                    RepNodeStatus status = rna.ping();
                    if (status.getReplicationState().isMaster()) {
                        if (mRNStatus != null) {
                            return null;
                        }
                        mRNStatus = status;
                    }
                    this.groupStatus.put((RepNodeId)rn.getResourceId(), status);
                }
                catch (Exception re) {
                    this.quiesceStatus.add(new QuiesceUnavailable((RepNodeId)rn.getResourceId(), re));
                }
            }
            return mRNStatus;
        }
    }

    private static class QuiesceUnavailable
    extends QuiesceStatus {
        final Exception exception;

        QuiesceUnavailable(RepNodeId rnId, Exception exception) {
            super(rnId, exception.getMessage());
            this.exception = exception;
        }
    }

    private static class QuiesceLag
    extends QuiesceStatus {
        final RepNodeStatus rnStatus;

        QuiesceLag(RepNodeId rnId, String message, RepNodeStatus rnStatus) {
            super(rnId, message);
            this.rnStatus = rnStatus;
        }

        @Override
        String getReason() {
            return this.message + " Status:" + this.rnStatus;
        }
    }

    private static abstract class QuiesceStatus {
        final RepNodeId rnId;
        final String message;

        QuiesceStatus(RepNodeId rnId, String message) {
            this.rnId = rnId;
            this.message = message;
        }

        String getReason() {
            return this.message;
        }
    }
}

