/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.sna.masterBalance;

import com.sleepycat.je.rep.ReplicatedEnvironment;
import com.sleepycat.je.utilint.StoppableThread;
import java.rmi.NotBoundException;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.kv.impl.fault.InternalFaultException;
import oracle.kv.impl.rep.admin.RepNodeAdminAPI;
import oracle.kv.impl.sna.StorageNodeAgentAPI;
import oracle.kv.impl.sna.masterBalance.MasterBalanceManager;
import oracle.kv.impl.sna.masterBalance.MasterBalancingInterface;
import oracle.kv.impl.sna.masterBalance.ReplicaLeaseManager;
import oracle.kv.impl.sna.masterBalance.TopoCache;
import oracle.kv.impl.topo.RepGroupId;
import oracle.kv.impl.topo.RepNode;
import oracle.kv.impl.topo.RepNodeId;
import oracle.kv.impl.topo.StorageNode;
import oracle.kv.impl.topo.StorageNodeId;
import oracle.kv.impl.topo.Topology;
import oracle.kv.impl.util.PollCondition;
import oracle.kv.impl.util.registry.RegistryUtils;

class RebalanceThread
extends StoppableThread {
    private static final int THREAD_SOFT_SHUTDOWN_MS = 10000;
    private static final int MASTER_LEASE_MS = 300000;
    private static final int POLL_PERIOD_DEFAULT_MS = 60000;
    private static int pollPeriodMs = 60000;
    private final MasterBalanceManager.SNInfo snInfo;
    private final Set<RepNodeId> activeReplicas;
    private final Set<RepNodeId> activeMasters;
    private final TopoCache topoCache;
    private final ReplicaLeaseManager replicaLeases;
    private final AtomicBoolean overloadedNeighbor = new AtomicBoolean(false);
    private final BlockingQueue<MasterBalancingInterface.StateInfo> stateTransitions = new ArrayBlockingQueue<MasterBalancingInterface.StateInfo>(100);
    private final MasterBalanceManager manager;
    private final Logger logger;
    private final AtomicBoolean shutdownServices = new AtomicBoolean(false);

    RebalanceThread(MasterBalanceManager manager) {
        super("MasterRebalanceThread");
        this.snInfo = manager.getSnInfo();
        this.topoCache = manager.getTopoCache();
        this.manager = manager;
        this.activeReplicas = Collections.synchronizedSet(new HashSet());
        this.activeMasters = Collections.synchronizedSet(new HashSet());
        this.logger = manager.logger;
        this.replicaLeases = new ReplicaLeaseManager(this.logger);
    }

    protected Logger getLogger() {
        return this.logger;
    }

    static void setPollPeriodMs(int pollPeriodMs) {
        RebalanceThread.pollPeriodMs = pollPeriodMs;
    }

    void noteExit(RepNodeId rnId) throws InterruptedException {
        this.logger.info("Rebalance thread notes " + rnId + " exited");
        this.noteState(new MasterBalancingInterface.StateInfo(rnId, ReplicatedEnvironment.State.DETACHED, 0));
    }

    void noteState(MasterBalancingInterface.StateInfo stateInfo) throws InterruptedException {
        while (!this.stateTransitions.offer(stateInfo, 60L, TimeUnit.SECONDS)) {
            this.logger.info("State transition queue is full retrying. Capacity:" + this.stateTransitions.size());
        }
        this.logger.info("added:" + stateInfo);
    }

    protected int initiateSoftShutdown() {
        if (!this.manager.shutdown.get()) {
            throw new IllegalStateException("Expected manager to be shutdown");
        }
        this.stateTransitions.offer(new MasterBalancingInterface.StateInfo(null, null, 0));
        return 10000;
    }

    private boolean needsRebalancing(boolean overload) {
        boolean needsRebalancing;
        if (this.activeMasters.size() == 0) {
            return false;
        }
        int leaseAdjustedMD = this.getLeaseAdjustedMD();
        int BMD = this.getBMD();
        boolean bl = needsRebalancing = this.activeMasters.size() > 1 && leaseAdjustedMD > BMD;
        if (needsRebalancing) {
            this.logger.info(this.snInfo.snId + " masters: " + this.activeMasters + " replica leases: " + this.replicaLeases.leaseCount() + " resident RNs: " + this.topoCache.getRnCount() + " needs rebalancing. lease adjusted MD: " + leaseAdjustedMD + " > BMD:" + BMD);
            return true;
        }
        int incrementalMD = 100 / this.topoCache.getRnCount();
        if (overload && leaseAdjustedMD + incrementalMD > BMD) {
            this.logger.info(this.snInfo.snId + " masters: " + this.activeMasters + " replica leases: " + this.replicaLeases.leaseCount() + " resident RNs: " + this.topoCache.getRnCount() + " Unbalanced neighbors initiated rebalancing. " + "lease adjusted MD: " + leaseAdjustedMD + " + " + incrementalMD + "> BMD:" + BMD);
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        this.logger.info("Started " + this.getName());
        try {
            while (true) {
                List<Transfer> choice;
                boolean overload;
                MasterBalancingInterface.StateInfo stateInfo = this.stateTransitions.poll(pollPeriodMs, TimeUnit.MILLISECONDS);
                if (this.manager.shutdown.get()) {
                    return;
                }
                if (stateInfo != null) {
                    this.processStateInfo(stateInfo);
                }
                if (!this.topoCache.ensureTopology() || !this.needsRebalancing(overload = this.overloadedNeighbor.getAndSet(false)) || (choice = this.candidateTransfers(overload)).size() > 0 && this.transferMaster(choice) != null) continue;
                String masters = new ArrayList<RepNodeId>(this.activeMasters).toString();
                this.logger.info("No suitable RNs: " + masters + " for master transfer.");
                if (this.replicaLeases.leaseCount() != 0 || this.getRawMD() <= this.getBMD()) continue;
                this.informNeighborsOfOverload();
                continue;
                break;
            }
        }
        catch (InterruptedException e) {
            if (this.manager.shutdown.get()) {
                return;
            }
            this.logger.info("Lease expiration task interrupted.");
            return;
        }
        catch (Exception e) {
            this.logger.log(Level.SEVERE, this.getName() + " thread exiting due to exception.", e);
            this.manager.shutdown();
            return;
        }
        finally {
            this.logger.info(this.getName() + " thread exited.");
        }
    }

    private void processStateInfo(MasterBalancingInterface.StateInfo stateInfo) {
        RepNodeId rnId = stateInfo.rnId;
        switch (stateInfo.state) {
            case MASTER: {
                this.activeReplicas.remove(rnId);
                this.activeMasters.add(rnId);
                break;
            }
            case REPLICA: {
                this.activeMasters.remove(rnId);
                this.activeReplicas.add(rnId);
                this.replicaLeases.cancel(rnId);
                break;
            }
            case UNKNOWN: 
            case DETACHED: {
                this.activeMasters.remove(rnId);
                this.activeReplicas.remove(rnId);
                this.replicaLeases.cancel(rnId);
            }
        }
        this.logger.info("sn: " + this.snInfo.snId + " state transition: " + stateInfo + " active masters:" + this.activeMasters + " active replicas:" + this.activeReplicas.size() + " replica leases:" + this.replicaLeases.leaseCount());
    }

    private boolean isMaster(RepNodeId repNodeId) {
        return this.activeMasters.contains(repNodeId);
    }

    boolean isReplica(RepNodeId repNodeId) {
        return this.activeReplicas.contains(repNodeId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Transfer transferMaster(List<Transfer> candidateTransfers) {
        Topology topo = this.topoCache.getTopology();
        RegistryUtils regUtils = new RegistryUtils(topo, this.manager.getLoginManager());
        StorageNode localSN = topo.get(this.snInfo.snId);
        Iterator<Transfer> i$ = candidateTransfers.iterator();
        while (i$.hasNext()) {
            boolean masterTransferInitiated;
            RepNodeId sourceRNId;
            StorageNodeAgentAPI sna;
            Transfer transfer;
            block42: {
                Transfer transfer2;
                block41: {
                    block39: {
                        block40: {
                            transfer = i$.next();
                            this.logger.info("Requesting master RN transfer : " + transfer);
                            sna = null;
                            sourceRNId = null;
                            masterTransferInitiated = false;
                            try {
                                sna = regUtils.getStorageNodeAgent((StorageNodeId)transfer.targetSN.getResourceId());
                                MasterBalancingInterface.MasterLeaseInfo masterLease = new MasterBalancingInterface.MasterLeaseInfo(localSN, transfer.targetRN, transfer.ptmd, 300000);
                                if (!sna.getMasterLease(masterLease)) {
                                    if (masterTransferInitiated) continue;
                                    if (sna == null) break block39;
                                    break block40;
                                }
                                sourceRNId = (RepNodeId)transfer.sourceRN.getResourceId();
                                ReplicaLeaseManager.ReplicaLease replicaLease = new ReplicaLeaseManager.ReplicaLease(sourceRNId, 300000);
                                this.replicaLeases.getReplicaLease(replicaLease);
                                RepNodeAdminAPI rna = regUtils.getRepNodeAdmin(sourceRNId);
                                masterTransferInitiated = rna.initiateMasterTransfer((RepNodeId)transfer.targetRN.getResourceId(), 300000, TimeUnit.MILLISECONDS);
                                if (masterTransferInitiated) {
                                    transfer2 = transfer;
                                    if (masterTransferInitiated) return transfer2;
                                    break block41;
                                }
                                if (masterTransferInitiated) continue;
                                break block42;
                            }
                            catch (RemoteException e) {
                                if (masterTransferInitiated) continue;
                                if (sna != null) {
                                    try {
                                        sna.cancelMasterLease(localSN, transfer.targetRN);
                                    }
                                    catch (RemoteException e2) {
                                        this.logger.info("Failed master lease cleanup: " + e2.getMessage());
                                    }
                                    catch (InternalFaultException re) {
                                        this.logger.log(Level.WARNING, "Failed master lease cleanup:" + transfer, re);
                                        continue;
                                    }
                                }
                                if (sourceRNId == null) continue;
                                this.replicaLeases.cancel(sourceRNId);
                                continue;
                            }
                            catch (NotBoundException e) {
                                if (masterTransferInitiated) continue;
                                if (sna != null) {
                                    try {
                                        sna.cancelMasterLease(localSN, transfer.targetRN);
                                    }
                                    catch (RemoteException e3) {
                                        this.logger.info("Failed master lease cleanup: " + e3.getMessage());
                                    }
                                    catch (InternalFaultException re) {
                                        this.logger.log(Level.WARNING, "Failed master lease cleanup:" + transfer, re);
                                        continue;
                                    }
                                }
                                if (sourceRNId == null) continue;
                                this.replicaLeases.cancel(sourceRNId);
                                continue;
                            }
                            catch (InternalFaultException re) {
                                this.logger.log(Level.WARNING, "Unexpected fault during transfer:" + transfer, re);
                                continue;
                            }
                        }
                        try {
                            sna.cancelMasterLease(localSN, transfer.targetRN);
                        }
                        catch (RemoteException e) {
                            this.logger.info("Failed master lease cleanup: " + e.getMessage());
                        }
                        catch (InternalFaultException re) {
                            this.logger.log(Level.WARNING, "Failed master lease cleanup:" + transfer, re);
                            continue;
                        }
                    }
                    if (sourceRNId == null) continue;
                    this.replicaLeases.cancel(sourceRNId);
                    continue;
                }
                if (sna != null) {
                    try {
                        sna.cancelMasterLease(localSN, transfer.targetRN);
                    }
                    catch (RemoteException e) {
                        this.logger.info("Failed master lease cleanup: " + e.getMessage());
                    }
                    catch (InternalFaultException re) {
                        this.logger.log(Level.WARNING, "Failed master lease cleanup:" + transfer, re);
                        continue;
                    }
                }
                if (sourceRNId == null) return transfer2;
                this.replicaLeases.cancel(sourceRNId);
                return transfer2;
            }
            if (sna != null) {
                try {
                    sna.cancelMasterLease(localSN, transfer.targetRN);
                }
                catch (RemoteException e) {
                    this.logger.info("Failed master lease cleanup: " + e.getMessage());
                }
                catch (InternalFaultException re) {
                    this.logger.log(Level.WARNING, "Failed master lease cleanup:" + transfer, re);
                    continue;
                }
            }
            if (sourceRNId == null) continue;
            this.replicaLeases.cancel(sourceRNId);
            continue;
            finally {
                if (masterTransferInitiated) continue;
                if (sna != null) {
                    try {
                        sna.cancelMasterLease(localSN, transfer.targetRN);
                    }
                    catch (RemoteException e) {
                        this.logger.info("Failed master lease cleanup: " + e.getMessage());
                    }
                    catch (InternalFaultException re) {
                        this.logger.log(Level.WARNING, "Failed master lease cleanup:" + transfer, re);
                        continue;
                    }
                }
                if (sourceRNId == null) continue;
                this.replicaLeases.cancel(sourceRNId);
            }
        }
        return null;
    }

    private List<Transfer> candidateTransfers(boolean overload) {
        Set<StorageNode> mscns = this.getMCSNs();
        this.logger.info("MSCNS:" + mscns);
        TreeMap<Integer, List<StorageNode>> ptmds = this.orderMSCNs(mscns);
        LinkedList<Transfer> transfers = new LinkedList<Transfer>();
        if (ptmds.size() == 0) {
            return transfers;
        }
        int loweredMD = (this.activeMasters.size() + (overload ? 1 : 0) - this.replicaLeases.leaseCount() - 1) * 100 / this.topoCache.getRnCount();
        if (loweredMD <= 0) {
            return transfers;
        }
        Topology topology = this.topoCache.getTopology();
        for (Map.Entry<Integer, List<StorageNode>> entry : ptmds.entrySet()) {
            int ptmd = entry.getKey();
            this.logger.info("loweredMD:" + loweredMD + " ptmd:" + ptmd + " SNS:" + entry.getValue());
            if (ptmd > this.getBMD() && ptmd > loweredMD) {
                return transfers;
            }
            if (overload && ptmd > this.getBMD()) {
                return transfers;
            }
            for (StorageNode targetSN : entry.getValue()) {
                StorageNodeId targetSnId = (StorageNodeId)targetSN.getResourceId();
                for (RepNodeId mRnId : this.activeMasters) {
                    RepNode sourceRN;
                    if (this.replicaLeases.hasLease(mRnId) || (sourceRN = topology.get(mRnId)) == null) continue;
                    Collection<RepNode> groupNodes = topology.get(sourceRN.getRepGroupId()).getRepNodes();
                    for (RepNode targetRN : groupNodes) {
                        if (!targetRN.getStorageNodeId().equals(targetSnId)) continue;
                        Transfer transfer = new Transfer(sourceRN, targetRN, targetSN, ptmd);
                        this.logger.info("Candidate transfer:" + transfer);
                        transfers.add(transfer);
                    }
                }
            }
        }
        return transfers;
    }

    private TreeMap<Integer, List<StorageNode>> orderMSCNs(Set<StorageNode> mscns) {
        TreeMap<Integer, List<StorageNode>> ptmds = new TreeMap<Integer, List<StorageNode>>();
        for (StorageNode sn : mscns) {
            try {
                StorageNodeAgentAPI sna = RegistryUtils.getStorageNodeAgent(this.snInfo.storename, sn, this.manager.getLoginManager());
                MasterBalancingInterface.MDInfo mdInfo = sna.getMDInfo();
                if (mdInfo == null) continue;
                int ptmd = mdInfo.getPTMD();
                List<StorageNode> sns = ptmds.get(ptmd);
                if (sns == null) {
                    sns = new LinkedList<StorageNode>();
                    ptmds.put(ptmd, sns);
                }
                sns.add(sn);
            }
            catch (RemoteException e) {
                this.logger.info("Could not contact SN to compute PTMD: " + sn + " reason:" + e.getMessage());
            }
            catch (NotBoundException e) {
                this.logger.warning(sn + " missing from registry.");
            }
            catch (InternalFaultException re) {
                this.logger.log(Level.WARNING, "Unexpected fault at remote SN:" + sn, re);
            }
        }
        return ptmds;
    }

    private Set<StorageNode> getMCSNs() {
        HashSet<StorageNode> mscns = new HashSet<StorageNode>();
        Topology topology = this.topoCache.getTopology();
        for (RepNodeId mRnId : this.activeMasters) {
            RepNode mrn = topology.get(mRnId);
            if (mrn == null) continue;
            RepGroupId mRgId = mrn.getRepGroupId();
            if (this.replicaLeases.hasLease(mRnId)) continue;
            for (RepNode rn : topology.get(mRgId).getRepNodes()) {
                StorageNode targetSN;
                StorageNodeId targetSNId = rn.getStorageNodeId();
                if (this.snInfo.snId.equals(targetSNId) || !topology.get((targetSN = topology.get(targetSNId)).getDatacenterId()).getDatacenterType().isPrimary()) continue;
                mscns.add(targetSN);
            }
        }
        return mscns;
    }

    private int getRawMD() {
        return !this.topoCache.isInitialized() || this.manager.shutdown.get() ? Integer.MAX_VALUE : this.activeMasters.size() * 100 / this.topoCache.getRnCount();
    }

    private int getLeaseAdjustedMD() {
        return (this.activeMasters.size() - this.replicaLeases.leaseCount()) * 100 / this.topoCache.getRnCount();
    }

    int getBMD() {
        return 100 / this.topoCache.getPrimaryRF();
    }

    int getMasterCount() {
        return this.activeMasters.size();
    }

    int getReplicaCount() {
        return this.activeReplicas.size();
    }

    Set<RepNodeId> getActiveRNs() {
        HashSet<RepNodeId> activeRNs = new HashSet<RepNodeId>();
        activeRNs.addAll(this.activeMasters);
        activeRNs.addAll(this.activeReplicas);
        return activeRNs;
    }

    private void informNeighborsOfOverload() {
        for (StorageNode sn : this.getMCSNs()) {
            try {
                StorageNodeAgentAPI sna = RegistryUtils.getStorageNodeAgent(this.snInfo.storename, sn, this.manager.getLoginManager());
                sna.overloadedNeighbor(this.snInfo.snId);
                this.logger.info("master rebalance push requested: " + sn);
            }
            catch (RemoteException e) {
                this.logger.info("Could not contact SN to request master rebalance push: " + sn + " reason:" + e.getMessage());
            }
            catch (NotBoundException e) {
                this.logger.warning(sn + " missing from registry.");
            }
            catch (InternalFaultException re) {
                this.logger.log(Level.WARNING, "Unexpected fault at remote SN:" + sn, re);
            }
        }
    }

    void overloadedNeighbor(StorageNodeId storageNodeId) {
        this.logger.info("Master unbalanced neighbor sn:" + storageNodeId);
        this.overloadedNeighbor.set(true);
    }

    public void setShutDownServices(boolean shutdownServices) {
        this.shutdownServices.set(shutdownServices);
    }

    public boolean willShutDownServices() {
        return this.shutdownServices.get();
    }

    public void transferMastersForShutdown() {
        this.logger.info("Initiating master transfers for RNs in preparation for shutting down the SN");
        if (!this.topoCache.ensureTopology()) {
            return;
        }
        if (!this.shutdownServices.compareAndSet(false, true)) {
            return;
        }
        Topology topology = this.topoCache.getTopology();
        HashSet<RepNodeId> activeMasterSet = new HashSet<RepNodeId>();
        activeMasterSet.addAll(this.activeMasters);
        LinkedList<RepNodeId> allMasterTransferSourceRNs = new LinkedList<RepNodeId>();
        for (RepNodeId rnId : activeMasterSet) {
            Map.Entry<Integer, List<StorageNode>> entry;
            int ptmd;
            int remainingMasters = this.activeMasters.size() - this.replicaLeases.leaseCount();
            if (remainingMasters <= 0) break;
            RepNode masterRN = topology.get(rnId);
            if (masterRN == null || this.replicaLeases.hasLease(rnId)) continue;
            LinkedList<Transfer> transfers = new LinkedList<Transfer>();
            Collection<RepNode> groupNodes = topology.get(masterRN.getRepGroupId()).getRepNodes();
            HashSet<StorageNode> targetSNs = new HashSet<StorageNode>();
            for (RepNode rn : groupNodes) {
                StorageNode targetSN;
                StorageNodeId targetSNId = rn.getStorageNodeId();
                if (targetSNId.equals(this.snInfo.snId) || !topology.get((targetSN = topology.get(targetSNId)).getDatacenterId()).getDatacenterType().isPrimary()) continue;
                targetSNs.add(targetSN);
            }
            if (targetSNs.isEmpty()) continue;
            TreeMap<Integer, List<StorageNode>> ptmds = this.orderMSCNs(targetSNs);
            Iterator<Map.Entry<Integer, List<StorageNode>>> i$ = ptmds.entrySet().iterator();
            while (i$.hasNext() && (ptmd = (entry = i$.next()).getKey().intValue()) <= 100) {
                for (StorageNode targetSN : entry.getValue()) {
                    StorageNodeId targetSNId = targetSN.getStorageNodeId();
                    for (RepNode targetRN : groupNodes) {
                        if (!targetRN.getStorageNodeId().equals(targetSNId)) continue;
                        Transfer transfer = new Transfer(masterRN, targetRN, targetSN, ptmd);
                        transfers.add(transfer);
                    }
                }
            }
            if (transfers.isEmpty()) continue;
            Transfer masterTransfer = this.transferMaster(transfers);
            if (masterTransfer != null) {
                allMasterTransferSourceRNs.add((RepNodeId)masterTransfer.sourceRN.getResourceId());
                this.logger.info("Master transfer of RN: " + masterRN.getResourceId() + " initiated");
                continue;
            }
            this.logger.info("Master transfer of RN: " + masterRN.getResourceId() + " was not initiated");
        }
        int transferWaitMillis = 120000;
        this.waitForRNTransfer(allMasterTransferSourceRNs, 120000);
    }

    private void waitForRNTransfer(List<RepNodeId> allMasterTransferSourceRNs, int transferWaitMillis) {
        final LinkedList currentMasterTransferSourceRNs = new LinkedList();
        final LinkedList<RepNodeId> nextMasterTransferSourceRNs = new LinkedList<RepNodeId>();
        nextMasterTransferSourceRNs.addAll(allMasterTransferSourceRNs);
        new PollCondition(1000, transferWaitMillis){

            @Override
            protected boolean condition() {
                currentMasterTransferSourceRNs.clear();
                currentMasterTransferSourceRNs.addAll(nextMasterTransferSourceRNs);
                for (RepNodeId sourceRNId : currentMasterTransferSourceRNs) {
                    if (RebalanceThread.this.replicaLeases.hasLease(sourceRNId)) continue;
                    nextMasterTransferSourceRNs.remove(sourceRNId);
                }
                return nextMasterTransferSourceRNs.isEmpty();
            }
        }.await();
        for (RepNodeId rnId : allMasterTransferSourceRNs) {
            if (nextMasterTransferSourceRNs.contains(rnId)) {
                this.logger.info("Master transfer of RepNode: " + rnId + " timed out");
                continue;
            }
            this.logger.info("Master transfer of RepNode: " + rnId + " completed");
        }
    }

    private static final class Transfer {
        final RepNode sourceRN;
        final RepNode targetRN;
        final StorageNode targetSN;
        private final int ptmd;

        Transfer(RepNode sourceRN, RepNode targetRN, StorageNode targetSN, int ptmd) {
            this.sourceRN = sourceRN;
            this.targetRN = targetRN;
            this.targetSN = targetSN;
            this.ptmd = ptmd;
        }

        public String toString() {
            return "<Transfer master from " + this.sourceRN + " to " + this.targetRN + " at " + this.targetSN + " ptmd: " + this.ptmd + ">";
        }
    }
}

